/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.parser.MarkedUpTextAssembler;
import com.lowagie.text.pdf.parser.PdfTextExtractor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;

public class PdfContentReaderTool {
    public static String getDictionaryDetail(PdfDictionary pdfDictionary) {
        return PdfContentReaderTool.getDictionaryDetail(pdfDictionary, 0);
    }

    public static String getDictionaryDetail(PdfDictionary pdfDictionary, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        ArrayList<PdfName> arrayList = new ArrayList<PdfName>();
        for (PdfName object : pdfDictionary.getKeys()) {
            PdfObject pdfObject = pdfDictionary.getDirectObject(object);
            if (pdfObject.isDictionary()) {
                arrayList.add(object);
            }
            stringBuilder.append(object);
            stringBuilder.append('=');
            stringBuilder.append(pdfObject);
            stringBuilder.append(", ");
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.setLength(stringBuilder2.length() - 2);
        stringBuilder.append(')');
        for (Object e2 : arrayList) {
            PdfName pdfName = (PdfName)e2;
            stringBuilder.append('\n');
            for (int i2 = 0; i2 < n2 + 1; ++i2) {
                stringBuilder.append('\t');
            }
            stringBuilder.append("Subdictionary ");
            stringBuilder.append(pdfName);
            stringBuilder.append(" = ");
            stringBuilder.append(PdfContentReaderTool.getDictionaryDetail(pdfDictionary.getAsDict(pdfName), n2 + 1));
        }
        return stringBuilder.toString();
    }

    public static void listContentStreamForPage(PdfReader object, int n2, PrintWriter printWriter) {
        int n3;
        printWriter.println("==============Page " + n2 + "====================");
        printWriter.println("- - - - - Dictionary - - - - - -");
        Object object2 = ((PdfReader)object).getPageN(n2);
        printWriter.println(PdfContentReaderTool.getDictionaryDetail((PdfDictionary)object2));
        printWriter.println("- - - - - Content Stream - - - - - -");
        object2 = ((PdfReader)object).getSafeFile();
        byte[] byArray = ((PdfReader)object).getPageContent(n2, (RandomAccessFileOrArray)object2);
        ((RandomAccessFileOrArray)object2).close();
        object2 = new ByteArrayInputStream(byArray);
        while ((n3 = ((InputStream)object2).read()) != -1) {
            printWriter.print((char)n3);
        }
        printWriter.println("- - - - - Text Extraction - - - - - -");
        object = new PdfTextExtractor((PdfReader)object, new MarkedUpTextAssembler((PdfReader)object));
        object = ((PdfTextExtractor)object).getTextFromPage(n2);
        if (((String)object).length() != 0) {
            printWriter.println((String)object);
        } else {
            printWriter.println("No text found on page " + n2);
        }
        printWriter.println();
    }

    public static void listContentStream(File object, PrintWriter printWriter) {
        object = new PdfReader(((File)object).getCanonicalPath());
        int n2 = ((PdfReader)object).getNumberOfPages();
        for (int i2 = 1; i2 <= n2; ++i2) {
            PdfContentReaderTool.listContentStreamForPage((PdfReader)object, i2, printWriter);
        }
    }

    public static void listContentStream(File object, int n2, PrintWriter printWriter) {
        object = new PdfReader(((File)object).getCanonicalPath());
        PdfContentReaderTool.listContentStreamForPage((PdfReader)object, n2, printWriter);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length <= 0 || stringArray.length > 3) {
                System.out.println("Usage:  PdfContentReaderTool <pdf file> [<output file>|stdout] [<page num>]");
                return;
            }
            PrintWriter printWriter = new PrintWriter(System.out);
            if (stringArray.length >= 2 && stringArray[1].compareToIgnoreCase("stdout") != 0) {
                System.out.println("Writing PDF content to " + stringArray[1]);
                printWriter = new PrintWriter(new FileOutputStream(new File(stringArray[1])));
            }
            int n2 = -1;
            if (stringArray.length >= 3) {
                n2 = Integer.parseInt(stringArray[2]);
            }
            if (n2 == -1) {
                PdfContentReaderTool.listContentStream(new File(stringArray[0]), printWriter);
            } else {
                PdfContentReaderTool.listContentStream(new File(stringArray[0]), n2, printWriter);
            }
            printWriter.flush();
            if (stringArray.length >= 2) {
                printWriter.close();
                System.out.println("Finished writing content to " + stringArray[1]);
            }
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace(System.err);
            return;
        }
    }
}

