/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.CMapAwareDocumentFont;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentParser;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.parser.ContentOperator;
import com.lowagie.text.pdf.parser.FinalText;
import com.lowagie.text.pdf.parser.GraphicsState;
import com.lowagie.text.pdf.parser.Matrix;
import com.lowagie.text.pdf.parser.ParsedText;
import com.lowagie.text.pdf.parser.TextAssembler;
import com.lowagie.text.pdf.parser.TextAssemblyBuffer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import javax.annotation.Nonnull;

public class PdfContentStreamHandler {
    private Map<String, ContentOperator> a;
    private Stack<GraphicsState> b;
    private Matrix c;
    private Matrix d;
    private final Stack<List<TextAssemblyBuffer>> e = new Stack();
    private final Stack<String> f = new Stack();
    private List<TextAssemblyBuffer> g = new ArrayList<TextAssemblyBuffer>();
    private final TextAssembler h;

    public PdfContentStreamHandler(TextAssembler textAssembler) {
        this.h = textAssembler;
        this.installDefaultOperators();
        this.reset();
    }

    public void registerContentOperator(ContentOperator contentOperator) {
        String string = contentOperator.getOperatorName();
        if (this.a.containsKey(string)) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("operator.1.already.registered", string));
        }
        this.a.put(string, contentOperator);
    }

    protected void installDefaultOperators() {
        this.a = new HashMap<String, ContentOperator>();
        this.registerContentOperator(new l());
        this.registerContentOperator(new j());
        this.registerContentOperator(new g());
        this.registerContentOperator(new k());
        m m2 = new m();
        this.registerContentOperator(m2);
        s s2 = new s();
        this.registerContentOperator(s2);
        this.registerContentOperator(new o());
        ContentOperator contentOperator = new p();
        this.registerContentOperator(contentOperator);
        this.registerContentOperator(new n());
        this.registerContentOperator(new q());
        this.registerContentOperator(new r());
        this.registerContentOperator(new c());
        this.registerContentOperator(new f());
        ContentOperator contentOperator2 = new w();
        this.registerContentOperator(contentOperator2);
        this.registerContentOperator(new x((w)contentOperator2, (p)contentOperator));
        this.registerContentOperator(new y());
        contentOperator = new v((w)contentOperator2);
        this.registerContentOperator(contentOperator);
        contentOperator2 = new t();
        this.registerContentOperator(new t());
        contentOperator = new h((v)contentOperator, (t)contentOperator2);
        this.registerContentOperator(contentOperator);
        this.registerContentOperator(new i(s2, m2, (h)contentOperator));
        this.registerContentOperator(new u());
        this.registerContentOperator(new a(0));
        this.registerContentOperator(new b(0));
        this.registerContentOperator(new e(0));
        this.registerContentOperator(new d(this, 0));
    }

    @Nonnull
    public Optional<ContentOperator> lookupOperator(String string) {
        return Optional.ofNullable(this.a.get(string));
    }

    public void invokeOperator(PdfLiteral object, List<PdfObject> list, PdfDictionary pdfDictionary) {
        object = ((PdfObject)object).toString();
        this.lookupOperator((String)object).ifPresent(contentOperator -> contentOperator.invoke(list, this, pdfDictionary));
    }

    final void a() {
        String string2 = this.f.pop();
        List<TextAssemblyBuffer> list = this.e.pop();
        this.h.reset();
        for (TextAssemblyBuffer textAssemblyBuffer : this.g) {
            textAssemblyBuffer.accumulate(this.h, string2);
        }
        FinalText finalText = this.h.endParsingContext(string2);
        Optional.ofNullable(finalText).map(FinalText::getText).filter(string -> !string.isEmpty()).ifPresent(string -> list.add(finalText));
        this.g = list;
    }

    final void a(String string) {
        this.f.push(string);
        this.e.push(this.g);
        this.g = new ArrayList<TextAssemblyBuffer>();
    }

    @Nonnull
    final GraphicsState b() {
        return this.b.peek();
    }

    public void reset() {
        if (this.b == null || this.b.isEmpty()) {
            this.b = new Stack();
        }
        this.b.add(new GraphicsState());
        this.c = null;
        this.d = null;
    }

    protected Matrix getCurrentTextMatrix() {
        return this.c;
    }

    protected Matrix getCurrentTextLineMatrix() {
        return this.d;
    }

    final void a(float f2) {
        f2 = -f2 / 1000.0f * this.b().getFontSize() * this.b().getHorizontalScaling();
        this.c = new Matrix(f2, 0.0f).multiply(this.c);
    }

    public CMapAwareDocumentFont getCurrentFont() {
        return this.b().getFont();
    }

    final void a(PdfString object) {
        object = new ParsedText((PdfString)object, this.b(), this.c);
        if (this.f.peek() != null) {
            this.g.add((TextAssemblyBuffer)object);
        }
        this.c = new Matrix(((ParsedText)object).getUnscaledTextWidth(this.b()), 0.0f).multiply(this.c);
    }

    @Nonnull
    public String getResultantText() {
        if (this.f.size() > 0) {
            throw new RuntimeException("can't get text with unprocessed stack items");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (TextAssemblyBuffer textAssemblyBuffer : this.g) {
            stringBuilder.append(textAssemblyBuffer.getText());
        }
        return stringBuilder.toString().trim();
    }

    static /* synthetic */ Matrix a(List list) {
        float f2 = ((PdfNumber)list.get(0)).floatValue();
        float f3 = ((PdfNumber)list.get(1)).floatValue();
        float f4 = ((PdfNumber)list.get(2)).floatValue();
        float f5 = ((PdfNumber)list.get(3)).floatValue();
        float f6 = ((PdfNumber)list.get(4)).floatValue();
        float f7 = ((PdfNumber)list.get(5)).floatValue();
        return new Matrix(f2, f3, f4, f5, f6, f7);
    }

    private final class d
    implements ContentOperator {
        private /* synthetic */ PdfContentStreamHandler a;

        private d(PdfContentStreamHandler pdfContentStreamHandler) {
            this.a = pdfContentStreamHandler;
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "Do";
        }

        @Override
        public final void invoke(List<PdfObject> list, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            Object object = list.get(0);
            if (object instanceof PdfName) {
                object = (PdfName)object;
                Object object2 = pdfDictionary.getAsDict(PdfName.XOBJECT);
                if (object2 == null) {
                    return;
                }
                if (PdfName.FORM.equals(object2 = ((PdfDictionary)(object = (PdfStream)((PdfDictionary)object2).getDirectObject((PdfName)object))).getAsName(PdfName.SUBTYPE))) {
                    object2 = ((PdfDictionary)object).getAsDict(PdfName.RESOURCES);
                    try {
                        object = this.a((PdfObject)object);
                    }
                    catch (IOException iOException) {
                        throw new ExceptionConverter(iOException);
                    }
                    new l().invoke(list, pdfContentStreamHandler, pdfDictionary);
                    PdfObject pdfObject = object2;
                    object2 = object;
                    object = this;
                    try {
                        object2 = new PdfContentParser(new PRTokeniser((byte[])object2));
                        ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>();
                        while (!((PdfContentParser)object2).parse(arrayList).isEmpty()) {
                            ArrayList<PdfObject> arrayList2 = arrayList;
                            PdfLiteral pdfLiteral = (PdfLiteral)arrayList2.get(arrayList2.size() - 1);
                            ((d)object).a.invokeOperator(pdfLiteral, (List<PdfObject>)arrayList, (PdfDictionary)pdfObject);
                        }
                    }
                    catch (Exception exception) {
                        throw new ExceptionConverter(exception);
                    }
                    new j().invoke(list, pdfContentStreamHandler, pdfDictionary);
                }
            }
        }

        private byte[] a(PdfObject object) {
            block5: while (true) {
                switch (((PdfObject)object).type()) {
                    case 10: {
                        object = PdfReader.getPdfObject((PdfObject)object);
                        continue block5;
                    }
                    case 7: {
                        return PdfReader.getStreamBytes((PRStream)PdfReader.getPdfObject((PdfObject)object));
                    }
                    case 5: {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        for (PdfObject pdfObject : ((PdfArray)object).getElements()) {
                            byteArrayOutputStream.write(this.a(pdfObject));
                        }
                        return byteArrayOutputStream.toByteArray();
                    }
                }
                break;
            }
            throw new IllegalStateException("Unsupported type: " + object.getClass().getCanonicalName());
        }

        /* synthetic */ d(PdfContentStreamHandler pdfContentStreamHandler, byte by) {
            this(pdfContentStreamHandler);
        }
    }

    private static final class e
    implements ContentOperator {
        private e() {
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "EMC";
        }

        @Override
        public final void invoke(List<PdfObject> list, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            pdfContentStreamHandler.a();
        }

        /* synthetic */ e(byte by) {
            this();
        }
    }

    private static final class b
    implements ContentOperator {
        private b() {
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "BDC";
        }

        @Override
        public final void invoke(List<PdfObject> object, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfObject) {
            Object object2 = object.get(0);
            if ("artifact".equals(object2 = ((PdfObject)object2).toString().substring(1).toLowerCase(Locale.ROOT)) || "placedpdf".equals(object2) || pdfContentStreamHandler.f.peek() == null) {
                object2 = null;
            } else if ("l".equals(object2)) {
                object2 = "ul";
            }
            object = object.get(1);
            if (((PdfObject)object).isName()) {
                PdfIndirectReference pdfIndirectReference = ((PdfDictionary)(pdfObject = ((PdfDictionary)pdfObject).getAsDict(PdfName.PROPERTIES))).getAsIndirectObject((PdfName)object);
                object = pdfIndirectReference != null ? pdfIndirectReference.getIndRef() : ((PdfDictionary)pdfObject).getAsDict((PdfName)object);
            }
            if ((object = (PdfDictionary)object) != null && object2 != null) {
                pdfObject = ((PdfDictionary)object).getAsString(PdfName.E);
                if (pdfObject != null) {
                    pdfContentStreamHandler.a((String)object2);
                    pdfContentStreamHandler.g.add(new FinalText(pdfObject.toString()));
                    pdfContentStreamHandler.a();
                    pdfContentStreamHandler.a((String)null);
                    return;
                }
                if (((PdfDictionary)object).get(PdfName.TYPE) != null) {
                    object2 = "";
                }
            }
            pdfContentStreamHandler.a((String)object2);
        }

        /* synthetic */ b(byte by) {
            this();
        }
    }

    private static final class a
    implements ContentOperator {
        private a() {
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "BMC";
        }

        @Override
        public final void invoke(List<PdfObject> object, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            object = (PdfName)object.get(0);
            if ("artifact".equals(object = ((PdfObject)object).toString().substring(1).toLowerCase(Locale.ROOT)) || "placedpdf".equals(object)) {
                pdfContentStreamHandler.a((String)null);
                return;
            }
            pdfContentStreamHandler.a((String)object);
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }

    static final class s
    implements ContentOperator {
        s() {
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "Tw";
        }

        @Override
        public final void invoke(List<PdfObject> object, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            object = (PdfNumber)object.get(0);
            pdfContentStreamHandler.b().setWordSpacing(((PdfNumber)object).floatValue());
        }
    }

    static final class o
    implements ContentOperator {
        o() {
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "Tz";
        }

        @Override
        public final void invoke(List<PdfObject> object, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            object = (PdfNumber)object.get(0);
            pdfContentStreamHandler.b().setHorizontalScaling(((PdfNumber)object).floatValue());
        }
    }

    static final class p
    implements ContentOperator {
        p() {
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "TL";
        }

        @Override
        public final void invoke(List<PdfObject> object, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            object = (PdfNumber)object.get(0);
            pdfContentStreamHandler.b().setLeading(((PdfNumber)object).floatValue());
        }
    }

    static final class r
    implements ContentOperator {
        r() {
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "Ts";
        }

        @Override
        public final void invoke(List<PdfObject> object, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            object = (PdfNumber)object.get(0);
            pdfContentStreamHandler.b().setRise(((PdfNumber)object).floatValue());
        }
    }

    static final class q
    implements ContentOperator {
        q() {
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "Tr";
        }

        @Override
        public final void invoke(List<PdfObject> object, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            object = (PdfNumber)object.get(0);
            pdfContentStreamHandler.b().setRenderMode(((PdfNumber)object).intValue());
        }
    }

    static final class w
    implements ContentOperator {
        w() {
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "Td";
        }

        @Override
        public final void invoke(List<PdfObject> list, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            float f2 = ((PdfNumber)list.get(0)).floatValue();
            float f3 = ((PdfNumber)list.get(1)).floatValue();
            Matrix matrix = new Matrix(f2, f3);
            pdfContentStreamHandler.c = matrix.multiply(pdfContentStreamHandler.d);
            PdfContentStreamHandler pdfContentStreamHandler2 = pdfContentStreamHandler;
            pdfContentStreamHandler2.d = pdfContentStreamHandler2.c;
        }
    }

    static final class v
    implements ContentOperator {
        private final w a;

        public v(w w2) {
            this.a = w2;
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "T*";
        }

        @Override
        public final void invoke(List<PdfObject> list, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            list = new ArrayList<PdfObject>(2);
            list.add(0, new PdfNumber(0));
            list.add(1, new PdfNumber(-pdfContentStreamHandler.b().getLeading()));
            this.a.invoke(list, pdfContentStreamHandler, pdfDictionary);
        }
    }

    static final class t
    implements ContentOperator {
        t() {
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "Tj";
        }

        @Override
        public final void invoke(List<PdfObject> object, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            object = (PdfString)object.get(0);
            pdfContentStreamHandler.a((PdfString)object);
        }
    }

    static final class x
    implements ContentOperator {
        private final w a;
        private final p b;

        public x(w w2, p p2) {
            this.a = w2;
            this.b = p2;
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "TD";
        }

        @Override
        public final void invoke(List<PdfObject> list, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            float f2 = ((PdfNumber)list.get(1)).floatValue();
            ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>(1);
            arrayList.add(0, new PdfNumber(-f2));
            this.b.invoke(arrayList, pdfContentStreamHandler, pdfDictionary);
            this.a.invoke(list, pdfContentStreamHandler, pdfDictionary);
        }
    }

    static final class y
    implements ContentOperator {
        y() {
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "Tm";
        }

        @Override
        public final void invoke(List<PdfObject> list, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            pdfContentStreamHandler.d = PdfContentStreamHandler.a(list);
            PdfContentStreamHandler pdfContentStreamHandler2 = pdfContentStreamHandler;
            pdfContentStreamHandler2.c = pdfContentStreamHandler2.d;
        }
    }

    static final class n
    implements ContentOperator {
        n() {
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "Tf";
        }

        @Override
        public final void invoke(List<PdfObject> list, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary object) {
            PdfName pdfName = (PdfName)list.get(0);
            float f2 = ((PdfNumber)list.get(1)).floatValue();
            object = ((PdfDictionary)object).getAsDict(PdfName.FONT);
            object = ((PdfDictionary)object).get(pdfName);
            object = new CMapAwareDocumentFont((PRIndirectReference)object);
            pdfContentStreamHandler.b().setFont((CMapAwareDocumentFont)object);
            pdfContentStreamHandler.b().setFontSize(f2);
        }
    }

    static final class m
    implements ContentOperator {
        m() {
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "Tc";
        }

        @Override
        public final void invoke(List<PdfObject> object, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            object = (PdfNumber)object.get(0);
            pdfContentStreamHandler.b().setCharacterSpacing(((PdfNumber)object).floatValue());
        }
    }

    static final class l
    implements ContentOperator {
        l() {
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "q";
        }

        @Override
        public final void invoke(List<PdfObject> object, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            object = (GraphicsState)pdfContentStreamHandler.b.peek();
            object = new GraphicsState((GraphicsState)object);
            pdfContentStreamHandler.b.push(object);
        }
    }

    static final class k
    implements ContentOperator {
        k() {
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "gs";
        }

        @Override
        public final void invoke(List<PdfObject> object, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary object2) {
            object = (PdfName)object.get(0);
            if ((object2 = ((PdfDictionary)object2).getAsDict(PdfName.EXTGSTATE)) == null) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("resources.do.not.contain.extgstate.entry.unable.to.process.operator.1", this.getOperatorName()));
            }
            if ((object2 = ((PdfDictionary)object2).getAsDict((PdfName)object)) == null) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("1.is.an.unknown.graphics.state.dictionary", object));
            }
            object = ((PdfDictionary)object2).getAsArray(PdfName.FONT);
            if (object != null) {
                object2 = ((PdfArray)object).getPdfObject(0);
                object2 = new CMapAwareDocumentFont((PRIndirectReference)object2);
                float f2 = ((PdfArray)object).getAsNumber(1).floatValue();
                pdfContentStreamHandler.b().setFont((CMapAwareDocumentFont)object2);
                pdfContentStreamHandler.b().setFontSize(f2);
            }
        }
    }

    static final class j
    implements ContentOperator {
        j() {
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "Q";
        }

        @Override
        public final void invoke(List<PdfObject> list, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            pdfContentStreamHandler.b.pop();
        }
    }

    static final class i
    implements ContentOperator {
        private final s a;
        private final m b;
        private final h c;

        public i(s s2, m m2, h h2) {
            this.a = s2;
            this.b = m2;
            this.c = h2;
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "\"";
        }

        @Override
        public final void invoke(List<PdfObject> object, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            ArrayList<PdfObject> arrayList = (PdfNumber)object.get(0);
            PdfNumber pdfNumber = (PdfNumber)object.get(1);
            object = (PdfString)object.get(2);
            ArrayList<PdfObject> arrayList2 = new ArrayList<PdfObject>(1);
            arrayList2.add(0, (PdfObject)((Object)arrayList));
            this.a.invoke(arrayList2, pdfContentStreamHandler, pdfDictionary);
            arrayList = new ArrayList<PdfNumber>(1);
            arrayList.add(0, pdfNumber);
            this.b.invoke((List<PdfObject>)arrayList, pdfContentStreamHandler, pdfDictionary);
            arrayList = new ArrayList<PdfObject>(1);
            arrayList.add(0, (PdfObject)object);
            this.c.invoke(arrayList, pdfContentStreamHandler, pdfDictionary);
        }
    }

    static final class h
    implements ContentOperator {
        private final v a;
        private final t b;

        public h(v v2, t t2) {
            this.a = v2;
            this.b = t2;
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "'";
        }

        @Override
        public final void invoke(List<PdfObject> list, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            this.a.invoke(new ArrayList<PdfObject>(0), pdfContentStreamHandler, pdfDictionary);
            this.b.invoke(list, pdfContentStreamHandler, pdfDictionary);
        }
    }

    static final class g
    implements ContentOperator {
        g() {
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "cm";
        }

        @Override
        public final void invoke(List<PdfObject> object, PdfContentStreamHandler object2, PdfDictionary pdfDictionary) {
            object = PdfContentStreamHandler.a(object);
            object2 = (GraphicsState)((PdfContentStreamHandler)object2).b.peek();
            ((GraphicsState)object2).multiplyCtm((Matrix)object);
        }
    }

    static final class f
    implements ContentOperator {
        f() {
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "ET";
        }

        @Override
        public final void invoke(List<PdfObject> list, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            pdfContentStreamHandler.c = null;
            pdfContentStreamHandler.d = null;
        }
    }

    static final class c
    implements ContentOperator {
        c() {
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "BT";
        }

        @Override
        public final void invoke(List<PdfObject> list, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            pdfContentStreamHandler.c = new Matrix();
            PdfContentStreamHandler pdfContentStreamHandler2 = pdfContentStreamHandler;
            pdfContentStreamHandler2.d = pdfContentStreamHandler2.c;
        }
    }

    static final class u
    implements ContentOperator {
        u() {
        }

        @Override
        @Nonnull
        public final String getOperatorName() {
            return "TJ";
        }

        @Override
        public final void invoke(List<PdfObject> iterator, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfObject2) {
            iterator = (PdfArray)iterator.get(0);
            for (PdfObject f2 : ((PdfArray)((Object)iterator)).getElements()) {
                if (f2 instanceof PdfString) {
                    pdfContentStreamHandler.a((PdfString)f2);
                    continue;
                }
                float f3 = ((PdfNumber)f2).floatValue();
                pdfContentStreamHandler.a(f3);
            }
        }
    }
}

