/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentParser;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.parser.MarkedUpTextAssembler;
import com.lowagie.text.pdf.parser.PdfContentStreamHandler;
import com.lowagie.text.pdf.parser.TextAssembler;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class PdfTextExtractor {
    private final PdfReader a;
    private final TextAssembler b;

    public PdfTextExtractor(PdfReader pdfReader) {
        this(pdfReader, new MarkedUpTextAssembler(pdfReader));
    }

    public PdfTextExtractor(PdfReader pdfReader, boolean bl2) {
        this(pdfReader, new MarkedUpTextAssembler(pdfReader, bl2));
    }

    public PdfTextExtractor(PdfReader pdfReader, TextAssembler textAssembler) {
        this.a = pdfReader;
        this.b = textAssembler;
    }

    private byte[] a(int n2) {
        RandomAccessFileOrArray randomAccessFileOrArray = this.a.getSafeFile();
        Throwable throwable = null;
        try {
            Object object = this.a.getPageN(n2);
            object = ((PdfDictionary)object).get(PdfName.CONTENTS);
            object = this.a((PdfObject)object);
            if (randomAccessFileOrArray != null) {
                randomAccessFileOrArray.close();
            }
            return object;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (randomAccessFileOrArray != null) {
                    if (throwable != null) {
                        try {
                            randomAccessFileOrArray.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        randomAccessFileOrArray.close();
                    }
                }
                throw throwable4;
            }
        }
    }

    private byte[] a(PdfObject object) {
        switch (((PdfObject)object).type()) {
            case 10: {
                object = (PRIndirectReference)object;
                object = PdfReader.getPdfObject((PdfObject)object);
                object = this.a((PdfObject)object);
                break;
            }
            case 7: {
                object = (PRStream)PdfReader.getPdfObject((PdfObject)object);
                object = PdfReader.getStreamBytes((PRStream)object);
                break;
            }
            case 5: {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                object = (PdfArray)object;
                for (PdfObject pdfObject : ((PdfArray)object).getElements()) {
                    byteArrayOutputStream.write(this.a(pdfObject));
                }
                object = byteArrayOutputStream.toByteArray();
                break;
            }
            default: {
                throw new IllegalStateException("Unable to handle Content of type " + object.getClass());
            }
        }
        return object;
    }

    @Nonnull
    public String getTextFromPage(int n2) {
        return this.getTextFromPage(n2, false);
    }

    @Nonnull
    public String getTextFromPage(int n2, boolean bl2) {
        PdfDictionary pdfDictionary = this.a.getPageN(n2);
        if (pdfDictionary == null) {
            return "";
        }
        pdfDictionary = pdfDictionary.getAsDict(PdfName.RESOURCES);
        this.b.reset();
        this.b.setPage(n2);
        PdfContentStreamHandler pdfContentStreamHandler = new PdfContentStreamHandler(this.b);
        PdfTextExtractor pdfTextExtractor = this;
        pdfTextExtractor.processContent(pdfTextExtractor.a(n2), pdfDictionary, pdfContentStreamHandler);
        return pdfContentStreamHandler.getResultantText();
    }

    public void processContent(byte[] object, PdfDictionary pdfDictionary, PdfContentStreamHandler pdfContentStreamHandler) {
        pdfContentStreamHandler.a("div class='t-extracted-page'");
        try {
            object = new PdfContentParser(new PRTokeniser((byte[])object));
            ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>();
            while (((PdfContentParser)object).parse(arrayList).size() > 0) {
                ArrayList<PdfObject> arrayList2 = arrayList;
                PdfLiteral pdfLiteral = (PdfLiteral)arrayList2.get(arrayList2.size() - 1);
                pdfContentStreamHandler.invokeOperator(pdfLiteral, arrayList, pdfDictionary);
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        pdfContentStreamHandler.a();
    }
}

