/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import com.lowagie.text.pdf.parser.Matrix;

public class Vector {
    private final float[] a = new float[]{0.0f, 0.0f, 0.0f};

    public Vector(float f2, float f3, float f4) {
        this.a[0] = f2;
        this.a[1] = f3;
        this.a[2] = f4;
    }

    public float get(int n2) {
        return this.a[n2];
    }

    public Vector cross(Matrix matrix) {
        float f2 = this.a[0] * matrix.get(0) + this.a[1] * matrix.get(3) + this.a[2] * matrix.get(6);
        float f3 = this.a[0] * matrix.get(1) + this.a[1] * matrix.get(4) + this.a[2] * matrix.get(7);
        float f4 = this.a[0] * matrix.get(2) + this.a[1] * matrix.get(5) + this.a[2] * matrix.get(8);
        return new Vector(f2, f3, f4);
    }

    public Vector subtract(Vector vector) {
        float f2 = this.a[0] - vector.a[0];
        float f3 = this.a[1] - vector.a[1];
        float f4 = this.a[2] - vector.a[2];
        return new Vector(f2, f3, f4);
    }

    public Vector add(Vector vector) {
        float f2 = this.a[0] + vector.a[0];
        float f3 = this.a[1] + vector.a[1];
        float f4 = this.a[2] + vector.a[2];
        return new Vector(f2, f3, f4);
    }

    public Vector cross(Vector vector) {
        float f2 = this.a[1] * vector.a[2] - this.a[2] * vector.a[1];
        float f3 = this.a[2] * vector.a[0] - this.a[0] * vector.a[2];
        float f4 = this.a[0] * vector.a[1] - this.a[1] * vector.a[0];
        return new Vector(f2, f3, f4);
    }

    public float dot(Vector vector) {
        return this.a[0] * vector.a[0] + this.a[1] * vector.a[1] + this.a[2] * vector.a[2];
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.a[0] * this.a[0] + this.a[1] * this.a[1] + this.a[2] * this.a[2];
    }

    public String toString() {
        return this.a[0] + "," + this.a[1] + "," + this.a[2];
    }
}

