/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Meta;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Section;
import com.lowagie.text.Table;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.factories.ElementFactory;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.draw.LineSeparator;
import com.lowagie.text.xml.XmlPeer;
import com.lowagie.text.xml.simpleparser.EntitiesToSymbol;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SAXiTextHandler<T extends XmlPeer>
extends DefaultHandler {
    protected DocListener document;
    protected Stack<Element> stack;
    protected int chapters = 0;
    protected Chunk currentChunk = null;
    protected boolean ignore = false;
    private boolean a = true;
    protected Map<String, T> myTags;
    private float b = 36.0f;
    private float c = 36.0f;
    private float d = 36.0f;
    private float e = 36.0f;
    private BaseFont f = null;

    public SAXiTextHandler(DocListener docListener) {
        this.document = docListener;
        this.stack = new Stack();
    }

    public SAXiTextHandler(DocListener docListener, Map<String, T> map, BaseFont baseFont) {
        this(docListener, map);
        this.f = baseFont;
    }

    public SAXiTextHandler(DocListener docListener, Map<String, T> map) {
        this(docListener);
        this.myTags = map;
    }

    public void setControlOpenClose(boolean bl2) {
        this.a = bl2;
    }

    @Override
    public void startElement(String object, String string, String string2, Attributes attributes) {
        object = new Properties();
        if (attributes != null) {
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                String string3 = attributes.getQName(i2);
                ((Properties)object).setProperty(string3, attributes.getValue(i2));
            }
        }
        this.handleStartingTags(string2, (Properties)object);
    }

    public void handleStartingTags(String object3, Properties properties) {
        Object object2;
        if (this.ignore || "ignore".equals(object3)) {
            this.ignore = true;
            return;
        }
        if (this.currentChunk != null && (object2 = this.currentChunk.getContent()) != null && !((String)object2).trim().isEmpty()) {
            try {
                object2 = (TextElementArray)this.stack.pop();
            }
            catch (EmptyStackException emptyStackException) {
                object2 = this.f == null ? new Paragraph("", new Font()) : new Paragraph("", new Font(this.f));
            }
            object2.add(this.currentChunk);
            this.stack.push((Element)object2);
            this.currentChunk = null;
        }
        if ("chunk".equals(object3)) {
            this.currentChunk = ElementFactory.getChunk(properties);
            if (this.f != null) {
                this.currentChunk.setFont(new Font(this.f));
            }
            return;
        }
        if ("entity".equals(object3)) {
            object2 = new Font();
            if (this.currentChunk != null) {
                this.handleEndingTags("chunk");
                object2 = this.currentChunk.getFont();
            }
            this.currentChunk = EntitiesToSymbol.get(properties.getProperty("id"), (Font)object2);
            return;
        }
        if ("phrase".equals(object3)) {
            this.stack.push(ElementFactory.getPhrase(properties));
            return;
        }
        if ("anchor".equals(object3)) {
            this.stack.push(ElementFactory.getAnchor(properties));
            return;
        }
        if ("paragraph".equals(object3) || "title".equals(object3)) {
            this.stack.push(ElementFactory.getParagraph(properties));
            return;
        }
        if ("list".equals(object3)) {
            this.stack.push(ElementFactory.getList(properties));
            return;
        }
        if ("listitem".equals(object3)) {
            this.stack.push(ElementFactory.getListItem(properties));
            return;
        }
        if ("cell".equals(object3)) {
            this.stack.push(ElementFactory.getCell(properties));
            return;
        }
        if ("table".equals(object3)) {
            object2 = ElementFactory.getTable(properties);
            object3 = ((Table)object2).getProportionalWidths();
            for (int i2 = 0; i2 < ((Object)object3).length; ++i2) {
                if (object3[i2] != 0.0f) continue;
                object3[i2] = 100.0f / (float)((Object)object3).length;
            }
            try {
                ((Table)object2).setWidths((float[])object3);
            }
            catch (BadElementException badElementException) {
                throw new ExceptionConverter(badElementException);
            }
            this.stack.push((Element)object2);
            return;
        }
        if ("section".equals(object3)) {
            object2 = this.stack.pop();
            try {
                object3 = ElementFactory.getSection((Section)object2, properties);
            }
            catch (ClassCastException classCastException) {
                throw new ExceptionConverter(classCastException);
            }
            this.stack.push((Element)object2);
            this.stack.push((Element)object3);
            return;
        }
        if ("chapter".equals(object3)) {
            this.stack.push(ElementFactory.getChapter(properties));
            return;
        }
        if ("image".equals(object3)) {
            try {
                object2 = ElementFactory.getImage(properties);
                try {
                    this.addImage((Image)object2);
                    return;
                }
                catch (EmptyStackException emptyStackException) {
                    try {
                        this.document.add((Element)object2);
                        return;
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                }
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
        if ("annotation".equals(object3)) {
            object2 = ElementFactory.getAnnotation(properties);
            try {
                try {
                    object3 = (TextElementArray)this.stack.pop();
                    try {
                        object3.add((Element)object2);
                    }
                    catch (Exception exception) {
                        this.document.add((Element)object2);
                    }
                    this.stack.push((Element)object3);
                    return;
                }
                catch (EmptyStackException emptyStackException) {
                    this.document.add((Element)object2);
                    return;
                }
            }
            catch (DocumentException documentException) {
                throw new ExceptionConverter(documentException);
            }
        }
        object2 = object3;
        if ("newline".equals(object2)) {
            try {
                object2 = (TextElementArray)this.stack.pop();
                object2.add(Chunk.NEWLINE);
                this.stack.push((Element)object2);
                return;
            }
            catch (EmptyStackException emptyStackException) {
                if (this.currentChunk == null) {
                    try {
                        this.document.add(Chunk.NEWLINE);
                        return;
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                }
                this.currentChunk.append("\n");
                return;
            }
        }
        object2 = object3;
        if ("newpage".equals(object2)) {
            try {
                object2 = (TextElementArray)this.stack.pop();
                object3 = new Chunk("");
                ((Chunk)object3).setNewPage();
                if (this.f != null) {
                    ((Chunk)object3).setFont(new Font(this.f));
                }
                object2.add((Element)object3);
                this.stack.push((Element)object2);
                return;
            }
            catch (EmptyStackException emptyStackException) {
                this.document.newPage();
                return;
            }
        }
        if ("horizontalrule".equals(object3)) {
            object3 = new LineSeparator(1.0f, 100.0f, null, 1, 0.0f);
            try {
                object2 = (TextElementArray)this.stack.pop();
                object2.add((Element)object3);
                this.stack.push((Element)object2);
                return;
            }
            catch (EmptyStackException emptyStackException) {
                try {
                    this.document.add((Element)object3);
                    return;
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            }
        }
        if (this.isDocumentRoot((String)object3)) {
            Rectangle rectangle = null;
            String string = null;
            for (Object object3 : properties.keySet()) {
                object2 = (String)object3;
                object3 = properties.getProperty((String)object2);
                try {
                    if ("left".equalsIgnoreCase((String)object2)) {
                        this.d = Float.parseFloat((String)object3 + "f");
                    }
                    if ("right".equalsIgnoreCase((String)object2)) {
                        this.c = Float.parseFloat((String)object3 + "f");
                    }
                    if ("top".equalsIgnoreCase((String)object2)) {
                        this.b = Float.parseFloat((String)object3 + "f");
                    }
                    if ("bottom".equalsIgnoreCase((String)object2)) {
                        this.e = Float.parseFloat((String)object3 + "f");
                    }
                }
                catch (Exception exception) {
                    throw new ExceptionConverter(exception);
                }
                if ("pagesize".equals(object2)) {
                    try {
                        object3 = PageSize.class.getField((String)object3);
                        rectangle = (Rectangle)((Field)object3).get(null);
                        continue;
                    }
                    catch (Exception exception) {
                        throw new ExceptionConverter(exception);
                    }
                }
                if ("orientation".equals(object2)) {
                    try {
                        if (!"landscape".equals(object3)) continue;
                        string = "landscape";
                        continue;
                    }
                    catch (Exception exception) {
                        throw new ExceptionConverter(exception);
                    }
                }
                try {
                    this.document.add(new Meta((String)object2, (String)object3));
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            }
            if (rectangle != null) {
                if ("landscape".equals(string)) {
                    rectangle = rectangle.rotate();
                }
                this.document.setPageSize(rectangle);
            }
            this.document.setMargins(this.d, this.c, this.b, this.e);
            if (this.a) {
                this.document.open();
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n2, int n3) {
        this.characters(cArray, n2, n3);
    }

    @Override
    public void characters(char[] object, int n2, int n3) {
        if (this.ignore) {
            return;
        }
        String string = new String((char[])object, n2, n3);
        object = string;
        if (string.trim().isEmpty() && ((String)object).indexOf(32) < 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        n3 = ((String)object).length();
        boolean bl2 = false;
        block6: for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = ((String)object).charAt(i2);
            switch (c2) {
                case ' ': {
                    if (bl2) continue block6;
                    stringBuilder.append(c2);
                    continue block6;
                }
                case '\n': {
                    if (i2 <= 0) continue block6;
                    bl2 = true;
                    stringBuilder.append(' ');
                    continue block6;
                }
                case '\r': {
                    continue block6;
                }
                case '\t': {
                    continue block6;
                }
                default: {
                    bl2 = false;
                    stringBuilder.append(c2);
                }
            }
        }
        if (this.currentChunk == null) {
            if (this.f == null) {
                this.currentChunk = new Chunk(stringBuilder.toString());
                return;
            }
            this.currentChunk = new Chunk(stringBuilder.toString(), new Font(this.f));
            return;
        }
        this.currentChunk.append(stringBuilder.toString());
    }

    public void setBaseFont(BaseFont baseFont) {
        this.f = baseFont;
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.handleEndingTags(string3);
    }

    public void handleEndingTags(String string) {
        if ("ignore".equals(string)) {
            this.ignore = false;
            return;
        }
        if (this.ignore) {
            return;
        }
        Object object = string;
        if ("newpage".equals(object) || "annotation".equals(string) || "image".equals(string) || "newline".equals(object = string)) {
            return;
        }
        try {
            block46: {
                TextElementArray textElementArray;
                if ("title".equals(string)) {
                    object = (Paragraph)this.stack.pop();
                    if (this.currentChunk != null) {
                        ((Phrase)object).add(this.currentChunk);
                        this.currentChunk = null;
                    }
                    Section section = (Section)this.stack.pop();
                    section.setTitle((Paragraph)object);
                    this.stack.push(section);
                    return;
                }
                if (this.currentChunk != null) {
                    try {
                        object = (TextElementArray)this.stack.pop();
                    }
                    catch (EmptyStackException emptyStackException) {
                        object = new Paragraph();
                    }
                    object.add(this.currentChunk);
                    this.stack.push((Element)object);
                    this.currentChunk = null;
                }
                if ("chunk".equals(string)) {
                    return;
                }
                if ("phrase".equals(string) || "anchor".equals(string) || "list".equals(string) || "paragraph".equals(string)) {
                    object = this.stack.pop();
                    try {
                        TextElementArray textElementArray2 = (TextElementArray)this.stack.pop();
                        textElementArray2.add((Element)object);
                        this.stack.push(textElementArray2);
                        return;
                    }
                    catch (EmptyStackException emptyStackException) {
                        this.document.add((Element)object);
                        return;
                    }
                }
                if ("listitem".equals(string)) {
                    object = (ListItem)this.stack.pop();
                    textElementArray = (List)this.stack.pop();
                    textElementArray.add((Element)object);
                    this.stack.push(textElementArray);
                }
                if ("table".equals(string)) {
                    object = (Table)this.stack.pop();
                    try {
                        textElementArray = (TextElementArray)this.stack.pop();
                        textElementArray.add((Element)object);
                        this.stack.push(textElementArray);
                        return;
                    }
                    catch (EmptyStackException emptyStackException) {
                        this.document.add((Element)object);
                        return;
                    }
                }
                if ("row".equals(string)) {
                    Cell cell;
                    Object object2;
                    object = new ArrayList();
                    int n2 = 0;
                    while ((object2 = this.stack.pop()).type() == 20) {
                        cell = (Cell)object2;
                        n2 += cell.getColspan();
                        object.add(cell);
                    }
                    Table table = (Table)object2;
                    if (table.getColumns() < n2) {
                        table.addColumns(n2 - table.getColumns());
                    }
                    Collections.reverse(object);
                    float[] fArray = new float[n2];
                    boolean[] blArray = new boolean[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        fArray[i2] = 0.0f;
                        blArray[i2] = true;
                    }
                    float f2 = 0.0f;
                    int n3 = 0;
                    object = object.iterator();
                    while (object.hasNext()) {
                        Cell cell2 = (Cell)object.next();
                        cell = cell2;
                        cell = cell2;
                        object2 = cell2.getWidthAsString();
                        if (((Rectangle)cell).getWidth() == 0.0f) {
                            if (cell.getColspan() == 1 && fArray[n3] == 0.0f) {
                                try {
                                    fArray[n3] = 100.0f / (float)n2;
                                    f2 += fArray[n3];
                                }
                                catch (Exception exception) {}
                            } else if (cell.getColspan() == 1) {
                                blArray[n3] = false;
                            }
                        } else if (cell.getColspan() == 1 && ((String)object2).endsWith("%")) {
                            try {
                                fArray[n3] = Float.parseFloat(((String)object2).substring(0, ((String)object2).length() - 1) + "f");
                                f2 += fArray[n3];
                                blArray[n3] = false;
                            }
                            catch (Exception exception) {}
                        }
                        n3 += cell.getColspan();
                        table.addCell(cell);
                    }
                    float[] fArray2 = table.getProportionalWidths();
                    object = fArray2;
                    if (fArray2.length == n2) {
                        int n4;
                        float f3 = 0.0f;
                        for (n4 = 0; n4 < n2; ++n4) {
                            if (!blArray[n4] || object[n4] == 0.0f) continue;
                            f3 += object[n4];
                            fArray[n4] = (float)object[n4];
                        }
                        if (100.0 >= (double)f2) {
                            for (n4 = 0; n4 < ((Object)object).length; ++n4) {
                                if (fArray[n4] != 0.0f || object[n4] == 0.0f) continue;
                                fArray[n4] = (float)(object[n4] / f3 * (100.0f - f2));
                            }
                        }
                        table.setWidths(fArray);
                    }
                    this.stack.push(table);
                }
                if ("cell".equals(string)) {
                    return;
                }
                if ("section".equals(string)) {
                    this.stack.pop();
                    return;
                }
                if ("chapter".equals(string)) {
                    this.document.add(this.stack.pop());
                    return;
                }
                if (this.isDocumentRoot(string)) {
                    try {
                        while (true) {
                            object = this.stack.pop();
                            try {
                                TextElementArray textElementArray3 = (TextElementArray)this.stack.pop();
                                textElementArray3.add((Element)object);
                                this.stack.push(textElementArray3);
                            }
                            catch (EmptyStackException emptyStackException) {
                                this.document.add((Element)object);
                            }
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        if (!this.a) break block46;
                        this.document.close();
                    }
                }
            }
            return;
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    protected void addImage(Image image) {
        Element element = this.stack.pop();
        if (element instanceof Section || element instanceof Cell) {
            ((TextElementArray)element).add(image);
            this.stack.push(element);
            return;
        }
        if (element instanceof Phrase) {
            ((TextElementArray)element).add(new Chunk(image, 0.0f, 0.0f));
            this.stack.push(element);
            return;
        }
        Stack<Element> stack = new Stack<Element>();
        while (!(element instanceof Section) && !(element instanceof Cell)) {
            stack.push(element);
            if (element instanceof Anchor) {
                image.setAnnotation(new Annotation(0.0f, 0.0f, 0.0f, 0.0f, ((Anchor)element).getReference()));
            }
            element = this.stack.pop();
        }
        ((TextElementArray)element).add(image);
        this.stack.push(element);
        while (!stack.empty()) {
            this.stack.push((Element)stack.pop());
        }
    }

    protected boolean isDocumentRoot(String string) {
        return "itext".equals(string);
    }
}

