/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlDomWriter {
    protected PrintWriter fOut;
    protected boolean fCanonical;
    protected boolean fXML11;

    public XmlDomWriter() {
    }

    public XmlDomWriter(boolean bl2) {
        this.fCanonical = bl2;
    }

    public void setCanonical(boolean bl2) {
        this.fCanonical = bl2;
    }

    public void setOutput(OutputStream closeable, String string) {
        if (string == null) {
            string = "UTF8";
        }
        closeable = new OutputStreamWriter((OutputStream)closeable, string);
        this.fOut = new PrintWriter((Writer)closeable);
    }

    public void setOutput(Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void write(Node node) {
        if (node == null) {
            return;
        }
        short s2 = node.getNodeType();
        switch (s2) {
            case 9: {
                Document document = (Document)node;
                this.fXML11 = false;
                if (!this.fCanonical) {
                    if (this.fXML11) {
                        this.fOut.println("<?xml version=\"1.1\" encoding=\"UTF-8\"?>");
                    } else {
                        this.fOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    }
                    this.fOut.flush();
                    this.write(document.getDoctype());
                }
                this.write(document.getDocumentElement());
                break;
            }
            case 10: {
                Object object = (DocumentType)node;
                this.fOut.print("<!DOCTYPE ");
                this.fOut.print(object.getName());
                String string = object.getPublicId();
                String string2 = object.getSystemId();
                if (string != null) {
                    this.fOut.print(" PUBLIC '");
                    this.fOut.print(string);
                    this.fOut.print("' '");
                    this.fOut.print(string2);
                    this.fOut.print('\'');
                } else if (string2 != null) {
                    this.fOut.print(" SYSTEM '");
                    this.fOut.print(string2);
                    this.fOut.print('\'');
                }
                object = object.getInternalSubset();
                if (object != null) {
                    this.fOut.println(" [");
                    this.fOut.print((String)object);
                    this.fOut.print(']');
                }
                this.fOut.println('>');
                break;
            }
            case 1: {
                this.fOut.print('<');
                this.fOut.print(node.getNodeName());
                Attr[] attrArray = this.sortAttributes(node.getAttributes());
                Object object = attrArray;
                int n2 = attrArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Attr attr = object[i2];
                    this.fOut.print(' ');
                    this.fOut.print(attr.getNodeName());
                    this.fOut.print("=\"");
                    this.normalizeAndPrint(attr.getNodeValue(), true);
                    this.fOut.print('\"');
                }
                this.fOut.print('>');
                this.fOut.flush();
                for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                    this.write((Node)object);
                }
                break;
            }
            case 5: {
                if (this.fCanonical) {
                    for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        this.write(node2);
                    }
                    break;
                }
                this.fOut.print('&');
                this.fOut.print(node.getNodeName());
                this.fOut.print(';');
                this.fOut.flush();
                break;
            }
            case 4: {
                if (this.fCanonical) {
                    this.normalizeAndPrint(node.getNodeValue(), false);
                } else {
                    this.fOut.print("<![CDATA[");
                    this.fOut.print(node.getNodeValue());
                    this.fOut.print("]]>");
                }
                this.fOut.flush();
                break;
            }
            case 3: {
                this.normalizeAndPrint(node.getNodeValue(), false);
                this.fOut.flush();
                break;
            }
            case 7: {
                this.fOut.print("<?");
                this.fOut.print(node.getNodeName());
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    this.fOut.print(' ');
                    this.fOut.print(string);
                }
                this.fOut.print("?>");
                this.fOut.flush();
                break;
            }
            case 8: {
                if (this.fCanonical) break;
                this.fOut.print("<!--");
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    this.fOut.print(string);
                }
                this.fOut.print("-->");
                this.fOut.flush();
            }
        }
        if (s2 == 1) {
            this.fOut.print("</");
            this.fOut.print(node.getNodeName());
            this.fOut.print('>');
            this.fOut.flush();
        }
    }

    protected Attr[] sortAttributes(NamedNodeMap object) {
        int n2;
        int n3 = object != null ? object.getLength() : 0;
        Attr[] attrArray = new Attr[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            attrArray[n2] = (Attr)object.item(n2);
        }
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            object = attrArray[n2].getNodeName();
            int n4 = n2;
            for (int i2 = n2 + 1; i2 < n3; ++i2) {
                String string = attrArray[i2].getNodeName();
                if (string.compareTo((String)object) >= 0) continue;
                object = string;
                n4 = i2;
            }
            if (n4 == n2) continue;
            Attr attr = attrArray[n2];
            attrArray[n2] = attrArray[n4];
            attrArray[n4] = attr;
        }
        return attrArray;
    }

    protected void normalizeAndPrint(String string, boolean bl2) {
        int n2 = string != null ? string.length() : 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            this.normalizeAndPrint(c2, bl2);
        }
    }

    protected void normalizeAndPrint(char c2, boolean bl2) {
        switch (c2) {
            case '<': {
                this.fOut.print("&lt;");
                return;
            }
            case '>': {
                this.fOut.print("&gt;");
                return;
            }
            case '&': {
                this.fOut.print("&amp;");
                return;
            }
            case '\"': {
                if (bl2) {
                    this.fOut.print("&quot;");
                    return;
                }
                this.fOut.print("\"");
                return;
            }
            case '\r': {
                this.fOut.print("&#xD;");
                return;
            }
            case '\n': {
                if (!this.fCanonical) break;
                this.fOut.print("&#xA;");
                return;
            }
        }
        if (this.fXML11 && (c2 > '\u0000' && c2 <= '\u001f' && c2 != '\t' && c2 != '\n' || c2 >= '\u007f' && c2 <= '\u009f' || c2 == '\u2028') || bl2 && (c2 == '\t' || c2 == '\n')) {
            this.fOut.print("&#x");
            this.fOut.print(Integer.toHexString(c2).toUpperCase());
            this.fOut.print(";");
            return;
        }
        this.fOut.print(c2);
    }
}

