/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml;

import com.lowagie.text.DocListener;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.xml.SAXiTextHandler;
import com.lowagie.text.xml.SAXmyHandler;
import com.lowagie.text.xml.TagMap;
import com.lowagie.text.xml.XmlPeer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser {
    protected SAXParser parser;

    public XmlParser() {
        try {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
            return;
        }
        catch (ParserConfigurationException | SAXException exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public void go(DocListener docListener, InputSource inputSource) {
        try {
            this.parser.parse(inputSource, new SAXiTextHandler(docListener));
            return;
        }
        catch (IOException | SAXException exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public void go(DocListener docListener, InputSource inputSource, String string) {
        try {
            this.parser.parse(inputSource, (DefaultHandler)new SAXmyHandler(docListener, new TagMap(string)));
            return;
        }
        catch (IOException | SAXException exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public void go(DocListener docListener, InputSource inputSource, InputStream inputStream) {
        try {
            this.parser.parse(inputSource, (DefaultHandler)new SAXmyHandler(docListener, new TagMap(inputStream)));
            return;
        }
        catch (IOException | SAXException exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public void go(DocListener docListener, InputSource inputSource, Map<String, XmlPeer> map) {
        try {
            this.parser.parse(inputSource, (DefaultHandler)new SAXmyHandler(docListener, map));
            return;
        }
        catch (IOException | SAXException exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public void go(DocListener docListener, String string) {
        try {
            this.parser.parse(string, new SAXiTextHandler(docListener));
            return;
        }
        catch (IOException | SAXException exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public void go(DocListener docListener, String string, String string2) {
        try {
            this.parser.parse(string, (DefaultHandler)new SAXmyHandler(docListener, new TagMap(string2)));
            return;
        }
        catch (IOException | SAXException exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public void go(DocListener docListener, String string, Map<String, XmlPeer> map) {
        try {
            this.parser.parse(string, (DefaultHandler)new SAXmyHandler(docListener, map));
            return;
        }
        catch (IOException | SAXException exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static void parse(DocListener docListener, InputSource inputSource) {
        XmlParser xmlParser = new XmlParser();
        xmlParser.go(docListener, inputSource);
    }

    public static void parse(DocListener docListener, InputSource inputSource, String string) {
        XmlParser xmlParser = new XmlParser();
        xmlParser.go(docListener, inputSource, string);
    }

    public static void parse(DocListener docListener, InputSource inputSource, Map<String, XmlPeer> map) {
        XmlParser xmlParser = new XmlParser();
        xmlParser.go(docListener, inputSource, map);
    }

    public static void parse(DocListener docListener, String string) {
        XmlParser xmlParser = new XmlParser();
        xmlParser.go(docListener, string);
    }

    public static void parse(DocListener docListener, String string, String string2) {
        XmlParser xmlParser = new XmlParser();
        xmlParser.go(docListener, string, string2);
    }

    public static void parse(DocListener docListener, String string, Map<String, XmlPeer> map) {
        XmlParser xmlParser = new XmlParser();
        xmlParser.go(docListener, string, map);
    }

    public static void parse(DocListener docListener, InputStream inputStream) {
        XmlParser xmlParser = new XmlParser();
        xmlParser.go(docListener, new InputSource(inputStream));
    }

    public static void parse(DocListener docListener, InputStream inputStream, String string) {
        XmlParser xmlParser = new XmlParser();
        xmlParser.go(docListener, new InputSource(inputStream), string);
    }

    public static void parse(DocListener docListener, InputStream inputStream, Map<String, XmlPeer> map) {
        XmlParser xmlParser = new XmlParser();
        xmlParser.go(docListener, new InputSource(inputStream), map);
    }

    public static void parse(DocListener docListener, Reader reader) {
        XmlParser xmlParser = new XmlParser();
        xmlParser.go(docListener, new InputSource(reader));
    }

    public static void parse(DocListener docListener, Reader reader, String string) {
        XmlParser xmlParser = new XmlParser();
        xmlParser.go(docListener, new InputSource(reader), string);
    }

    public static void parse(DocListener docListener, Reader reader, Map<String, XmlPeer> map) {
        XmlParser xmlParser = new XmlParser();
        xmlParser.go(docListener, new InputSource(reader), map);
    }
}

