/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml.xmp;

import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.xml.xmp.DublinCoreSchema;
import com.lowagie.text.xml.xmp.PdfA1Schema;
import com.lowagie.text.xml.xmp.PdfSchema;
import com.lowagie.text.xml.xmp.XmpBasicSchema;
import com.lowagie.text.xml.xmp.XmpSchema;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class XmpWriter {
    public static final String UTF8 = "UTF-8";
    public static final String UTF16 = "UTF-16";
    public static final String UTF16BE = "UTF-16BE";
    public static final String UTF16LE = "UTF-16LE";
    public static final String EXTRASPACE = "                                                                                                   \n";
    protected int extraSpace;
    protected OutputStreamWriter writer;
    protected String about;
    public static final String XPACKET_PI_BEGIN = "<?xpacket begin=\"\ufeff\" id=\"W5M0MpCehiHzreSzNTczkc9d\"?>\n";
    public static final String XPACKET_PI_END_W = "<?xpacket end=\"w\"?>";
    public static final String XPACKET_PI_END_R = "<?xpacket end=\"r\"?>";
    protected char end = (char)119;

    public XmpWriter(OutputStream outputStream, String string, int n2) {
        this.extraSpace = n2;
        this.writer = new OutputStreamWriter(outputStream, string);
        this.writer.write(XPACKET_PI_BEGIN);
        this.writer.write("<x:xmpmeta xmlns:x=\"adobe:ns:meta/\">\n");
        this.writer.write("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n");
        this.about = "";
    }

    public XmpWriter(OutputStream outputStream) {
        this(outputStream, UTF8, 20);
    }

    public XmpWriter(OutputStream object, PdfDictionary pdfDictionary, int n2) {
        this((OutputStream)object);
        if (pdfDictionary != null) {
            object = new DublinCoreSchema();
            PdfSchema pdfSchema = new PdfSchema();
            XmpBasicSchema xmpBasicSchema = new XmpBasicSchema();
            for (PdfName pdfName : pdfDictionary.getKeys()) {
                PdfObject pdfObject = pdfDictionary.get(pdfName);
                if (pdfObject == null) continue;
                if (PdfName.TITLE.equals(pdfName)) {
                    ((DublinCoreSchema)object).addTitle(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.AUTHOR.equals(pdfName)) {
                    ((DublinCoreSchema)object).addAuthor(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.SUBJECT.equals(pdfName)) {
                    ((DublinCoreSchema)object).addSubject(((PdfString)pdfObject).toUnicodeString());
                    ((DublinCoreSchema)object).addDescription(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.KEYWORDS.equals(pdfName)) {
                    pdfSchema.addKeywords(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.CREATOR.equals(pdfName)) {
                    xmpBasicSchema.addCreatorTool(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.PRODUCER.equals(pdfName)) {
                    pdfSchema.addProducer(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.CREATIONDATE.equals(pdfName)) {
                    xmpBasicSchema.addCreateDate(((PdfDate)pdfObject).getW3CDate());
                }
                if (!PdfName.MODDATE.equals(pdfName)) continue;
                xmpBasicSchema.addModDate(((PdfDate)pdfObject).getW3CDate());
            }
            if (((Properties)object).size() > 0) {
                this.addRdfDescription((XmpSchema)object);
            }
            if (pdfSchema.size() > 0) {
                this.addRdfDescription(pdfSchema);
            }
            if (xmpBasicSchema.size() > 0) {
                this.addRdfDescription(xmpBasicSchema);
            }
            if (n2 == 3 || n2 == 4) {
                PdfA1Schema pdfA1Schema = new PdfA1Schema();
                if (n2 == 3) {
                    pdfA1Schema.addConformance("A");
                } else {
                    pdfA1Schema.addConformance("B");
                }
                this.addRdfDescription(pdfA1Schema);
            }
        }
    }

    public XmpWriter(OutputStream object, Map object2) {
        this((OutputStream)object);
        if (object2 != null) {
            object = new DublinCoreSchema();
            PdfSchema pdfSchema = new PdfSchema();
            XmpBasicSchema xmpBasicSchema = new XmpBasicSchema();
            Iterator iterator = object2.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object3 = object2 = iterator.next();
                object2 = (String)object2.getKey();
                if ((object3 = (String)object3.getValue()) == null) continue;
                if ("Title".equals(object2)) {
                    ((DublinCoreSchema)object).addTitle((String)object3);
                }
                if ("Author".equals(object2)) {
                    ((DublinCoreSchema)object).addAuthor((String)object3);
                }
                if ("Subject".equals(object2)) {
                    ((DublinCoreSchema)object).addSubject((String)object3);
                    ((DublinCoreSchema)object).addDescription((String)object3);
                }
                if ("Keywords".equals(object2)) {
                    pdfSchema.addKeywords((String)object3);
                }
                if ("Creator".equals(object2)) {
                    xmpBasicSchema.addCreatorTool((String)object3);
                }
                if ("Producer".equals(object2)) {
                    pdfSchema.addProducer((String)object3);
                }
                if ("CreationDate".equals(object2)) {
                    xmpBasicSchema.addCreateDate(PdfDate.getW3CDate((String)object3));
                }
                if (!"ModDate".equals(object2)) continue;
                xmpBasicSchema.addModDate(PdfDate.getW3CDate((String)object3));
            }
            if (((Properties)object).size() > 0) {
                this.addRdfDescription((XmpSchema)object);
            }
            if (pdfSchema.size() > 0) {
                this.addRdfDescription(pdfSchema);
            }
            if (xmpBasicSchema.size() > 0) {
                this.addRdfDescription(xmpBasicSchema);
            }
        }
    }

    public void setReadOnly() {
        this.end = (char)114;
    }

    public void setAbout(String string) {
        this.about = string;
    }

    public void addRdfDescription(String string, String string2) {
        this.writer.write("<rdf:Description rdf:about=\"");
        this.writer.write(this.about);
        this.writer.write("\" ");
        this.writer.write(string);
        this.writer.write(">");
        this.writer.write(string2);
        this.writer.write("</rdf:Description>\n");
    }

    public void addRdfDescription(XmpSchema xmpSchema) {
        this.writer.write("<rdf:Description rdf:about=\"");
        this.writer.write(this.about);
        this.writer.write("\" ");
        this.writer.write(xmpSchema.getXmlns());
        this.writer.write(">");
        this.writer.write(xmpSchema.toString());
        this.writer.write("</rdf:Description>\n");
    }

    public void close() {
        this.writer.write("</rdf:RDF>");
        this.writer.write("</x:xmpmeta>\n");
        for (int i2 = 0; i2 < this.extraSpace; ++i2) {
            this.writer.write(EXTRASPACE);
        }
        this.writer.write(this.end == 'r' ? XPACKET_PI_END_R : XPACKET_PI_END_W);
        this.writer.flush();
        this.writer.close();
    }
}

