/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.A;
import com.microsoft.sqlserver.jdbc.ISQLServerBulkRecord;
import com.microsoft.sqlserver.jdbc.L;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.ay;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class SQLServerBulkCSVFileRecord
implements ISQLServerBulkRecord,
AutoCloseable {
    private BufferedReader a;
    private InputStreamReader b;
    private FileInputStream c;
    private Map<Integer, a> d;
    private String e = null;
    private final String f;
    private String[] g = null;
    private DateTimeFormatter h = null;
    private DateTimeFormatter i = null;
    private static final Logger j = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord");

    public SQLServerBulkCSVFileRecord(String object, String string, String string2, boolean bl2) {
        j.entering("com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord", "SQLServerBulkCSVFileRecord", new Object[]{object, string, string2, bl2});
        if (object == null) {
            SQLServerBulkCSVFileRecord.a("fileToParse");
        } else if (string2 == null) {
            SQLServerBulkCSVFileRecord.a("delimiter");
        }
        this.f = string2;
        try {
            this.c = new FileInputStream((String)object);
            this.b = string == null || 0 == string.length() ? new InputStreamReader(this.c) : new InputStreamReader((InputStream)this.c, string);
            this.a = new BufferedReader(this.b);
            if (bl2) {
                this.e = this.a.readLine();
                if (this.e != null) {
                    this.g = this.e.split(string2, -1);
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = new MessageFormat(SQLServerException.a("R_unsupportedEncoding"));
            throw new SQLServerException(((Format)object).format(new Object[]{string}), null, 0, null);
        }
        catch (Exception exception) {
            throw new SQLServerException(null, exception.getMessage(), null, 0, false);
        }
        this.d = new HashMap<Integer, a>();
        j.exiting("com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord", "SQLServerBulkCSVFileRecord");
    }

    public SQLServerBulkCSVFileRecord(String string, String string2, boolean bl2) {
        this(string, string2, ",", bl2);
    }

    public SQLServerBulkCSVFileRecord(String string, boolean bl2) {
        this(string, null, ",", bl2);
    }

    public void addColumnMetadata(int n2, String string, int n3, int n4, int n5, DateTimeFormatter dateTimeFormatter) {
        this.a(n2, string, n3, n4, n5, dateTimeFormatter);
    }

    public void addColumnMetadata(int n2, String string, int n3, int n4, int n5) {
        this.a(n2, string, n3, n4, n5, null);
    }

    private void a(int n2, String object, int n3, int n4, int n5, DateTimeFormatter dateTimeFormatter) {
        j.entering("com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord", "addColumnMetadata", new Object[]{n2, object, n3, n4, n5});
        String string = "";
        if (n2 <= 0) {
            object = new MessageFormat(SQLServerException.a("R_invalidColumnOrdinal"));
            Object[] objectArray = new Object[]{n2};
            throw new SQLServerException(((Format)object).format(objectArray), ay.e, A.a, null);
        }
        if (object != null) {
            string = ((String)object).trim();
        } else if (this.g != null && this.g.length >= n2) {
            string = this.g[n2 - 1];
        }
        if (this.g != null && n2 > this.g.length) {
            object = new MessageFormat(SQLServerException.a("R_invalidColumn"));
            Object[] objectArray = new Object[]{n2};
            throw new SQLServerException(((Format)object).format(objectArray), ay.e, A.a, null);
        }
        this.a(n2, (String)object);
        switch (n3) {
            case -155: 
            case 91: 
            case 92: 
            case 93: {
                this.d.put(n2, new a(this, string, n3, 50, n5, dateTimeFormatter));
                break;
            }
            case 2009: {
                this.d.put(n2, new a(this, string, -16, n4, n5, dateTimeFormatter));
                break;
            }
            case 6: {
                this.d.put(n2, new a(this, string, 8, n4, n5, dateTimeFormatter));
                break;
            }
            case 16: {
                this.d.put(n2, new a(this, string, -7, n4, n5, dateTimeFormatter));
                break;
            }
            default: {
                this.d.put(n2, new a(this, string, n3, n4, n5, dateTimeFormatter));
            }
        }
        j.exiting("com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord", "addColumnMetadata");
    }

    public void setTimestampWithTimezoneFormat(String string) {
        j.entering("com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord", "setTimestampWithTimezoneFormat", string);
        this.h = DateTimeFormatter.ofPattern(string);
        j.exiting("com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord", "setTimestampWithTimezoneFormat");
    }

    public void setTimestampWithTimezoneFormat(DateTimeFormatter dateTimeFormatter) {
        j.entering("com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord", "setTimestampWithTimezoneFormat", new Object[]{dateTimeFormatter});
        this.h = dateTimeFormatter;
        j.exiting("com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord", "setTimestampWithTimezoneFormat");
    }

    public void setTimeWithTimezoneFormat(String string) {
        j.entering("com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord", "setTimeWithTimezoneFormat", string);
        this.i = DateTimeFormatter.ofPattern(string);
        j.exiting("com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord", "setTimeWithTimezoneFormat");
    }

    public void setTimeWithTimezoneFormat(DateTimeFormatter dateTimeFormatter) {
        j.entering("com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord", "setTimeWithTimezoneFormat", new Object[]{dateTimeFormatter});
        this.i = dateTimeFormatter;
        j.exiting("com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord", "setTimeWithTimezoneFormat");
    }

    @Override
    public void close() {
        j.entering("com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord", "close");
        if (this.a != null) {
            try {
                this.a.close();
            }
            catch (Exception exception) {}
        }
        if (this.b != null) {
            try {
                this.b.close();
            }
            catch (Exception exception) {}
        }
        if (this.c != null) {
            try {
                this.c.close();
            }
            catch (Exception exception) {}
        }
        j.exiting("com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord", "close");
    }

    public DateTimeFormatter getColumnDateTimeFormatter(int n2) {
        return this.d.get((Object)Integer.valueOf((int)n2)).e;
    }

    @Override
    public Set<Integer> getColumnOrdinals() {
        return this.d.keySet();
    }

    @Override
    public String getColumnName(int n2) {
        return this.d.get((Object)Integer.valueOf((int)n2)).a;
    }

    @Override
    public int getColumnType(int n2) {
        return this.d.get((Object)Integer.valueOf((int)n2)).b;
    }

    @Override
    public int getPrecision(int n2) {
        return this.d.get((Object)Integer.valueOf((int)n2)).c;
    }

    @Override
    public int getScale(int n2) {
        return this.d.get((Object)Integer.valueOf((int)n2)).d;
    }

    @Override
    public boolean isAutoIncrement(int n2) {
        return false;
    }

    @Override
    public Object[] getRowData() {
        if (this.e == null) {
            return null;
        }
        String[] stringArray = this.e.split(this.f, -1);
        Object object = new Object[stringArray.length];
        Object object2 = this.d.entrySet().iterator();
        block20: while (object2.hasNext()) {
            Object object3;
            Object object4;
            Map.Entry<Integer, a> entry = object2.next();
            a a2 = entry.getValue();
            if (stringArray.length < entry.getKey() - 1) {
                object4 = new MessageFormat(SQLServerException.a("R_invalidColumn"));
                object3 = new Object[]{entry.getKey()};
                throw new SQLServerException(((Format)object4).format(object3), ay.e, A.a, null);
            }
            if (this.g != null && this.g.length > stringArray.length) {
                object4 = new MessageFormat(SQLServerException.a("R_BulkCSVDataSchemaMismatch"));
                object3 = new Object[]{};
                throw new SQLServerException(((Format)object4).format(object3), ay.e, A.a, null);
            }
            try {
                if (0 == stringArray[entry.getKey() - 1].length()) {
                    object[entry.getKey().intValue() - 1] = null;
                    continue;
                }
                switch (a2.b) {
                    case 4: {
                        object4 = new DecimalFormat("#");
                        object3 = ((NumberFormat)object4).format(Double.parseDouble(stringArray[entry.getKey() - 1]));
                        object[entry.getKey().intValue() - 1] = Integer.valueOf((String)object3);
                        continue block20;
                    }
                    case -6: 
                    case 5: {
                        object4 = new DecimalFormat("#");
                        object3 = ((NumberFormat)object4).format(Double.parseDouble(stringArray[entry.getKey() - 1]));
                        object[entry.getKey().intValue() - 1] = Short.valueOf((String)object3);
                        continue block20;
                    }
                    case -5: {
                        object4 = new BigDecimal(stringArray[entry.getKey() - 1].trim());
                        try {
                            object[entry.getKey().intValue() - 1] = ((BigDecimal)object4).setScale(0, 1).longValueExact();
                            continue block20;
                        }
                        catch (ArithmeticException arithmeticException) {
                            object = "'" + stringArray[entry.getKey() - 1] + "'";
                            object2 = new MessageFormat(SQLServerException.a("R_errorConvertingValue"));
                            throw new SQLServerException(((Format)object2).format(new Object[]{object, L.a(a2.b)}), null, 0, null);
                        }
                    }
                    case 2: 
                    case 3: {
                        object4 = new BigDecimal(stringArray[entry.getKey() - 1].trim());
                        object[entry.getKey().intValue() - 1] = ((BigDecimal)object4).setScale(a2.d, RoundingMode.HALF_UP);
                        continue block20;
                    }
                    case -7: {
                        try {
                            object[entry.getKey().intValue() - 1] = 0.0 == Double.parseDouble(stringArray[entry.getKey() - 1]) ? Boolean.FALSE : Boolean.TRUE;
                        }
                        catch (NumberFormatException numberFormatException) {
                            object[entry.getKey().intValue() - 1] = Boolean.parseBoolean(stringArray[entry.getKey() - 1]);
                        }
                        continue block20;
                    }
                    case 7: {
                        object[entry.getKey().intValue() - 1] = Float.valueOf(Float.parseFloat(stringArray[entry.getKey() - 1]));
                        continue block20;
                    }
                    case 8: {
                        object[entry.getKey().intValue() - 1] = Double.parseDouble(stringArray[entry.getKey() - 1]);
                        continue block20;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        object4 = stringArray[entry.getKey() - 1].trim();
                        if (((String)object4).startsWith("0x") || ((String)object4).startsWith("0X")) {
                            object[entry.getKey().intValue() - 1] = ((String)object4).substring(2);
                            continue block20;
                        }
                        object[entry.getKey().intValue() - 1] = object4;
                        continue block20;
                    }
                    case 2013: {
                        object4 = a2.e != null ? OffsetTime.parse(stringArray[entry.getKey() - 1], a2.e) : (this.i != null ? OffsetTime.parse(stringArray[entry.getKey() - 1], this.i) : OffsetTime.parse(stringArray[entry.getKey() - 1]));
                        object[entry.getKey().intValue() - 1] = object4;
                        continue block20;
                    }
                    case 2014: {
                        object4 = a2.e != null ? OffsetDateTime.parse(stringArray[entry.getKey() - 1], a2.e) : (this.h != null ? OffsetDateTime.parse(stringArray[entry.getKey() - 1], this.h) : OffsetDateTime.parse(stringArray[entry.getKey() - 1]));
                        object[entry.getKey().intValue() - 1] = object4;
                        continue block20;
                    }
                    case 0: {
                        object[entry.getKey().intValue() - 1] = null;
                        continue block20;
                    }
                }
                object[entry.getKey().intValue() - 1] = stringArray[entry.getKey() - 1];
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object3 = "'" + stringArray[entry.getKey() - 1] + "'";
                object = new MessageFormat(SQLServerException.a("R_errorConvertingValue"));
                throw new SQLServerException(((Format)object).format(new Object[]{object3, L.a(a2.b)}), null, 0, null);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new SQLServerException(SQLServerException.a("R_BulkCSVDataSchemaMismatch"), null);
            }
        }
        return object;
    }

    @Override
    public boolean next() {
        try {
            this.e = this.a.readLine();
        }
        catch (IOException iOException) {
            throw new SQLServerException(null, iOException.getMessage(), null, 0, false);
        }
        return this.e != null;
    }

    private static void a(String objectArray) {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.a("R_invalidArgument"));
        objectArray = new Object[]{objectArray};
        SQLServerException.a(null, null, messageFormat.format(objectArray), null, false);
    }

    private void a(int n2, String string) {
        if (string != null && string.trim().length() != 0) {
            for (Map.Entry<Integer, a> entry : this.d.entrySet()) {
                if (entry == null || entry.getKey() == n2 || null == entry.getValue() || !string.trim().equalsIgnoreCase(entry.getValue().a)) continue;
                throw new SQLServerException(SQLServerException.a("R_BulkCSVDataDuplicateColumn"), null);
            }
        }
    }

    private final class a {
        String a;
        int b;
        int c;
        int d;
        DateTimeFormatter e = null;
        private /* synthetic */ SQLServerBulkCSVFileRecord f;

        a(SQLServerBulkCSVFileRecord sQLServerBulkCSVFileRecord, String string, int n2, int n3, int n4, DateTimeFormatter dateTimeFormatter) {
            this.f = sQLServerBulkCSVFileRecord;
            this.a = string;
            this.b = n2;
            this.c = n3;
            this.d = n4;
            this.e = dateTimeFormatter;
        }
    }
}

