/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.keyvault.KeyVaultClientImpl;
import com.microsoft.azure.keyvault.models.KeyBundle;
import com.microsoft.azure.keyvault.models.KeyOperationResult;
import com.microsoft.sqlserver.jdbc.Q;
import com.microsoft.sqlserver.jdbc.SQLServerColumnEncryptionKeyStoreProvider;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerKeyVaultAuthenticationCallback;
import com.microsoft.windowsazure.credentials.CloudCredentials;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.http.impl.client.HttpClientBuilder;

public class SQLServerColumnEncryptionAzureKeyVaultProvider
extends SQLServerColumnEncryptionKeyStoreProvider {
    private String a = "AZURE_KEY_VAULT";
    private final String b = "vault.azure.net";
    private final String c = "RSA-OAEP";
    private final byte[] d = new byte[]{1};
    private KeyVaultClient e;
    private Q f;

    @Override
    public void setName(String string) {
        this.a = string;
    }

    @Override
    public String getName() {
        return this.a;
    }

    public SQLServerColumnEncryptionAzureKeyVaultProvider(SQLServerKeyVaultAuthenticationCallback object, ExecutorService objectArray) {
        if (object == null) {
            object = new MessageFormat(SQLServerException.a("R_NullValue"));
            objectArray = new Object[]{"SQLServerKeyVaultAuthenticationCallback"};
            throw new SQLServerException(((Format)object).format(objectArray), null);
        }
        this.f = new Q((SQLServerKeyVaultAuthenticationCallback)object);
        object = HttpClientBuilder.create();
        this.e = new KeyVaultClientImpl((HttpClientBuilder)object, (ExecutorService)objectArray, (CloudCredentials)this.f);
    }

    @Override
    public byte[] decryptColumnEncryptionKey(String objectArray, String object, byte[] object2) {
        SQLServerColumnEncryptionAzureKeyVaultProvider.b((String)objectArray);
        if (object2 == null) {
            throw new SQLServerException(SQLServerException.a("R_NullEncryptedColumnEncryptionKey"), null);
        }
        if (0 == ((byte[])object2).length) {
            throw new SQLServerException(SQLServerException.a("R_EmptyEncryptedColumnEncryptionKey"), null);
        }
        object = this.a((String)object);
        int n2 = this.c((String)objectArray);
        if (object2[0] != this.d[0]) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.a("R_InvalidEcryptionAlgorithmVersion"));
            Object[] objectArray2 = new Object[]{String.format("%02X ", object2[0]), String.format("%02X ", this.d[0])};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray2), null, 0, false);
        }
        int n3 = this.d.length;
        int n4 = SQLServerColumnEncryptionAzureKeyVaultProvider.a(object2, n3);
        short s2 = SQLServerColumnEncryptionAzureKeyVaultProvider.a(object2, n3 += 2);
        n3 += 2;
        n3 += n4;
        if (s2 != n2) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.a("R_AKVKeyLengthError"));
            Object[] objectArray3 = new Object[]{s2, n2, objectArray};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray3), null, 0, false);
        }
        n4 = ((byte[])object2).length - n3 - s2;
        if (n4 != n2) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.a("R_AKVSignatureLengthError"));
            Object[] objectArray4 = new Object[]{n4, n2, objectArray};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray4), null, 0, false);
        }
        byte[] byArray = new byte[s2];
        System.arraycopy(object2, n3, byArray, 0, s2);
        byte[] byArray2 = new byte[n4];
        System.arraycopy(object2, n3 += s2, byArray2, 0, n4);
        byte[] byArray3 = new byte[((byte[])object2).length - byArray2.length];
        System.arraycopy(object2, 0, byArray3, 0, ((byte[])object2).length - byArray2.length);
        try {
            object2 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SQLServerException(SQLServerException.a("R_NoSHA256Algorithm"), null);
        }
        object2.update(byArray3);
        object2 = object2.digest();
        if (object2 == null) {
            throw new SQLServerException(SQLServerException.a("R_HashNull"), null);
        }
        if (!this.a((byte[])object2, byArray2, (String)objectArray)) {
            object = new MessageFormat(SQLServerException.a("R_CEKSignatureNotMatchCMK"));
            objectArray = new Object[]{objectArray};
            throw new SQLServerException((Object)this, ((Format)object).format(objectArray), null, 0, false);
        }
        byte[] byArray4 = this.b((String)objectArray, (String)object, byArray);
        object = byArray4;
        return byArray4;
    }

    private static short a(byte[] byArray, int n2) {
        if (n2 + 1 >= byArray.length) {
            throw new SQLServerException(null, SQLServerException.a("R_ByteToShortConversion"), null, 0, false);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(byArray[n2]);
        byteBuffer.put(byArray[n2 + 1]);
        short s2 = byteBuffer.getShort(0);
        return s2;
    }

    @Override
    public byte[] encryptColumnEncryptionKey(String string, String object, byte[] objectArray) {
        Object object2;
        byte[] byArray;
        SQLServerColumnEncryptionAzureKeyVaultProvider.b(string);
        if (objectArray == null) {
            throw new SQLServerException(SQLServerException.a("R_NullColumnEncryptionKey"), null);
        }
        if (0 == objectArray.length) {
            throw new SQLServerException(SQLServerException.a("R_EmptyCEK"), null);
        }
        object = this.a((String)object);
        int n2 = this.c(string);
        byte[] byArray2 = new byte[]{this.d[0]};
        try {
            byArray = string.toLowerCase().getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = new MessageFormat(SQLServerException.a("R_unsupportedEncoding"));
            objectArray = new Object[]{"UTF-16LE"};
            throw new SQLServerException((Object)this, ((Format)object).format(objectArray), null, 0, false);
        }
        byte[] byArray3 = new byte[2];
        byte[] byArray4 = byArray3;
        byArray3[0] = (byte)byArray.length;
        byArray4[1] = (byte)((short)byArray.length >> 8);
        object = this.a(string, (String)object, (byte[])objectArray);
        byte[] byArray5 = new byte[2];
        objectArray = byArray5;
        byArray5[0] = (byte)((Object)object).length;
        objectArray[1] = (byte)((short)((Object)object).length >> 8);
        if (((Object)object).length != n2) {
            throw new SQLServerException(SQLServerException.a("R_CipherTextLengthNotMatchRSASize"), null);
        }
        int cfr_ignored_0 = byArray2.length;
        int cfr_ignored_1 = byArray4.length;
        int cfr_ignored_2 = objectArray.length;
        byte[] byArray6 = new byte[5 + byArray.length + ((Object)object).length];
        int cfr_ignored_3 = byArray2.length;
        System.arraycopy(byArray2, 0, byArray6, 0, byArray2.length);
        System.arraycopy(byArray4, 0, byArray6, 1, byArray4.length);
        int cfr_ignored_4 = byArray4.length;
        System.arraycopy(objectArray, 0, byArray6, 3, objectArray.length);
        int cfr_ignored_5 = objectArray.length;
        System.arraycopy(byArray, 0, byArray6, 5, byArray.length);
        int n3 = 5 + byArray.length;
        System.arraycopy(object, 0, byArray6, n3, ((Object)object).length);
        try {
            object2 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SQLServerException(SQLServerException.a("R_NoSHA256Algorithm"), null);
        }
        ((MessageDigest)object2).update(byArray6);
        byArray6 = ((MessageDigest)object2).digest();
        byte[] byArray7 = this.a(byArray6, string);
        object2 = byArray7;
        if (byArray7.length != n2) {
            throw new SQLServerException(SQLServerException.a("R_SignedHashLengthError"), null);
        }
        if (!this.a(byArray6, (byte[])object2, string)) {
            throw new SQLServerException(SQLServerException.a("R_InvalidSignatureComputed"), null);
        }
        int cfr_ignored_6 = byArray2.length;
        int cfr_ignored_7 = objectArray.length;
        int cfr_ignored_8 = byArray4.length;
        int n4 = 5 + ((Object)object).length + byArray.length + ((Object)object2).length;
        byte[] byArray8 = new byte[n4];
        System.arraycopy(byArray2, 0, byArray8, 0, byArray2.length);
        int cfr_ignored_9 = byArray2.length;
        System.arraycopy(byArray4, 0, byArray8, 1, byArray4.length);
        int cfr_ignored_10 = byArray4.length;
        System.arraycopy(objectArray, 0, byArray8, 3, objectArray.length);
        int cfr_ignored_11 = objectArray.length;
        System.arraycopy(byArray, 0, byArray8, 5, byArray.length);
        int n5 = 5 + byArray.length;
        System.arraycopy(object, 0, byArray8, n5, ((Object)object).length);
        System.arraycopy(object2, 0, byArray8, n5 += ((Object)object).length, ((Object)object2).length);
        return byArray8;
    }

    private String a(String objectArray) {
        if (objectArray == null) {
            throw new SQLServerException(null, SQLServerException.a("R_NullKeyEncryptionAlgorithm"), null, 0, false);
        }
        if (objectArray.equalsIgnoreCase("RSA_OAEP")) {
            objectArray = "RSA-OAEP";
        }
        if (!"RSA-OAEP".equalsIgnoreCase(objectArray.trim())) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.a("R_InvalidKeyEncryptionAlgorithm"));
            objectArray = new Object[]{objectArray, "RSA-OAEP"};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        return objectArray;
    }

    private static void b(String objectArray) {
        Object[] objectArray2;
        if (objectArray == null || objectArray.trim().isEmpty()) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.a("R_AKVPathNull"));
            Object[] objectArray3 = new Object[]{objectArray};
            throw new SQLServerException(null, messageFormat.format(objectArray3), null, 0, false);
        }
        try {
            objectArray2 = new URI((String)objectArray);
        }
        catch (URISyntaxException uRISyntaxException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.a("R_AKVURLInvalid"));
            objectArray = new Object[]{objectArray};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
        }
        if (!objectArray2.getHost().toLowerCase().endsWith("vault.azure.net")) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.a("R_AKVMasterKeyPathInvalid"));
            objectArray2 = new Object[]{objectArray};
            throw new SQLServerException(null, messageFormat.format(objectArray2), null, 0, false);
        }
    }

    private byte[] a(String string, String string2, byte[] byArray) {
        if (byArray == null) {
            throw new SQLServerException(SQLServerException.a("R_CEKNull"), null);
        }
        try {
            string = (KeyOperationResult)this.e.wrapKeyAsync(string, string2, byArray).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new SQLServerException(SQLServerException.a("R_EncryptCEKError"), null);
        }
        return string.getResult();
    }

    private byte[] b(String string, String string2, byte[] byArray) {
        if (0 == byArray.length) {
            throw new SQLServerException(SQLServerException.a("R_EmptyEncryptedCEK"), null);
        }
        try {
            string = (KeyOperationResult)this.e.unwrapKeyAsync(string, string2, byArray).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new SQLServerException(SQLServerException.a("R_DecryptCEKError"), null);
        }
        return string.getResult();
    }

    private byte[] a(byte[] object, String string) {
        assert (object != null && 0 != ((byte[])object).length);
        try {
            object = (KeyOperationResult)this.e.signAsync(string, "RS256", object).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new SQLServerException(SQLServerException.a("R_GenerateSignature"), null);
        }
        return object.getResult();
    }

    private boolean a(byte[] byArray, byte[] byArray2, String string) {
        boolean bl2;
        assert (byArray != null && 0 != byArray.length);
        assert (byArray2 != null && 0 != byArray2.length);
        try {
            bl2 = (Boolean)this.e.verifyAsync(string, "RS256", byArray, byArray2).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new SQLServerException(SQLServerException.a("R_VerifySignature"), null);
        }
        return bl2;
    }

    private int c(String objectArray) {
        try {
            objectArray = (KeyBundle)this.e.getKeyAsync((String)objectArray).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new SQLServerException(SQLServerException.a("R_GetAKVKeySize"), null);
        }
        if (!objectArray.getKey().getKty().equalsIgnoreCase("RSA") && !objectArray.getKey().getKty().equalsIgnoreCase("RSA-HSM")) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.a("R_NonRSAKey"));
            objectArray = new Object[]{objectArray.getKey().getKty()};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
        }
        return objectArray.getKey().getN().length;
    }
}

