/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.P;
import com.microsoft.sqlserver.jdbc.SQLServerColumnEncryptionKeyStoreProvider;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.m;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.Format;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class SQLServerColumnEncryptionJavaKeyStoreProvider
extends SQLServerColumnEncryptionKeyStoreProvider {
    private String a = "MSSQL_JAVA_KEYSTORE";
    private String b = null;
    private char[] c = null;
    private static final Logger d = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerColumnEncryptionJavaKeyStoreProvider");

    @Override
    public void setName(String string) {
        this.a = string;
    }

    @Override
    public String getName() {
        return this.a;
    }

    public SQLServerColumnEncryptionJavaKeyStoreProvider(String objectArray, char[] object) {
        d.entering(SQLServerColumnEncryptionJavaKeyStoreProvider.class.getName(), "SQLServerColumnEncryptionJavaKeyStoreProvider");
        if (objectArray == null || 0 == objectArray.length()) {
            object = new MessageFormat(SQLServerException.a("R_InvalidConnectionSetting"));
            objectArray = new Object[]{"keyStoreLocation", objectArray};
            throw new SQLServerException(((Format)object).format(objectArray), null);
        }
        this.b = objectArray;
        if (d.isLoggable(Level.FINE)) {
            d.fine("Path of key store provider is set.");
        }
        if (object == null) {
            object = "".toCharArray();
        }
        this.c = new char[((char[])object).length];
        System.arraycopy(object, 0, this.c, 0, ((Object)object).length);
        if (d.isLoggable(Level.FINE)) {
            d.fine("Password for key store provider is set.");
        }
        d.exiting(SQLServerColumnEncryptionJavaKeyStoreProvider.class.getName(), "SQLServerColumnEncryptionJavaKeyStoreProvider");
    }

    @Override
    public byte[] decryptColumnEncryptionKey(String object, String string, byte[] byArray) {
        d.entering(SQLServerColumnEncryptionJavaKeyStoreProvider.class.getName(), "decryptColumnEncryptionKey", "Decrypting Column Encryption Key.");
        P.a((String)object);
        m m2 = this.a((String)object);
        object = P.a((String)object, string, byArray, m2);
        d.exiting(SQLServerColumnEncryptionJavaKeyStoreProvider.class.getName(), "decryptColumnEncryptionKey", "Finished decrypting Column Encryption Key.");
        return object;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private m a(String object) {
        FileInputStream fileInputStream = null;
        try {
            KeyStore keyStore;
            if (object == null) throw new SQLServerException(null, SQLServerException.a("R_InvalidMasterKeyDetails"), null, 0, false);
            if (0 == ((String)object).length()) {
                throw new SQLServerException(null, SQLServerException.a("R_InvalidMasterKeyDetails"), null, 0, false);
            }
            try {
                keyStore = KeyStore.getInstance("JKS");
                fileInputStream = new FileInputStream(this.b);
                keyStore.load(fileInputStream, this.c);
            }
            catch (IOException iOException) {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                keyStore = KeyStore.getInstance("PKCS12");
                fileInputStream = new FileInputStream(this.b);
                keyStore.load(fileInputStream, this.c);
            }
            object = this.a(keyStore, (String)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new SQLServerException((Object)this, SQLServerException.a("R_KeyStoreNotFound"), null, 0, false);
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.a("R_invalidKeyStoreFile"));
                    Object[] objectArray = new Object[]{this.b};
                    throw new SQLServerException(messageFormat.format(objectArray), exception);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream == null) throw throwable;
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            fileInputStream.close();
            return object;
        }
        catch (IOException iOException) {
            return object;
        }
    }

    private m a(KeyStore objectArray, String string) {
        try {
            X509Certificate x509Certificate = (X509Certificate)objectArray.getCertificate(string);
            objectArray = objectArray.getKey(string, this.c);
            if (x509Certificate == null) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.a("R_CertificateNotFoundForAlias"));
                objectArray = new Object[]{string, "MSSQL_JAVA_KEYSTORE"};
                throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
            }
            if (objectArray == null) {
                throw new UnrecoverableKeyException();
            }
            return new m(x509Certificate, (Key)objectArray);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            objectArray = new MessageFormat(SQLServerException.a("R_UnrecoverableKeyAE"));
            Object[] objectArray2 = new Object[]{string};
            throw new SQLServerException((Object)this, objectArray.format(objectArray2), null, 0, false);
        }
        catch (KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
            objectArray = new MessageFormat(SQLServerException.a("R_CertificateError"));
            Object[] objectArray3 = new Object[]{string, this.a};
            throw new SQLServerException(objectArray.format(objectArray3), generalSecurityException);
        }
    }

    @Override
    public byte[] encryptColumnEncryptionKey(String object, String object2, byte[] byArray) {
        d.entering(SQLServerColumnEncryptionJavaKeyStoreProvider.class.getName(), Thread.currentThread().getStackTrace()[1].getMethodName(), "Encrypting Column Encryption Key.");
        byte[] byArray2 = P.a;
        P.a((String)object);
        if (byArray == null) {
            throw new SQLServerException(null, SQLServerException.a("R_NullColumnEncryptionKey"), null, 0, false);
        }
        if (0 == byArray.length) {
            throw new SQLServerException(null, SQLServerException.a("R_EmptyColumnEncryptionKey"), null, 0, false);
        }
        P.a((String)object2, true);
        object2 = this.a((String)object);
        byArray = this.a(byArray, (m)object2);
        byte[] byArray3 = SQLServerColumnEncryptionJavaKeyStoreProvider.a((short)byArray.length);
        try {
            object = ((String)object).toLowerCase().getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.a("R_unsupportedEncoding"));
            throw new SQLServerException(messageFormat.format(new Object[]{"UTF-16LE"}), null, 0, null);
        }
        byte[] byArray4 = SQLServerColumnEncryptionJavaKeyStoreProvider.a((short)((Object)object).length);
        byte[] byArray5 = new byte[byArray2.length + byArray4.length + byArray3.length + ((Object)object).length + byArray.length];
        int n2 = byArray2.length;
        System.arraycopy(byArray2, 0, byArray5, 0, byArray2.length);
        System.arraycopy(byArray4, 0, byArray5, n2, byArray4.length);
        System.arraycopy(byArray3, 0, byArray5, n2 += byArray4.length, byArray3.length);
        System.arraycopy(object, 0, byArray5, n2 += byArray3.length, ((Object)object).length);
        System.arraycopy(byArray, 0, byArray5, n2 += ((Object)object).length, byArray.length);
        object2 = this.b(byArray5, (m)object2);
        int n3 = byArray2.length + byArray3.length + byArray4.length + byArray.length + ((Object)object).length + ((Object)object2).length;
        byte[] byArray6 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray6, 0, byArray2.length);
        int n4 = 0 + byArray2.length;
        System.arraycopy(byArray4, 0, byArray6, n4, byArray4.length);
        System.arraycopy(byArray3, 0, byArray6, n4 += byArray4.length, byArray3.length);
        System.arraycopy(object, 0, byArray6, n4 += byArray3.length, ((Object)object).length);
        System.arraycopy(byArray, 0, byArray6, n4 += ((Object)object).length, byArray.length);
        System.arraycopy(object2, 0, byArray6, n4 += byArray.length, ((Object)object2).length);
        d.exiting(SQLServerColumnEncryptionJavaKeyStoreProvider.class.getName(), Thread.currentThread().getStackTrace()[1].getMethodName(), "Finished encrypting Column Encryption Key.");
        return byArray6;
    }

    private byte[] a(byte[] object, m objectArray) {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(1, objectArray.a.getPublicKey());
            cipher.update((byte[])object);
            object = cipher.doFinal();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {
            object = new MessageFormat(SQLServerException.a("R_EncryptionFailed"));
            objectArray = new Object[]{generalSecurityException.getMessage()};
            throw new SQLServerException((Object)this, ((Format)object).format(objectArray), null, 0, false);
        }
        return object;
    }

    private byte[] b(byte[] byArray, m object) {
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign((PrivateKey)((m)object).b);
            signature.update(byArray);
            byArray = signature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException generalSecurityException) {
            object = new MessageFormat(SQLServerException.a("R_EncryptionFailed"));
            Object[] objectArray = new Object[]{generalSecurityException.getMessage()};
            throw new SQLServerException((Object)this, ((Format)object).format(objectArray), null, 0, false);
        }
        return byArray;
    }

    private static byte[] a(short s2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte[] byArray = byteBuffer.putShort(s2).array();
        return byArray;
    }
}

