/*
 * Decompiled with CFR 0.152.
 */
package fiskalizacija;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.pdf417.PDF417Writer;
import fiskalizacija.SysUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.imageio.ImageIO;

public class BarCodeFactory {
    public void test() {
        Object object = "Pjero manjifiko";
        String string = "QRCode.png";
        String string2 = "UTF-8";
        object = this.createQRCodeBitMatrix((String)object, string2, 200, 200);
        this.saveCodeMatrixToImage(string, (BitMatrix)object);
        SysUtil.vdevout("QR Code image created successfully!");
        SysUtil.vdevout("Data read from QR Code: " + this.readQRCode(string, string2));
    }

    public BitMatrix createPDF417CodeBitMatrix(String string, String string2, String object, int n2, int n3) {
        object = new PDF417Writer();
        Hashtable<EncodeHintType, String> hashtable = new Hashtable<EncodeHintType, String>();
        hashtable.put(EncodeHintType.CHARACTER_SET, string2);
        string = string.replace("\\r\\n", System.getProperty("line.separator"));
        string = string.replace("\\n", System.getProperty("line.separator"));
        return object.encode(string, BarcodeFormat.PDF_417, n2, n3, hashtable);
    }

    public BufferedImage createPDF417CodeImage(String object, String string, String string2, int n2, int n3) {
        object = this.createPDF417CodeBitMatrix((String)object, string, string2, n2, n3);
        return MatrixToImageWriter.toBufferedImage((BitMatrix)object);
    }

    public BufferedImage createQrCodeImage(String object, String string, int n2, int n3) {
        object = this.createQRCodeBitMatrix((String)object, string, n2, n3);
        return MatrixToImageWriter.toBufferedImage((BitMatrix)object);
    }

    public BitMatrix createQRCodeBitMatrix(String object, String string, int n2, int n3) {
        Hashtable<EncodeHintType, String> hashtable = new Hashtable<EncodeHintType, String>();
        hashtable.put(EncodeHintType.CHARACTER_SET, string);
        object = ((String)object).replace("\\r\\n", System.getProperty("line.separator"));
        object = ((String)object).replace("\\n", System.getProperty("line.separator"));
        object = new MultiFormatWriter().encode(new String(((String)object).getBytes(string), string), BarcodeFormat.QR_CODE, n3, n2, hashtable);
        return object;
    }

    public void saveCodeMatrixToImage(String string, BitMatrix bitMatrix) {
        String string2 = string;
        MatrixToImageWriter.writeToFile(bitMatrix, string2.substring(string2.lastIndexOf(46) + 1), new File(string));
    }

    public String readQRCode(String object, String object2) {
        object2 = new HashMap();
        object = new BinaryBitmap(new HybridBinarizer(new BufferedImageLuminanceSource(ImageIO.read(new FileInputStream((String)object)))));
        object = new MultiFormatReader().decode((BinaryBitmap)object, (Map<DecodeHintType, ?>)object2);
        return ((Result)object).getText();
    }

    public String barcodetext(InputStream object) {
        object = this.decodeImage((InputStream)object);
        return ((BarcodeInfo)object).getText();
    }

    public BarcodeInfo decodeImage(InputStream object) {
        try {
            object = new BinaryBitmap(new HybridBinarizer(new BufferedImageLuminanceSource(ImageIO.read((InputStream)object))));
            if (((BinaryBitmap)object).getWidth() < ((BinaryBitmap)object).getHeight() && ((BinaryBitmap)object).isRotateSupported()) {
                object = ((BinaryBitmap)object).rotateCounterClockwise();
            }
            return this.decode((BinaryBitmap)object);
        }
        catch (IOException iOException) {
            throw new BarcodeDecodingException(iOException);
        }
    }

    private BarcodeInfo decode(BinaryBitmap object) {
        MultiFormatReader multiFormatReader = new MultiFormatReader();
        try {
            object = multiFormatReader.decode((BinaryBitmap)object);
            return new BarcodeInfo(((Result)object).getText(), ((Result)object).getBarcodeFormat().toString());
        }
        catch (Exception exception) {
            throw new BarcodeDecodingException(exception);
        }
    }

    public static class BarcodeDecodingException
    extends Exception {
        BarcodeDecodingException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class BarcodeInfo {
        private final String text;
        private final String format;

        public String getText() {
            return this.text;
        }

        public String getFormat() {
            return this.format;
        }

        BarcodeInfo(String string, String string2) {
            this.text = string;
            this.format = string2;
        }
    }
}

