/*
 * Decompiled with CFR 0.152.
 */
package fiskalizacija;

import ConfigRelated.LoadIni;
import SYSTEM.EchoChecker;
import SYSTEM.EchoSheduler;
import SYSTEM.LicenseManager;
import SYSTEM.NewTray;
import SYSTEM.Pmenu;
import UTIL.EnhProperies;
import UTIL.KeyStoreUtil;
import UTIL.PluginLoader;
import UTIL.Register;
import UTIL.StringUtils;
import UTIL.TxtFileWriter;
import com.google.gson.JsonObject;
import com.sun.net.httpserver.HttpHandler;
import fiskalizacija.Cfg;
import fiskalizacija.DDNSSheduler;
import fiskalizacija.FILE_Server;
import fiskalizacija.FileWaiter;
import fiskalizacija.HTTPS_Server;
import fiskalizacija.HTTP_Server;
import fiskalizacija.MainSplash;
import fiskalizacija.Setup;
import fiskalizacija.SysUtil;
import fiskalizacija.Utilities;
import fiskalizacija.VosHandler;
import java.awt.SystemTray;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.net.ServerSocket;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HrFiskalizator {
    public static final Logger logger;
    public static PluginLoader pluginsloader;
    public static FileHandler fh;
    public static EnhProperies p;
    public static EnhProperies s;
    public static EchoChecker echoChecker;
    public static EchoSheduler echoSheduler;
    public static Instant start;
    public static String restartString;
    public static ArrayList<String> pluginsWEBhandlerNames;
    public static ArrayList<HttpHandler> pluginsWEBHandlers;
    public static JsonObject licenceList;

    public static void main(String[] object) {
        Object object2;
        String string;
        block16: {
            Cfg.setArgs(object);
            System.setProperty("file.encoding", "UTF-8");
            System.setProperty("console.encoding", "UTF-8");
            string = "";
            SysUtil.setOnLinux();
            SysUtil.setLoger();
            object2 = System.getProperty("java.home") + " " + System.getProperty("java.version") + "(" + System.getProperty("sun.arch.data.model") + "bit)";
            System.out.println("JRE : " + (String)object2);
            Cfg.aaddToMenuHint("\nJRE : " + (String)object2);
            object2 = new StringBuilder();
            ((StringBuilder)object2).append(System.getProperty("java.home")).append(File.separator).append("bin").append(File.separator).append("java ");
            ((StringBuilder)object2).append("-cp ").append(ManagementFactory.getRuntimeMXBean().getClassPath()).append(" ");
            ((StringBuilder)object2).append(HrFiskalizator.class.getName()).append(" ");
            ManagementFactory.getRuntimeMXBean().getInputArguments().forEach(arg_0 -> HrFiskalizator.lambda$main$0((StringBuilder)object2, arg_0));
            restartString = ((StringBuilder)object2).toString();
            if (StringUtils.indexOfStrArray(object, "SERVICE") >= 0) {
                Cfg.SERVICEMODE = true;
            }
            if (((String[])object).length > 0) {
                string = object[0].toUpperCase();
                if (StringUtils.indexOfStrArray(Cfg.getLineCommands(), string) >= 0) {
                    HrFiskalizator.ProcesLineCommand(object);
                }
            }
            try {
                object2 = new RandomAccessFile(".instance.lock", "rw");
                object2 = ((RandomAccessFile)object2).getChannel();
                if (((FileChannel)object2).tryLock() != null) break block16;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    logger.log(Level.SEVERE, interruptedException.getMessage());
                }
                if (((FileChannel)object2).tryLock() == null) {
                    SysUtil.msg("HrFiskalizator ve\u010d radi\n\nGasim novu instancu....", "Info", 2000);
                    System.exit(0);
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException.toString());
            }
        }
        p = new LoadIni(Cfg.getIniName(), 2).run("UTF-8");
        object2 = new File(".");
        System.out.println("Current Working Directory: " + ((File)object2).getAbsolutePath());
        SysUtil.checkAudioPreset();
        s = new LoadIni("translations/strings.trans", 1).run("UTF-8");
        switch (string) {
            case "SETUP": {
                Cfg.setSetupMode(true);
                Cfg.setMainConfig(p, true);
                SysUtil.skinChanger(p.getProperty("LOOKANDFEEL"));
                System.setProperty("user.dir", p.getProperty("RADNIFOLDER"));
                object = new KeyStoreUtil();
                object.importCertNoMessages();
                object = new Setup();
                object.setVisible(true);
                return;
            }
        }
        Cfg.setMainConfig(p, true);
        try {
            System.setProperty("user.dir", p.getProperty("RADNIFOLDER"));
            HrFiskalizator.normal(object);
            return;
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage());
            return;
        }
    }

    public static void restartApp() {
        String string = " ";
        for (String string2 : Cfg.getArgs()) {
            string = string + " " + string2;
        }
        if (!string.contains("file.encoding")) {
            string = string + " -Dfile.encoding=UTF-8  ";
        }
        try {
            Thread.sleep(1000L);
            System.out.println(restartString + string);
            if (SysUtil.isOnLinux()) {
                System.out.println("Runing on Linux");
                Runtime.getRuntime().exec("HrFiskalizator.sh " + string);
            } else {
                Runtime.getRuntime().exec(restartString + string);
            }
            System.exit(0);
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (InterruptedException interruptedException) {
            logger.log(Level.WARNING, "Gre\u0161ka kod poku\u0161aja restarta HrFiskalizatora :{0}", interruptedException.getMessage());
            return;
        }
    }

    private static boolean isLocalPortInUse(int n2) {
        try {
            new ServerSocket(n2).close();
            return false;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public static void normal(String[] stringArray) {
        String string;
        Object object = new Object(){}.getClass().getEnclosingClass().getSimpleName();
        boolean bl2 = LicenseManager.validateLicense((String)object, string = (String)object + "-" + Cfg.getVERSION());
        if (!bl2) {
            bl2 = Cfg.GetPkey("SERVER").equals("Testni");
        }
        Object object2 = "Ugra\u0111eno u HrFiskalizator";
        if (bl2) {
            LicenseManager.setVersion((String)object, string);
            LicenseManager.addLicenceToList("iEracuni", (String)object2, SysUtil.tomorrowDate());
            LicenseManager.addLicenceToList("FinaHandler", (String)object2, SysUtil.tomorrowDate());
            LicenseManager.addLicenceToList("eIzvjestavanje", (String)object2, SysUtil.tomorrowDate());
        } else {
            SysUtil.toConsole((String)object + " licence expired ...");
            if (SysUtil.runningFromJar()) {
                new Thread(() -> {
                    if (SysUtil.Upit("Pozdrav ....", "Osigurajte klju\u010d HrFiskalizatora za svoje ra\u010dunalo i potpomognite \n na\u0161 trud da vam omogu\u0107imo pouzdan rad !", "Vi\u0161e o registraciji", "Hvala za sada") == 0) {
                        SysUtil.openWebpage(Cfg.hrfweb + "uvijeti-uporabe.html");
                    }
                }).start();
            }
            if (bl2 = Cfg.GetPkey("SERVER").equals("Testni")) {
                LicenseManager.addLicenceToList("iEracuni", (String)object2, SysUtil.tomorrowDate());
                LicenseManager.addLicenceToList("FinaHandler", (String)object2, SysUtil.tomorrowDate());
                LicenseManager.addLicenceToList("eIzvjestavanje", (String)object2, SysUtil.tomorrowDate());
            }
        }
        LicenseManager.isLicenceValid((String)object);
        Utilities.checkPersonalCerticateExpiration(5);
        if (!Cfg.SERVICEMODE && StringUtils.indexOfStrArray(stringArray, "NOSPLASH") == -1) {
            object = new MainSplash();
            ((MainSplash)object).execute(3000);
        }
        if ("TRUE".equals(p.getProperty("DEBUGMODE").toUpperCase())) {
            System.out.println("STARTED IN DEBUGMODE");
        }
        System.out.println(String.format("file.encoding: %s", System.getProperty("file.encoding")));
        System.out.println(String.format("defaultCharset: %s", Charset.defaultCharset().name()));
        if (!Cfg.SERVICEMODE) {
            if (SystemTray.isSupported()) {
                if (StringUtils.indexOfStrArray(stringArray, "NOMENU") == -1) {
                    Cfg.setPmenu(new Pmenu());
                    new NewTray(Cfg.getPmenu());
                } else {
                    new NewTray(null);
                }
            } else {
                System.out.println("System tray is not supported !!! ");
            }
        } else {
            System.out.println("Program started wirh SERVICE parameter");
            Cfg.setTrayExist(false);
        }
        if (p.getProperty("SERVER").equals("Produkcijski")) {
            Cfg.setServerPU("https://cis.porezna-uprava.hr:8449/", "/FiskalizacijaService");
        }
        Cfg.aaddToMenuHint("\nServer PU : " + p.getProperty("SERVER"));
        Cfg.aaddToMenuHint("\nServer IERACUNI : " + p.getProperty("IERACUNISERVER"));
        pluginsloader = new PluginLoader();
        pluginsloader.loadPlugins();
        if (SysUtil.StrToBol(p.getProperty("HTTPLISTENER"))) {
            object = " je zauzet \n Web server HrFiskalizatora nemo\u017ee biti pokrenut na tom portu.\nProvjerite koja aplikacija zauzima port ....";
            string = p.getProperty("PORT");
            String string2 = p.getProperty("PORTSSL");
            object2 = !"".equals(string) ? Integer.valueOf(string) : Integer.valueOf(0);
            Integer n2 = !"".equals(string2) ? Integer.valueOf(string2) : Integer.valueOf(0);
            try {
                if ((Integer)object2 != 0) {
                    if (HrFiskalizator.isLocalPortInUse((Integer)object2)) {
                        SysUtil.msg("Port " + string + (String)object, "Info", 3000);
                    } else {
                        HTTP_Server.start(stringArray);
                    }
                }
                if (n2 != 0) {
                    if (HrFiskalizator.isLocalPortInUse(n2)) {
                        SysUtil.msg("Port " + string2 + (String)object, "Info", 3000);
                    } else {
                        object = new HTTPS_Server();
                        ((HTTPS_Server)object).start();
                    }
                }
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Gre\u0161ka  :{0}", exception.getMessage());
            }
        }
        if (SysUtil.StrToBol(p.getProperty("FILELISTENER"))) {
            object = new FileWaiter();
            ((FileWaiter)object).run(stringArray);
        }
        HrFiskalizator.loadTrustStore(p);
        System.out.println("Jar Folder  : " + System.getProperty("user.dir"));
        System.out.println("The time is : " + new Date());
        echoChecker = new EchoChecker(p, false);
        echoSheduler = new EchoSheduler();
        echoSheduler.create();
        echoSheduler.run();
        SysUtil.MemoryTest(true);
        if (!SystemTray.isSupported()) {
            Cfg.setTrayExist(false);
        }
        if (!Cfg.SERVICEMODE) {
            SysUtil.changeTrayIconHint(Cfg.getMenuHint());
            if (!SystemTray.isSupported() && StringUtils.indexOfStrArray(stringArray, "NOMENU") == -1) {
                System.out.println("System tray is not supported !!! ");
                if (Cfg.getPmenu() == null) {
                    Cfg.setPmenu(new Pmenu());
                }
                Cfg.getPmenu().setLocation(Cfg.getDimension().width - (Cfg.getPmenu().getSize().width + 10), Cfg.getDimension().height - (Cfg.getPmenu().getSize().height + 40));
                Cfg.getPmenu().setVisible(true);
                Cfg.getPmenu().setAlwaysOnTop(false);
            }
        }
        SysUtil.Arhiva(p.getProperty("FOLDERARHIVAZAHTJEV"));
        SysUtil.Arhiva(p.getProperty("FOLDERARHIVAODGOVOR"));
        HrFiskalizator.startDDNSSheduler();
        new VosHandler().loadVosDll();
        System.out.println("HrFiskalizator " + Cfg.getVERSION() + " is up and running in : " + Duration.between(start, Instant.now()));
        System.out.println("--------------------------------------------------------");
    }

    public static void startDDNSSheduler() {
        Object object = p.getProperty("DDNSPUTANJA", "");
        if ("TRUE".equals(p.getProperty("DDNSAKTIVAN").toUpperCase()) && !"".equals(object)) {
            object = new DDNSSheduler();
            ((DDNSSheduler)object).create();
            ((DDNSSheduler)object).run();
            Cfg.aaddToMenuHint("\nDDNSupdater : activated.");
        }
    }

    public static void ProcesLineCommand(String[] stringArray) {
        Cfg.setLineCommand(true);
        p = new LoadIni(Cfg.getIniName(), 2).run("UTF-8");
        HrFiskalizator.loadTrustStore(p);
        String string = "";
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                string = string + stringArray[i2] + "\n";
                if ("GZKI".equals(stringArray[0]) || "GENERIRAJZKI".equals(stringArray[0])) {
                    if (i2 == 7) {
                        p.setProperty("PRIVATEKEY", stringArray[i2].replace("\"", ""));
                    }
                    if (i2 != 8) continue;
                    p.setProperty("LOZINKAKEY", stringArray[i2].replace("\"", ""));
                    continue;
                }
                if (i2 == 3) {
                    p.setProperty("DATOTEKASAODGOVOROM", stringArray[i2].replace("\"", ""));
                }
                if (i2 == 6) {
                    p.setProperty("PRIVATEKEY", stringArray[i2].replace("\"", ""));
                }
                if (i2 != 7) continue;
                p.setProperty("LOZINKAKEY", stringArray[i2].replace("\"", ""));
            }
            new TxtFileWriter(p.getProperty("DATOTEKASAZADATKOM"), string).save();
            FILE_Server fILE_Server = new FILE_Server();
            fILE_Server.run(p.getProperty("DATOTEKASAZADATKOM"), p.getProperty("DATOTEKASAODGOVOROM"));
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            SysUtil.alertBox(exception.getMessage(), "Gre\u0161ka");
        }
        System.exit(0);
    }

    public static void loadTrustStore(EnhProperies enhProperies) {
        System.setProperty("javax.net.ssl.keyStore", enhProperies.getProperty("PUTANJAJKS"));
        System.setProperty("javax.net.ssl.keyStoreType", "JKS");
        System.setProperty("javax.net.ssl.keyStorePassword", enhProperies.getProperty("LOZINKAJKS"));
        System.setProperty("javax.net.ssl.trustStore", enhProperies.getProperty("PUTANJAJKS"));
        System.setProperty("javax.net.ssl.trustStoreType", "JKS");
        System.setProperty("javax.net.ssl.trustStorePassword", enhProperies.getProperty("LOZINKAJKS"));
        Register.checkPluginLock(Register.calcPluginKey("HrFiskalizator_" + Cfg.VERSION));
        if ("Testni".equals(enhProperies.getProperty("SERVER"))) {
            Cfg.setUnlocked("Program session unlocked ...");
        }
    }

    public static void probe() {
    }

    private static /* synthetic */ void lambda$main$0(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string).append(" ");
    }

    static {
        System.setProperty("file.encoding", "UTF-8");
        System.setProperty("console.encoding", "UTF-8");
        logger = Logger.getLogger("HrFiskalizator");
        start = Instant.now();
        restartString = "";
        pluginsWEBhandlerNames = new ArrayList();
        pluginsWEBHandlers = new ArrayList();
        licenceList = new JsonObject();
    }
}

