/*
 * Decompiled with CFR 0.152.
 */
package fiskalizacija;

import UTIL.KeyStoreUtil;
import UTIL.StringUtils;
import fiskalizacija.Cfg;
import fiskalizacija.HrFiskalizator;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.logging.Level;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;

public class HttpsClient {
    public static void main(String[] stringArray) {
        new HttpsClient().testIt();
    }

    private void testIt() {
        Object object = "https://www.google.com/";
        try {
            object = new URL((String)object);
            object = (HttpsURLConnection)((URL)object).openConnection();
            this.print_https_cert((HttpsURLConnection)object);
            this.print_content((HttpsURLConnection)object);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            HrFiskalizator.logger.log(Level.SEVERE, HttpsClient.class.getName(), malformedURLException);
            return;
        }
        catch (IOException iOException) {
            HrFiskalizator.logger.log(Level.SEVERE, HttpsClient.class.getName(), iOException);
            return;
        }
    }

    public HttpsURLConnection createHttpsConn(String string2, String string3, String string4) {
        HttpsURLConnection httpsURLConnection = null;
        try {
            URL uRL = new URL(string2);
            KeyStoreUtil keyStoreUtil = new KeyStoreUtil();
            keyStoreUtil.trustAllCertificate();
            httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setHostnameVerifier((string, sSLSession) -> true);
            httpsURLConnection.setRequestProperty("User-Agent", "Hrfiskalizator");
            httpsURLConnection.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            if (string2.contains("mvv.hr")) {
                httpsURLConnection.setRequestProperty("Token", Cfg.getPass(1));
            }
            httpsURLConnection.setRequestMethod(string3);
            if (!"".equals(string4)) {
                httpsURLConnection.addRequestProperty("Content-Type", string4);
            }
        }
        catch (MalformedURLException malformedURLException) {
            HrFiskalizator.logger.log(Level.SEVERE, HttpsClient.class.getName(), malformedURLException);
        }
        catch (IOException iOException) {
            HrFiskalizator.logger.log(Level.SEVERE, HttpsClient.class.getName(), iOException);
        }
        return httpsURLConnection;
    }

    public String getUrlTxt(String object) {
        object = this.createHttpsConn((String)object, "GET", "");
        object = (byte[])this.httpsProxyReader((HttpsURLConnection)object, null)[1];
        return new String((byte[])object);
    }

    public Object[] httpsProxyReader(HttpsURLConnection httpsURLConnection, InputStream inputStream) {
        Object[] objectArray = new Object[]{200, "", ""};
        try {
            if ("POST".equals(httpsURLConnection.getRequestMethod())) {
                httpsURLConnection.setDoOutput(true);
                DataOutputStream dataOutputStream = new DataOutputStream(httpsURLConnection.getOutputStream());
                Throwable throwable = null;
                try {
                    byte[] byArray = new byte[1024];
                    try {
                        int n2;
                        while ((n2 = inputStream.read(byArray)) != -1) {
                            dataOutputStream.write(byArray, 0, n2);
                            dataOutputStream.flush();
                        }
                    }
                    catch (IOException iOException) {
                        HrFiskalizator.logger.log(Level.SEVERE, HttpsClient.class.getName(), iOException);
                    }
                    dataOutputStream.flush();
                }
                catch (Throwable throwable2) {
                    try {
                        Throwable throwable3 = throwable2;
                        throwable = throwable2;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable != null) {
                            try {
                                dataOutputStream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            dataOutputStream.close();
                        }
                        throw throwable4;
                    }
                }
                dataOutputStream.close();
            }
            objectArray[0] = httpsURLConnection.getResponseCode();
            objectArray[2] = httpsURLConnection.getHeaderField("Content-Type") != null ? httpsURLConnection.getHeaderField("Content-Type").trim() : "text/html";
            switch ((Integer)objectArray[0]) {
                case 200: {
                    objectArray[1] = this.get_bytecontent(httpsURLConnection.getInputStream());
                    break;
                }
                case 204: {
                    objectArray[0] = 200;
                    objectArray[1] = "OK".getBytes();
                    objectArray[2] = "text/html";
                    break;
                }
                case 400: 
                case 500: {
                    objectArray[0] = 200;
                    objectArray[1] = this.get_bytecontent(httpsURLConnection.getErrorStream());
                    objectArray[2] = "application/json";
                    break;
                }
                case 401: {
                    objectArray[0] = 200;
                    objectArray[1] = this.get_bytecontent(httpsURLConnection.getErrorStream());
                    objectArray[2] = "text/html";
                    break;
                }
                default: {
                    objectArray[1] = this.get_bytecontent(httpsURLConnection.getErrorStream());
                    break;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            HrFiskalizator.logger.log(Level.SEVERE, HttpsClient.class.getName(), malformedURLException);
        }
        catch (IOException iOException) {
            HrFiskalizator.logger.log(Level.SEVERE, HttpsClient.class.getName(), iOException);
        }
        return objectArray;
    }

    private byte[] get_bytecontent(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n2;
            byte[] byArray = new byte[4];
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            HrFiskalizator.logger.log(Level.SEVERE, HttpsClient.class.getName(), iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                HrFiskalizator.logger.log(Level.SEVERE, HttpsClient.class.getName(), iOException);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void print_https_cert(HttpsURLConnection certificateArray) {
        if (certificateArray != null) {
            try {
                System.out.println("Response Code : " + certificateArray.getResponseCode());
                System.out.println("Cipher Suite : " + certificateArray.getCipherSuite());
                System.out.println("\n");
                Certificate[] certificateArray2 = certificateArray.getServerCertificates();
                certificateArray = certificateArray2;
                certificateArray = certificateArray2;
                int n2 = certificateArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Certificate certificate = certificateArray[i2];
                    System.out.println("Cert Type : " + certificate.getType());
                    System.out.println("Cert Hash Code : " + certificate.hashCode());
                    System.out.println("Cert Public Key Algorithm : " + certificate.getPublicKey().getAlgorithm());
                    System.out.println("Cert Public Key Format : " + certificate.getPublicKey().getFormat());
                    System.out.println("\n");
                }
                return;
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                HrFiskalizator.logger.log(Level.SEVERE, HttpsClient.class.getName(), sSLPeerUnverifiedException);
                return;
            }
            catch (IOException iOException) {
                HrFiskalizator.logger.log(Level.SEVERE, HttpsClient.class.getName(), iOException);
            }
        }
    }

    private String get_content(HttpsURLConnection httpsURLConnection) {
        String string = "";
        if (httpsURLConnection != null) {
            try {
                string = StringUtils.inputStream2String(httpsURLConnection.getInputStream());
            }
            catch (IOException iOException) {
                HrFiskalizator.logger.log(Level.SEVERE, HttpsClient.class.getName(), iOException);
            }
        }
        return string;
    }

    private void print_content(HttpsURLConnection httpsURLConnection) {
        System.out.print(this.get_content(httpsURLConnection));
    }
}

