/*
 * Decompiled with CFR 0.152.
 */
package fiskalizacija;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import fiskalizacija.SSEHandler;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class SSEAPIHandler
implements HttpHandler {
    SSEAPIHandler() {
    }

    @Override
    public void handle(HttpExchange httpExchange) {
        String string = httpExchange.getRequestMethod();
        Object object = httpExchange.getRequestURI().getPath();
        httpExchange.getRequestURI().getQuery();
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Methods", "GET, POST, OPTIONS");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Headers", "Content-Type");
        if ("OPTIONS".equals(string)) {
            httpExchange.sendResponseHeaders(200, 0L);
            httpExchange.close();
            return;
        }
        try {
            int n2 = 200;
            if (((String)object).equals("/sseapi/") || ((String)object).equals("/sseapi")) {
                string = this.getAPIInfo();
            } else if (((String)object).equals("/sseapi/tasks")) {
                string = this.getTasksList();
            } else if (((String)object).equals("/sseapi/plugins")) {
                string = SSEHandler.getPluginsInfo();
            } else if (((String)object).equals("/sseapi/clients")) {
                string = SSEHandler.getRegisteredClientsJson();
            } else if (((String)object).equals("/sseapi/stats")) {
                string = SSEHandler.getSystemInfoJson();
            } else if (((String)object).startsWith("/sseapi/task/")) {
                object = ((String)object).substring(13);
                string = this.executeTask(httpExchange, (String)object, string);
            } else {
                string = "{\"error\":\"Unknown endpoint\",\"path\":\"" + (String)object + "\"}";
                n2 = 404;
            }
            httpExchange.getResponseHeaders().add("Content-Type", "application/json; charset=utf-8");
            object = string.getBytes("UTF-8");
            httpExchange.sendResponseHeaders(n2, ((Object)object).length);
            httpExchange.getResponseBody().write((byte[])object);
        }
        catch (Exception exception) {
            String string2 = "{\"error\":\"Internal server error\",\"message\":\"" + exception.getMessage() + "\"}";
            object = string2.getBytes("UTF-8");
            httpExchange.getResponseHeaders().add("Content-Type", "application/json");
            httpExchange.sendResponseHeaders(500, ((Object)object).length);
            httpExchange.getResponseBody().write((byte[])object);
        }
        httpExchange.close();
    }

    private String getAPIInfo() {
        return "{\n  \"name\": \"SSE Plugin API\",\n  \"version\": \"1.0.0\",\n  \"endpoints\": {\n    \"GET /sseapi/tasks\": \"List available tasks\",\n    \"GET /sseapi/plugins\": \"List registered plugins\",\n    \"GET /sseapi/clients\": \"List connected clients\",\n    \"GET /sseapi/stats\": \"System statistics\",\n    \"POST /sseapi/task/{taskName}\": \"Execute task with POST data\",\n    \"GET /sseapi/task/{taskName}?data=...\": \"Execute task with query data\"\n  }\n}";
    }

    private String getTasksList() {
        List<String> list = SSEHandler.getAllRegisteredTasks();
        Set<String> set = SSEHandler.getSystemTasks();
        Set<String> set2 = SSEHandler.getPluginTasks();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\n");
        stringBuilder.append("  \"allTasks\": ").append(this.convertToJsonArray(list)).append(",\n");
        stringBuilder.append("  \"systemTasks\": ").append(this.convertToJsonArray(new ArrayList<String>(set))).append(",\n");
        stringBuilder.append("  \"pluginTasks\": ").append(this.convertToJsonArray(new ArrayList<String>(set2))).append(",\n");
        stringBuilder.append("  \"count\": ").append(list.size()).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String executeTask(HttpExchange object, String string, String string2) {
        boolean bl2;
        String string3 = "";
        if ("POST".equals(string2)) {
            String string4;
            object = new BufferedReader(new InputStreamReader(((HttpExchange)object).getRequestBody(), "UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string4 = ((BufferedReader)object).readLine()) != null) {
                stringBuilder.append(string4);
            }
            string3 = stringBuilder.toString();
        } else if ("GET".equals(string2) && (object = ((HttpExchange)object).getRequestURI().getQuery()) != null) {
            String[] stringArray;
            String[] stringArray2 = stringArray = ((String)object).split("&");
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String[] stringArray3 = stringArray2[i2];
                if ((stringArray3 = stringArray3.split("=", 2)).length != 2 || !"data".equals(stringArray3[0])) continue;
                try {
                    string3 = URLDecoder.decode(stringArray3[1], "UTF-8");
                }
                catch (Exception exception) {
                    string3 = stringArray3[1];
                }
                break;
            }
        }
        if (string3.isEmpty()) {
            string3 = "API call to " + string;
        }
        if (bl2 = SSEHandler.getRegisteredPlugins().containsKey(string)) {
            SSEHandler.executePluginTask(string, string3);
        } else {
            SSEHandler.sendTaskUpdate(string, string3);
        }
        return "{\n  \"status\": \"success\",\n  \"taskName\": \"" + string + "\",\n  \"data\": \"" + this.escapeJson(string3) + "\",\n  \"method\": \"" + string2 + "\",\n  \"timestamp\": " + System.currentTimeMillis() + "\n}";
    }

    private String convertToJsonArray(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"").append(this.escapeJson(list.get(i2))).append("\"");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private String escapeJson(String string) {
        if (string == null) {
            return "";
        }
        return string.replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r");
    }
}

