/*
 * Decompiled with CFR 0.152.
 */
package fiskalizacija;

import a.a.a.a;
import a.a.a.b;
import a.a.a.d;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import fiskalizacija.Cfg;
import fiskalizacija.HrFiskalizator;
import fiskalizacija.SS;
import fiskalizacija.SysUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;

public class SSEHandler
implements HttpHandler {
    private static final List<SSEConnection> connections = new CopyOnWriteArrayList<SSEConnection>();
    private static final Map<String, Set<SSEConnection>> contextClients = new ConcurrentHashMap<String, Set<SSEConnection>>();
    private static final Map<String, SSEConnection> clientsById = new ConcurrentHashMap<String, SSEConnection>();
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2);
    private static String[] ipAuthorized = new String[0];
    private static String[] ipBanned = new String[0];
    private static String username = "";
    private static String password = "";
    private static final Map<String, SSETaskPlugin> registeredPlugins = new ConcurrentHashMap<String, SSETaskPlugin>();
    private static final Map<String, String> pluginJarPaths = new ConcurrentHashMap<String, String>();
    private static final Gson gson;
    private static final Map<String, ClientRegistration> pendingRegistrations;
    private static final Set<String> systemTasks;

    private static void startCleanupTasks() {
        scheduler.scheduleAtFixedRate(() -> SSEHandler.cleanupStalePendingRegistrations(), 120L, 120L, TimeUnit.SECONDS);
        scheduler.scheduleAtFixedRate(() -> {
            int n2 = SSEHandler.lightweightCleanupCheck();
            if (n2 > 0) {
                HrFiskalizator.logger.log(Level.INFO, "[SAFETY] Emergency cleanup removed " + n2 + " missed entries");
            }
        }, 30L, 30L, TimeUnit.SECONDS);
    }

    private static void cleanupDisconnectedClients() {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        AtomicInteger atomicInteger2 = new AtomicInteger(0);
        connections.removeIf(sSEConnection -> {
            if (sSEConnection.isClosed()) {
                atomicInteger.incrementAndGet();
                return true;
            }
            return false;
        });
        for (Map.Entry<String, Set<SSEConnection>> entry2 : contextClients.entrySet()) {
            Set<SSEConnection> object = entry2.getValue();
            object.size();
            object.removeIf(SSEConnection::isClosed);
            object.size();
        }
        clientsById.entrySet().removeIf(entry -> {
            if (((SSEConnection)entry.getValue()).isClosed()) {
                atomicInteger2.incrementAndGet();
                return true;
            }
            return false;
        });
        contextClients.entrySet().removeIf(entry -> ((Set)entry.getValue()).isEmpty());
        atomicInteger.get();
        atomicInteger2.get();
    }

    private static void cleanupStalePendingRegistrations() {
        long l2 = System.currentTimeMillis();
        AtomicInteger atomicInteger = new AtomicInteger(0);
        pendingRegistrations.entrySet().removeIf(entry -> {
            if (l2 - ((ClientRegistration)entry.getValue()).timestamp > 300000L) {
                atomicInteger.incrementAndGet();
                return true;
            }
            return false;
        });
        atomicInteger.get();
    }

    private static void performHeartbeatCheck() {
        for (SSEConnection sSEConnection : new ArrayList<SSEConnection>(connections)) {
            if (sSEConnection.isClosed()) continue;
            try {
                sSEConnection.sendData(": heartbeat\n\n");
            }
            catch (Exception exception) {
                sSEConnection.close();
            }
        }
    }

    private static int lightweightCleanupCheck() {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        atomicInteger.addAndGet(connections.removeIf(SSEConnection::isClosed) ? 1 : 0);
        clientsById.entrySet().removeIf(entry -> {
            if (((SSEConnection)entry.getValue()).isClosed()) {
                atomicInteger.incrementAndGet();
                return true;
            }
            return false;
        });
        for (Set<SSEConnection> set : contextClients.values()) {
            atomicInteger.addAndGet(set.removeIf(SSEConnection::isClosed) ? 1 : 0);
        }
        contextClients.entrySet().removeIf(entry -> ((Set)entry.getValue()).isEmpty());
        return atomicInteger.get();
    }

    public static void setIpRestrictions(String[] stringArray, String[] stringArray2) {
        ipAuthorized = stringArray != null ? stringArray : new String[]{};
        ipBanned = stringArray2 != null ? stringArray2 : new String[]{};
    }

    private static ClientRegistration parseClientRegistration(String object) {
        try {
            if (object == null || ((String)object).length() > 10000) {
                System.err.println("\u001b[31m[JSON ERROR] JSON too large or null: " + (object != null ? ((String)object).length() : 0) + " chars\u001b[0m");
                return null;
            }
            if ((object = gson.fromJson((String)object, ClientRegistration.class)) != null && ((ClientRegistration)object).id != null && ((ClientRegistration)object).id.length() > 200) {
                System.err.println("\u001b[31m[JSON ERROR] Client ID too long: " + ((ClientRegistration)object).id.length() + " chars\u001b[0m");
                return null;
            }
            return object;
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            HrFiskalizator.logger.log(Level.SEVERE, "[JSON ERROR] Invalid JSON syntax: " + jsonSyntaxException.getMessage(), jsonSyntaxException);
            return null;
        }
        catch (Exception exception) {
            HrFiskalizator.logger.log(Level.SEVERE, "[JSON ERROR] Unexpected error parsing JSON: " + exception.getMessage(), exception);
            return null;
        }
    }

    public static void updateBannedList() {
        if (Cfg.ipBanned != null) {
            ipBanned = Cfg.ipBanned.toArray(new String[0]);
        }
    }

    public static void setCredentials(String string, String string2) {
        username = string != null ? string : "";
        password = string2 != null ? string2 : "";
    }

    private boolean isIPMatch(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("^([0-9]{1,3}\\.){3}[0-9]{1,3}$");
        if (pattern.matcher(string2).matches()) {
            return string.equals(string2);
        }
        return string.startsWith(string2 + ".");
    }

    private boolean isIPBanned(String string) {
        String[] stringArray = ipBanned;
        int n2 = ipBanned.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (!this.isIPMatch(string, string2)) continue;
            return true;
        }
        return false;
    }

    private boolean isIPAuthorized(String string) {
        if (ipAuthorized.length == 0) {
            return false;
        }
        String[] stringArray = ipAuthorized;
        int n2 = ipAuthorized.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (!this.isIPMatch(string, string2)) continue;
            return true;
        }
        return false;
    }

    private boolean isLocalhost(String string) {
        return "127.0.0.1".equals(string) || "::1".equals(string) || "localhost".equals(string);
    }

    private boolean isAuthenticated(HttpExchange object, String string) {
        Object object2;
        String object3 = ((HttpExchange)object).getRequestHeaders().getFirst("Authorization");
        object = ((HttpExchange)object).getRequestURI().getQuery();
        boolean bl2 = false;
        if (object3 != null && object3.startsWith("Basic ")) {
            try {
                String string2 = new String(Base64.getDecoder().decode(object3.substring(6)), "UTF-8");
                object2 = string2.split(":", 2);
                if (((String[])object2).length == 2) {
                    bl2 = username.equals(object2[0]) && password.equals(object2[1]);
                }
            }
            catch (Exception exception) {
                bl2 = false;
            }
        }
        if (!bl2 && object != null && ((String)object).contains("user=") && ((String)object).contains("pass=")) {
            String[] stringArray = ((String)object).split("&");
            object2 = null;
            object = null;
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string3 = stringArray2[i2];
                String[] stringArray3 = string3.split("=", 2);
                if (stringArray3.length != 2) continue;
                if ("user".equals(stringArray3[0])) {
                    object2 = stringArray3[1];
                }
                if (!"pass".equals(stringArray3[0])) continue;
                object = stringArray3[1];
            }
            if (object2 != null && object != null) {
                boolean bl3 = bl2 = username.equals(object2) && password.equals(object);
            }
        }
        if (bl2) {
            if (Cfg.failCounter.containsKey(string)) {
                Cfg.failCounter.remove(string);
            }
        } else if (Cfg.failCounter.containsKey(string)) {
            Integer n3 = Integer.valueOf(Cfg.failCounter.getProperty(string));
            if (n3 > SS.FAILLOGINLIMIT && !Cfg.ipBanned.contains(string)) {
                Cfg.ipBanned.add(string);
            }
            Cfg.failCounter.setProperty(string, String.valueOf(n3 + 1));
        } else {
            Cfg.failCounter.setProperty(string, "1");
        }
        return bl2;
    }

    @Override
    public void handle(HttpExchange httpExchange) {
        String string = httpExchange.getRemoteAddress().getAddress().getHostAddress();
        String string2 = httpExchange.getRequestMethod();
        httpExchange.getRequestURI();
        String string3 = httpExchange.getRequestURI().getPath();
        if (!string3.startsWith("/sse/")) {
            httpExchange.sendResponseHeaders(404, 0L);
            httpExchange.close();
            return;
        }
        if (!("GET".equals(string2) || "POST".equals(string2) || "OPTIONS".equals(string2))) {
            httpExchange.sendResponseHeaders(405, 0L);
            httpExchange.close();
            return;
        }
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Methods", "GET, POST, OPTIONS");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Headers", "Content-Type, Authorization");
        if ("OPTIONS".equals(string2)) {
            httpExchange.getResponseHeaders().add("Access-Control-Allow-Credentials", "false");
            httpExchange.getResponseHeaders().add("Access-Control-Max-Age", "86400");
            httpExchange.sendResponseHeaders(200, 0L);
            httpExchange.close();
            return;
        }
        SSEHandler.updateBannedList();
        if (this.isIPBanned(string)) {
            httpExchange.sendResponseHeaders(403, 0L);
            httpExchange.close();
            return;
        }
        boolean bl2 = !this.isLocalhost(string) && !this.isIPAuthorized(string);
        if (bl2 && !this.isAuthenticated(httpExchange, string)) {
            httpExchange.getResponseHeaders().add("WWW-Authenticate", "Basic realm=\"SSE\"");
            httpExchange.sendResponseHeaders(401, 0L);
            httpExchange.close();
            return;
        }
        if ("POST".equals(string2)) {
            this.handleClientRegistration(httpExchange, string);
            return;
        }
        if (!"GET".equals(string2)) {
            httpExchange.sendResponseHeaders(405, 0L);
            httpExchange.close();
            return;
        }
        this.handleSSEConnection(httpExchange, string);
    }

    private void handleClientRegistration(HttpExchange httpExchange, String object) {
        try {
            Object object2;
            Throwable throwable;
            block12: {
                String string;
                object = new BufferedReader(new InputStreamReader(httpExchange.getRequestBody(), "UTF-8"));
                throwable = null;
                object2 = new StringBuilder();
                while ((string = ((BufferedReader)object).readLine()) != null) {
                    ((StringBuilder)object2).append(string);
                }
                object2 = ((StringBuilder)object2).toString();
                if ((object2 = SSEHandler.parseClientRegistration((String)object2)) != null && ((ClientRegistration)object2).id != null && !((ClientRegistration)object2).id.isEmpty()) break block12;
                httpExchange.getResponseHeaders().add("Content-Type", "application/json");
                object2 = "{\"status\":\"error\",\"message\":\"Missing or invalid client ID\"}";
                httpExchange.sendResponseHeaders(400, ((String)object2).length());
                httpExchange.getResponseBody().write(((String)object2).getBytes("UTF-8"));
                httpExchange.close();
                ((BufferedReader)object).close();
                return;
            }
            try {
                pendingRegistrations.put(((ClientRegistration)object2).id, new ClientRegistration(((ClientRegistration)object2).id, ((ClientRegistration)object2).tasks));
                object2 = "{\"status\":\"success\",\"message\":\"Client registered\",\"clientId\":\"" + ((ClientRegistration)object2).id + "\"}";
                httpExchange.getResponseHeaders().add("Content-Type", "application/json; charset=utf-8");
                httpExchange.getResponseHeaders().add("Cache-Control", "no-cache, no-store, must-revalidate");
                httpExchange.getResponseHeaders().add("Pragma", "no-cache");
                httpExchange.getResponseHeaders().add("Expires", "0");
                httpExchange.sendResponseHeaders(200, ((String)object2).length());
                httpExchange.getResponseBody().write(((String)object2).getBytes("UTF-8"));
                httpExchange.getResponseBody().flush();
                httpExchange.close();
            }
            catch (Throwable throwable2) {
                try {
                    object2 = throwable2;
                    throwable = throwable2;
                    throw object2;
                }
                catch (Throwable throwable3) {
                    if (throwable != null) {
                        try {
                            ((BufferedReader)object).close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        ((BufferedReader)object).close();
                    }
                    throw throwable3;
                }
            }
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {
            String string = "{\"status\":\"error\",\"message\":\"Invalid JSON format\"}";
            httpExchange.getResponseHeaders().add("Content-Type", "application/json");
            httpExchange.sendResponseHeaders(400, string.length());
            httpExchange.getResponseBody().write(string.getBytes("UTF-8"));
            httpExchange.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleSSEConnection(HttpExchange httpExchange, String string2) {
        void var6_14;
        Object object;
        Object object2;
        Object object3 = httpExchange.getRequestURI().getQuery();
        String string3 = null;
        if (object3 != null) {
            object3 = object3.split("&");
            object2 = object3;
            int n2 = ((String[])object3).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object4 = object2[i2];
                object = ((String)object4).split("=", 2);
                if (((String[])object).length != 2 || !"clientId".equals(object[0])) continue;
                string3 = object[1];
                break;
            }
        }
        object3 = null;
        if (string3 != null) {
            object3 = pendingRegistrations.remove(string3);
        } else {
            for (Map.Entry entry : pendingRegistrations.entrySet()) {
                if (System.currentTimeMillis() - ((ClientRegistration)entry.getValue()).timestamp >= 30000L) continue;
                object3 = (ClientRegistration)entry.getValue();
                String cfr_ignored_0 = object3.id;
                pendingRegistrations.remove(entry.getKey());
                break;
            }
        }
        if (object3 == null) {
            httpExchange.sendResponseHeaders(400, 0L);
            httpExchange.close();
            return;
        }
        httpExchange.getResponseHeaders().add("Content-Type", "text/event-stream");
        httpExchange.getResponseHeaders().add("Cache-Control", "no-cache");
        httpExchange.getResponseHeaders().add("Connection", "keep-alive");
        httpExchange.sendResponseHeaders(200, 0L);
        List<SSEConnection> object5 = connections;
        synchronized (object5) {
            SSEConnection sSEConnection = clientsById.get(object3.id);
            if (sSEConnection != null) {
                connections.remove(sSEConnection);
                clientsById.remove(object3.id);
                SSEHandler.removeConnectionFromContexts(sSEConnection);
                sSEConnection.close();
            }
            object2 = new SSEConnection(httpExchange.getResponseBody(), string2, object3.id, object3.tasks);
            connections.add((SSEConnection)object2);
            clientsById.put(object3.id, (SSEConnection)object2);
            HrFiskalizator.logger.log(Level.INFO, "[CONNECT] Registered client " + object3.id + " (" + string2 + ") - Total clients: " + connections.size());
        }
        if (object3.tasks != null) {
            String[] stringArray = object3.tasks;
            int n2 = object3.tasks.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                object = stringArray[i3];
                if ((object = object.trim()).isEmpty()) continue;
                contextClients.computeIfAbsent((String)object, string -> ConcurrentHashMap.newKeySet()).add(object2);
            }
        }
        String string4 = "data: Connected to SSE stream (ID: " + object3.id + ")";
        if (object3.tasks != null && object3.tasks.length > 0) {
            String string5 = string4 + " (Tasks: " + String.join((CharSequence)",", object3.tasks) + ")";
        }
        String string6 = (String)var6_14 + "\n\n";
        ((SSEConnection)object2).sendData(string6);
        scheduler.schedule(() -> SSEHandler.lambda$handleSSEConnection$9((SSEConnection)object2), 30L, TimeUnit.MINUTES);
    }

    public static void broadcast(String string) {
        connections.removeIf(SSEConnection::isClosed);
        for (SSEConnection sSEConnection : connections) {
            sSEConnection.sendData(string);
        }
    }

    public static void broadcastToTask(String iterator, String string) {
        if ((iterator = contextClients.get(iterator)) != null) {
            iterator.removeIf(SSEConnection::isClosed);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                SSEConnection sSEConnection = (SSEConnection)iterator.next();
                sSEConnection.sendData(string);
            }
        }
    }

    public static void broadcastToContext(String string, String string2) {
        SSEHandler.broadcastToTask(string, string2);
    }

    public static void sendToClient(String object, String string) {
        if ((object = clientsById.get(object)) != null && !((SSEConnection)object).isClosed()) {
            ((SSEConnection)object).sendData(string);
        }
    }

    public static void broadcastToClients(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            SSEHandler.sendToClient(string2, string);
        }
    }

    public static void broadcastToTasks(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            SSEHandler.broadcastToTask(string2, string);
        }
    }

    public static void broadcastToContexts(String[] stringArray, String string) {
        SSEHandler.broadcastToTasks(stringArray, string);
    }

    public static void sendTaskStatus(String string) {
        SSEHandler.ensureSystemTaskRegistered("status");
        SSEHandler.broadcastToTask("status", "event: task-status\ndata: " + string + "\n\n");
    }

    public static void sendTaskUpdate(String string, String string2) {
        SSEHandler.ensureSystemTaskRegistered(string);
        SSEHandler.ensureSystemTaskRegistered("task-update");
        SSEHandler.broadcastToTask(string, "event: task-update\ndata: {\"task\":\"" + string + "\",\"data\":\"" + string2 + "\"}\n\n");
    }

    public static void sendTaskNotification(String string, String string2) {
        SSEHandler.ensureSystemTaskRegistered(string);
        SSEHandler.ensureSystemTaskRegistered("notification");
        SSEHandler.broadcastToTask(string, "event: notification\ndata: {\"task\":\"" + string + "\",\"message\":\"" + string2 + "\"}\n\n");
    }

    public static void broadcastStatus(String string) {
        SSEHandler.broadcast("data: " + string + "\n\n");
    }

    public static List<String> getActiveClients() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, SSEConnection> entry : clientsById.entrySet()) {
            if (entry.getValue().isClosed()) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    public static List<String> getTaskClients(String iterator) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((iterator = contextClients.get(iterator)) != null) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                SSEConnection sSEConnection = (SSEConnection)iterator.next();
                if (sSEConnection.isClosed() || sSEConnection.getClientId() == null) continue;
                arrayList.add(sSEConnection.getClientId());
            }
        }
        return arrayList;
    }

    public static List<String> getContextClients(String string) {
        return SSEHandler.getTaskClients(string);
    }

    public static List<String> getActiveTasks() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : contextClients.keySet()) {
            Set<SSEConnection> set = contextClients.get(string);
            if (set == null || set.isEmpty()) continue;
            boolean bl2 = false;
            for (SSEConnection sSEConnection : set) {
                if (sSEConnection.isClosed()) continue;
                bl2 = true;
                break;
            }
            if (!bl2) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static Map<String, List<String>> getClientTaskMapping() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (SSEConnection sSEConnection : connections) {
            if (sSEConnection.isClosed() || sSEConnection.getClientId() == null) continue;
            String string = sSEConnection.getClientId();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (sSEConnection.getTasks() != null) {
                for (String string2 : sSEConnection.getTasks()) {
                    arrayList.add(string2);
                }
            }
            hashMap.put(string, arrayList);
        }
        return hashMap;
    }

    private static void removeConnection(SSEConnection sSEConnection) {
        if (sSEConnection == null) {
            return;
        }
        String string = sSEConnection.getClientId();
        sSEConnection.getClientIP();
        List<SSEConnection> list = connections;
        synchronized (list) {
            SSEConnection sSEConnection2;
            sSEConnection.close();
            connections.remove(sSEConnection);
            if (string != null && (sSEConnection2 = clientsById.get(string)) == sSEConnection) {
                clientsById.remove(string);
            }
            SSEHandler.removeConnectionFromContexts(sSEConnection);
            return;
        }
    }

    private static int removeConnectionFromContexts(SSEConnection sSEConnection) {
        int n2 = 0;
        for (Set<SSEConnection> set : contextClients.values()) {
            if (!set.remove(sSEConnection)) continue;
            ++n2;
        }
        contextClients.entrySet().removeIf(entry -> ((Set)entry.getValue()).isEmpty());
        return n2;
    }

    public static void registerTaskPlugin(SSETaskPlugin sSETaskPlugin) {
        if (sSETaskPlugin != null && sSETaskPlugin.getTaskName() != null && !sSETaskPlugin.getTaskName().isEmpty()) {
            String string = sSETaskPlugin.getTaskName();
            if (registeredPlugins.containsKey(string)) {
                SSETaskPlugin sSETaskPlugin2 = registeredPlugins.get(string);
                HrFiskalizator.logger.log(Level.SEVERE, "[SSE PLUGIN ERROR] REJECTED duplicate task name '" + string + "'!");
                HrFiskalizator.logger.log(Level.INFO, "  KEEPING: " + sSETaskPlugin2.getClass().getSimpleName() + " v" + sSETaskPlugin2.getVersion() + " (" + sSETaskPlugin2.getDescription() + ")");
                HrFiskalizator.logger.log(Level.INFO, "  REJECTED: " + sSETaskPlugin.getClass().getSimpleName() + " v" + sSETaskPlugin.getVersion() + " (" + sSETaskPlugin.getDescription() + ")");
                HrFiskalizator.logger.log(Level.INFO, "  FIX: Rename task in one of the plugins or remove duplicate JAR file");
                return;
            }
            registeredPlugins.put(string, sSETaskPlugin);
            HrFiskalizator.logger.log(Level.INFO, "[SSE PLUGIN] Registered: " + string + " v" + sSETaskPlugin.getVersion() + " - " + sSETaskPlugin.getDescription() + " (" + sSETaskPlugin.getClass().getSimpleName() + ")");
        }
    }

    public static void executePluginTask(String string, String string2) {
        SSETaskPlugin sSETaskPlugin = registeredPlugins.get(string);
        if (sSETaskPlugin != null && sSETaskPlugin.isEnabled()) {
            try {
                long l2 = System.currentTimeMillis();
                sSETaskPlugin.executeTask(string2);
                long l3 = System.currentTimeMillis() - l2;
                if (l3 > 5000L) {
                    HrFiskalizator.logger.log(Level.WARNING, "[SSE PLUGIN WARNING] Plugin " + string + " took " + l3 + "ms to execute (slow!)");
                }
                return;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                HrFiskalizator.logger.log(Level.SEVERE, "[SSE PLUGIN CRITICAL] OUT OF MEMORY in plugin " + string + " - forcing GC");
                System.gc();
                return;
            }
            catch (StackOverflowError stackOverflowError) {
                HrFiskalizator.logger.log(Level.SEVERE, "[SSE PLUGIN CRITICAL] STACK OVERFLOW in plugin " + string + " (infinite recursion?)");
                return;
            }
            catch (ThreadDeath threadDeath) {
                HrFiskalizator.logger.log(Level.SEVERE, "[SSE PLUGIN CRITICAL] THREAD DEATH in plugin " + string);
                throw threadDeath;
            }
            catch (Throwable throwable) {
                HrFiskalizator.logger.log(Level.SEVERE, "[SSE PLUGIN ERROR] Plugin " + string + " failed: " + throwable.getClass().getSimpleName() + ": " + throwable.getMessage(), throwable);
                return;
            }
        }
        System.err.println("[SSE PLUGIN ERROR] Plugin '" + string + "' not found or disabled");
    }

    public static Map<String, SSETaskPlugin> getRegisteredPlugins() {
        return new HashMap<String, SSETaskPlugin>(registeredPlugins);
    }

    public static void loadSSEPlugins() {
        File[] fileArray = System.getProperty("user.dir") + File.separator + "SSEPLUGINS";
        if (!(fileArray = new File((String)fileArray)).exists()) {
            fileArray.mkdirs();
            return;
        }
        if ((fileArray = fileArray.listFiles((file, string) -> string.toLowerCase().endsWith(".jar"))) == null || fileArray.length == 0) {
            return;
        }
        for (File file2 : fileArray) {
            SSEHandler.loadPluginFromJar(file2);
        }
        SSEHandler.printPluginSummary();
    }

    private static void loadPluginFromJar(File file) {
        HrFiskalizator.logger.log(Level.INFO, "[PLUGIN LOAD] Loading: " + file.getName());
        try {
            long l2 = file.length();
            if (l2 > 0x3200000L) {
                HrFiskalizator.logger.log(Level.SEVERE, "[PLUGIN ERROR] JAR file too large: " + file.getName() + " (" + l2 + " bytes)");
                return;
            }
            Object object = file.toURI().toURL();
            object = new URLClassLoader(new URL[]{object});
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            boolean bl2 = false;
            while (enumeration.hasMoreElements()) {
                Object object2 = enumeration.nextElement();
                if (!((String)(object2 = ((ZipEntry)object2).getName())).endsWith(".class") || ((String)object2).contains("$")) continue;
                object2 = ((String)object2).replace('/', '.').substring(0, ((String)object2).length() - 6);
                try {
                    if (!SSETaskPlugin.class.isAssignableFrom((Class<?>)(object2 = ((ClassLoader)object).loadClass((String)object2))) || ((Class)object2).isInterface()) continue;
                    bl2 = true;
                    object2 = (SSETaskPlugin)((Class)object2).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    SSEHandler.registerTaskPlugin((SSETaskPlugin)object2);
                    pluginJarPaths.put(object2.getTaskName(), file.getAbsolutePath());
                }
                catch (Exception exception) {}
            }
            if (!bl2) {
                HrFiskalizator.logger.log(Level.WARNING, "[SSE PLUGIN ERROR] No valid plugin found in " + file.getName());
            }
            jarFile.close();
            return;
        }
        catch (Exception exception) {
            HrFiskalizator.logger.log(Level.SEVERE, "[SSE PLUGIN ERROR] Failed to load " + file.getName() + ": " + exception.getMessage(), exception);
            return;
        }
    }

    private static void printPluginSummary() {
    }

    public static void reloadPlugins() {
        registeredPlugins.clear();
        pluginJarPaths.clear();
        SSEHandler.loadSSEPlugins();
    }

    public static String getPluginsInfo() {
        if (registeredPlugins.isEmpty()) {
            SSEHandler.loadSSEPlugins();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"plugins\":[");
        boolean bl2 = true;
        for (Map.Entry<String, SSETaskPlugin> entry : registeredPlugins.entrySet()) {
            if (!bl2) {
                stringBuilder.append(",");
            }
            SSETaskPlugin sSETaskPlugin = entry.getValue();
            String object = pluginJarPaths.getOrDefault(sSETaskPlugin.getTaskName(), "unknown");
            object = object.replace("\\", "\\\\");
            String string2 = sSETaskPlugin.getTaskName().replace("\"", "\\\"");
            String string3 = sSETaskPlugin.getDescription().replace("\"", "\\\"");
            String string4 = sSETaskPlugin.getVersion().replace("\"", "\\\"");
            stringBuilder.append("{\"taskName\":\"").append(string2).append("\",\"description\":\"").append(string3).append("\",\"version\":\"").append(string4).append("\",\"enabled\":").append(sSETaskPlugin.isEnabled()).append(",\"jarPath\":\"").append(object).append("\"}");
            bl2 = false;
        }
        stringBuilder.append("],\"count\":").append(registeredPlugins.size()).append("}");
        return stringBuilder.toString();
    }

    private static void registerSystemTask(String string) {
        if (string != null && !string.trim().isEmpty()) {
            systemTasks.add(string.trim());
        }
    }

    private static void ensureSystemTaskRegistered(String string) {
        if (systemTasks.isEmpty()) {
            SSEHandler.initializeSystemTasks();
            return;
        }
        if (!systemTasks.contains(string)) {
            SSEHandler.registerSystemTask(string);
        }
    }

    private static void initializeSystemTasks() {
        systemTasks.clear();
        SSEHandler.registerSystemTask("status");
        SSEHandler.registerSystemTask("notification");
        SSEHandler.registerSystemTask("task-update");
        SSEHandler.registerSystemTask("task-status");
    }

    private static Set<String> discoverAllAvailableTasks() {
        if (systemTasks.isEmpty()) {
            SSEHandler.initializeSystemTasks();
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(registeredPlugins.keySet());
        hashSet.addAll(systemTasks);
        hashSet.addAll(contextClients.keySet());
        for (ClientRegistration clientRegistration : pendingRegistrations.values()) {
            if (clientRegistration.tasks == null) continue;
            String[] stringArray = clientRegistration.tasks;
            int n2 = clientRegistration.tasks.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = stringArray[i2];
                if (string2 == null || string2.trim().isEmpty()) continue;
                hashSet.add(string2.trim());
            }
        }
        for (SSEConnection sSEConnection : connections) {
            if (sSEConnection.isClosed() || sSEConnection.getTasks() == null) continue;
            for (String string3 : sSEConnection.getTasks()) {
                if (string3 == null || string3.trim().isEmpty()) continue;
                hashSet.add(string3.trim());
            }
        }
        hashSet.removeIf(string -> string == null || string.trim().isEmpty());
        return hashSet;
    }

    public static List<String> getAllRegisteredTasks() {
        Set<String> set = SSEHandler.discoverAllAvailableTasks();
        return new ArrayList<String>(set);
    }

    public static void registerCustomTask(String string) {
        if (string != null && !string.trim().isEmpty()) {
            systemTasks.add(string.trim());
        }
    }

    public static Set<String> getSystemTasks() {
        if (systemTasks.isEmpty()) {
            SSEHandler.initializeSystemTasks();
        }
        return new HashSet<String>(systemTasks);
    }

    public static Set<String> getPluginTasks() {
        return new HashSet<String>(registeredPlugins.keySet());
    }

    public static void refreshTaskRegistry() {
        SSEHandler.initializeSystemTasks();
        SSEHandler.reloadPlugins();
    }

    public static List<Map<String, Object>> getRegisteredClientsInfo() {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, SSEConnection> entry : clientsById.entrySet()) {
            SSEConnection object = entry.getValue();
            if (object.isClosed()) continue;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("clientId", object.getClientId());
            hashMap.put("clientIP", object.getClientIP());
            hashMap.put("tasks", Arrays.asList(object.getTasks()));
            hashMap.put("connected", Boolean.TRUE);
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    public static String getRegisteredClientsJson() {
        List<Map<String, Object>> list = SSEHandler.getRegisteredClientsInfo();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"clients\":[");
        boolean bl2 = true;
        for (Map<String, Object> map : list) {
            if (!bl2) {
                stringBuilder.append(",");
            }
            Object object = (List)map.get("tasks");
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("[");
            boolean bl3 = true;
            object = object.iterator();
            while (object.hasNext()) {
                Object e2 = object.next();
                if (!bl3) {
                    stringBuilder2.append(",");
                }
                stringBuilder2.append("\"").append(e2.toString()).append("\"");
                bl3 = false;
            }
            stringBuilder2.append("]");
            stringBuilder.append("{\"clientId\":\"").append(map.get("clientId")).append("\",\"clientIP\":\"").append(map.get("clientIP")).append("\",\"tasks\":").append(stringBuilder2.toString()).append(",\"connected\":").append(map.get("connected")).append("}");
            bl2 = false;
        }
        stringBuilder.append("],\"count\":").append(list.size()).append("}");
        return stringBuilder.toString();
    }

    public static List<Map<String, Object>> getClientsForTask(String string) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        Set<SSEConnection> set = contextClients.get(string);
        if (set != null) {
            for (SSEConnection sSEConnection : set) {
                if (sSEConnection.isClosed()) continue;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("clientId", sSEConnection.getClientId());
                hashMap.put("clientIP", sSEConnection.getClientIP());
                hashMap.put("taskName", string);
                arrayList.add(hashMap);
            }
        }
        return arrayList;
    }

    public static Map<String, Object> getTaskStatistics() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("totalTasks", SSEHandler.getAllRegisteredTasks().size());
        hashMap.put("activeClients", SSEHandler.getActiveClients().size());
        hashMap.put("pluginTasks", registeredPlugins.size());
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        for (String string : contextClients.keySet()) {
            Set<SSEConnection> set = contextClients.get(string);
            if (set == null) continue;
            int n2 = 0;
            for (SSEConnection sSEConnection : set) {
                if (sSEConnection.isClosed()) continue;
                ++n2;
            }
            hashMap2.put(string, n2);
        }
        hashMap.put("taskSubscribers", hashMap2);
        return hashMap;
    }

    public static String getSystemInfoJson() {
        Map<String, Object> map = SSEHandler.getTaskStatistics();
        List<String> list = SSEHandler.getAllRegisteredTasks();
        List<Map<String, Object>> list2 = SSEHandler.getRegisteredClientsInfo();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append("\"systemInfo\":{");
        stringBuilder.append("\"totalTasks\":").append(map.get("totalTasks")).append(",");
        stringBuilder.append("\"activeClients\":").append(map.get("activeClients")).append(",");
        stringBuilder.append("\"pluginTasks\":").append(map.get("pluginTasks"));
        stringBuilder.append("},");
        stringBuilder.append("\"allTasks\":").append(gson.toJson(list)).append(",");
        stringBuilder.append("\"clients\":").append(gson.toJson(list2)).append(",");
        stringBuilder.append("\"taskSubscribers\":").append(gson.toJson(map.get("taskSubscribers")));
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static void forceCleanup() {
        SSEHandler.cleanupDisconnectedClients();
        SSEHandler.cleanupStalePendingRegistrations();
    }

    public static Map<String, Object> getCleanupStatistics() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n2 = 0;
        int n3 = 0;
        for (SSEConnection sSEConnection : connections) {
            if (sSEConnection.isClosed()) {
                ++n3;
                continue;
            }
            ++n2;
        }
        int n4 = 0;
        int n5 = 0;
        for (Set<SSEConnection> set : contextClients.values()) {
            n4 += set.size();
            if (!set.isEmpty()) continue;
            ++n5;
        }
        hashMap.put("totalConnections", connections.size());
        hashMap.put("activeConnections", n2);
        hashMap.put("closedConnections", n3);
        hashMap.put("clientsInMap", clientsById.size());
        hashMap.put("pendingRegistrations", pendingRegistrations.size());
        hashMap.put("totalTasks", contextClients.size());
        hashMap.put("totalContextSubscriptions", n4);
        hashMap.put("emptyContexts", n5);
        return hashMap;
    }

    public static boolean disconnectClient(String object) {
        if ((object = clientsById.get(object)) != null) {
            ((SSEConnection)object).close();
            SSEHandler.removeConnection((SSEConnection)object);
            return true;
        }
        return false;
    }

    public static int disconnectTaskClients(String iterator) {
        if ((iterator = contextClients.get(iterator)) != null) {
            int n2 = 0;
            for (SSEConnection sSEConnection : new ArrayList(iterator)) {
                sSEConnection.close();
                SSEHandler.removeConnection(sSEConnection);
                ++n2;
            }
            return n2;
        }
        return 0;
    }

    public static void checkMemoryUsage() {
        double d2;
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.totalMemory();
        long l3 = runtime.freeMemory();
        long l4 = l2 - l3;
        long l5 = runtime.maxMemory();
        double d3 = (double)l4 / (double)l5 * 100.0;
        if (d2 > 80.0) {
            System.err.println(String.format("\u001b[33m[MEMORY WARNING] Memory usage high: %.1f%% (%d/%d MB)\u001b[0m", d3, l4 / 1024L / 1024L, l5 / 1024L / 1024L));
            if (d3 > 90.0) {
                System.err.println("\u001b[31m[MEMORY CRITICAL] Forcing garbage collection\u001b[0m");
                System.gc();
            }
        }
    }

    public static void shutdown() {
        HrFiskalizator.logger.log(Level.INFO, "[SSE SYSTEM] Shutting down SSE Handler...");
        SSEHandler.forceCleanup();
        scheduler.shutdown();
        try {
            if (!scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                scheduler.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            scheduler.shutdownNow();
        }
        for (SSEConnection sSEConnection : connections) {
            sSEConnection.close();
        }
        connections.clear();
        contextClients.clear();
        clientsById.clear();
        pendingRegistrations.clear();
        registeredPlugins.clear();
        pluginJarPaths.clear();
        HrFiskalizator.logger.log(Level.INFO, "[SSE SYSTEM] SSE Handler shutdown complete.");
    }

    private static String escapeHtml(String string) {
        if (string == null) {
            return "";
        }
        return string.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
    }

    private static String getHrFiskalizatorLogo() {
        return SysUtil.getHrFiskalizatorLogoBase64();
    }

    private static String getJarNameForTask(String string2) {
        File[] fileArray;
        String object = pluginJarPaths.get(string2);
        if (object != null && !object.equals("unknown")) {
            File file2 = new File(object);
            String string3 = file2.getName();
            return string3.substring(0, string3.length() - 4);
        }
        String string4 = System.getProperty("user.dir") + File.separator + "SSEPLUGINS";
        File file3 = new File(string4);
        if (file3.exists() && (fileArray = file3.listFiles((file, string) -> string.toLowerCase().endsWith(".jar"))) != null) {
            File[] fileArray2 = fileArray;
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                File file4 = fileArray2[i2];
                String string5 = file4.getName();
                string5 = string5.substring(0, string5.length() - 4);
                String string6 = SSEHandler.getTaskNameFromJar(file4);
                if (!string2.equals(string6)) continue;
                return string5;
            }
        }
        return string2;
    }

    private static String getTaskNameFromJar(File file) {
        try {
            Object object = file.toURI().toURL();
            object = new URLClassLoader(new URL[]{object});
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                Object object2 = enumeration.nextElement();
                if (!((String)(object2 = ((ZipEntry)object2).getName())).endsWith(".class") || ((String)object2).contains("$")) continue;
                object2 = ((String)object2).replace('/', '.').substring(0, ((String)object2).length() - 6);
                try {
                    if (!SSETaskPlugin.class.isAssignableFrom((Class<?>)(object2 = ((ClassLoader)object).loadClass((String)object2))) || ((Class)object2).isInterface()) continue;
                    object2 = (SSETaskPlugin)((Class)object2).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    object2 = object2.getTaskName();
                    jarFile.close();
                    ((URLClassLoader)object).close();
                    return object2;
                }
                catch (Exception exception) {
                }
            }
            jarFile.close();
            ((URLClassLoader)object).close();
        }
        catch (Exception exception) {
            System.err.println("[JAR SCAN ERROR] Failed to read task name from " + file.getName() + ": " + exception.getMessage());
        }
        return null;
    }

    private static String getPluginFolderName(String string) {
        File[] fileArray;
        Object object = SSEHandler.getJarNameForTask(string);
        if (object != null && !((String)object).equals(string)) {
            return object;
        }
        object = System.getProperty("user.dir") + File.separator + "SSEPLUGINS";
        if (((File)(object = new File((String)object))).exists() && (fileArray = ((File)object).listFiles(File::isDirectory)) != null) {
            for (File file : fileArray) {
                String string2;
                String string3;
                String string4 = file.getName();
                File file2 = new File(file, string4 + ".jar");
                File file3 = new File((File)object, string4 + ".jar");
                if (!(file2.exists() ? string.equals(string3 = SSEHandler.getTaskNameFromJar(file2)) : file3.exists() && string.equals(string2 = SSEHandler.getTaskNameFromJar(file3)))) continue;
                return string4;
            }
        }
        return string;
    }

    public static void generatePluginHelpFile(String string) {
        SSETaskPlugin sSETaskPlugin = registeredPlugins.get(string);
        if (sSETaskPlugin == null) {
            return;
        }
        try {
            Object object = SSEHandler.getJarNameForTask(string);
            object = System.getProperty("user.dir") + File.separator + "SSEPLUGINS" + File.separator + (String)object + ".html";
            object = new OutputStreamWriter((OutputStream)new FileOutputStream((String)object), "UTF-8");
            ((Writer)object).write("<!DOCTYPE html>\n");
            ((Writer)object).write("<html>\n<head>\n");
            ((Writer)object).write("    <title>" + sSETaskPlugin.getTaskName().toUpperCase() + " Plugin Help</title>\n");
            ((Writer)object).write("    <meta charset=\"UTF-8\">\n");
            ((Writer)object).write("    <style>\n");
            ((Writer)object).write("        body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }\n");
            ((Writer)object).write("        .container { max-width: 800px; background: white; padding: 30px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }\n");
            ((Writer)object).write("        .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 20px; border-radius: 8px; margin: -30px -30px 30px -30px; }\n");
            ((Writer)object).write("        h1 { margin: 0; font-size: 28px; }\n");
            ((Writer)object).write("        h2 { color: #333; border-bottom: 2px solid #667eea; padding-bottom: 5px; }\n");
            ((Writer)object).write("        .info { background: #e8f2ff; padding: 15px; border-radius: 5px; margin: 20px 0; }\n");
            ((Writer)object).write("        .status-enabled { color: #28a745; font-weight: bold; }\n");
            ((Writer)object).write("        .status-disabled { color: #dc3545; font-weight: bold; }\n");
            ((Writer)object).write("        pre { background: #f8f9fa; padding: 15px; border-radius: 5px; overflow-x: auto; }\n");
            ((Writer)object).write("        .footer { text-align: center; margin-top: 30px; color: #666; font-size: 12px; }\n");
            ((Writer)object).write("    </style>\n");
            ((Writer)object).write("</head>\n<body>\n");
            ((Writer)object).write("    <div class=\"container\">\n");
            ((Writer)object).write("        <div class=\"header\">\n");
            ((Writer)object).write("            <h1>[PLUGIN] " + sSETaskPlugin.getTaskName().toUpperCase() + "</h1>\n");
            ((Writer)object).write("        </div>\n");
            ((Writer)object).write("        <div class=\"info\">\n");
            ((Writer)object).write("            <div style=\"display: flex; align-items: center; margin-bottom: 15px;\">\n");
            ((Writer)object).write("                <img src=\"data:image/png;base64," + SSEHandler.getHrFiskalizatorLogo() + "\" alt=\"HrFiskalizator Logo\" style=\"width: 48px; height: 32px; margin-right: 15px;\">\n");
            ((Writer)object).write("                <div>\n");
            ((Writer)object).write("                    <strong>This is an SSE plugin for use with HrFiskalizator from version 78 onwards.</strong><br>\n");
            ((Writer)object).write("                    <small style=\"color: #666;\">Plugin System - Server-Sent Events</small>\n");
            ((Writer)object).write("                </div>\n");
            ((Writer)object).write("            </div>\n");
            ((Writer)object).write("            <strong>Plugin:</strong> " + sSETaskPlugin.getTaskName() + "<br>\n");
            ((Writer)object).write("            <strong>Version:</strong> " + sSETaskPlugin.getVersion() + "<br>\n");
            ((Writer)object).write("            <strong>Description:</strong> " + sSETaskPlugin.getDescription() + "<br>\n");
            ((Writer)object).write("            <strong>Status:</strong> <span class=\"" + (sSETaskPlugin.isEnabled() ? "status-enabled\">[ENABLED]" : "status-disabled\">[DISABLED]") + "</span><br>\n");
            Object object2 = pluginJarPaths.getOrDefault(string, "unknown");
            String string2 = "unknown";
            if (!((String)object2).equals("unknown")) {
                object2 = new File((String)object2);
                string2 = ((File)object2).getName();
            }
            ((Writer)object).write("            <strong>JAR File:</strong> <code>" + string2 + "</code>\n");
            ((Writer)object).write("        </div>\n\n");
            ((Writer)object).write("        <h2>&#128196; Documentation</h2>\n");
            ((Writer)object).write("        <pre>" + SSEHandler.escapeHtml(sSETaskPlugin.getHelp()) + "</pre>\n\n");
            ((Writer)object).write("        <div class=\"footer\">\n");
            ((Writer)object).write("            Generated: " + LocalDateTime.now().toString() + "<br>\n");
            ((Writer)object).write("            SSE Plugin System - HrFiskalizator\n");
            ((Writer)object).write("        </div>\n");
            ((Writer)object).write("    </div>\n");
            ((OutputStreamWriter)object).close();
            return;
        }
        catch (Exception exception) {
            System.err.println("[HELP ERROR] Failed to generate help for " + string + ": " + exception.getMessage());
            return;
        }
    }

    public static void generateAllPluginHelpFiles() {
        for (String string : registeredPlugins.keySet()) {
            SSEHandler.generatePluginHelpFile(string);
        }
    }

    public static void generateAllPluginHelpFilesIfNeeded() {
        int n2 = 0;
        int n3 = 0;
        for (String string : registeredPlugins.keySet()) {
            if (SSEHandler.generatePluginHelpFileIfNeeded(string)) {
                ++n2;
                continue;
            }
            ++n3;
        }
        if (n2 > 0) {
            HrFiskalizator.logger.log(Level.INFO, "[HELP] Generated " + n2 + " help files, skipped " + n3 + " (already up-to-date)");
        }
    }

    public static boolean generatePluginHelpFileIfNeeded(String string) {
        Object object = registeredPlugins.get(string);
        if (object == null) {
            return false;
        }
        try {
            object = SSEHandler.getJarNameForTask(string);
            object = System.getProperty("user.dir") + File.separator + "SSEPLUGINS" + File.separator + (String)object + ".html";
            object = new File((String)object);
            Object object2 = pluginJarPaths.get(string);
            if (((File)object).exists() && object2 != null && !((String)object2).equals("unknown") && ((File)(object2 = new File((String)object2))).exists() && ((File)object).lastModified() > ((File)object2).lastModified()) {
                return false;
            }
            SSEHandler.generatePluginHelpFile(string);
            return true;
        }
        catch (Exception exception) {
            System.err.println("[HELP ERROR] Failed to check/generate help for " + string + ": " + exception.getMessage());
            return false;
        }
    }

    public static String readPluginHelpFile(String string) {
        try {
            Object object = SSEHandler.getJarNameForTask(string);
            object = System.getProperty("user.dir") + File.separator + "SSEPLUGINS" + File.separator + (String)object + ".html";
            object = new File((String)object);
            if (!((File)object).exists()) {
                SSEHandler.generatePluginHelpFile(string);
                if (!((File)object).exists()) {
                    return "Help file not available for plugin: " + string;
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            object = new BufferedReader(new FileReader((File)object));
            Throwable throwable = null;
            try {
                String string2;
                while ((string2 = ((BufferedReader)object).readLine()) != null) {
                    stringBuilder.append(string2).append("\n");
                }
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable != null) {
                        try {
                            ((BufferedReader)object).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((BufferedReader)object).close();
                    }
                    throw throwable4;
                }
            }
            ((BufferedReader)object).close();
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "Error reading help file for " + string + ": " + exception.getMessage();
        }
    }

    public static String getPluginHelp(String string) {
        SSETaskPlugin sSETaskPlugin = registeredPlugins.get(string);
        if (sSETaskPlugin == null) {
            return "Plugin not found: " + string;
        }
        String string2 = SSEHandler.readPluginHelpFile(string);
        if (!string2.startsWith("Help file not available") && !string2.startsWith("Error reading")) {
            return string2;
        }
        try {
            return sSETaskPlugin.getHelp();
        }
        catch (Exception exception) {
            return "Help not available for plugin: " + string;
        }
    }

    public static void generateMasterHelpIndex() {
        try {
            Object object = System.getProperty("user.dir") + File.separator + "SSEPLUGINS" + File.separator + "plugin-help-index.txt";
            object = new OutputStreamWriter((OutputStream)new FileOutputStream((String)object), "UTF-8");
            ((Writer)object).write("=====================================================\n");
            ((Writer)object).write(" SSE PLUGIN SYSTEM - MASTER HELP INDEX\n");
            ((Writer)object).write("=====================================================\n\n");
            ((Writer)object).write("Total plugins: " + registeredPlugins.size() + "\n");
            ((Writer)object).write("Generated: " + LocalDateTime.now().toString() + "\n\n");
            for (Map.Entry<String, SSETaskPlugin> entry : registeredPlugins.entrySet()) {
                SSETaskPlugin object2 = entry.getValue();
                String string = SSEHandler.getJarNameForTask(object2.getTaskName());
                ((Writer)object).write("Plugin: " + object2.getTaskName() + "\n");
                ((Writer)object).write("  Version: " + object2.getVersion() + "\n");
                ((Writer)object).write("  Description: " + object2.getDescription() + "\n");
                ((Writer)object).write("  Status: " + (object2.isEnabled() ? "ENABLED" : "DISABLED") + "\n");
                ((Writer)object).write("  JAR file: " + string + ".jar\n");
                ((Writer)object).write("  Help file: " + string + ".html\n\n");
            }
            ((OutputStreamWriter)object).close();
            return;
        }
        catch (Exception exception) {
            System.err.println("[HELP ERROR] Failed to generate master help index: " + exception.getMessage());
            return;
        }
    }

    public static void generateMasterHelpIndexIfNeeded() {
        try {
            Object object = System.getProperty("user.dir") + File.separator + "SSEPLUGINS" + File.separator + "plugin-help-index.txt";
            object = new File((String)object);
            if (((File)object).exists()) {
                long l2 = ((File)object).lastModified();
                boolean bl2 = false;
                for (String string : pluginJarPaths.values()) {
                    File file;
                    if (string == null || string.equals("unknown") || !(file = new File(string)).exists() || file.lastModified() <= l2) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    return;
                }
            }
            SSEHandler.generateMasterHelpIndex();
            return;
        }
        catch (Exception exception) {
            System.err.println("[HELP ERROR] Failed to check master help index: " + exception.getMessage());
            SSEHandler.generateMasterHelpIndex();
            return;
        }
    }

    private static /* synthetic */ void lambda$handleSSEConnection$9(SSEConnection sSEConnection) {
        SSEHandler.removeConnection(sSEConnection);
    }

    static {
        HrFiskalizator.logger.log(Level.INFO, "[SSE PLUGIN SYSTEM] Initializing SSE Plugin System...");
        SSEHandler.loadSSEPlugins();
        HrFiskalizator.logger.log(Level.INFO, "[SSE PLUGIN SYSTEM] Plugin system initialized. Total plugins: " + registeredPlugins.size());
        HrFiskalizator.logger.log(Level.INFO, "[SSE HELP SYSTEM] Checking help documentation...");
        SSEHandler.generateAllPluginHelpFilesIfNeeded();
        SSEHandler.generateMasterHelpIndexIfNeeded();
        HrFiskalizator.logger.log(Level.INFO, "[SSE HELP SYSTEM] Help documentation check completed.");
        HrFiskalizator.logger.log(Level.INFO, "[SSE CLEANUP] Starting periodic cleanup tasks...");
        SSEHandler.startCleanupTasks();
        HrFiskalizator.logger.log(Level.INFO, "[SSE CLEANUP] Cleanup system initialized.");
        gson = new Gson();
        pendingRegistrations = new ConcurrentHashMap<String, ClientRegistration>();
        systemTasks = new HashSet<String>();
    }

    private static class ClientRegistration {
        public String id;
        public String[] tasks;
        long timestamp;

        public ClientRegistration() {
            this.timestamp = System.currentTimeMillis();
        }

        ClientRegistration(String string, String[] stringArray) {
            this.id = string;
            this.tasks = stringArray;
            this.timestamp = System.currentTimeMillis();
        }

        public final /* synthetic */ void a(Gson object, JsonWriter jsonWriter, d object2) {
            Object object3;
            jsonWriter.beginObject();
            d d2 = object2;
            JsonWriter jsonWriter2 = jsonWriter;
            object2 = object;
            object = this;
            if (object != ((ClientRegistration)object).id) {
                d2.a(jsonWriter2, 0);
                jsonWriter2.value(((ClientRegistration)object).id);
            }
            Object object4 = object;
            if (object4 != ((ClientRegistration)object4).tasks) {
                d2.a(jsonWriter2, 1);
                object3 = ((ClientRegistration)object).tasks;
                a.a((Gson)object2, String[].class, ((ClientRegistration)object).tasks).write(jsonWriter2, object3);
            }
            d2.a(jsonWriter2, 2);
            object3 = ((ClientRegistration)object).timestamp;
            a.a((Gson)object2, Long.TYPE, object3).write(jsonWriter2, object3);
            jsonWriter.endObject();
        }

        public final /* synthetic */ void a(Gson gson, JsonReader jsonReader, b b2) {
            jsonReader.beginObject();
            block5: while (jsonReader.hasNext()) {
                int n2;
                int n3 = n2 = b2.a(jsonReader);
                JsonReader jsonReader2 = jsonReader;
                Gson gson2 = gson;
                ClientRegistration clientRegistration = this;
                boolean bl2 = jsonReader2.peek() != JsonToken.NULL;
                switch (n3) {
                    case 0: {
                        if (bl2) {
                            if (jsonReader2.peek() != JsonToken.BOOLEAN) {
                                clientRegistration.id = jsonReader2.nextString();
                                continue block5;
                            }
                            clientRegistration.id = Boolean.toString(jsonReader2.nextBoolean());
                            continue block5;
                        }
                        clientRegistration.id = null;
                        jsonReader2.nextNull();
                        continue block5;
                    }
                    case 1: {
                        if (bl2) {
                            clientRegistration.tasks = gson2.getAdapter(String[].class).read(jsonReader2);
                            continue block5;
                        }
                        clientRegistration.tasks = null;
                        jsonReader2.nextNull();
                        continue block5;
                    }
                    case 2: {
                        if (bl2) {
                            clientRegistration.timestamp = gson2.getAdapter(Long.class).read(jsonReader2);
                            continue block5;
                        }
                        jsonReader2.nextNull();
                        continue block5;
                    }
                }
                jsonReader2.skipValue();
            }
            jsonReader.endObject();
        }
    }

    private static class SSEConnection {
        private final OutputStream out;
        private final String clientIP;
        private final String clientId;
        private final String[] tasks;
        private boolean closed = false;

        public SSEConnection(OutputStream outputStream, String string, String string2, String[] stringArray) {
            this.out = outputStream;
            this.clientIP = string;
            this.clientId = string2;
            this.tasks = stringArray != null ? stringArray : new String[]{};
        }

        public void sendData(String string) {
            if (!this.closed) {
                try {
                    this.out.write(string.getBytes("UTF-8"));
                    this.out.flush();
                    return;
                }
                catch (IOException iOException) {
                    HrFiskalizator.logger.log(Level.WARNING, "[CONNECTION] Broken connection detected for client " + (this.clientId != null ? this.clientId : "unknown") + " - triggering immediate cleanup: " + iOException.getMessage());
                    this.close();
                }
            }
        }

        public void close() {
            if (!this.closed) {
                this.closed = true;
                try {
                    this.out.close();
                }
                catch (IOException iOException) {}
                scheduler.execute(() -> SSEHandler.removeConnection(this));
            }
        }

        public boolean isClosed() {
            return this.closed;
        }

        public String getClientIP() {
            return this.clientIP;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String[] getTasks() {
            return this.tasks;
        }

        public boolean hasTask(String string) {
            if (this.tasks == null) {
                return false;
            }
            String[] stringArray = this.tasks;
            int n2 = this.tasks.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = stringArray[i2];
                if (!string.equals(string2)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface SSETaskPlugin {
        public String getTaskName();

        public String getDescription();

        public String getVersion();

        public void executeTask(String var1);

        public boolean isEnabled();

        public String getHelp();
    }
}

