/*
 * Decompiled with CFR 0.152.
 */
package fiskalizacija;

import ConfigRelated.LoadIni;
import UTIL.EnhProperies;
import UTIL.KeyStoreUtil;
import UTIL.ResourceFileLoader;
import UTIL.VFileUtils;
import UTIL.XMLrelated;
import com.sun.net.ssl.internal.ssl.Provider;
import fiskalizacija.Cfg;
import fiskalizacija.HrFiskalizator;
import fiskalizacija.SysUtil;
import fiskalizacija.Utilities;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Signer {
    private String fileWithoutPath = null;
    private String echo = null;
    private String jir = "";
    private String uid = null;
    private String zki = null;
    private String vrijemepovrat = "";
    public SOAPMessage reply = null;
    private EnhProperies p;
    public static final String ID_PDZAHTJEV = "#PrateciDokumentiZahtjev";
    public static final String ID_RACUNPD = "#RacunPDZahtjev";
    public static final String ID_RACUN = "#RacunZahtjev";
    public static final String ID_PROMIJENINACPLACZAHTJEV = "#PromijeniNacPlacZahtjev";
    public static final String ID_NAPOJNICAZAHTJEV = "#NapojnicaZahtjev";
    public static final String ID_ECHO = "#Echo";
    public static final String ID_PROVJERA = "#ProvjeraZahtjev";
    public static final String ID_DOHVATIRADNOVRIJEMEZAHTJEV = "#DohvatiRadnoVrijemeZahtjev";
    public static final String ID_PRIJAVIRADNOVRIJEMEZAHTJEV = "#PrijaviRadnoVrijemeZahtjev";
    public static final String ID_OBRISIRADNOVRIJEMEZAHTJEV = "#ObrisiRadnoVrijemeZahtjev";
    public boolean rawResponse;
    private final String urlWs;
    private final String nazivWs;
    private final String putanjaJKS;
    private final String lozinkaJKS;
    private final String privateKey;
    private final String lozinkaKey;
    private final int timeout;
    private String porukaGreske = null;
    public Map<String, String> ZADACI = new HashMap<String, String>();

    public String getFileWithoutPath() {
        return this.fileWithoutPath;
    }

    public void setFileWithoutPath(String string) {
        this.fileWithoutPath = string;
    }

    public Signer(EnhProperies enhProperies) {
        this.p = enhProperies;
        this.ZADACI.put("DOHVATIRADNOVRIJEMEZAHTJEV", ID_DOHVATIRADNOVRIJEMEZAHTJEV);
        this.ZADACI.put("PRIJAVIRADNOVRIJEMEZAHTJEV", ID_OBRISIRADNOVRIJEMEZAHTJEV);
        this.ZADACI.put("OBRISIRADNOVRIJEMEZAHTJEV", ID_OBRISIRADNOVRIJEMEZAHTJEV);
        this.urlWs = Cfg.getServerPU()[0];
        this.nazivWs = Cfg.getServerPU()[1];
        this.putanjaJKS = this.p.getProperty("PUTANJAJKS");
        this.lozinkaJKS = this.p.getProperty("LOZINKAJKS");
        this.timeout = Integer.parseInt(this.p.getProperty("CISTIMEOUT"));
        this.privateKey = this.p.getProperty("PRIVATEKEY");
        this.lozinkaKey = this.p.getProperty("LOZINKAKEY");
        this.rawResponse = enhProperies.getProperty("RAWRESPONSE").equals("true");
    }

    public void sendSoapFromResource(String object, String string) {
        object = new ResourceFileLoader((String)object);
        object = ((ResourceFileLoader)object).loadResourceToInputStream();
        object = XMLrelated.xmlStreamToXMLDocument((InputStream)object);
        this.sendSOAP((Document)object, string);
    }

    public void signAndSendFile(String string, String string2) {
        Utilities.setXMLPath(string);
        this.setFileWithoutPath(VFileUtils.fileNameWithoutPath(string));
        String string3 = VFileUtils.readFile(string);
        if (string3 == null) {
            this.porukaGreske = "Datoteka : " + string + " nije uspjesno ucitana !";
            return;
        }
        this.signAndSendString(string3, string2);
    }

    public void checkTns(String string) {
        if (!Cfg.isTnsSet()) {
            if (string.toUpperCase().contains("TNS:ZAGLAVLJE")) {
                Cfg.setTrsT(new LoadIni("translations/withtns.trans", 1).run("UTF-8"));
                Cfg.setTns(true);
                System.out.println("Used tns: translations");
            }
            if (!Cfg.isTnsSet() && string.toUpperCase().contains("ZAGLAVLJE")) {
                Cfg.setTrsT(new LoadIni("translations/notns.trans", 1).run("UTF-8"));
                Cfg.setTns(true);
                System.out.println("No tns: translations used");
            }
        }
    }

    public void signAndSendString(String object, String string) {
        if (this.p.get("UKLONIXMLKOMENTARE").equals("true")) {
            object = XMLrelated.removeXmlRemarks((String)object);
        }
        this.checkTns((String)object);
        object = XMLrelated.xmlStringToXMLDocument((String)object);
        object = this.signDoc((Document)object, string, null);
        this.sendSOAP((Document)object, string);
    }

    public String getJIR() {
        return this.jir;
    }

    public String getUID() {
        return this.uid;
    }

    public String getZKI() {
        return this.zki;
    }

    public String getECHO() {
        return this.echo;
    }

    public String getVrijemePovrata() {
        return this.vrijemepovrat;
    }

    public String getPorukaGreske() {
        return this.porukaGreske;
    }

    public void setPorukaGreske(String string) {
        this.porukaGreske = string;
    }

    public byte[] signZki(String string) {
        byte[] byArray = null;
        try {
            Object object = new FileInputStream(this.putanjaJKS);
            Object object2 = KeyStore.getInstance("JKS");
            ((KeyStore)object2).load((InputStream)object, this.lozinkaJKS.toCharArray());
            object = ((KeyStore)object2).getKey(this.privateKey, this.lozinkaKey.toCharArray());
            object2 = Signature.getInstance("SHA1withRSA");
            ((Signature)object2).initSign((PrivateKey)object);
            ((Signature)object2).update(string.getBytes());
            byArray = ((Signature)object2).sign();
        }
        catch (IOException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | SignatureException | UnrecoverableKeyException | CertificateException exception) {}
        return byArray;
    }

    private Document signDoc(Document document, String object, Object object2) {
        String string;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        if (document == null) {
            this.porukaGreske = "Od XML_a se nemo\u017ee kreirati poruka za slanje, izgleda da nije pravilno formatiran !?";
            return null;
        }
        object2 = XMLSignatureFactory.getInstance("DOM");
        XMLStructure xMLStructure = ((XMLSignatureFactory)object2).newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
        Object object7 = new ArrayList<Transform>();
        try {
            object6 = ((XMLSignatureFactory)object2).newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
            object5 = ((XMLSignatureFactory)object2).newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null);
            object7.add(object6);
            object7.add(object5);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException generalSecurityException) {
            this.porukaGreske = "Signer : Greska prije potpisivanja dokumenta : " + generalSecurityException.getMessage();
        }
        object5 = ((XMLSignatureFactory)object2).newReference((String)object, (DigestMethod)xMLStructure, (List<? extends Transform>)object7, null, null);
        xMLStructure = ((XMLSignatureFactory)object2).newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null);
        object7 = ((XMLSignatureFactory)object2).newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
        xMLStructure = ((XMLSignatureFactory)object2).newSignedInfo((CanonicalizationMethod)xMLStructure, (SignatureMethod)object7, Collections.singletonList(object5));
        object7 = KeyStore.getInstance("JKS");
        try {
            ((KeyStore)object7).load(new FileInputStream(this.putanjaJKS), this.lozinkaJKS.toCharArray());
        }
        catch (Exception exception) {
            this.porukaGreske = "Problem sa otvaranjem keystora, izgleda da password keystora nije ispravan : " + exception.getMessage();
            return null;
        }
        try {
            object7 = (KeyStore.PrivateKeyEntry)((KeyStore)object7).getEntry(this.privateKey, new KeyStore.PasswordProtection(this.lozinkaKey.toCharArray()));
        }
        catch (Exception exception) {
            this.porukaGreske = "Keystore je odkljucan ali password osobnog certifikata u keystoru izgleda nije ispravan, ili nema certifikata : " + exception.getMessage();
            return null;
        }
        try {
            object6 = (X509Certificate)((KeyStore.PrivateKeyEntry)object7).getCertificate();
        }
        catch (Exception exception) {
            this.porukaGreske = "Problem sa dohvatom korisnickog certifikata iz keystora : " + exception.getMessage();
            return null;
        }
        object5 = ((XMLSignatureFactory)object2).getKeyInfoFactory();
        Object object8 = ((KeyInfoFactory)object5).newX509IssuerSerial(((X509Certificate)object6).getIssuerX500Principal().getName(), ((X509Certificate)object6).getSerialNumber());
        this.porukaGreske = new KeyStoreUtil().IsCorrectCertificate((X509Certificate)object6);
        Object object9 = new ArrayList<Object>();
        object9.add(object6);
        object9.add(object8);
        object6 = ((KeyInfoFactory)object5).newX509Data((List<?>)object9);
        object8 = new ArrayList<Object>();
        object8.add(object6);
        object6 = ((KeyInfoFactory)object5).newKeyInfo((List<? extends XMLStructure>)object8);
        try {
            object5 = document.getDocumentElement();
            object5.setIdAttribute("Id", true);
            object5.getAttributeNode("Id").setTextContent(((String)object).replace("#", ""));
        }
        catch (Exception exception) {
            this.porukaGreske = "Problem kod potpisivanja dokumenta , izgleda da nije pravilno formatiran.(provjeri postavke tns: tagova) : ";
            this.porukaGreske = this.porukaGreske + exception.getMessage();
            return null;
        }
        object8 = null;
        if (((String)object).equals(ID_RACUN) || ((String)object).equals(ID_PROMIJENINACPLACZAHTJEV) || ((String)object).equals(ID_NAPOJNICAZAHTJEV) || ((String)object).equals(ID_PROVJERA) || ((String)object).equals(ID_RACUNPD) || ((String)object).equals(ID_PDZAHTJEV)) {
            try {
                object8 = XMLrelated.getNodeFromDocument(Cfg.TrsT("DatVrijeme"), document).getTextContent();
                object9 = ((String)object8).replace("T", " ");
                object4 = XMLrelated.getNodeFromDocument(Cfg.TrsT("Oib"), document).getTextContent();
                object3 = "BrOznRac";
                string = "ZastKod";
                if (((String)object).equals(ID_PDZAHTJEV)) {
                    object3 = "BrOznPD";
                    string = "ZastKodPD";
                }
                object3 = XMLrelated.getNodeFromDocument(Cfg.TrsT((String)object3), document).getTextContent();
                String string2 = XMLrelated.getNodeFromDocument(Cfg.TrsT("IznosUkupno"), document).getTextContent();
                String string3 = XMLrelated.getNodeFromDocument(Cfg.TrsT("OznPosPr"), document).getTextContent();
                String string4 = XMLrelated.getNodeFromDocument(Cfg.TrsT("OznNapUr"), document).getTextContent();
                this.zki = object9 = Utilities.getZKI(this, (String)object9, (String)object4, (String)object3, string2, string3, string4);
                object4 = XMLrelated.getNodeFromDocument(Cfg.TrsT(string), document);
                object4.setTextContent((String)object9);
                Cfg.updaterCounter();
            }
            catch (NoSuchAlgorithmException | DOMException exception) {
                this.porukaGreske = this.porukaGreske + exception.getMessage();
                return document;
            }
        }
        object9 = XMLrelated.getNodeFromDocument(Cfg.TrsT("IdPoruke"), document);
        if (Cfg.UidInputActive()) {
            object4 = Utilities.uidString();
            object9.setTextContent((String)object4);
        }
        this.uid = object9.getTextContent();
        if (!((String)object).equals(ID_ECHO)) {
            object4 = XMLrelated.getNodeFromDocument(Cfg.TrsT("DatumVrijeme"), document);
            if (Cfg.UpdateSendTimeActive()) {
                object3 = new Date();
                string = SysUtil.ldf.format((Date)object3);
                object4.setTextContent(string);
            } else {
                object3 = SysUtil.ldf.parse(object4.getTextContent());
            }
            if ((((String)object).equals(ID_RACUN) || ((String)object).equals(ID_PROVJERA) || ((String)object).equals(ID_RACUNPD)) && ((Date)(object = SysUtil.ldf.parse((String)object8))).after((Date)object3)) {
                this.porukaGreske = "Vrijeme racuna je ve\u010de od vremena slanja !";
                HrFiskalizator.logger.log(Level.SEVERE, "VR = " + ((Date)object).toString() + " VS = " + ((Date)object3).toString());
                HrFiskalizator.logger.log(Level.SEVERE, this.porukaGreske);
                return null;
            }
        }
        object4 = new DOMSignContext(((KeyStore.PrivateKeyEntry)object7).getPrivateKey(), (Node)object5);
        object3 = ((XMLSignatureFactory)object2).newXMLSignature((SignedInfo)xMLStructure, (KeyInfo)object6);
        object3.sign((XMLSignContext)object4);
        return document;
    }

    private void sendSOAP(Document object, String string) {
        if (this.porukaGreske != null) {
            return;
        }
        Security.addProvider((java.security.Provider)new Provider());
        SOAPConnectionFactory sOAPConnectionFactory = SOAPConnectionFactory.newInstance();
        sOAPConnectionFactory = sOAPConnectionFactory.createConnection();
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage sOAPMessage = messageFactory.createMessage();
        Object object2 = sOAPMessage.getSOAPPart();
        object2 = object2.getEnvelope();
        SOAPBody sOAPBody = object2.getBody();
        object2.getHeader().detachNode();
        object2 = DocumentBuilderFactory.newInstance();
        object2.setNamespaceAware(true);
        sOAPBody.addDocument((Document)object);
        sOAPMessage.saveChanges();
        if ("TRUE".equals(this.p.getProperty("DEBUGMODE").toUpperCase())) {
            sOAPMessage.writeTo((OutputStream)System.out);
        }
        if ("TRUE".equals(this.p.getProperty("ZANEMARISSLCERTIFIKATE").toUpperCase())) {
            new KeyStoreUtil().trustAllCertificate();
        } else {
            try {
                object = SSLContext.getInstance("TLSv1.2");
                object.init(null, null, null);
                SSLContext.setDefault((SSLContext)object);
            }
            catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
                object = generalSecurityException;
                Cfg.setLastError(generalSecurityException.getMessage());
            }
        }
        object = new URL(new URL(this.urlWs), this.nazivWs, new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL object) {
                object = new URL(((URL)object).toString());
                object = ((URL)object).openConnection();
                ((URLConnection)object).setConnectTimeout(Signer.this.timeout);
                ((URLConnection)object).setReadTimeout(Signer.this.timeout);
                return object;
            }
        });
        this.reply = messageFactory.createMessage();
        try {
            this.reply = sOAPConnectionFactory.call(sOAPMessage, object);
        }
        catch (SOAPException sOAPException) {
            this.porukaGreske = "Problem pri slanju poruke na server porezne uprave : " + sOAPException.getMessage();
        }
        if (this.porukaGreske != null) {
            return;
        }
        if ("TRUE".equals(this.p.getProperty("DEBUGMODE").toUpperCase())) {
            this.reply.writeTo((OutputStream)System.out);
        }
        switch (string) {
            case "#Echo": {
                object = "";
                try {
                    object = this.reply.getSOAPBody().getElementsByTagName("tns:EchoResponse").item(0).getTextContent();
                }
                catch (NullPointerException nullPointerException) {
                    try {
                        this.porukaGreske = this.reply.getSOAPBody().getElementsByTagName("tns:PorukaGreske").item(0).getTextContent();
                        object = this.porukaGreske;
                    }
                    catch (NullPointerException nullPointerException2) {}
                }
                this.echo = object;
                break;
            }
            case "#PrateciDokumentiZahtjev": 
            case "#RacunPDZahtjev": 
            case "#RacunZahtjev": {
                try {
                    this.jir = this.reply.getSOAPBody().getElementsByTagName("tns:Jir").item(0).getTextContent();
                    this.vrijemepovrat = this.reply.getSOAPBody().getElementsByTagName("tns:DatumVrijeme").item(0).getTextContent();
                    break;
                }
                catch (NullPointerException nullPointerException) {
                    try {
                        this.porukaGreske = "Server PU je vratio gresku : " + nullPointerException.getMessage();
                        this.porukaGreske = this.reply.getSOAPBody().getElementsByTagName("tns:PorukaGreske").item(0).getTextContent();
                        break;
                    }
                    catch (NullPointerException nullPointerException3) {
                        try {
                            this.porukaGreske = this.porukaGreske + "\nIzgleda da XML datoteka nije ispravno formatirana : " + nullPointerException3.getMessage();
                            this.porukaGreske = this.reply.getSOAPBody().getElementsByTagName("faultstring").item(0).getTextContent();
                            break;
                        }
                        catch (NullPointerException nullPointerException4) {
                            sOAPConnectionFactory.close();
                            return;
                        }
                    }
                }
            }
            case "#PromijeniNacPlacZahtjev": {
                object = this.reply.getSOAPBody();
                try {
                    this.jir = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
                    this.uid = object.getElementsByTagName("tns:SifraPoruke").item(0).getTextContent();
                    break;
                }
                catch (NullPointerException nullPointerException) {
                    try {
                        this.zki = "Greska pri izvo\u0111enju zahtjeva " + string + " : " + object.getElementsByTagName("tns:PorukaGreske").item(0).getTextContent();
                        break;
                    }
                    catch (NullPointerException nullPointerException5) {
                        sOAPConnectionFactory.close();
                        return;
                    }
                }
            }
            case "#NapojnicaZahtjev": {
                object = this.reply.getSOAPBody();
                try {
                    this.vrijemepovrat = this.reply.getSOAPBody().getElementsByTagName("tns:DatumVrijeme").item(0).getTextContent();
                    this.uid = this.reply.getSOAPBody().getElementsByTagName("tns:IdPoruke").item(0).getTextContent();
                    this.jir = this.reply.getSOAPBody().getElementsByTagName("tns:Poruka").item(0).getTextContent();
                    this.zki = this.reply.getSOAPBody().getElementsByTagName("tns:SifraPoruke").item(0).getTextContent();
                    break;
                }
                catch (NullPointerException nullPointerException) {
                    try {
                        this.jir = object.getElementsByTagName("tns:PorukaGreske").item(0).getTextContent();
                        this.zki = this.reply.getSOAPBody().getElementsByTagName("tns:SifraGreske").item(0).getTextContent();
                        break;
                    }
                    catch (NullPointerException nullPointerException6) {
                        sOAPConnectionFactory.close();
                        return;
                    }
                }
            }
            case "#ProvjeraZahtjev": {
                try {
                    this.vrijemepovrat = "";
                    this.uid = this.reply.getSOAPBody().getElementsByTagName("f73:IdPoruke").item(0).getTextContent();
                    this.jir = this.reply.getSOAPBody().getElementsByTagName("f73:PorukaGreske").item(0).getTextContent();
                    this.zki = this.reply.getSOAPBody().getElementsByTagName("f73:SifraGreske").item(0).getTextContent();
                    break;
                }
                catch (NullPointerException nullPointerException) {
                    try {
                        this.porukaGreske = this.reply.getSOAPBody().getElementsByTagName("tns:PorukaGreske").item(0).getTextContent();
                        this.porukaGreske = "Server PU je vratio gresku : " + this.porukaGreske + nullPointerException.getMessage();
                        break;
                    }
                    catch (SOAPException | DOMException throwable) {
                        this.porukaGreske = "Greska pri dohvatu greske iz poruke PU : " + nullPointerException.getMessage();
                        sOAPConnectionFactory.close();
                        return;
                    }
                }
            }
            case "#DohvatiRadnoVrijemeZahtjev": 
            case "#ObrisiRadnoVrijemeZahtjev": 
            case "#PrijaviRadnoVrijemeZahtjev": {
                try {
                    this.uid = this.reply.getSOAPBody().getElementsByTagName("f73:IdPoruke").item(0).getTextContent();
                    break;
                }
                catch (NullPointerException nullPointerException) {
                    try {
                        this.porukaGreske = this.reply.getSOAPBody().getElementsByTagName("tns:PorukaGreske").item(0).getTextContent();
                        this.porukaGreske = "Server PU je vratio gresku : " + this.porukaGreske + nullPointerException.getMessage();
                        break;
                    }
                    catch (SOAPException | DOMException throwable) {
                        this.porukaGreske = "Greska pri dohvatu greske iz poruke PU : " + nullPointerException.getMessage();
                        sOAPConnectionFactory.close();
                        return;
                    }
                }
            }
        }
        if (!string.equals(ID_ECHO) && !string.equals(ID_PROVJERA) && this.porukaGreske == null) {
            object = SysUtil.OSFS() + this.getFileWithoutPath();
            Integer n2 = 1;
            if (string.equals(ID_PROMIJENINACPLACZAHTJEV)) {
                if (this.uid.equals("p001")) {
                    object = object.split(SysUtil.OSFS() + ".");
                    object = object[0] + "_PNP." + object[1];
                } else {
                    n2 = 0;
                }
            }
            if (string.equals(ID_NAPOJNICAZAHTJEV)) {
                object = object.split(SysUtil.OSFS() + ".");
                object = this.zki.equals("p002") ? object[0] + "_NAP." + object[1] : object[0] + "_NAP_GRESKA_" + this.zki + "." + object[1];
            }
            if (string.contains("RADNOVRIJEMEZAHTJEV")) {
                object = object.split(SysUtil.OSFS() + ".");
                object = object[0] + "_" + this.uid + "_." + object[1];
            }
            if (n2 == 1) {
                if (!"".equals(this.p.getProperty("FOLDERARHIVAZAHTJEV"))) {
                    XMLrelated.SOAPmessageToXmlFile(this.p.getProperty("FOLDERARHIVAZAHTJEV") + "/" + (String)object, sOAPMessage);
                }
                if (!"".equals(this.p.getProperty("FOLDERARHIVAODGOVOR"))) {
                    XMLrelated.SOAPmessageToXmlFile(this.p.getProperty("FOLDERARHIVAODGOVOR") + "/" + (String)object, this.reply);
                }
            }
        }
        sOAPConnectionFactory.close();
    }
}

