/*
 * Decompiled with CFR 0.152.
 */
package fiskalizacija;

import fiskalizacija.HrFiskalizator;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public enum SoundEffect {
    ERROR("/audio/error.wav"),
    PING("/audio/ping.wav"),
    BEEP("/audio/beep.wav"),
    CASH("/audio/cash.wav");

    public static Volume volume;
    private double soundlevel = 10.0;
    private Clip clip;

    private SoundEffect(String string) {
        try {
            object = ((Object)((Object)this)).getClass().getResource(string);
            object = AudioSystem.getAudioInputStream((URL)object);
            this.clip = AudioSystem.getClip();
            this.clip.open((AudioInputStream)object);
            switch (HrFiskalizator.p.getProperty("SOUNDLEVEL")) {
                case "LOW": {
                    this.soundlevel = 20.0;
                    break;
                }
                case "MEDIUM": {
                    this.soundlevel = 10.0;
                    break;
                }
                case "HIGH": {
                    this.soundlevel = 0.0;
                    break;
                }
                default: {
                    this.soundlevel = 10.0;
                }
            }
            object = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
            float f2 = (float)(Math.log(0.25) / Math.log(10.0) * this.soundlevel);
            ((FloatControl)object).setValue(f2);
            return;
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException exception) {
            return;
        }
    }

    public final void play(Boolean bl2) {
        if (volume != Volume.MUTE) {
            if (this.clip.isRunning()) {
                this.clip.stop();
            }
            this.clip.setFramePosition(0);
            this.clip.start();
            if (bl2.booleanValue()) {
                this.clip.loop(-1);
            }
        }
    }

    public final void stop() {
        this.clip.stop();
        this.clip.setFramePosition(0);
    }

    public final void mute() {
        volume = Volume.MUTE;
    }

    public static void init() {
        SoundEffect.values();
    }

    static {
        volume = Volume.LOW;
    }

    public static enum Volume {
        MUTE,
        LOW,
        MEDIUM,
        HIGH;

    }
}

