/*
 * Decompiled with CFR 0.152.
 */
package fiskalizacija20.kpd;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fiskalizacija.SysUtil;
import fiskalizacija20.kpd.JedinicaMjera;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JediniceMjeraSearcher {
    private JsonNode a;
    private Map<String, JsonNode> b;
    private ObjectMapper c;
    private String d;
    private int e = 0;
    private Map<String, Integer> f = new HashMap<String, Integer>();
    private Map<String, List<String>> g = new HashMap<String, List<String>>();

    public JediniceMjeraSearcher() {
        this("fiskalizacija20/json/JediniceMjera_EN16931_HR.json");
    }

    public JediniceMjeraSearcher(String object2) {
        this.d = object2;
        this.c = new ObjectMapper();
        object2 = this;
        try {
            Object object3 = new File(((JediniceMjeraSearcher)object2).d);
            if (!((File)object3).exists()) {
                throw new RuntimeException("JediniceMjera JSON datoteka nije prona\u0111ena na: " + ((JediniceMjeraSearcher)object2).d);
            }
            ((JediniceMjeraSearcher)object2).a = ((JediniceMjeraSearcher)object2).c.readTree((File)object3);
            ((JediniceMjeraSearcher)object2).b = new HashMap<String, JsonNode>();
            object3 = ((JediniceMjeraSearcher)object2).a.get("JediniceMjera_EN16931_HR").get("units");
            if (object3 != null && ((JsonNode)object3).isObject()) {
                ((JsonNode)object3).fields().forEachRemaining(object -> {
                    String string = (String)object.getKey();
                    object = (JsonNode)object.getValue();
                    if (!string.startsWith("_comment_") && ((JsonNode)object).isObject()) {
                        this.b.put(string, (JsonNode)object);
                    }
                });
            }
            if ((object3 = ((JediniceMjeraSearcher)object2).a.get("JediniceMjera_EN16931_HR").get("categories")) != null && ((JsonNode)object3).isObject()) {
                ((JsonNode)object3).fields().forEachRemaining(entry -> {
                    String string = (String)entry.getKey();
                    ArrayList arrayList = new ArrayList();
                    ((JsonNode)entry.getValue()).forEach(jsonNode -> arrayList.add(jsonNode.asText()));
                    this.g.put(string, arrayList);
                });
            }
            ((JediniceMjeraSearcher)object2).e = ((JediniceMjeraSearcher)object2).b.size();
            object3 = object2;
            for (Map.Entry<String, List<String>> entry2 : ((JediniceMjeraSearcher)object3).g.entrySet()) {
                ((JediniceMjeraSearcher)object3).f.put(entry2.getKey(), entry2.getValue().size());
            }
            SysUtil.vdevout("\u2713 Jedinice mjera uspje\u0161no u\u010ditane:");
            SysUtil.vdevout("   Ukupno jedinica: " + ((JediniceMjeraSearcher)object2).e);
            SysUtil.vdevout("   Ukupno kategorija: " + ((JediniceMjeraSearcher)object2).g.size());
            SysUtil.vdevout("   JSON datoteka: " + ((JediniceMjeraSearcher)object2).d);
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Gre\u0161ka pri u\u010ditavanju JediniceMjera JSON: " + iOException.getMessage(), iOException);
        }
    }

    public static JediniceMjeraSearcher fromFolder(String string) {
        string = "../" + string + "/JediniceMjera_EN16931_HR.json";
        return new JediniceMjeraSearcher(string);
    }

    public static JediniceMjeraSearcher fromAbsolutePath(String string) {
        return new JediniceMjeraSearcher(string);
    }

    public List<JedinicaMjera> searchByName(String string, boolean bl2) {
        if (string == null || string.trim().isEmpty()) {
            return new ArrayList<JedinicaMjera>();
        }
        string = bl2 ? string : string.toLowerCase();
        return this.b.entrySet().stream().filter(object -> {
            object = (JsonNode)object.getValue();
            String string2 = JediniceMjeraSearcher.b((JsonNode)object, "name_en");
            String string3 = JediniceMjeraSearcher.b((JsonNode)object, "name_hr");
            String string4 = JediniceMjeraSearcher.b((JsonNode)object, "description");
            object = JediniceMjeraSearcher.b((JsonNode)object, "synonym");
            if (!bl2) {
                string2 = string2.toLowerCase();
                string3 = string3.toLowerCase();
                string4 = string4.toLowerCase();
                object = ((String)object).toLowerCase();
            }
            return string2.contains(string) || string3.contains(string) || string4.contains(string) || ((String)object).contains(string);
        }).map(entry -> this.a((String)entry.getKey(), (JsonNode)entry.getValue())).collect(Collectors.toList());
    }

    public List<JedinicaMjera> searchByName(String string) {
        return this.searchByName(string, false);
    }

    public List<JedinicaMjera> searchByCode(String string) {
        if (string == null || string.trim().isEmpty()) {
            return new ArrayList<JedinicaMjera>();
        }
        string = string.toUpperCase().trim();
        return this.b.entrySet().stream().filter(object -> {
            String string2 = ((String)object.getKey()).toUpperCase();
            object = (JsonNode)object.getValue();
            object = JediniceMjeraSearcher.b((JsonNode)object, "code").toUpperCase();
            return string2.equals(string) || string2.contains(string) || ((String)object).equals(string) || ((String)object).contains(string);
        }).map(entry -> this.a((String)entry.getKey(), (JsonNode)entry.getValue())).collect(Collectors.toList());
    }

    public List<JedinicaMjera> searchByCategory(String object) {
        if (object == null || ((String)object).trim().isEmpty()) {
            return new ArrayList<JedinicaMjera>();
        }
        if ((object = this.g.get(((String)object).toLowerCase())) == null || object.isEmpty()) {
            return new ArrayList<JedinicaMjera>();
        }
        return object.stream().filter(this.b::containsKey).map(string -> this.a((String)string, this.b.get(string))).collect(Collectors.toList());
    }

    public List<JedinicaMjera> advancedSearch(String object, String string, int n2) {
        Stream<Object> stream = this.b.entrySet().stream();
        if (object != null && !((String)object).trim().isEmpty()) {
            object = ((String)object).toLowerCase();
            stream = stream.filter(arg_0 -> this.b((String)object, arg_0));
        }
        if (string != null && !string.trim().isEmpty() && (object = this.g.get(string.toLowerCase())) != null) {
            stream = stream.filter(arg_0 -> JediniceMjeraSearcher.a((List)object, arg_0));
        }
        if (n2 > 0) {
            stream = stream.limit(n2);
        }
        return stream.map(entry -> this.a((String)entry.getKey(), (JsonNode)entry.getValue())).collect(Collectors.toList());
    }

    public JedinicaMjera findByExactCode(String string) {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        JsonNode jsonNode = this.b.get(string.toUpperCase());
        if (jsonNode != null) {
            return this.a(string.toUpperCase(), jsonNode);
        }
        jsonNode = this.b.get(string.toLowerCase());
        if (jsonNode != null) {
            return this.a(string.toLowerCase(), jsonNode);
        }
        return this.b.entrySet().stream().filter(object -> {
            object = JediniceMjeraSearcher.b((JsonNode)object.getValue(), "code");
            return ((String)object).equalsIgnoreCase(string);
        }).map(entry -> this.a((String)entry.getKey(), (JsonNode)entry.getValue())).findFirst().orElse(null);
    }

    public Map<String, Integer> getCategoryStatistics() {
        return new HashMap<String, Integer>(this.f);
    }

    public List<String> getAllCategories() {
        return new ArrayList<String>(this.g.keySet());
    }

    public List<String> getCodesInCategory(String object) {
        if ((object = this.g.get(((String)object).toLowerCase())) != null) {
            return new ArrayList<String>((Collection<String>)object);
        }
        return new ArrayList<String>();
    }

    public String getJsonFilePath() {
        return this.d;
    }

    public static String getDefaultPath() {
        return "fiskalizacija20/json/JediniceMjera_EN16931_HR.json";
    }

    private JedinicaMjera a(String string, JsonNode object) {
        JedinicaMjera jedinicaMjera = new JedinicaMjera();
        jedinicaMjera.setCode(string);
        jedinicaMjera.setNameEn(JediniceMjeraSearcher.a((JsonNode)((Object)object), "name_en"));
        jedinicaMjera.setNameHr(JediniceMjeraSearcher.a((JsonNode)((Object)object), "name_hr"));
        jedinicaMjera.setDescription(JediniceMjeraSearcher.a((JsonNode)((Object)object), "description"));
        jedinicaMjera.setSynonym(JediniceMjeraSearcher.a((JsonNode)((Object)object), "synonym"));
        for (Map.Entry<String, List<String>> entry : this.g.entrySet()) {
            if (!entry.getValue().contains(string)) continue;
            jedinicaMjera.setCategory(entry.getKey());
            break;
        }
        return jedinicaMjera;
    }

    private static String a(JsonNode jsonNode, String string) {
        if (jsonNode.has(string)) {
            return jsonNode.get(string).asText();
        }
        return null;
    }

    private static String b(JsonNode jsonNode, String string) {
        if (jsonNode.has(string)) {
            return jsonNode.get(string).asText();
        }
        return "";
    }

    public static String formatResults(List<JedinicaMjera> list, int n2) {
        if (list == null || list.isEmpty()) {
            return "   Nema prona\u0111enih rezultata\n";
        }
        StringBuilder stringBuilder = new StringBuilder();
        list.stream().limit(n2).forEach(jedinicaMjera -> stringBuilder.append("   \u2713 ").append(jedinicaMjera.getCode()).append(" - ").append(jedinicaMjera.getNameHr()).append(" (").append(jedinicaMjera.getNameEn()).append(")\n"));
        if (list.size() > n2) {
            stringBuilder.append("   ... i jo\u0161 ").append(list.size() - n2).append(" rezultata\n");
        }
        return stringBuilder.toString();
    }

    public static void main(String[] object) {
        try {
            System.out.println("=== JEDINICE MJERA SEARCHER TEST ===");
            System.out.println("=====================================");
            System.out.println("\n1. DEFAULT KONSTRUKTOR:");
            System.out.println("   Default putanja: " + JediniceMjeraSearcher.getDefaultPath());
            object = new JediniceMjeraSearcher();
            System.out.println("   Trenutna putanja: " + ((JediniceMjeraSearcher)object).getJsonFilePath());
            System.out.println("\n2. OSNOVNI TESTOVI:");
            List<JedinicaMjera> list = ((JediniceMjeraSearcher)object).searchByName("kilogram");
            JediniceMjeraSearcher.a(list, 3);
            System.out.println("\n3. PRETRA\u017dIVANJE PO KODU:");
            list = ((JediniceMjeraSearcher)object).searchByCode("KGM");
            JediniceMjeraSearcher.a(list, 3);
            System.out.println("\n4. PRETRA\u017dIVANJE PO KATEGORIJI:");
            list = ((JediniceMjeraSearcher)object).searchByCategory("mass");
            System.out.println("   Jedinice u kategoriji 'mass': " + list.size() + " stavki");
            JediniceMjeraSearcher.a(list.subList(0, Math.min(3, list.size())), 3);
            System.out.println("\n5. STATISTIKE PO KATEGORIJAMA:");
            object = ((JediniceMjeraSearcher)object).getCategoryStatistics();
            object.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(5L).forEach(entry -> System.out.println("   " + (String)entry.getKey() + ": " + entry.getValue() + " jedinica"));
            System.out.println("\n=== NA\u010cINI KREIRANJA SEARCHER-A ===");
            System.out.println("1. new JediniceMjeraSearcher() - koristi default putanju");
            System.out.println("2. new JediniceMjeraSearcher(\"custom/path.json\") - custom putanja");
            System.out.println("3. JediniceMjeraSearcher.fromFolder(\"data/units\") - iz foldera");
            System.out.println("4. JediniceMjeraSearcher.fromAbsolutePath(\"/full/path.json\") - apsolutno");
            System.out.println("\nZa promjenu default putanje, mijenjajte DEFAULT_JEDINICE_JSON_PATH konstantu!");
            return;
        }
        catch (Exception exception) {
            System.err.println("X Gre\u0161ka: " + exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }

    private static void a(List<JedinicaMjera> list, int n2) {
        list.stream().limit(3L).forEach(jedinicaMjera -> System.out.println("   \u2713 " + jedinicaMjera.getCode() + " - " + jedinicaMjera.getNameHr() + " (" + jedinicaMjera.getNameEn() + ")"));
        if (list.size() > 3) {
            System.out.println("   ... i jo\u0161 " + (list.size() - 3) + " rezultata");
        }
    }

    private static /* synthetic */ boolean a(List list, Map.Entry entry) {
        return list.contains(entry.getKey());
    }

    private /* synthetic */ boolean b(String string, Map.Entry object) {
        Object object2 = (JsonNode)object.getValue();
        String string2 = JediniceMjeraSearcher.b((JsonNode)object2, "name_en").toLowerCase();
        String string3 = JediniceMjeraSearcher.b((JsonNode)object2, "name_hr").toLowerCase();
        object2 = JediniceMjeraSearcher.b((JsonNode)object2, "description").toLowerCase();
        object = ((String)object.getKey()).toLowerCase();
        return string2.contains(string) || string3.contains(string) || ((String)object2).contains(string) || ((String)object).contains(string);
    }
}

