/*
 * Decompiled with CFR 0.152.
 */
package fiskalizacija20.kpd;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fiskalizacija20.kpd.KPDHierarchy;
import fiskalizacija20.kpd.KPDItem;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class KPD2025Searcher {
    private JsonNode a;
    private List<JsonNode> b;
    private ObjectMapper c;
    private String d;
    private int e = 0;
    private int f = 0;
    private Map<String, Integer> g = new HashMap<String, Integer>();

    public KPD2025Searcher() {
        this("fiskalizacija20/json/KPD2025.json");
    }

    public KPD2025Searcher(String object) {
        this.d = object;
        this.c = new ObjectMapper();
        object = this;
        try {
            Object object2 = new File(((KPD2025Searcher)object).d);
            if (!((File)object2).exists()) {
                throw new RuntimeException("KPD2025.json datoteka nije prona\u0111ena na: " + ((KPD2025Searcher)object).d);
            }
            ((KPD2025Searcher)object).a = ((KPD2025Searcher)object).c.readTree((File)object2);
            ((KPD2025Searcher)object).b = new ArrayList<JsonNode>();
            object2 = ((KPD2025Searcher)object).a.get("klasifikacije");
            if (object2 != null && ((JsonNode)object2).isArray()) {
                object2.forEach(((KPD2025Searcher)object).b::add);
            }
            if ((object2 = ((KPD2025Searcher)object).a.get("meta")) != null) {
                ((KPD2025Searcher)object).e = ((JsonNode)object2).get("totalRecords").asInt();
                ((KPD2025Searcher)object).f = ((JsonNode)object2).get("sectorsCount").asInt();
            }
            object2 = object;
            for (JsonNode jsonNode : ((KPD2025Searcher)object2).b) {
                String object3 = jsonNode.get("sectorCode").asText();
                ((KPD2025Searcher)object2).g.put(object3, ((KPD2025Searcher)object2).g.getOrDefault(object3, 0) + 1);
            }
            System.out.println("\u2713 KPD2025 podaci uspje\u0161no u\u010ditani:");
            System.out.println("   Ukupno klasifikacija: " + ((KPD2025Searcher)object).e);
            System.out.println("   Ukupno sektora: " + ((KPD2025Searcher)object).f);
            System.out.println("   JSON datoteka: " + ((KPD2025Searcher)object).d);
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Gre\u0161ka pri u\u010ditavanju KPD2025.json: " + iOException.getMessage(), iOException);
        }
    }

    public static KPD2025Searcher fromFolder(String string) {
        string = "../" + string + "/KPD2025.json";
        return new KPD2025Searcher(string);
    }

    public static KPD2025Searcher fromAbsolutePath(String string) {
        return new KPD2025Searcher(string);
    }

    public List<KPDItem> searchByName(String string, boolean bl2) {
        if (string == null || string.trim().isEmpty()) {
            return new ArrayList<KPDItem>();
        }
        string = bl2 ? string : string.toLowerCase();
        return this.b.stream().filter(object -> {
            String string2 = ((JsonNode)object).get("name").asText();
            Object object2 = object = ((JsonNode)object).has("nameEn") ? ((JsonNode)object).get("nameEn").asText() : "";
            if (!bl2) {
                string2 = string2.toLowerCase();
                object = ((String)object).toLowerCase();
            }
            return string2.contains(string) || ((String)object).contains(string);
        }).map(this::a).collect(Collectors.toList());
    }

    public List<KPDItem> searchByName(String string) {
        return this.searchByName(string, false);
    }

    public List<KPDItem> searchByCode(String string) {
        if (string == null || string.trim().isEmpty()) {
            return new ArrayList<KPDItem>();
        }
        return this.b.stream().filter(object -> {
            String string2 = ((JsonNode)object).get("fullCode").asText();
            object = ((JsonNode)object).get("code").asText();
            return string2.equals(string) || ((String)object).equals(string) || string2.contains(string) || ((String)object).contains(string);
        }).map(this::a).collect(Collectors.toList());
    }

    public List<KPDItem> searchBySector(String string) {
        if (string == null || string.trim().isEmpty()) {
            return new ArrayList<KPDItem>();
        }
        return this.b.stream().filter(jsonNode -> jsonNode.get("sectorCode").asText().equalsIgnoreCase(string)).map(this::a).collect(Collectors.toList());
    }

    public List<KPDItem> advancedSearch(String string, String string2, String string3, int n2) {
        Stream<Object> stream = this.b.stream();
        if (string != null && !string.trim().isEmpty()) {
            string = string.toLowerCase();
            stream = stream.filter(object -> {
                String string2 = ((JsonNode)object).get("name").asText().toLowerCase();
                String string3 = ((JsonNode)object).has("nameEn") ? ((JsonNode)object).get("nameEn").asText().toLowerCase() : "";
                object = ((JsonNode)object).get("fullCode").asText().toLowerCase();
                return string2.contains(string) || string3.contains(string) || ((String)object).contains(string);
            });
        }
        if (string2 != null && !string2.trim().isEmpty()) {
            stream = stream.filter(jsonNode -> jsonNode.get("sectorCode").asText().equalsIgnoreCase(string2));
        }
        if (string3 != null && !string3.trim().isEmpty()) {
            try {
                int n3 = Integer.parseInt(string3);
                stream = stream.filter(jsonNode -> jsonNode.get("level").asInt() == n3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (n2 > 0) {
            stream = stream.limit(n2);
        }
        return stream.map(this::a).collect(Collectors.toList());
    }

    public KPDItem findByExactCode(String string) {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        return this.b.stream().filter(jsonNode -> jsonNode.get("fullCode").asText().equals(string) || jsonNode.get("code").asText().equals(string)).map(this::a).findFirst().orElse(null);
    }

    public KPDHierarchy getHierarchy(String object) {
        if ((object = this.findByExactCode((String)object)) == null) {
            return null;
        }
        KPDItem kPDItem = null;
        if (((KPDItem)object).getParentCode() != null) {
            kPDItem = this.findByExactCode(((KPDItem)object).getParentCode());
        }
        List<KPDItem> list = this.b.stream().filter(arg_0 -> KPD2025Searcher.a((KPDItem)object, arg_0)).map(this::a).collect(Collectors.toList());
        return new KPDHierarchy((KPDItem)object, kPDItem, list);
    }

    public Map<String, Integer> getSectorStatistics() {
        return new HashMap<String, Integer>(this.g);
    }

    public List<String> getAllSectors() {
        JsonNode jsonNode2 = this.a.get("sectors");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (jsonNode2 != null && jsonNode2.isArray()) {
            jsonNode2.forEach(jsonNode -> arrayList.add(jsonNode.asText()));
        }
        return arrayList;
    }

    public String getJsonFilePath() {
        return this.d;
    }

    public static String getDefaultPath() {
        return "fiskalizacija20/json/KPD2025.json";
    }

    private KPDItem a(JsonNode jsonNode) {
        KPDItem kPDItem = new KPDItem();
        kPDItem.setCode(jsonNode.get("code").asText());
        kPDItem.setFullCode(jsonNode.get("fullCode").asText());
        kPDItem.setName(jsonNode.get("name").asText());
        kPDItem.setNameEn(jsonNode.has("nameEn") ? jsonNode.get("nameEn").asText() : null);
        kPDItem.setLevel(jsonNode.get("level").asInt());
        kPDItem.setSector(jsonNode.get("sector").asText());
        kPDItem.setSectorCode(jsonNode.get("sectorCode").asText());
        kPDItem.setParentCode(jsonNode.has("parentCode") ? jsonNode.get("parentCode").asText() : null);
        kPDItem.setActive(jsonNode.get("isActive").asBoolean());
        kPDItem.setLevel1Name(KPD2025Searcher.a(jsonNode, "level1Name"));
        kPDItem.setLevel2Name(KPD2025Searcher.a(jsonNode, "level2Name"));
        kPDItem.setLevel3Name(KPD2025Searcher.a(jsonNode, "level3Name"));
        kPDItem.setLevel4Name(KPD2025Searcher.a(jsonNode, "level4Name"));
        kPDItem.setLevel5Name(KPD2025Searcher.a(jsonNode, "level5Name"));
        kPDItem.setLevel6Name(KPD2025Searcher.a(jsonNode, "level6Name"));
        return kPDItem;
    }

    private static String a(JsonNode jsonNode, String string) {
        if (jsonNode.has(string)) {
            return jsonNode.get(string).asText();
        }
        return null;
    }

    public static void main(String[] object) {
        try {
            System.out.println("=== KPD2025 SEARCHER FLEKSIBILNOST TEST ===");
            System.out.println("==========================================");
            System.out.println("\n1. DEFAULT KONSTRUKTOR:");
            System.out.println("   Default putanja: " + KPD2025Searcher.getDefaultPath());
            object = new KPD2025Searcher();
            System.out.println("   Trenutna putanja: " + ((KPD2025Searcher)object).getJsonFilePath());
            System.out.println("\n2. OSNOVNI TESTOVI:");
            List<KPDItem> list = ((KPD2025Searcher)object).searchByName("kosilic");
            int n2 = 3;
            List<KPDItem> list2 = list;
            list.stream().limit(3L).forEach(kPDItem -> System.out.println("   \u2713 " + kPDItem.getFullCode() + " - " + kPDItem.getName()));
            if (list2.size() > 3) {
                System.out.println("   ... i jo\u0161 " + (list2.size() - 3) + " rezultata");
            }
            System.out.println("\n3. STATISTIKE:");
            object = ((KPD2025Searcher)object).getSectorStatistics();
            object.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(3L).forEach(entry -> System.out.println("   " + (String)entry.getKey() + ": " + entry.getValue() + " stavki"));
            System.out.println("\n=== NA\u010cINI KREIRANJA SEARCHER-A ===");
            System.out.println("1. new KPD2025Searcher() - koristi default putanju");
            System.out.println("2. new KPD2025Searcher(\"custom/path.json\") - custom putanja");
            System.out.println("3. KPD2025Searcher.fromFolder(\"data/kpd\") - iz foldera");
            System.out.println("4. KPD2025Searcher.fromAbsolutePath(\"/full/path.json\") - apsolutno");
            System.out.println("\nZa promjenu default putanje, mijenjajte DEFAULT_KPD_JSON_PATH konstantu!");
            return;
        }
        catch (Exception exception) {
            System.err.println("X Gre\u0161ka: " + exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }

    public static String formatResults(List<KPDItem> list, int n2) {
        if (list == null || list.isEmpty()) {
            return "   Nema prona\u0111enih rezultata\n";
        }
        StringBuilder stringBuilder = new StringBuilder();
        list.stream().limit(n2).forEach(kPDItem -> stringBuilder.append("   \u2713 ").append(kPDItem.getFullCode()).append(" - ").append(kPDItem.getName()).append("\n"));
        if (list.size() > n2) {
            stringBuilder.append("   ... i jo\u0161 ").append(list.size() - n2).append(" rezultata\n");
        }
        return stringBuilder.toString();
    }

    private static /* synthetic */ boolean a(KPDItem kPDItem, JsonNode object) {
        return ((String)(object = ((JsonNode)object).has("parentCode") ? ((JsonNode)object).get("parentCode").asText() : "")).equals(kPDItem.getFullCode()) || ((String)object).equals(kPDItem.getCode());
    }
}

