/*
 * Decompiled with CFR 0.152.
 */
package fiskalizacija20.kpd;

import fiskalizacija20.kpd.KPD2025Searcher;
import fiskalizacija20.kpd.KPDItem;
import java.util.Arrays;
import java.util.List;

public class KPDSearcherTester {
    public static void main(String[] object) {
        System.out.println("=== KPD2025 COMPREHENSIVE TESTER ===");
        System.out.println("=====================================");
        try {
            int n2;
            Object object2;
            Object object3 = object = new KPD2025Searcher();
            System.out.println("\n--- TEST 1: OSNOVNA FUNKCIONALNOST ---");
            System.out.println("1.1 Testiranje u\u010ditavanja podataka:");
            Object object4 = ((KPD2025Searcher)object3).getSectorStatistics();
            System.out.println("   Broj sektora: " + object4.size());
            System.out.println("   Ukupno stavki: " + object4.values().stream().mapToInt(Integer::intValue).sum());
            System.out.println("\n1.2 Testiranje exact pretra\u017eivanja:");
            Object object5 = ((KPD2025Searcher)object3).findByExactCode("A01.11.10");
            if (object5 != null) {
                System.out.println("   \u2713 " + ((KPDItem)object5).getFullCode() + " - " + ((KPDItem)object5).getName());
            } else {
                System.out.println("   X Exact search failed");
            }
            System.out.println("\n1.3 Testiranje sector pretra\u017eivanja:");
            List<KPDItem> list = ((KPD2025Searcher)object3).searchBySector("A");
            System.out.println("   Sektor A: " + list.size() + " stavki");
            System.out.println("\u2713 Test 1 completed");
            object3 = object;
            System.out.println("\n--- TEST 2: VARIJACIJE PRETRAGE ---");
            object4 = new String[]{"meso", "kosilica", "auto", "mlijeko", "kruh"};
            object5 = object4;
            int cfr_ignored_0 = ((String[])object4).length;
            for (int i2 = 0; i2 < 5; ++i2) {
                object2 = object5[i2];
                list = ((KPD2025Searcher)object3).searchByName((String)object2);
                System.out.println("2." + (Arrays.asList(object4).indexOf(object2) + 1) + " '" + (String)object2 + "': " + list.size() + " rezultata");
                if (list.isEmpty()) continue;
                System.out.println("   Prvi rezultat: " + list.get(0).getFullCode() + " - " + list.get(0).getName());
            }
            System.out.println("\u2713 Test 2 completed");
            object3 = object;
            System.out.println("\n--- TEST 3: GRANI\u010cNI SLU\u010cAJEVI ---");
            System.out.println("3.1 Testiranje praznih pretaga:");
            object4 = ((KPD2025Searcher)object3).searchByName("");
            System.out.println("   Prazan string: " + object4.size() + " rezultata");
            object5 = ((KPD2025Searcher)object3).searchByName(null);
            System.out.println("   Null string: " + object5.size() + " rezultata");
            System.out.println("\n3.2 Testiranje nepostoje\u0107eg koda:");
            list = ((KPD2025Searcher)object3).findByExactCode("Z99.99.99");
            System.out.println("   Nepostoje\u0107i kod: " + (list == null ? "null (OK)" : "prona\u0111en (ERROR)"));
            System.out.println("\n3.3 Testiranje case sensitivity:");
            List<KPDItem> list2 = ((KPD2025Searcher)object3).searchByName("meso");
            object2 = ((KPD2025Searcher)object3).searchByName("MESO");
            list = ((KPD2025Searcher)object3).searchByName("Meso");
            System.out.println("   'meso': " + list2.size() + " rezultata");
            System.out.println("   'MESO': " + object2.size() + " rezultata");
            System.out.println("   'Meso': " + list.size() + " rezultata");
            System.out.println("   Case insensitive: " + (list2.size() == object2.size() && object2.size() == list.size() ? "\u2713" : "X"));
            System.out.println("\u2713 Test 3 completed");
            object3 = object;
            System.out.println("\n--- TEST 4: PERFORMANCE ---");
            long l2 = System.currentTimeMillis();
            for (n2 = 0; n2 < 100; ++n2) {
                ((KPD2025Searcher)object3).searchByName("meso");
            }
            long l3 = System.currentTimeMillis();
            System.out.println("4.1 100x name search: " + (l3 - l2) + " ms");
            l2 = System.currentTimeMillis();
            for (n2 = 0; n2 < 1000; ++n2) {
                ((KPD2025Searcher)object3).findByExactCode("A01.11.10");
            }
            l3 = System.currentTimeMillis();
            System.out.println("4.2 1000x exact search: " + (l3 - l2) + " ms");
            l2 = System.currentTimeMillis();
            for (n2 = 0; n2 < 10; ++n2) {
                ((KPD2025Searcher)object3).getSectorStatistics();
            }
            l3 = System.currentTimeMillis();
            System.out.println("4.3 10x sector stats: " + (l3 - l2) + " ms");
            System.out.println("\u2713 Test 4 completed");
            System.out.println("\n=== TESTOVI ZAVR\u0160ENI USPJE\u0160NO ===");
            return;
        }
        catch (Exception exception) {
            System.err.println("GRE\u0160KA: " + exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }
}

