/*
 * Decompiled with CFR 0.152.
 */
package fiskalizacija20.testeri;

import UTIL.VFileUtils;
import UTIL.XMLtester;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import fiskalizacija20.XmlTemplateFiller;
import fiskalizacija20.testeri.HelperFunctions;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CreditNoteZahtjevTester {
    public static String TEMPLATE_PATH;
    public static String XSD_PATH;
    public static String SCHEMATRON_XSL_PATH;
    public static String TEMPLATE;
    public static boolean DEVOUT;
    public static String templateContent;
    public static String jsonContent;
    private static Map<String, Object> a;
    private static String b;
    private List<TestResult> c = new ArrayList<TestResult>();
    private int d = 0;
    private int e = 0;

    private static boolean a() {
        try {
            Object object = HelperFunctions.createCaseInsensitiveObjectMapper();
            object = ((ObjectMapper)object).readValue(jsonContent, Map.class);
            a = HelperFunctions.convertKeysToLowercase((Map<String, Object>)object);
            HelperFunctions.log("\u2705 Globalni JSON uspje\u0161no inicijaliziran i konvertiran u lovercase");
            return true;
        }
        catch (Exception exception) {
            HelperFunctions.log("\u2717 Gre\u0161ka pri inicijalizaciji globalnog JSON-a: " + exception.getMessage());
            return false;
        }
    }

    public void runAllTests(XmlTemplateFiller object, XmlTemplateFiller._config object2) {
        Map<String, Object> map;
        boolean bl2;
        Object object3;
        Object object4;
        Object object5;
        Map<String, Object> map2;
        HelperFunctions.log("\ud83d\udd27 Pokretanje JSON-specifi\u010dnih testova za CreditNote...");
        if (!CreditNoteZahtjevTester.a()) {
            HelperFunctions.log("\u274c Prekidam testove zbog gre\u0161ke u inicijalizaciji JSON-a");
            return;
        }
        try {
            b = ((XmlTemplateFiller)object).FillTemplate(((XmlTemplateFiller._config)object2).JSON_CONTENT, (XmlTemplateFiller._config)object2);
            HelperFunctions.log("\u2705 Globalni CreditNote XML uspje\u0161no generisan pomo\u0107u XmlTemplateFiller (" + b.length() + " znakova)");
        }
        catch (Exception exception) {
            HelperFunctions.log("\u274c Prekidam testove zbog gre\u0161ke u generisanju XML-a: " + exception.getMessage());
            return;
        }
        object = this;
        long l2 = System.nanoTime();
        try {
            boolean bl3 = b.contains("<?xml") || b.contains("<CreditNote");
            map2 = HelperFunctions.getCIM(a, "creditnote");
            if (map2 == null) {
                super.a("Template Processing", false, "CreditNote je null", "creditnote klju\u010d nije prona\u0111en", l2);
            } else {
                Map<String, Object> map3;
                object5 = HelperFunctions.getCIS(map2, "id");
                boolean bl4 = b.contains("<cbc:ID>") && !b.contains("{{uuid}}") || object5 != null && b.contains((CharSequence)object5);
                object4 = HelperFunctions.getCIM(map2, "accountingsupplierparty");
                object3 = null;
                if (object4 != null && (object2 = HelperFunctions.getCIM(object4, "party")) != null && (map3 = HelperFunctions.getCIM((Map<String, Object>)object2, "partyname")) != null) {
                    object3 = HelperFunctions.getCIS(map3, "name");
                }
                boolean bl5 = object3 != null && b.contains((CharSequence)object3);
                boolean bl6 = bl2 = b.contains("CreditNoteLine") || b.contains("TaxTotal");
                if (bl3 && bl4 && bl5 && bl2) {
                    super.a("Template Processing", true, "CreditNote template processing potpuno uspje\u0161an", "Svi podaci iz JSON-a pravilno procesovani", l2);
                } else {
                    super.a("Template Processing", false, "Problem u CreditNote template processing", "XML=" + bl3 + ", ID=" + bl4 + ", Supplier=" + bl5 + ", Elements=" + bl2, l2);
                }
            }
        }
        catch (Exception exception) {
            super.a("Template Processing", false, "Gre\u0161ka pri CreditNote template processing", exception.getMessage(), l2);
        }
        object = this;
        l2 = System.nanoTime();
        try {
            Map<String, Object> map4 = HelperFunctions.getCIM(a, "creditnote");
            if (map4 == null) {
                map4 = a;
            }
            if (!((HelperFunctions.ValidationResult)((Object)(map2 = fiskalizacija20.testeri.CreditNoteZahtjevTester$a.a(a)))).isValid()) {
                super.a("Business Validation", false, "Credit Note matemati\u010dka validacija neuspje\u0161na", ((HelperFunctions.ValidationResult)((Object)map2)).getErrors(), l2);
            } else {
                boolean bl7;
                HelperFunctions.getCIS(map4, "id");
                String string = HelperFunctions.getCIS(map4, "issuedate");
                object4 = HelperFunctions.getCIS(map4, "documentcurrencycode");
                object3 = HelperFunctions.getCIM(map4, "accountingsupplierparty");
                boolean bl8 = object3 != null;
                Map<String, Object> map5 = HelperFunctions.getCIM(map4, "accountingcustomerparty");
                boolean bl9 = map5 != null;
                bl8 = string != null && object4 != null && bl8 && bl9;
                Map<String, Object> map6 = HelperFunctions.getCIM(map4, "legalmonetarytotal");
                bl2 = map6 != null;
                List list = (List)map4.get("creditnoteline");
                if (list == null) {
                    list = (List)map4.get("creditnotelines");
                }
                boolean bl10 = list != null && !list.isEmpty();
                map2 = HelperFunctions.getCIM(map4, "invoicedocumentreference");
                if (map2 == null && (map4 = HelperFunctions.getCIM(map4, "billingreference")) != null) {
                    map2 = HelperFunctions.getCIM(map4, "invoicedocumentreference");
                }
                boolean bl11 = bl7 = map2 != null;
                if (bl8 && bl2 && bl10 && bl7) {
                    super.a("Business Validation", true, "Sva Credit Note poslovna pravila zadovoljena", "Osnovni podaci, monetary totali, lines i Invoice reference valjani", l2);
                } else {
                    super.a("Business Validation", false, "Problemi sa Credit Note poslovnim pravilima", "RequiredFields=" + bl8 + ", MonetaryTotal=" + bl2 + ", Lines=" + bl10 + ", InvoiceRef=" + bl7, l2);
                }
            }
        }
        catch (Exception exception) {
            super.a("Business Validation", false, "Gre\u0161ka pri Credit Note poslovnoj validaciji", exception.getMessage(), l2);
        }
        object = this;
        l2 = System.nanoTime();
        try {
            String string;
            Map map7;
            String string2;
            String string3;
            map = HelperFunctions.getCIM(a, "creditnote");
            if (map == null) {
                map = a;
            }
            map2 = new HelperFunctions.ValidationResult();
            object5 = new ArrayList();
            int n2 = 0;
            object4 = map.get("accountingsupplierparty");
            if (object4 instanceof List) {
                Map map8;
                String string4;
                object3 = (List)object4;
                if (!object3.isEmpty() && (string4 = CreditNoteZahtjevTester.a(map8 = (Map)object3.get(0))) != null) {
                    ++n2;
                    if (!HelperFunctions.isValidOIB(string4)) {
                        ((HelperFunctions.ValidationResult)((Object)map2)).addError("Credit Note Supplier: Nevaljan OIB '" + string4 + "'");
                        object5.add("Supplier OIB: '" + string4 + "'");
                    }
                }
            } else if (object4 instanceof Map && (string3 = CreditNoteZahtjevTester.a((Map<String, Object>)(object3 = (Map)object4))) != null) {
                ++n2;
                if (!HelperFunctions.isValidOIB(string3)) {
                    ((HelperFunctions.ValidationResult)((Object)map2)).addError("Credit Note Supplier: Nevaljan OIB '" + string3 + "'");
                    object5.add("Supplier OIB: '" + string3 + "'");
                }
            }
            object3 = map.get("accountingcustomerparty");
            if (object3 instanceof List) {
                List list = (List)object3;
                if (!list.isEmpty()) {
                    Object object6 = (Map)list.get(0);
                    if ((object6 = CreditNoteZahtjevTester.a((Map<String, Object>)object6)) != null) {
                        ++n2;
                        if (!HelperFunctions.isValidOIB((String)object6)) {
                            ((HelperFunctions.ValidationResult)((Object)map2)).addError("Credit Note Customer: Nevaljan OIB '" + (String)object6 + "'");
                            object5.add("Customer OIB: '" + (String)object6 + "'");
                        }
                    }
                }
            } else if (object3 instanceof Map && (string2 = CreditNoteZahtjevTester.a(map7 = (Map)object3)) != null) {
                ++n2;
                if (!HelperFunctions.isValidOIB(string2)) {
                    ((HelperFunctions.ValidationResult)((Object)map2)).addError("Credit Note Customer: Nevaljan OIB '" + string2 + "'");
                    object5.add("Customer OIB: '" + string2 + "'");
                }
            }
            Map<String, Object> map9 = HelperFunctions.getMapFromObject(map, "hrfisk20data");
            if (map9 != null && (string = HelperFunctions.getString(map9, "hroperatoroib")) != null) {
                ++n2;
                if (!HelperFunctions.isValidOIB(string)) {
                    ((HelperFunctions.ValidationResult)((Object)map2)).addError("Credit Note HR Operator: Nevaljan OIB '" + string + "'");
                    object5.add("Operator OIB: '" + string + "'");
                }
            }
            if (((HelperFunctions.ValidationResult)((Object)map2)).isValid() && n2 > 0) {
                super.a("OIB Validation", true, "Svi Credit Note OIB kodovi su valjani", "Supplier, Customer i HR Operator OIB-ovi pro\u0161li validaciju (" + n2 + " provjereno)", l2);
            } else if (n2 == 0) {
                super.a("OIB Validation", true, "Nema OIB-ova za validaciju", "Credit Note ne sadr\u017ei OIB kodove", l2);
            } else {
                super.a("OIB Validation", false, "Neva\u017ee\u0107i Credit Note OIB kodovi prona\u0111eni", ((HelperFunctions.ValidationResult)((Object)map2)).getErrors(), l2);
            }
        }
        catch (Exception exception) {
            super.a("OIB Validation", false, "Gre\u0161ka pri Credit Note OIB validaciji", exception.getMessage(), l2);
        }
        this.runXMLTests();
        object = this;
        l2 = System.nanoTime();
        try {
            try {
                Files.readAllBytes(Paths.get("nonexistent-creditnote-template.xml", new String[0]));
                super.a("Error Handling", false, "Nije uhva\u0107ena gre\u0161ka za nepostoje\u0107i CreditNote template", "Treba baciti IOException", l2);
            }
            catch (IOException iOException) {
                try {
                    map = HelperFunctions.createCaseInsensitiveObjectMapper();
                    ((ObjectMapper)((Object)map)).readValue("{invalid creditnote json", Map.class);
                    super.a("Error Handling", false, "Nije uhva\u0107ena gre\u0161ka za neispravni CreditNote JSON", "Treba baciti JsonProcessingException", l2);
                }
                catch (Exception exception) {
                    super.a("Error Handling", true, "CreditNote gre\u0161ke se pravilno hvataju", "IOException i JsonProcessingException uhva\u0107eni", l2);
                }
            }
        }
        catch (Exception exception) {
            super.a("Error Handling", false, "Neo\u010dekivana gre\u0161ka u CreditNote error handling testu", exception.getMessage(), l2);
        }
        object = this;
        l2 = System.nanoTime();
        try {
            boolean bl12;
            map = HelperFunctions.getCIM(a, "creditnote");
            HelperFunctions.getCIS(map, "id");
            boolean bl13 = b.contains("<cbc:ID>") && !b.contains("{{uuid}}");
            String string = HelperFunctions.getCIS(map, "issuedate");
            boolean bl14 = string != null && string.matches("\\d{4}-\\d{2}-\\d{2}");
            object3 = HelperFunctions.getCIS(map, "documentcurrencycode");
            boolean bl15 = object3 != null && ((String)object3).length() == 3;
            List list = (List)map.get("creditnoteline");
            boolean bl16 = bl12 = list != null && !list.isEmpty();
            if (bl13 && bl14 && bl15 && bl12) {
                super.a("Edge Cases", true, "CreditNote edge cases pravilno obra\u0111eni", "ID, datum, valuta i linije su ispravni", l2);
            } else {
                super.a("Edge Cases", false, "Problemi sa CreditNote edge cases", "ID=" + bl13 + ", DateFormat=" + bl14 + ", Currency=" + bl15 + ", Lines=" + bl12, l2);
            }
        }
        catch (Exception exception) {
            super.a("Edge Cases", false, "Gre\u0161ka pri testiranju CreditNote edge cases", exception.getMessage(), l2);
        }
        object = this;
        l2 = System.nanoTime();
        try {
            double d2;
            long l3 = System.nanoTime();
            for (int i2 = 0; i2 < 10; ++i2) {
                Handlebars handlebars = new Handlebars();
                Template template = handlebars.compileInline(templateContent);
                template.apply(a);
            }
            long l4 = System.nanoTime() - l3;
            double d3 = (double)l4 / 10.0 / 1000000.0;
            if (d2 < 80.0) {
                super.a("Performance", true, "CreditNote performanse odli\u010dne", "Prosje\u010dno vrijeme: " + String.format("%.2f", d3) + "ms po iteraciji", l2);
            } else {
                super.a("Performance", false, "CreditNote performanse prespore", "Prosje\u010dno vrijeme: " + String.format("%.2f", d3) + "ms po iteraciji", l2);
            }
        }
        catch (Exception exception) {
            super.a("Performance", false, "Gre\u0161ka pri testiranju CreditNote performansi", exception.getMessage(), l2);
        }
        this.b();
    }

    public void runXMLTests() {
        boolean bl2;
        Object object;
        Object object2;
        HelperFunctions.log("\ud83d\udd27 Pokretanje XML-specifi\u010dnih testova za CreditNote...");
        if (b == null || b.isEmpty()) {
            HelperFunctions.log("\u274c XML nije dostupan za XML testove");
            return;
        }
        CreditNoteZahtjevTester creditNoteZahtjevTester = this;
        long l2 = System.nanoTime();
        try {
            if (b == null || b.isEmpty()) {
                creditNoteZahtjevTester.a("XSD Validation", false, "Globalni XML rezultat nije dostupan", "globalXmlResult je null ili prazan", l2);
            } else {
                object2 = b;
                object = new XMLtester();
                new XMLtester().DEVOUT = false;
                if (HelperFunctions.isXsdFileNotFoundError((String)(object = ((XMLtester)object).testXmlAgainstXsdFile((String)object2, XSD_PATH)))) {
                    creditNoteZahtjevTester.a("XSD Validation", true, "\nPresko\u010dena jer XSD file " + XSD_PATH + " nije prona\u0111en!", "XSD file nedostaje: " + (String)object, l2);
                } else {
                    boolean bl3 = HelperFunctions.isXsdValidationSuccessful((String)object);
                    bl2 = HelperFunctions.hasXsdValidationErrors((String)object);
                    if (bl3 && !bl2) {
                        creditNoteZahtjevTester.a("XSD Validation", true, "CreditNote XML uspje\u0161no validiran protiv UBL XSD sheme", "XML je u skladu sa " + XSD_PATH, l2);
                    } else {
                        creditNoteZahtjevTester.a("XSD Validation", false, "CreditNote XSD validacija neuspje\u0161na", "Rezultat: " + (String)(object != null ? object : "null"), l2);
                    }
                }
            }
        }
        catch (IOException iOException) {
            creditNoteZahtjevTester.a("XSD Validation", false, "IO gre\u0161ka pri CreditNote XSD validaciji", iOException.getMessage(), l2);
        }
        catch (Exception exception) {
            creditNoteZahtjevTester.a("XSD Validation", false, "Gre\u0161ka pri CreditNote XSD validaciji", exception.getMessage(), l2);
        }
        creditNoteZahtjevTester = this;
        l2 = System.nanoTime();
        try {
            if (b == null || b.isEmpty()) {
                creditNoteZahtjevTester.a("Schematron Validation", false, "Globalni XML rezultat nije dostupan", "globalXmlResult je null ili prazan", l2);
            } else {
                object2 = b;
                object = new File(SCHEMATRON_XSL_PATH);
                if (!((File)object).exists()) {
                    creditNoteZahtjevTester.a("Schematron Validation", true, "\nPresko\u010dena jer CreditNote Schematron XSL " + SCHEMATRON_XSL_PATH + " nije prona\u0111en!", "Schematron file nedostaje: " + SCHEMATRON_XSL_PATH, l2);
                } else {
                    object = new XMLtester();
                    object2 = ((XMLtester)object).validateAgainstSchematron((String)object2, SCHEMATRON_XSL_PATH, false);
                    bl2 = ((XMLtester.SchematronValidationResult)object2).isValid();
                    int n2 = ((XMLtester.SchematronValidationResult)object2).getErrors();
                    int n3 = ((XMLtester.SchematronValidationResult)object2).getWarnings();
                    if (bl2 && n2 == 0) {
                        String string = String.format("Pro\u0161lo svih %d CreditNote pravila", ((XMLtester.SchematronValidationResult)object2).getSuccessfulAssertions());
                        if (((XMLtester.SchematronValidationResult)object2).getWarnings() > 0) {
                            string = string + String.format(" (%d upozorenja)", ((XMLtester.SchematronValidationResult)object2).getWarnings());
                        }
                        creditNoteZahtjevTester.a("Schematron Validation", true, "CreditNote XML Croatian Schematron poslovna pravila zadovoljena\n -" + string, "", l2);
                    } else if (n2 > 0) {
                        String string = "Prona\u0111eno " + n2 + " gre\u0161aka";
                        if (n3 > 0) {
                            string = string + " i " + n3 + " upozorenja";
                        }
                        string = string + ":\n" + ((XMLtester.SchematronValidationResult)object2).getErrorMessages();
                        creditNoteZahtjevTester.a("Schematron Validation", false, "CreditNote Schematron validacija neuspje\u0161na - " + n2, string, l2);
                    } else {
                        creditNoteZahtjevTester.a("Schematron Validation", true, "CreditNote Schematron validacija uspje\u0161na sa upozorenjima", n3 + " upozorenja prona\u0111eno", l2);
                    }
                }
            }
        }
        catch (Exception exception) {
            creditNoteZahtjevTester.a("Schematron Validation", false, "Gre\u0161ka pri CreditNote Schematron validaciji", exception.getMessage(), l2);
        }
        HelperFunctions.log("\u2705 XML testovi za CreditNote zavr\u0161eni!");
    }

    private static String a(Map<String, Object> object) {
        if (object == null) {
            return null;
        }
        try {
            object = HelperFunctions.getMapFromObject(object, "party");
            if (object == null) {
                return null;
            }
            Map map = HelperFunctions.getMapFromObject(object, "partyidentification");
            if (map != null) {
                object = map.get("id");
                if (object instanceof Map && "HR:OIB".equals((object = (Map)object).get("schemeid"))) {
                    return (String)object.get("text");
                }
                return HelperFunctions.getString(map, "id");
            }
            if ((object = object.get("partyidentification")) instanceof List) {
                object = (List)object;
                object = object.iterator();
                while (object.hasNext()) {
                    map = (Map)object.next();
                    if ((map = (Map)map.get("id")) == null || !"HR:OIB".equals(map.get("schemeid"))) continue;
                    return (String)map.get("text");
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void a(String object, boolean bl2, String string, String string2, long l2) {
        long l3 = System.nanoTime() - l2;
        object = new TestResult(this, (String)object, bl2, string, string2, l3);
        this.c.add((TestResult)object);
        if (bl2) {
            ++this.d;
        } else {
            ++this.e;
        }
        HelperFunctions.log(((TestResult)object).toString());
        if (!bl2 && string2 != null && !string2.isEmpty()) {
            HelperFunctions.log("    Detalji: " + string2);
        }
    }

    private void b() {
        HelperFunctions.log("\n" + HelperFunctions.hr80());
        HelperFunctions.log("\ud83d\udcca CREDITNOTE REZULTATI TESTOVA");
        HelperFunctions.log(HelperFunctions.hr80());
        HelperFunctions.log("Ukupno testova: " + this.c.size());
        HelperFunctions.log("\u2705 Pro\u0161lo: " + this.d);
        HelperFunctions.log("\u274c Palo: " + this.e);
        double d2 = (double)this.d / (double)this.c.size() * 100.0;
        HelperFunctions.log("Uspje\u0161nost: " + String.format("%.1f", d2) + "%");
        if (this.e > 0) {
            HelperFunctions.log("\n\u274c NEUSPJE\u0160NI CREDITNOTE TESTOVI:");
            for (TestResult testResult : this.c) {
                if (testResult.isPassed()) continue;
                HelperFunctions.log("  - " + testResult.getTestName() + ": " + testResult.getMessage());
            }
        }
        HelperFunctions.log("\n" + HelperFunctions.hr80());
        if (!HelperFunctions.getCallingMethodInfo().contains("utilXMLMethod")) {
            if (d2 == 100.0) {
                HelperFunctions.log("\ud83c\udf89 SVI CREDITNOTE TESTOVI USPJE\u0160NI! Template i JSON rade perfektno.");
            } else if (d2 >= 90.0) {
                HelperFunctions.log("\u26a0\ufe0f VE\u0106INA CREDITNOTE TESTOVA USPJE\u0160NA. Postoje manji problemi.");
            } else {
                HelperFunctions.log("\u274c VELIKI CREDITNOTE PROBLEMI. Potrebno rje\u0161avanje gre\u0161aka.");
            }
            HelperFunctions.log(HelperFunctions.hr80());
        }
    }

    public static boolean validateJsonData(Map<String, Object> map) {
        try {
            map = HelperFunctions.getCIM(map, "creditnote");
            if (map == null) {
                HelperFunctions.log("Nedostaje CreditNote root element");
                return false;
            }
            HelperFunctions.containsKeyCI(map, "id");
            boolean bl2 = HelperFunctions.containsKeyCI(map, "issuedate");
            boolean bl3 = HelperFunctions.containsKeyCI(map, "accountingsupplierparty");
            boolean bl4 = HelperFunctions.containsKeyCI(map, "accountingcustomerparty");
            if (!(bl2 && bl3 && bl4)) {
                HelperFunctions.log("Nedostaju obavezni CreditNote elementi");
                return false;
            }
            HelperFunctions.log("Osnovna CreditNote struktura validna");
            return true;
        }
        catch (Exception exception) {
            HelperFunctions.log("Gre\u0161ka pri validaciji CreditNote podataka: " + exception.getMessage());
            return false;
        }
    }

    public static boolean validateXml(String string) {
        try {
            boolean bl2 = string.contains("<?xml") || string.contains("<CreditNote");
            boolean bl3 = string.contains("CreditNote");
            boolean bl4 = string.contains("AccountingSupplierParty");
            boolean bl5 = string.contains("AccountingCustomerParty");
            if (!(bl2 && bl3 && bl4 && bl5)) {
                HelperFunctions.log("CreditNote XML struktura neispravna");
                return false;
            }
            HelperFunctions.log("CreditNote XML struktura validna");
            return true;
        }
        catch (Exception exception) {
            HelperFunctions.log("Gre\u0161ka pri CreditNote XML validaciji: " + exception.getMessage());
            return false;
        }
    }

    public static void main(String[] object) {
        XmlTemplateFiller xmlTemplateFiller = new XmlTemplateFiller();
        XmlTemplateFiller._config _config2 = new XmlTemplateFiller._config(xmlTemplateFiller);
        new XmlTemplateFiller._config(xmlTemplateFiller).ROOTELEMENT = XmlTemplateFiller.RootElementType.fromString("CreditNoteZahtjev");
        HelperFunctions.clearPrintout();
        object = ((String[])object).length > 0 ? VFileUtils.readFile(object[0]) : VFileUtils.readFile("ULAZNIJSON\\CreditNote_simple.json");
        _config2.JSON_CONTENT = object;
        System.out.println(xmlTemplateFiller.RedirectorZadataka((String)object, "TESTIRAJLOGIKU", xmlTemplateFiller, _config2));
    }

    public static void utilXMLMethod(String object, XmlTemplateFiller._config _config2) {
        DEVOUT = false;
        b = object;
        XSD_PATH = _config2.ROOTELEMENT.getXsdPath();
        SCHEMATRON_XSL_PATH = _config2.ROOTELEMENT.getXslPath();
        object = new CreditNoteZahtjevTester();
        ((CreditNoteZahtjevTester)object).runXMLTests();
        super.b();
    }

    public static void utilMethod(XmlTemplateFiller xmlTemplateFiller, XmlTemplateFiller._config _config2) {
        DEVOUT = true;
        XSD_PATH = _config2.ROOTELEMENT.getXsdPath();
        TEMPLATE_PATH = _config2.TEMPLATEPATH;
        SCHEMATRON_XSL_PATH = _config2.ROOTELEMENT.getXslPath();
        CreditNoteZahtjevTester creditNoteZahtjevTester = new CreditNoteZahtjevTester();
        templateContent = _config2.TEMPLATECONTENT;
        jsonContent = _config2.JSON_CONTENT;
        creditNoteZahtjevTester.runAllTests(xmlTemplateFiller, _config2);
    }

    static /* synthetic */ void a(Map iterator, HelperFunctions.ValidationResult validationResult) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            Object object2 = iterator.get("accountingsupplierparty");
            Object v2 = iterator.get("accountingcustomerparty");
            Map map = null;
            Map map2 = null;
            if (object2 instanceof List) {
                List list = (List)object2;
                if (!list.isEmpty()) {
                    map = (Map)list.get(0);
                }
            } else if (object2 instanceof Map) {
                map = (Map)object2;
            }
            if (v2 instanceof List) {
                List list = (List)v2;
                if (!list.isEmpty()) {
                    map2 = (Map)list.get(0);
                }
            } else if (v2 instanceof Map) {
                map2 = (Map)v2;
            }
            if (map == null) {
                arrayList.add("Nedostaje AccountingSupplierParty u Credit Note");
            } else {
                String string = CreditNoteZahtjevTester.a(map);
                if (string != null && !HelperFunctions.isValidOIB(string)) {
                    arrayList.add("Nevaljan Supplier OIB: " + string);
                }
            }
            if (map2 == null) {
                arrayList.add("Nedostaje AccountingCustomerParty u Credit Note");
            } else {
                String string = CreditNoteZahtjevTester.a(map2);
                if (string != null && !HelperFunctions.isValidOIB(string)) {
                    arrayList.add("Nevaljan Customer OIB: " + string);
                }
            }
            String string = HelperFunctions.getString(iterator, "documentcurrencycode");
            if (string != null && string.length() != 3) {
                arrayList.add("Nevaljan Currency kod: " + string + " (treba biti 3 znaka)");
            }
            if (map != null && map2 != null) {
                iterator = CreditNoteZahtjevTester.a(map);
                String string2 = CreditNoteZahtjevTester.a(map2);
                if (iterator != null && string2 != null && ((String)((Object)iterator)).equals(string2)) {
                    arrayList.add("Supplier i Customer imaju isti OIB: " + iterator);
                }
            }
            if (!arrayList.isEmpty()) {
                for (String string3 : arrayList) {
                    validationResult.addError(string3);
                }
                HelperFunctions.log("\u274c Problemi s party informacijama: " + String.join((CharSequence)", ", arrayList));
                return;
            }
            HelperFunctions.log("\u2705 Credit Note party informacije valjane");
        }
        catch (Exception exception) {
            validationResult.addError("Gre\u0161ka pri validaciji Credit Note party informacija: " + exception.getMessage());
        }
    }

    static {
        XSD_PATH = "fiskalizacija20\\eracunxsd\\maindoc\\UBL-CreditNote-2.1.xsd";
        TEMPLATE = null;
        DEVOUT = false;
        templateContent = null;
        jsonContent = null;
        a = null;
        b = null;
    }

    static final class a {
        private static final RoundingMode a = HelperFunctions.ROUNDING_MODE;
        private static Map<String, Map<String, Object>> b = null;

        private static Map<String, Map<String, Object>> a() {
            if (b != null) {
                return b;
            }
            try {
                b = new HashMap<String, Map<String, Object>>();
                Iterator iterator = HelperFunctions.createCaseInsensitiveObjectMapper();
                File object2 = new File("fiskalizacija20\\json\\CreditNoteTypeCode.json");
                if (!object2.exists()) {
                    HelperFunctions.log("\u26a0\ufe0f Credit Note Type Codes JSON file ne postoji: fiskalizacija20\\json\\CreditNoteTypeCode.json");
                    return b;
                }
                iterator = ((ObjectMapper)((Object)iterator)).readValue(object2, Map.class);
                if ((iterator = (Map)iterator.get("creditNoteTypeCodes")) != null) {
                    for (Map.Entry entry : iterator.entrySet()) {
                        String string = (String)entry.getKey();
                        Map map = (Map)entry.getValue();
                        b.put(string, map);
                    }
                }
            }
            catch (Exception exception) {
                HelperFunctions.log("\u274c Gre\u0161ka pri u\u010ditavanju Credit Note Type kodova: " + exception.getMessage());
                b = new HashMap<String, Map<String, Object>>();
            }
            return b;
        }

        private static Map<String, Map<String, Object>> b() {
            HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
            try {
                Iterator iterator = HelperFunctions.createCaseInsensitiveObjectMapper();
                File object2 = new File("fiskalizacija20\\json\\JediniceMjera_EN16931_HR.json");
                if (!object2.exists()) {
                    HelperFunctions.log("\u26a0\ufe0f Unit Codes JSON file ne postoji: " + object2.getPath());
                    return hashMap;
                }
                iterator = ((ObjectMapper)((Object)iterator)).readValue(object2, Map.class);
                if ((iterator = (Map)iterator.get("JediniceMjera_EN16931_HR")) != null && (iterator = (Map)iterator.get("units")) != null) {
                    for (Map.Entry entry : iterator.entrySet()) {
                        String string = (String)entry.getKey();
                        Object v2 = entry.getValue();
                        if (string.startsWith("_comment") || !(v2 instanceof Map)) continue;
                        hashMap.put(string, (Map)v2);
                    }
                }
            }
            catch (Exception exception) {
                HelperFunctions.log("\u274c Gre\u0161ka pri u\u010ditavanju unit kodova: " + exception.getMessage());
            }
            return hashMap;
        }

        private static Map<String, Map<String, Object>> c() {
            HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
            try {
                Iterator iterator = HelperFunctions.createCaseInsensitiveObjectMapper();
                Object object = new File("fiskalizacija20\\json\\KPD2025.json");
                if (!((File)object).exists()) {
                    HelperFunctions.log("\u26a0\ufe0f KPD Codes JSON file ne postoji: " + ((File)object).getPath());
                    return hashMap;
                }
                if ((iterator = ((ObjectMapper)((Object)iterator)).readValue((File)object, Map.class)).containsKey("klasifikacije") && (iterator = iterator.get("klasifikacije")) instanceof List) {
                    iterator = (List)((Object)iterator);
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        object = (Map)iterator.next();
                        String string = HelperFunctions.getString((Map<String, Object>)object, "code");
                        if (string == null || string.trim().isEmpty()) continue;
                        hashMap.put(string, (Map<String, Object>)object);
                    }
                }
            }
            catch (Exception exception) {
                HelperFunctions.log("\u274c Gre\u0161ka pri u\u010ditavanju KPD kodova: " + exception.getMessage());
            }
            return hashMap;
        }

        public static HelperFunctions.ValidationResult a(Map<String, Object> map) {
            HelperFunctions.ValidationResult validationResult = new HelperFunctions.ValidationResult();
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Map<String, Object> map2;
                Object object7;
                Object object8;
                block94: {
                    object8 = map;
                    object7 = HelperFunctions.getMapFromObject(object8, "creditnote");
                    if (object7 == null) {
                        object7 = object8;
                    }
                    if ((map = object7) == null) {
                        validationResult.addError("Nedostaje CreditNote objekt u JSON-u");
                        return validationResult;
                    }
                    object7 = validationResult;
                    object8 = map;
                    map2 = new ArrayList();
                    try {
                        object6 = null;
                        object5 = object8.get("invoicedocumentreference");
                        if (object5 instanceof List) {
                            object4 = (List)object5;
                            if (object4 != null && !object4.isEmpty()) {
                                object6 = (Map)object4.get(0);
                            }
                        } else if (object5 instanceof Map) {
                            object6 = (Map)object5;
                        }
                        if (object6 == null && (object4 = HelperFunctions.getMapFromObject(object8, "billingreference")) != null) {
                            object3 = object4.get("invoicedocumentreference");
                            if (object3 instanceof Map) {
                                object6 = (Map)object3;
                            } else if (object3 instanceof List && (object2 = (List)object3) != null && !object2.isEmpty()) {
                                object6 = (Map)object2.get(0);
                            }
                        }
                        if (object6 == null) {
                            ((HelperFunctions.ValidationResult)object7).addError("Credit Note MORA imati InvoiceDocumentReference na originalnu fakturu");
                            break block94;
                        }
                        object4 = HelperFunctions.getString((Map<String, Object>)object6, "id");
                        if (object4 == null || ((String)object4).trim().isEmpty()) {
                            map2.add("Nedostaje ID originalne fakture u InvoiceDocumentReference");
                        }
                        if ((object3 = HelperFunctions.getString(object6, "issuedate")) != null) {
                            if (!HelperFunctions.isValidDateFormat(object3)) {
                                map2.add("Neispravni format datuma originalne fakture: " + object3);
                            }
                            if ((object2 = HelperFunctions.getString(object8, "issuedate")) != null && HelperFunctions.isValidDateFormat((String)object2)) {
                                try {
                                    object = LocalDate.parse(object3);
                                    LocalDate localDate = LocalDate.parse((CharSequence)object2);
                                    if (localDate.isBefore((ChronoLocalDate)object)) {
                                        map2.add("Credit Note datum (" + (String)object2 + ") ne mo\u017ee biti prije datuma originalne fakture (" + object3 + ")");
                                    }
                                }
                                catch (Exception exception) {
                                    map2.add("Gre\u0161ka pri usporedbi datuma: " + exception.getMessage());
                                }
                            }
                        }
                        if (map2.isEmpty()) {
                            HelperFunctions.log("\u2705 Invoice Document Reference valjan (ID: " + (String)object4 + ")");
                        } else {
                            object2 = map2.iterator();
                            while (object2.hasNext()) {
                                object = (String)object2.next();
                                ((HelperFunctions.ValidationResult)object7).addError((String)object);
                            }
                            HelperFunctions.log("\u274c Prona\u0111ene gre\u0161ke u Invoice Document Reference: " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)((Object)map2)));
                        }
                    }
                    catch (Exception exception) {
                        ((HelperFunctions.ValidationResult)object7).addError("Gre\u0161ka pri validaciji Invoice Document Reference: " + exception.getMessage());
                    }
                }
                object7 = validationResult;
                object8 = map;
                try {
                    map2 = HelperFunctions.getString(object8, "creditnotetypecode");
                    if (map2 == null) {
                        map2 = HelperFunctions.getString(object8, "creditnotetype");
                    }
                    if (map2 != null) {
                        object6 = fiskalizacija20.testeri.CreditNoteZahtjevTester$a.a();
                        if (object6.isEmpty()) {
                            ((HelperFunctions.ValidationResult)object7).addError("Nije mogu\u0107e u\u010ditati listu validnih Credit Note Type kodova - preska\u010dem validaciju");
                        } else {
                            object5 = (Map)object6.get(map2);
                            if (object5 != null) {
                                object4 = (String)object5.get("name");
                                HelperFunctions.log("\u2705 Credit Note Type Code valjan: " + (String)((Object)map2) + " (" + (String)object4 + ")");
                            } else {
                                object4 = String.join((CharSequence)", ", object6.keySet());
                                ((HelperFunctions.ValidationResult)object7).addError("Nevaljan Credit Note Type Code: '" + (String)((Object)map2) + "' - dopu\u0161teni su: " + (String)object4);
                                HelperFunctions.log("\u274c Nevaljan Credit Note Type Code: " + (String)((Object)map2));
                            }
                        }
                    } else {
                        HelperFunctions.log("\u26a0\ufe0f Credit Note Type Code nije specificiran (opcionalno)");
                    }
                }
                catch (Exception exception) {
                    ((HelperFunctions.ValidationResult)object7).addError("Gre\u0161ka pri validaciji Credit Note Type Code: " + exception.getMessage());
                }
                object7 = validationResult;
                object8 = map;
                try {
                    map2 = HelperFunctions.getString(object8, "issuedate");
                    object6 = HelperFunctions.getString(object8, "issuetime");
                    object5 = new ArrayList<String>();
                    if (map2 != null) {
                        if (!HelperFunctions.isValidDateFormat((String)((Object)map2))) {
                            object5.add("Credit Note IssueDate format: " + (String)((Object)map2));
                        } else if (!HelperFunctions.isLogicalDate((String)((Object)map2))) {
                            object5.add("Credit Note IssueDate logi\u010dka gre\u0161ka: " + (String)((Object)map2));
                        } else if (HelperFunctions.isFutureDate((String)((Object)map2))) {
                            object5.add("Credit Note IssueDate u budu\u0107nosti: " + (String)((Object)map2));
                        }
                    }
                    if (object6 != null && !HelperFunctions.isValidTimeFormat((String)object6)) {
                        object5.add("Credit Note IssueTime format: " + (String)object6);
                    }
                    if (map2 != null && HelperFunctions.isValidDateFormat((String)((Object)map2)) && (object4 = HelperFunctions.getMapFromObject(object8, "invoicedocumentreference")) != null && (object3 = HelperFunctions.getString(object4, "issuedate")) != null && HelperFunctions.isValidDateFormat(object3)) {
                        try {
                            object2 = LocalDate.parse(object3);
                            object = LocalDate.parse((CharSequence)((Object)map2));
                            long l2 = ChronoUnit.DAYS.between((Temporal)object2, (Temporal)object);
                            if (l2 > 30L) {
                                ((HelperFunctions.ValidationResult)object7).addError("Credit Note izdano " + l2 + " dana nakon originalne fakture (preporu\u010duje se maksimalno 30 dana)");
                                object5.add("Credit Note prekasno izdano (" + l2 + " dana)");
                            }
                        }
                        catch (Exception exception) {
                            object5.add("Gre\u0161ka pri provjeri roka izdavanja: " + exception.getMessage());
                        }
                    }
                    if (object5.isEmpty()) {
                        HelperFunctions.log("\u2705 Credit Note datumi su valjani");
                    } else {
                        HelperFunctions.log("\u274c Problemi s datumima: " + String.join((CharSequence)", ", object5));
                    }
                }
                catch (Exception exception) {
                    ((HelperFunctions.ValidationResult)object7).addError("Gre\u0161ka pri validaciji Credit Note datuma: " + exception.getMessage());
                }
                CreditNoteZahtjevTester.a(map, validationResult);
                List<Map<String, Object>> list = fiskalizacija20.testeri.CreditNoteZahtjevTester$a.b(map);
                if (list != null && !list.isEmpty()) {
                    Object object9;
                    try {
                        object7 = validationResult;
                        object8 = list;
                        if (object8.isEmpty()) {
                            ((HelperFunctions.ValidationResult)object7).addError("Credit Note mora imati najmanje jednu liniju");
                        }
                        HelperFunctions.log("\u2705 Credit Note lines validacija pro\u0161la");
                    }
                    catch (Exception exception) {
                        validationResult.addError("Gre\u0161ka u validateCreditNoteLines: " + exception.getMessage());
                        HelperFunctions.log("\u274c Gre\u0161ka u validateCreditNoteLines: " + exception.getMessage());
                    }
                    try {
                        object7 = validationResult;
                        object8 = list;
                        try {
                            map2 = new ArrayList<String>();
                            int n2 = 0;
                            int n3 = 0;
                            int n4 = 0;
                            object3 = object8.iterator();
                            while (object3.hasNext()) {
                                object2 = (Map)object3.next();
                                object = HelperFunctions.getString((Map<String, Object>)object2, "id");
                                BigDecimal bigDecimal = HelperFunctions.getDecimal(object2, "creditedquantity");
                                if (bigDecimal == null) {
                                    bigDecimal = HelperFunctions.getDecimal(object2, "quantity");
                                }
                                if ((object9 = HelperFunctions.getDecimal(object2, "lineextensionamount")) == null) continue;
                                if (((BigDecimal)object9).compareTo(BigDecimal.ZERO) > 0) {
                                    ++n2;
                                } else if (((BigDecimal)object9).compareTo(BigDecimal.ZERO) < 0) {
                                    ++n3;
                                } else {
                                    ++n4;
                                }
                                if (bigDecimal == null || (object2 = HelperFunctions.getMapFromObject(object2, "price")) == null || (object8 = HelperFunctions.getDecimal((Map<String, Object>)object2, "priceamount")) == null || ((BigDecimal)(object2 = bigDecimal.multiply((BigDecimal)object8).setScale(2, a))).compareTo((BigDecimal)object9) == 0) continue;
                                map2.add("Artikal " + (String)object + ": CreditedQuantity(" + bigDecimal + ") \u00d7 Price(" + object8 + ") = " + object2 + ", ali LineAmount je " + object9);
                            }
                            boolean bl2 = true;
                            if (n2 == 0 && n3 == 0 && n4 > 0) {
                                map2.add("Credit Note ima samo nulte iznose - to nije valjano");
                                bl2 = false;
                            }
                            if (bl2 && map2.isEmpty()) {
                                HelperFunctions.log("\u2705 Credit Note iznosi valjani (+ " + n2 + ", - " + n3 + ", 0: " + n4 + ")");
                            } else {
                                object2 = map2.iterator();
                                while (object2.hasNext()) {
                                    object = (String)object2.next();
                                    ((HelperFunctions.ValidationResult)object7).addError((String)object);
                                }
                                HelperFunctions.log("\u274c Problemi s Credit Note iznosima: " + String.join((CharSequence)", ", map2));
                            }
                        }
                        catch (Exception exception) {
                            ((HelperFunctions.ValidationResult)object7).addError("Gre\u0161ka pri validaciji Credit Note iznosa: " + exception.getMessage());
                        }
                        HelperFunctions.log("\u2705 Credit Note negative amounts validacija pro\u0161la");
                    }
                    catch (Exception exception) {
                        validationResult.addError("Gre\u0161ka u validateNegativeAmounts: " + exception.getMessage());
                        HelperFunctions.log("\u274c Gre\u0161ka u validateNegativeAmounts: " + exception.getMessage());
                    }
                    try {
                        object7 = validationResult;
                        object8 = list;
                        map2 = fiskalizacija20.testeri.CreditNoteZahtjevTester$a.b();
                        if (map2.isEmpty()) {
                            ((HelperFunctions.ValidationResult)object7).addError("Nije mogu\u0107e u\u010ditati listu validnih jedinica mjere - preska\u010dem validaciju");
                        } else {
                            Iterator<Map<String, Object>> iterator = object8.iterator();
                            while (iterator.hasNext()) {
                                Map<String, Object> map3 = iterator.next();
                                String string = HelperFunctions.getString(map3, "id");
                                Map<String, Object> map4 = HelperFunctions.getMapFromObject(map3, "price");
                                if (map4 == null || (object2 = HelperFunctions.getString(map4, "unitcode")) == null || map2.containsKey(object2)) continue;
                                ((HelperFunctions.ValidationResult)object7).addError("Credit Note linija " + string + ": Nevaljan unitCode '" + (String)object2 + "'");
                            }
                        }
                        HelperFunctions.log("\u2705 Credit Note unit codes validacija pro\u0161la");
                    }
                    catch (Exception exception) {
                        validationResult.addError("Gre\u0161ka u validateUnitCodes: " + exception.getMessage());
                        HelperFunctions.log("\u274c Gre\u0161ka u validateUnitCodes: " + exception.getMessage());
                    }
                    try {
                        object7 = validationResult;
                        object8 = list;
                        map2 = fiskalizacija20.testeri.CreditNoteZahtjevTester$a.c();
                        if (map2.isEmpty()) {
                            ((HelperFunctions.ValidationResult)object7).addError("Nije mogu\u0107e u\u010ditati listu validnih KPD kodova - preska\u010dem validaciju");
                        } else {
                            for (int i2 = 0; i2 < object8.size(); ++i2) {
                                try {
                                    Object object10;
                                    Map<String, Object> map5 = object8.get(i2);
                                    String string = HelperFunctions.getString(map5, "id");
                                    Map<String, Object> map6 = HelperFunctions.getMapFromObject(map5, "item");
                                    if (map6 == null) continue;
                                    object2 = map6.get("commodityclassification");
                                    if (object2 instanceof List) {
                                        object = (List)object2;
                                        object10 = object.iterator();
                                        while (object10.hasNext()) {
                                            object9 = (Map)object10.next();
                                            object2 = HelperFunctions.getString((Map<String, Object>)object9, "commoditycode");
                                            if (object2 == null || map2.containsKey(object2)) continue;
                                            ((HelperFunctions.ValidationResult)object7).addError("Credit Note linija " + string + ": Nevaljan KPD kod '" + (String)object2 + "'");
                                        }
                                        continue;
                                    }
                                    if (!(object2 instanceof Map) || (object10 = HelperFunctions.getString((Map<String, Object>)(object = (Map)object2), "commoditycode")) == null || map2.containsKey(object10)) continue;
                                    ((HelperFunctions.ValidationResult)object7).addError("Credit Note linija " + string + ": Nevaljan KPD kod '" + (String)object10 + "'");
                                    continue;
                                }
                                catch (Exception exception) {
                                    HelperFunctions.log("\u274c Gre\u0161ka u validateCommodityCodes linija " + i2 + ": " + exception.getMessage());
                                    throw exception;
                                }
                            }
                            HelperFunctions.log("\u2705 Commodity codes validacija zavr\u0161ena");
                        }
                        HelperFunctions.log("\u2705 Credit Note commodity codes validacija pro\u0161la");
                    }
                    catch (Exception exception) {
                        validationResult.addError("Gre\u0161ka u validateCommodityCodes: " + exception.getMessage());
                        HelperFunctions.log("\u274c Gre\u0161ka u validateCommodityCodes: " + exception.getMessage());
                    }
                }
                try {
                    object7 = validationResult;
                    object8 = map;
                    map2 = HelperFunctions.getString(object8, "issuedate");
                    String string = HelperFunctions.getString((Map<String, Object>)object8, "issuetime");
                    String string2 = HelperFunctions.getString((Map<String, Object>)object8, "duedate");
                    if (map2 != null) {
                        if (!HelperFunctions.isValidDateFormat((String)((Object)map2))) {
                            ((HelperFunctions.ValidationResult)object7).addError("Credit Note IssueDate neispravni format: " + map2);
                        } else if (!HelperFunctions.isLogicalDate(map2)) {
                            ((HelperFunctions.ValidationResult)object7).addError("Credit Note IssueDate logi\u010dka gre\u0161ka: " + map2);
                        } else if (HelperFunctions.isFutureDate(map2)) {
                            ((HelperFunctions.ValidationResult)object7).addError("Credit Note IssueDate u budu\u0107nosti: " + (String)((Object)map2));
                        }
                    }
                    if (string != null && !HelperFunctions.isValidTimeFormat(string)) {
                        ((HelperFunctions.ValidationResult)object7).addError("Credit Note IssueTime neispravni format: " + string);
                    }
                    if (string2 != null && !HelperFunctions.isValidDateFormat(string2)) {
                        ((HelperFunctions.ValidationResult)object7).addError("Credit Note DueDate neispravni format: " + string2);
                    }
                    HelperFunctions.log("\u2705 Credit Note dates validacija pro\u0161la");
                }
                catch (Exception exception) {
                    validationResult.addError("Gre\u0161ka u validateDates: " + exception.getMessage());
                    HelperFunctions.log("\u274c Gre\u0161ka u validateDates: " + exception.getMessage());
                }
                try {
                    object7 = validationResult;
                    object8 = map;
                    map2 = HelperFunctions.getMapFromObject(object8, "legalmonetarytotal");
                    if (map2 != null) {
                        fiskalizacija20.testeri.CreditNoteZahtjevTester$a.a(map2, "lineextensionamount", "Credit Note LineExtensionAmount", (HelperFunctions.ValidationResult)object7);
                        fiskalizacija20.testeri.CreditNoteZahtjevTester$a.a(map2, "taxexclusiveamount", "Credit Note TaxExclusiveAmount", (HelperFunctions.ValidationResult)object7);
                        fiskalizacija20.testeri.CreditNoteZahtjevTester$a.a(map2, "taxinclusiveamount", "Credit Note TaxInclusiveAmount", (HelperFunctions.ValidationResult)object7);
                        fiskalizacija20.testeri.CreditNoteZahtjevTester$a.a(map2, "payableamount", "Credit Note PayableAmount", (HelperFunctions.ValidationResult)object7);
                    }
                    HelperFunctions.log("\u2705 Credit Note monetary totals validacija pro\u0161la");
                }
                catch (Exception exception) {
                    validationResult.addError("Gre\u0161ka u validateMonetaryTotals: " + exception.getMessage());
                    HelperFunctions.log("\u274c Gre\u0161ka u validateMonetaryTotals: " + exception.getMessage());
                }
            }
            catch (Exception exception) {
                validationResult.addError("Gre\u0161ka pri Credit Note validaciji: " + exception.getMessage());
            }
            return validationResult;
        }

        private static List<Map<String, Object>> b(Map<String, Object> map) {
            try {
                List list = HelperFunctions.getListFromObject(map, "creditnotelines");
                if (list == null) {
                    list = HelperFunctions.getListFromObject(map, "creditnoteline");
                }
                if (list == null) {
                    list = HelperFunctions.getListFromObject(map, "lines");
                }
                if (list != null) {
                    HelperFunctions.log("\ud83d\udd0d Prona\u0111eno " + list.size() + " Credit Note linija");
                } else {
                    HelperFunctions.log("\ud83d\udd0d Nisu prona\u0111ene Credit Note linije");
                    Object object = map.get("creditnotelines");
                    if (object == null) {
                        object = map.get("creditnoteline");
                    }
                    if (object != null) {
                        HelperFunctions.log("\ud83d\udd0d Raw lines object type: " + object.getClass().getSimpleName());
                        if (object instanceof List) {
                            list = (List)object;
                            HelperFunctions.log("\ud83d\udd0d Konvertovano u listu sa " + list.size() + " elemenata");
                        }
                    }
                }
                return list;
            }
            catch (Exception exception) {
                HelperFunctions.log("\u274c Gre\u0161ka u getCreditNoteLines: " + exception.getMessage());
                return new ArrayList<Map<String, Object>>();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static void a(Map<String, Object> object, String object2, String string, HelperFunctions.ValidationResult validationResult) {
            if ((object = object.get(object2)) == null) {
                return;
            }
            if (object instanceof String) {
                if (HelperFunctions.isValidCurrencyFormat((String)(object = (String)object))) return;
                validationResult.addError(string + " neispravni format: " + (String)object);
                return;
            }
            if (!(object instanceof Map)) {
                validationResult.addError(string + " nepoznati format: " + object.getClass().getSimpleName());
                return;
            }
            object2 = (Map)object;
            object = HelperFunctions.getString((Map<String, Object>)object2, "value");
            object2 = HelperFunctions.getString((Map<String, Object>)object2, "currencyid");
            if (object == null) {
                validationResult.addError(string + " nema 'value' vrednost");
            } else {
                try {
                    BigDecimal bigDecimal = new BigDecimal((String)object);
                    if (bigDecimal.scale() > 2) {
                        validationResult.addError(string + " ima previ\u0161e decimalnih mesta: " + (String)object);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    validationResult.addError(string + " neispravni broj: " + (String)object);
                }
            }
            if (object2 == null) {
                validationResult.addError(string + " nema 'currencyid' kod");
                return;
            }
            if (((String)object2).length() == 3) return;
            validationResult.addError(string + " neispravni currency kod: " + (String)object2 + " (treba biti 3 znaka)");
        }
    }

    public class TestResult {
        private String a;
        private boolean b;
        private String c;
        private String d;
        private long e;
        private /* synthetic */ CreditNoteZahtjevTester f;

        public TestResult(CreditNoteZahtjevTester creditNoteZahtjevTester, String string, boolean bl2, String string2, String string3, long l2) {
            this.f = creditNoteZahtjevTester;
            this.a = string;
            this.b = bl2;
            this.c = string2;
            this.d = string3;
            this.e = l2;
        }

        public String getTestName() {
            return this.a;
        }

        public boolean isPassed() {
            return this.b;
        }

        public String getMessage() {
            return this.c;
        }

        public String getDetails() {
            return this.d;
        }

        public long getExecutionTime() {
            return this.e;
        }

        public String toString() {
            return String.format("%s %s - %s (%.2fms)", this.b ? "\u2705" : "\u274c", this.a, this.c, (double)this.e / 1000000.0);
        }
    }
}

