/*
 * Decompiled with CFR 0.152.
 */
package fiskalizacija20.testeri;

import UTIL.VFileUtils;
import UTIL.XMLtester;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import fiskalizacija.HrFiskalizator;
import fiskalizacija.SysUtil;
import fiskalizacija20.XmlTemplateFiller;
import fiskalizacija20.testeri.HelperFunctions;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EinvoiceZahtjevTester {
    public static String TEMPLATE_PATH;
    public static String XSD_PATH;
    public static String SCHEMATRON_XSL_PATH;
    public static boolean DEVOUT;
    public static String templateContent;
    public static String jsonContent;
    private static Map<String, Object> a;
    private static String b;
    private List<TestResult> c = new ArrayList<TestResult>();
    private int d = 0;
    private int e = 0;

    private static boolean a() {
        try {
            Object object = HelperFunctions.createCaseInsensitiveObjectMapper();
            object = ((ObjectMapper)object).readValue(jsonContent, Map.class);
            a = HelperFunctions.convertKeysToLowercase((Map<String, Object>)object);
            HelperFunctions.log("\u2705 Globalni JSON uspje\u0161no inicijaliziran i konvertiran u lowercase");
            return true;
        }
        catch (Exception exception) {
            HelperFunctions.log("\u274c Gre\u0161ka pri inicijalizaciji globalnog JSON-a: " + exception.getMessage());
            return false;
        }
    }

    public void runAllTests(XmlTemplateFiller object, XmlTemplateFiller._config map) {
        Map<String, Object> map2;
        boolean bl2;
        boolean bl3;
        String string;
        Map<String, Object> map3;
        HelperFunctions.log("\ud83d\udd27 Pokretanje JSON-specifi\u010dnih testova za EinvoiceZahtjev...");
        if (!EinvoiceZahtjevTester.a()) {
            HelperFunctions.log("\u274c Prekidam testove zbog gre\u0161ke u inicijalizaciji JSON-a");
            return;
        }
        try {
            b = ((XmlTemplateFiller)object).FillTemplate(((XmlTemplateFiller._config)((Object)map)).JSON_CONTENT, (XmlTemplateFiller._config)((Object)map));
            HelperFunctions.log("\u2705 Globalni CreditNote XML uspje\u0161no generiran pomo\u0107u XmlTemplateFiller (" + b.length() + " znakova)");
        }
        catch (Exception exception) {
            HelperFunctions.log("\u274c Prekidam testove zbog gre\u0161ke u generiranju XML-a: " + exception.getMessage());
            return;
        }
        object = this;
        long l2 = System.nanoTime();
        try {
            Handlebars handlebars = new Handlebars();
            map3 = handlebars.compileInline(templateContent);
            if (map3 != null) {
                super.a("Template Compilation", true, "Template uspje\u0161no kompajliran", "Handlebars template spreman za kori\u0161tenje", l2);
            } else {
                super.a("Template Compilation", false, "Template kompilacija vratila null", "Neo\u010dekivani rezultat kompilacije", l2);
            }
        }
        catch (Exception exception) {
            super.a("Template Compilation", false, "Gre\u0161ka pri kompilaciji template-a", exception.getMessage(), l2);
        }
        object = this;
        l2 = System.nanoTime();
        try {
            Map<String, Object> map4;
            String string2;
            boolean bl4 = b.contains("<?xml") || b.contains("<Invoice");
            map3 = HelperFunctions.getCIM(a, "invoice");
            if (map3 == null) {
                map3 = a;
            }
            boolean bl5 = (string2 = HelperFunctions.getCIS(map3, "id")) != null && b.contains(string2);
            string = HelperFunctions.getCIS(map3, "issuedate");
            if (string == null) {
                string = HelperFunctions.getCIS(map3, "issueDate");
            }
            boolean bl6 = bl3 = string != null && b.contains(string);
            if (b.contains("<cbc:ID>")) {
                b.contains("<cbc:IssueDate>");
            }
            if (DEVOUT) {
                HelperFunctions.log("DEBUG: Invoice ID = '" + string2 + "', found in XML = " + bl5);
                HelperFunctions.log("DEBUG: Issue Date = '" + string + "', found in XML = " + bl3);
            }
            if ((map4 = HelperFunctions.getCIM(map3, "accountingsupplierparty")) == null) {
                map4 = HelperFunctions.getCIM(map3, "supplier");
            }
            boolean bl7 = map4 != null;
            map = HelperFunctions.getCIM(map3, "accountingcustomerparty");
            if (map == null) {
                map = HelperFunctions.getCIM(map3, "customer");
            }
            boolean bl8 = map != null;
            boolean bl9 = bl2 = b.contains("InvoiceLine") || b.contains("TaxSubtotal") || b.contains("AllowanceCharge") || b.contains("Party");
            if (bl4 && bl5 && bl3 && bl7 && bl8 && bl2) {
                super.a("Template Processing", true, "Template processing potpuno uspje\u0161an", "Svi podaci iz JSON-a pravilno procesovani u UBL XML", l2);
            } else {
                super.a("Template Processing", false, "Problem u template processing", "XML=" + bl4 + ", ID=" + bl5 + ", Date=" + bl3 + ", Supplier=" + bl7 + ", Customer=" + bl8 + ", Loops=" + bl2, l2);
            }
        }
        catch (Exception exception) {
            super.a("Template Processing", false, "Gre\u0161ka pri template processing", exception.getMessage(), l2);
        }
        object = this;
        l2 = System.nanoTime();
        try {
            Object object2;
            map2 = HelperFunctions.getCIM(a, "invoice");
            if (map2 == null) {
                map2 = a;
            }
            if (!((HelperFunctions.ValidationResult)(object2 = MathValidationTester.a(a))).isValid()) {
                super.a("Business Validation", false, "Matemati\u010dke gre\u0161ke u ra\u010dunu", ((HelperFunctions.ValidationResult)object2).getErrors(), l2);
            } else {
                String string3 = HelperFunctions.getCIS(map2, "id");
                String string4 = HelperFunctions.getCIS(map2, "issuedate");
                if (string4 == null) {
                    string4 = HelperFunctions.getCIS(map2, "issueDate");
                }
                if ((string = HelperFunctions.getCIS(map2, "documentcurrencycode")) == null) {
                    string = HelperFunctions.getCIS(map2, "currencyid");
                }
                bl3 = string3 != null && string4 != null && string != null;
                map = HelperFunctions.getCIM(map2, "accountingsupplierparty");
                if (map == null) {
                    map = HelperFunctions.getCIM(map2, "supplier");
                }
                boolean bl10 = map != null;
                Map<String, Object> map5 = HelperFunctions.getCIM(map2, "accountingcustomerparty");
                if (map5 == null) {
                    map5 = HelperFunctions.getCIM(map2, "customer");
                }
                boolean bl11 = map5 != null;
                object2 = (List)map2.get("invoiceline");
                if (object2 == null) {
                    object2 = (List)map2.get("invoicelines");
                }
                if (object2 == null) {
                    object2 = (List)map2.get("lines");
                }
                bl2 = object2 != null && !object2.isEmpty();
                HelperFunctions.getCIM(map2, "legalmonetarytotal");
                if (bl3 && bl10 && bl11 && bl2) {
                    super.a("Business Validation", true, "Sva poslovna pravila zadovoljena", "Obavezni podaci, supplier, customer, invoice lines i matematika su ispravni", l2);
                } else {
                    super.a("Business Validation", false, "Problemi sa poslovnim pravilima", "RequiredFields=" + bl3 + ", Supplier=" + bl10 + ", Customer=" + bl11 + ", Lines=" + bl2, l2);
                }
            }
        }
        catch (Exception exception) {
            super.a("Business Validation", false, "Gre\u0161ka pri poslovnoj validaciji", exception.getMessage(), l2);
        }
        object = this;
        l2 = System.nanoTime();
        try {
            map2 = HelperFunctions.getCIM(a, "invoice");
            if (map2 == null) {
                map2 = a;
            }
            MathValidationTester.ValidationResult validationResult = new MathValidationTester.ValidationResult();
            MathValidationTester.a(map2, validationResult);
            if (validationResult.isValid()) {
                super.a("OIB Validation", true, "Svi OIB kodovi su valjani", "Supplier, Customer i HR Operator OIB-ovi pro\u0161li validaciju", l2);
            } else {
                super.a("OIB Validation", false, "Neva\u017ee\u0107i OIB kodovi prona\u0111eni", validationResult.getErrors(), l2);
            }
        }
        catch (Exception exception) {
            super.a("OIB Validation", false, "Gre\u0161ka pri OIB validaciji", exception.getMessage(), l2);
        }
        HelperFunctions.log("\ud83d\udd27 Pokretanje XML-specifi\u010dnih testova za EinvoiceZahtjev...");
        try {
            this.b();
        }
        catch (Exception exception) {
            HelperFunctions.log("\u26a0\ufe0f XSD validacija presko\u010dena: " + exception.getMessage());
        }
        try {
            this.c();
        }
        catch (Exception exception) {
            HelperFunctions.log("\u26a0\ufe0f Schematron validacija presko\u010dena: " + exception.getMessage());
        }
        object = this;
        l2 = System.nanoTime();
        try {
            try {
                Files.readAllBytes(Paths.get("nonexistent-template.xml", new String[0]));
                super.a("Error Handling", false, "Nije uhva\u0107ena gre\u0161ka za nepostoje\u0107i template", "Treba baciti IOException", l2);
            }
            catch (IOException iOException) {
                try {
                    map2 = HelperFunctions.createCaseInsensitiveObjectMapper();
                    ((ObjectMapper)((Object)map2)).readValue("{invalid json", Map.class);
                    super.a("Error Handling", false, "Nije uhva\u0107ena gre\u0161ka za neispravni JSON", "Treba baciti JsonProcessingException", l2);
                }
                catch (Exception exception) {
                    super.a("Error Handling", true, "Gre\u0161ke se pravilno hvataju", "IOException i JsonProcessingException uhva\u0107eni", l2);
                }
            }
        }
        catch (Exception exception) {
            super.a("Error Handling", false, "Neo\u010dekivana gre\u0161ka u error handling testu", exception.getMessage(), l2);
        }
        object = this;
        l2 = System.nanoTime();
        try {
            boolean bl12;
            String string5;
            map2 = HelperFunctions.getCIM(a, "invoice");
            if (map2 == null) {
                map2 = a;
            }
            bl2 = (string5 = HelperFunctions.getCIS(map2, "id")) != null && string5.length() > 0;
            String string6 = HelperFunctions.getCIS(map2, "issuedate");
            if (string6 == null) {
                string6 = HelperFunctions.getCIS(map2, "issueDate");
            }
            boolean bl13 = string6 != null && (string6.matches("\\d{4}-\\d{2}-\\d{2}") || string6.matches("\\d{4}-\\d{2}-\\d{2}T.*"));
            String string7 = HelperFunctions.getCIS(map2, "documentcurrencycode");
            if (string7 == null) {
                string7 = HelperFunctions.getCIS(map2, "currencyid");
            }
            boolean bl14 = string7 != null && string7.length() == 3;
            List list = (List)map2.get("invoiceline");
            if (list == null) {
                list = (List)map2.get("invoicelines");
            }
            if (list == null) {
                list = (List)map2.get("lines");
            }
            boolean bl15 = bl12 = list != null && !list.isEmpty();
            if (bl2 && bl13 && bl14 && bl12) {
                super.a("Edge Cases", true, "Edge cases pravilno obra\u0111eni", "Invoice ID, format datuma, valuta i linije ispravni", l2);
            } else {
                super.a("Edge Cases", false, "Problemi sa edge cases", "InvoiceID=" + bl2 + ", DateFormat=" + bl13 + ", Currency=" + bl14 + ", Lines=" + bl12, l2);
            }
        }
        catch (Exception exception) {
            super.a("Edge Cases", false, "Gre\u0161ka pri testiranju edge cases", exception.getMessage(), l2);
        }
        object = this;
        l2 = System.nanoTime();
        try {
            double d2;
            long l3 = System.nanoTime();
            for (bl2 = false; bl2 < 10 != 0; bl2 += 1) {
                Handlebars handlebars = new Handlebars();
                Template template = handlebars.compileInline(templateContent);
                template.apply(a);
            }
            long l4 = System.nanoTime() - l3;
            double d3 = (double)l4 / 10.0 / 1000000.0;
            if (d2 < 75.0) {
                super.a("Performance", true, "Performanse odli\u010dne", "Prosje\u010dno vrijeme: " + String.format("%.2f", d3) + "ms po iteraciji", l2);
            } else {
                super.a("Performance", false, "Performanse prespore", "Prosje\u010dno vrijeme: " + String.format("%.2f", d3) + "ms po iteraciji", l2);
            }
        }
        catch (Exception exception) {
            super.a("Performance", false, "Gre\u0161ka pri testiranju performansi", exception.getMessage(), l2);
        }
        this.d();
    }

    public void runXMLTests() {
        HelperFunctions.log("\ud83d\udd27 Pokretanje XML-specifi\u010dnih testova...");
        if (b == null || b.isEmpty()) {
            HelperFunctions.log("\u274c XML nije dostupan za XML testove");
            return;
        }
        try {
            this.b();
        }
        catch (Exception exception) {
            HelperFunctions.log("\u26a0\ufe0f XSD validacija presko\u010dena: " + exception.getMessage());
        }
        try {
            this.c();
        }
        catch (Exception exception) {
            HelperFunctions.log("\u26a0\ufe0f Schematron validacija presko\u010dena: " + exception.getMessage());
        }
        HelperFunctions.log("\u2705 XML testovi zavr\u0161eni!");
    }

    private void b() {
        long l2 = System.nanoTime();
        try {
            if (b == null || b.isEmpty()) {
                this.a("XSD Validation", false, "Globalni XML rezultat nije dostupan", "globalXmlResult je null ili prazan", l2);
                return;
            }
            String string = b;
            XMLtester xMLtester = new XMLtester();
            if (HelperFunctions.isXsdFileNotFoundError(string = xMLtester.testXmlAgainstXsdFile(string, XSD_PATH))) {
                this.a("XSD Validation", true, "\nPresko\u010dena jer XSD file " + XSD_PATH + " nije prona\u0111en!", "XSD file nedostaje: " + string, l2);
                return;
            }
            boolean bl2 = HelperFunctions.isXsdValidationSuccessful(string);
            boolean bl3 = HelperFunctions.hasXsdValidationErrors(string);
            if (!bl2 || bl3) {
                this.a("XSD Validation", false, "XSD validacija neuspje\u0161na", "Rezultat: " + (string != null ? string : "null"), l2);
                return;
            }
            this.a("XSD Validation", true, "XML uspje\u0161no validiran protiv XSD sheme", "XML je u skladu sa " + XSD_PATH, l2);
        }
        catch (IOException iOException) {
            this.a("XSD Validation", false, "IO gre\u0161ka pri XSD validaciji", iOException.getMessage(), l2);
            return;
        }
        catch (Exception exception) {
            this.a("XSD Validation", false, "Gre\u0161ka pri XSD validaciji", exception.getMessage(), l2);
        }
    }

    private void c() {
        long l2 = System.nanoTime();
        try {
            Object object;
            Object object2 = b;
            if (object2 == null || ((String)object2).isEmpty()) {
                object = "AI/OUTPUT/generated_invoice.xml";
                try {
                    object2 = new String(Files.readAllBytes(Paths.get((String)object, new String[0])), "UTF-8");
                    SysUtil.vdevout("\ud83d\udcc4 U\u010ditan XML iz: " + (String)object);
                }
                catch (Exception exception) {
                    SysUtil.vdevout("\u274c XML fajl nije dostupan: " + (String)object);
                    this.a("Schematron Validation", false, "XML fajl za validaciju nije dostupan", "Ni globalXmlResult ni generirani XML nisu dostupni", l2);
                    return;
                }
            }
            if (((XMLtester.SchematronValidationResult)(object2 = ((XMLtester)(object = new XMLtester())).validateAgainstSchematron((String)object2, SCHEMATRON_XSL_PATH, true))).isValid()) {
                object = String.format("Pro\u0161lo svih %d HR-BR pravila", ((XMLtester.SchematronValidationResult)object2).getSuccessfulAssertions());
                if (((XMLtester.SchematronValidationResult)object2).getWarnings() > 0) {
                    object = (String)object + String.format(" (%d upozorenja)", ((XMLtester.SchematronValidationResult)object2).getWarnings());
                }
            } else {
                object = String.format("%d gre\u0161ke prona\u0111ene u HR-BR pravilima: %s", ((XMLtester.SchematronValidationResult)object2).getErrors(), ((XMLtester.SchematronValidationResult)object2).getErrorMessages());
                this.a("Schematron Validation", false, "HR-BR validacija neuspje\u0161na", (String)object, l2);
                return;
            }
            this.a("Schematron Validation", true, "HR-BR poslovna pravila zadovoljena \n - " + (String)object, "", l2);
        }
        catch (Exception exception) {
            this.a("Schematron Validation", false, "Gre\u0161ka pri Schematron validaciji", exception.getMessage(), l2);
        }
    }

    private void a(String object, boolean bl2, String string, String string2, long l2) {
        long l3 = System.nanoTime() - l2;
        object = new TestResult(this, (String)object, bl2, string, string2, l3);
        this.c.add((TestResult)object);
        if (bl2) {
            ++this.d;
        } else {
            ++this.e;
        }
        HelperFunctions.log(((TestResult)object).toString());
        if (!bl2 && string2 != null && !string2.isEmpty()) {
            HelperFunctions.log("    Detalji: " + string2);
        }
    }

    private void d() {
        HelperFunctions.log("\n" + HelperFunctions.hr80());
        HelperFunctions.log("\ud83d\udcca REZULTATI TESTOVA");
        HelperFunctions.log(HelperFunctions.hr80());
        HelperFunctions.log("Ukupno testova: " + this.c.size());
        HelperFunctions.log("\u2705 Pro\u0161lo: " + this.d);
        HelperFunctions.log("\u274c Palo: " + this.e);
        double d2 = (double)this.d / (double)this.c.size() * 100.0;
        HelperFunctions.log("Uspje\u0161nost: " + String.format("%.1f", d2) + "%");
        if (this.e > 0) {
            HelperFunctions.log("\n\u274c NEUSPJE\u0160NI TESTOVI:");
            for (TestResult testResult : this.c) {
                if (testResult.isPassed()) continue;
                HelperFunctions.log("  - " + testResult.getTestName() + ": " + testResult.getMessage());
            }
        }
        HelperFunctions.log("\n" + HelperFunctions.hr80());
        if (!HelperFunctions.getCallingMethodInfo().contains("utilXMLMethod")) {
            if (d2 == 100.0) {
                HelperFunctions.log("\ud83c\udf89 SVI TESTOVI USPJE\u0160NI!");
            } else if (d2 >= 90.0) {
                HelperFunctions.log("\u26a0\ufe0f VE\u0106INA TESTOVA USPJE\u0160NA. Postoje manji problemi.");
            } else {
                HelperFunctions.log("\u274c VELIKI PROBLEMI. Potrebno rje\u0161avanje gre\u0161aka.");
            }
            HelperFunctions.log(HelperFunctions.hr80());
        }
    }

    public static boolean validateJsonData(Map<String, Object> map) {
        try {
            map = HelperFunctions.convertKeysToLowercase(map);
            Map<String, Object> map2 = HelperFunctions.getCIM(map, "invoice");
            if (map2 == null) {
                map2 = map;
                HelperFunctions.log("DEBUG: Invoice objekt nije prona\u0111en, koristim root objekt");
            } else {
                HelperFunctions.log("DEBUG: Invoice objekt uspje\u0161no dohva\u0107en");
            }
            HelperFunctions.log("DEBUG: Dostupni klju\u010devi u invoice objektu: " + map2.keySet());
            map = HelperFunctions.getCIS(map2, "id");
            String string = HelperFunctions.getCIS(map2, "issuedate");
            if (string == null) {
                string = HelperFunctions.getCIS(map2, "issueDate");
            }
            if (map == null || string == null) {
                HelperFunctions.log("Nedostaju osnovni UBL Invoice elementi (ID, IssueDate)");
                return false;
            }
            map = HelperFunctions.getCIM(map2, "accountingsupplierparty");
            if (map == null) {
                map = HelperFunctions.getCIM(map2, "supplier");
            }
            if (map == null) {
                HelperFunctions.log("Nedostaju supplier podaci");
                return false;
            }
            map = HelperFunctions.getCIM(map2, "accountingcustomerparty");
            if (map == null) {
                map = HelperFunctions.getCIM(map2, "customer");
            }
            if (map == null) {
                HelperFunctions.log("Nedostaju customer podaci");
                return false;
            }
            HelperFunctions.log("Osnovna struktura UBL Invoice validna");
            return true;
        }
        catch (Exception exception) {
            HelperFunctions.log("Gre\u0161ka pri validaciji UBL Invoice podataka: " + exception.getMessage());
            return false;
        }
    }

    public static boolean validateXml(String string) {
        try {
            boolean bl2;
            boolean bl3 = string.contains("<?xml") || string.contains("<Invoice");
            boolean bl4 = string.contains("Invoice");
            boolean bl5 = string.contains("AccountingSupplierParty") || string.contains("Supplier");
            boolean bl6 = bl2 = string.contains("AccountingCustomerParty") || string.contains("Customer");
            if (!(bl3 && bl4 && bl5 && bl2)) {
                HelperFunctions.log("XML struktura UBL Invoice neispravna");
                return false;
            }
            HelperFunctions.log("XML struktura UBL Invoice validna");
            return true;
        }
        catch (Exception exception) {
            HelperFunctions.log("Gre\u0161ka pri XML validaciji UBL Invoice: " + exception.getMessage());
            return false;
        }
    }

    public static void main(String[] object) {
        XmlTemplateFiller xmlTemplateFiller = new XmlTemplateFiller();
        XmlTemplateFiller._config _config2 = new XmlTemplateFiller._config(xmlTemplateFiller);
        object = ((String[])object).length > 0 ? VFileUtils.readFile(object[0]) : VFileUtils.readFile("ULAZNIJSON\\Simple_UBL_Invoice_Example.json");
        _config2.JSON_CONTENT = object;
        _config2.ROOTELEMENT = XmlTemplateFiller.RootElementType.fromString("Invoice");
        HelperFunctions.clearPrintout();
        System.out.println(xmlTemplateFiller.RedirectorZadataka((String)object, "TESTIRAJLOGIKU", xmlTemplateFiller, _config2));
    }

    public static void utilXMLMethod(String object, XmlTemplateFiller._config _config2) {
        DEVOUT = false;
        b = object;
        XSD_PATH = _config2.ROOTELEMENT.getXsdPath();
        HelperFunctions.clearPrintout();
        SCHEMATRON_XSL_PATH = _config2.ROOTELEMENT.getXslPath();
        object = new EinvoiceZahtjevTester();
        ((EinvoiceZahtjevTester)object).runXMLTests();
        super.d();
    }

    public static void utilMethod(XmlTemplateFiller xmlTemplateFiller, XmlTemplateFiller._config _config2) {
        DEVOUT = false;
        XSD_PATH = _config2.ROOTELEMENT.getXsdPath();
        TEMPLATE_PATH = _config2.TEMPLATEPATH;
        SCHEMATRON_XSL_PATH = _config2.ROOTELEMENT.getXslPath();
        EinvoiceZahtjevTester einvoiceZahtjevTester = new EinvoiceZahtjevTester();
        templateContent = _config2.TEMPLATECONTENT;
        jsonContent = _config2.JSON_CONTENT;
        einvoiceZahtjevTester.runAllTests(xmlTemplateFiller, _config2);
    }

    static {
        XSD_PATH = "fiskalizacija20\\eracunxsd\\maindoc\\UBL-Invoice-2.1.xsd";
        SCHEMATRON_XSL_PATH = "fiskalizacija20\\xsl\\HR-BR.xsl";
        DEVOUT = false;
        templateContent = null;
        jsonContent = null;
        a = null;
        b = null;
    }

    static final class MathValidationTester {
        private static final RoundingMode a = HelperFunctions.ROUNDING_MODE;
        private static Map<String, Map<String, Object>> b = null;
        private static Map<String, Map<String, Object>> c = null;

        public static ValidationResult a(Map<String, Object> object) {
            ValidationResult validationResult;
            block74: {
                validationResult = new ValidationResult();
                try {
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object62;
                    Iterator iterator;
                    Object object7;
                    Object object8;
                    Map<String, Map<String, Object>> map;
                    List<Map<String, Object>> list;
                    Map<String, Object> map2 = object;
                    Object object9 = HelperFunctions.getMapFromObject(map2, "invoice");
                    object = object9 != null ? object9 : map2;
                    if (object == null) {
                        validationResult.addError("Nedostaje Invoice objekt u JSON-u");
                        return validationResult;
                    }
                    map2 = object;
                    object9 = HelperFunctions.getListFromObject(map2, "invoicelines");
                    if (object9 == null) {
                        object9 = HelperFunctions.getListFromObject(map2, "invoiceline");
                    }
                    if ((list = object9) == null || list.isEmpty()) {
                        validationResult.addError("Nedostaju Invoice Lines");
                        return validationResult;
                    }
                    Serializable serializable = BigDecimal.ZERO;
                    Object object10 = list.iterator();
                    while (object10.hasNext()) {
                        map2 = object10.next();
                        object9 = HelperFunctions.getDecimal(map2, "lineextensionamount");
                        if (object9 == null) {
                            validationResult.addError("Nedostaje LineExtensionAmount u liniji: " + HelperFunctions.getString(map2, "id"));
                            continue;
                        }
                        serializable = ((BigDecimal)serializable).add((BigDecimal)object9);
                        object9 = validationResult;
                        try {
                            map = HelperFunctions.getDecimal(map2, "invoicedquantity");
                            object8 = HelperFunctions.getDecimal(HelperFunctions.getMapFromObject(map2, "price"), "priceamount");
                            object7 = HelperFunctions.getDecimal(map2, "lineextensionamount");
                            if (map == null || object8 == null || object7 == null || ((BigDecimal)((Object)(iterator = ((BigDecimal)((Object)map)).multiply((BigDecimal)object8).setScale(2, a)))).compareTo((BigDecimal)object7) == 0) continue;
                            ((HelperFunctions.ValidationResult)object9).addError(String.format("Artikal %s: Quantity(%s) \u00d7 Price(%s) = %s, ali LineAmount je %s", HelperFunctions.getString(map2, "id"), map, object8, iterator, object7));
                        }
                        catch (Exception exception) {
                            ((HelperFunctions.ValidationResult)object9).addError("Gre\u0161ka u kalkulaciji linije: " + exception.getMessage());
                        }
                    }
                    object9 = validationResult;
                    map2 = object;
                    try {
                        object8 = HelperFunctions.getMapFromObject(map2, "taxtotal");
                        if (object8 != null) {
                            object7 = HelperFunctions.getDecimal(object8, "taxamount");
                            iterator = HelperFunctions.getListFromObject(object8, "taxsubtotals");
                            if (object7 != null && iterator != null) {
                                object10 = BigDecimal.ZERO;
                                object62 = iterator.iterator();
                                while (object62.hasNext()) {
                                    map2 = object62.next();
                                    object5 = HelperFunctions.getDecimal(map2, "taxableamount");
                                    object4 = HelperFunctions.getDecimal(map2, "taxamount");
                                    object3 = HelperFunctions.getDecimal(HelperFunctions.getMapFromObject(map2, "taxcategory"), "percent");
                                    if (object5 == null || object4 == null || object3 == null) continue;
                                    object2 = ((BigDecimal)object5).multiply((BigDecimal)object3).divide(BigDecimal.valueOf(100L), 2, a);
                                    if (((BigDecimal)object2).compareTo((BigDecimal)object4) != 0) {
                                        ((HelperFunctions.ValidationResult)object9).addError(String.format("PDV kalkulacija: %s \u00d7 %s%% = %s, ali TaxAmount je %s", object5, object3, object2, object4));
                                    }
                                    object10 = ((BigDecimal)object10).add((BigDecimal)object4);
                                }
                                if (((BigDecimal)object10).compareTo((BigDecimal)object7) != 0) {
                                    ((HelperFunctions.ValidationResult)object9).addError(String.format("Ukupni PDV: izra\u010dunato %s, u dokumentu %s", object10, object7));
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        ((HelperFunctions.ValidationResult)object9).addError("Gre\u0161ka u validaciji Tax Totals: " + exception.getMessage());
                    }
                    map = validationResult;
                    object9 = serializable;
                    map2 = object;
                    try {
                        object8 = HelperFunctions.getMapFromObject(map2, "legalmonetarytotal");
                        if (object8 != null) {
                            object7 = HelperFunctions.getDecimal(object8, "lineextensionamount");
                            iterator = HelperFunctions.getDecimal((Map<String, Object>)object8, "taxexclusiveamount");
                            object10 = HelperFunctions.getDecimal((Map<String, Object>)object8, "taxinclusiveamount");
                            object62 = HelperFunctions.getDecimal(object8, "payableamount");
                            if (object7 != null && ((BigDecimal)object7).compareTo((BigDecimal)object9) != 0) {
                                ((HelperFunctions.ValidationResult)((Object)map)).addError(String.format("LineExtensionAmount: izra\u010dunato %s, u dokumentu %s", object9, object7));
                            }
                            if (iterator != null && object7 != null && ((BigDecimal)((Object)iterator)).compareTo((BigDecimal)object7) != 0) {
                                ((HelperFunctions.ValidationResult)((Object)map)).addError(String.format("TaxExclusiveAmount (%s) trebao bi biti jednak LineExtensionAmount (%s)", iterator, object7));
                            }
                            if (object10 != null && object62 != null && ((BigDecimal)object10).compareTo((BigDecimal)object62) != 0) {
                                ((HelperFunctions.ValidationResult)((Object)map)).addError(String.format("TaxInclusiveAmount (%s) trebao bi biti jednak PayableAmount (%s)", object10, object62));
                            }
                        }
                    }
                    catch (Exception exception) {
                        ((HelperFunctions.ValidationResult)((Object)map)).addError("Gre\u0161ka u validaciji Legal Monetary Totals: " + exception.getMessage());
                    }
                    map = validationResult;
                    object9 = serializable;
                    map2 = object;
                    try {
                        object8 = HelperFunctions.getMapFromObject(map2, "hrfisk20data");
                        if (object8 != null) {
                            object7 = HelperFunctions.getMapFromObject(object8, "hrtaxtotal");
                            iterator = HelperFunctions.getMapFromObject(object8, "hrlegalmonetarytotal");
                            if (object7 != null && (object10 = HelperFunctions.getString((Map<String, Object>)object7, "taxamount")) != null) {
                                object62 = new BigDecimal((String)object10);
                                if ((map2 = HelperFunctions.getMapFromObject(map2, "taxtotal")) != null && (object5 = HelperFunctions.getDecimal(map2, "taxamount")) != null && ((BigDecimal)object62).compareTo((BigDecimal)object5) != 0) {
                                    ((HelperFunctions.ValidationResult)((Object)map)).addError(String.format("HR TaxAmount (%s) ne odgovara glavnom TaxAmount (%s)", object62, object5));
                                }
                            }
                            if (iterator != null && (object10 = HelperFunctions.getString(iterator, "taxexclusiveamount")) != null && ((BigDecimal)(object62 = new BigDecimal((String)object10))).compareTo((BigDecimal)object9) != 0) {
                                ((HelperFunctions.ValidationResult)((Object)map)).addError(String.format("HR TaxExclusiveAmount (%s) ne odgovara izra\u010dunatom (%s)", object62, object9));
                            }
                        }
                    }
                    catch (Exception exception) {
                        ((HelperFunctions.ValidationResult)((Object)map)).addError("Gre\u0161ka u validaciji HR Extensions: " + exception.getMessage());
                    }
                    object9 = validationResult;
                    map2 = list;
                    map = MathValidationTester.a();
                    if (map.isEmpty()) {
                        ((HelperFunctions.ValidationResult)object9).addError("Nije mogu\u0107e u\u010ditati listu validnih jedinica mjere - preska\u010dem validaciju");
                    } else {
                        object8 = new ArrayList();
                        int n2 = 0;
                        iterator = map2.iterator();
                        while (iterator.hasNext()) {
                            object10 = (Map)iterator.next();
                            object62 = HelperFunctions.getString((Map<String, Object>)object10, "id");
                            map2 = HelperFunctions.getMapFromObject((Map<String, Object>)object10, "price");
                            if (map2 != null) {
                                object5 = HelperFunctions.getString(map2, "unitcode");
                                ++n2;
                                if (object5 == null || ((String)object5).trim().isEmpty()) {
                                    ((HelperFunctions.ValidationResult)object9).addError("Linija " + (String)object62 + ": Nedostaje unitCode u price objektu");
                                    object8.add("Linija " + (String)object62 + ": nedostaje unitCode");
                                    continue;
                                }
                                if (map.containsKey(object5)) continue;
                                ((HelperFunctions.ValidationResult)object9).addError("Linija " + (String)object62 + ": Nevaljan unitCode '" + (String)object5 + "' - nije prona\u0111en u EN16931 HR listi jedinica mjere");
                                object8.add("Linija " + (String)object62 + ": '" + (String)object5 + "'");
                                object2 = map;
                                object3 = object5;
                                serializable = new ArrayList();
                                object10 = ((String)object3).toUpperCase();
                                for (Object object62 : object2.keySet()) {
                                    if (!((String)object62).toUpperCase().startsWith(((String)object10).substring(0, Math.min(1, ((String)object10).length())))) continue;
                                    object5 = (Map)object2.get(object62);
                                    object5 = (String)object5.get("name_hr");
                                    serializable.add((String)object62 + " (" + (String)object5 + ")");
                                    if (serializable.size() < 3) continue;
                                }
                                if (((String)(object4 = String.join((CharSequence)", ", (Iterable<? extends CharSequence>)((Object)serializable)))).isEmpty()) continue;
                                ((HelperFunctions.ValidationResult)object9).addError("  Mo\u017eda ste mislili: " + (String)object4);
                                continue;
                            }
                            ((HelperFunctions.ValidationResult)object9).addError("Linija " + (String)object62 + ": Nedostaje price objekt");
                            object8.add("Linija " + (String)object62 + ": nedostaje price objekt");
                        }
                        if (object8.isEmpty()) {
                            HelperFunctions.log("\u2705 UnitCode-ovi su valjani (" + n2 + " provjeren" + (n2 == 1 ? "" : "o") + ")");
                        } else {
                            HelperFunctions.log("\u274c Prona\u0111eni neva\u017ee\u0107i UnitCode-ovi: " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)object8));
                        }
                    }
                    object9 = validationResult;
                    map2 = object;
                    map = new ArrayList();
                    int n3 = 0;
                    try {
                        String string = HelperFunctions.getString(map2, "issuedate");
                        iterator = HelperFunctions.getString(map2, "duedate");
                        object10 = HelperFunctions.getString(map2, "issuetime");
                        if (string != null) {
                            ++n3;
                            if (!HelperFunctions.isValidDateFormat(string)) {
                                ((HelperFunctions.ValidationResult)object9).addError("IssueDate: Neispravni format datuma '" + string + "' (o\u010dekuje se YYYY-MM-DD)");
                                map.add("IssueDate format: '" + string + "'");
                            } else if (!HelperFunctions.isLogicalDate(string)) {
                                ((HelperFunctions.ValidationResult)object9).addError("IssueDate: Nelogi\u010dni datum '" + string + "'");
                                map.add("IssueDate logic: '" + string + "'");
                            } else if (HelperFunctions.isFutureDate(string)) {
                                ((HelperFunctions.ValidationResult)object9).addError("IssueDate: Datum izdavanja ne smije biti u budu\u0107nosti '" + string + "'");
                                map.add("IssueDate future: '" + string + "'");
                            }
                        }
                        if (iterator != null) {
                            ++n3;
                            if (!HelperFunctions.isValidDateFormat((String)((Object)iterator))) {
                                ((HelperFunctions.ValidationResult)object9).addError("DueDate: Neispravni format datuma '" + (String)((Object)iterator) + "' (o\u010dekuje se YYYY-MM-DD)");
                                map.add("DueDate format: '" + iterator + "'");
                            } else if (!HelperFunctions.isLogicalDate((String)((Object)iterator))) {
                                ((HelperFunctions.ValidationResult)object9).addError("DueDate: Nelogi\u010dni datum '" + (String)((Object)iterator) + "'");
                                map.add("DueDate logic: '" + iterator + "'");
                            }
                        }
                        if (object10 != null) {
                            ++n3;
                            if (!HelperFunctions.isValidTimeFormat((String)object10)) {
                                ((HelperFunctions.ValidationResult)object9).addError("IssueTime: Neispravni format vremena '" + (String)object10 + "' (o\u010dekuje se HH:MM:SS)");
                                map.add("IssueTime format: '" + (String)object10 + "'");
                            }
                        }
                        if (string != null && iterator != null && HelperFunctions.isValidDateFormat(string) && HelperFunctions.isValidDateFormat((String)((Object)iterator))) {
                            try {
                                object62 = LocalDate.parse(string);
                                map2 = LocalDate.parse(iterator);
                                if (((LocalDate)((Object)map2)).isBefore((ChronoLocalDate)object62)) {
                                    ((HelperFunctions.ValidationResult)object9).addError("DueDate (" + iterator + ") ne smije biti prije IssueDate (" + string + ")");
                                    map.add("DueDate < IssueDate");
                                }
                            }
                            catch (Exception exception) {
                                ((HelperFunctions.ValidationResult)object9).addError("Gre\u0161ka pri usporedbi datuma: " + exception.getMessage());
                            }
                        }
                        if (map.isEmpty() && n3 > 0) {
                            HelperFunctions.log("\u2705 Datumi su valjani (" + n3 + " provjeren" + (n3 == 1 ? "" : "o") + ")");
                        } else if (n3 == 0) {
                            HelperFunctions.log("\u26a0\ufe0f Nema datuma za validaciju");
                        } else {
                            HelperFunctions.log("\u274c Prona\u0111eni neva\u017ee\u0107i datumi: " + String.join((CharSequence)", ", map));
                        }
                    }
                    catch (Exception exception) {
                        ((HelperFunctions.ValidationResult)object9).addError("Gre\u0161ka pri validaciji datuma: " + exception.getMessage());
                    }
                    object9 = validationResult;
                    map2 = list;
                    map = MathValidationTester.b();
                    if (map.isEmpty()) {
                        ((HelperFunctions.ValidationResult)object9).addError("Nije mogu\u0107e u\u010ditati listu validnih KPD kodova - preska\u010dem validaciju");
                        break block74;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    int n4 = 0;
                    try {
                        iterator = map2.iterator();
                        while (iterator.hasNext()) {
                            object10 = (Map)iterator.next();
                            object62 = HelperFunctions.getString((Map<String, Object>)object10, "id");
                            map2 = HelperFunctions.getMapFromObject((Map<String, Object>)object10, "item");
                            if (map2 == null) continue;
                            object5 = HelperFunctions.getMapFromObject(map2, "commodityclassification");
                            if (object5 != null) {
                                object4 = HelperFunctions.getString(object5, "commoditycode");
                                object3 = HelperFunctions.getString(object5, "listid");
                                if (object4 != null) {
                                    ++n4;
                                    if ("KPD".equals(object3) || "HR-KPD".equals(object3) || object3 == null) {
                                        if (!HelperFunctions.isValidKPDCode(object4, map)) {
                                            ((HelperFunctions.ValidationResult)object9).addError("Linija " + (String)object62 + ": Nevaljan KPD kod '" + (String)object4 + "' - nije prona\u0111en u KPD 2025 klasifikaciji");
                                            arrayList.add("Linija " + (String)object62 + ": KPD '" + (String)object4 + "'");
                                            object2 = HelperFunctions.findSimilarKPDCodes((String)object4, map);
                                            if (!((String)object2).isEmpty()) {
                                                ((HelperFunctions.ValidationResult)object9).addError("  Mo\u017eda ste mislili: " + (String)object2);
                                            }
                                        }
                                    } else if ("HS".equals(object3)) {
                                        if (!HelperFunctions.isValidHSCode(object4)) {
                                            ((HelperFunctions.ValidationResult)object9).addError("Linija " + (String)object62 + ": Nevaljan HS kod '" + (String)object4 + "'");
                                            arrayList.add("Linija " + (String)object62 + ": HS '" + (String)object4 + "'");
                                        }
                                    } else if (!HelperFunctions.isValidGeneralCommodityCode(object4)) {
                                        ((HelperFunctions.ValidationResult)object9).addError("Linija " + (String)object62 + ": Nevaljan commodity kod '" + (String)object4 + "' (ListID: " + (String)object3 + ")");
                                        arrayList.add("Linija " + (String)object62 + ": '" + (String)object4 + "'");
                                    }
                                }
                            }
                            if ((object4 = HelperFunctions.getMapFromObject(map2, "standarditemidentification")) == null) continue;
                            object3 = HelperFunctions.getString(object4, "id");
                            object2 = HelperFunctions.getString(object4, "schemeid");
                            if (object3 == null) continue;
                            ++n4;
                            if (!"GTIN".equals(object2) && !"EAN".equals(object2) || HelperFunctions.isValidGTIN((String)object3)) continue;
                            ((HelperFunctions.ValidationResult)object9).addError("Linija " + (String)object62 + ": Nevaljan " + (String)object2 + " kod '" + (String)object3 + "'");
                            arrayList.add("Linija " + (String)object62 + ": " + (String)object2 + " '" + (String)object3 + "'");
                        }
                        if (arrayList.isEmpty() && n4 > 0) {
                            HelperFunctions.log("\u2705 Commodity kodovi su valjani (" + n4 + " provjeren" + (n4 == 1 ? "" : "o") + ")");
                            break block74;
                        }
                        if (n4 == 0) {
                            HelperFunctions.log("\u26a0\ufe0f Nema commodity kodova za validaciju");
                            break block74;
                        }
                        HelperFunctions.log("\u274c Prona\u0111eni neva\u017ee\u0107i commodity kodovi: " + String.join((CharSequence)", ", arrayList));
                    }
                    catch (Exception exception) {
                        ((HelperFunctions.ValidationResult)object9).addError("Gre\u0161ka pri validaciji commodity kodova: " + exception.getMessage());
                    }
                }
                catch (Exception exception) {
                    validationResult.addError("Gre\u0161ka pri matemati\u010dkoj validaciji: " + exception.getMessage());
                }
            }
            return validationResult;
        }

        private static Map<String, Map<String, Object>> a() {
            if (b != null) {
                return b;
            }
            try {
                Object object = "fiskalizacija20\\json\\JediniceMjera_EN16931_HR.json";
                if (HrFiskalizator.p != null && HrFiskalizator.p.getProperty("RADNIFOLDER") != null) {
                    object = HrFiskalizator.p.getProperty("RADNIFOLDER") + "\\fiskalizacija20\\json\\JediniceMjera_EN16931_HR.json";
                }
                object = new String(Files.readAllBytes(Paths.get((String)object, new String[0])), "UTF-8");
                ObjectMapper objectMapper = new ObjectMapper();
                object = objectMapper.readValue((String)object, Map.class);
                object = (Map)object.get("JediniceMjera_EN16931_HR");
                object = (Map)object.get("units");
                b = object;
                HelperFunctions.log("\u2705 U\u010ditano " + b.size() + " validnih jedinica mjere iz JSON datoteke");
                return b;
            }
            catch (Exception exception) {
                HelperFunctions.log("\u274c Gre\u0161ka pri u\u010ditavanju jedinica mjere: " + exception.getMessage());
                return new HashMap<String, Map<String, Object>>();
            }
        }

        public static void a(Map<String, Object> map, ValidationResult validationResult) {
            Object object;
            Map<String, Object> map2;
            Map<String, Object> map3;
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 0;
            Map<String, Object> map4 = HelperFunctions.getMapFromObject(map, "accountingsupplierparty");
            if (map4 != null && (map4 = HelperFunctions.getMapFromObject(map4, "party")) != null) {
                map3 = HelperFunctions.getMapFromObject(map4, "partyidentification");
                if (map3 != null && (map2 = HelperFunctions.getString(map3, "id")) != null) {
                    ++n2;
                    if (!HelperFunctions.isValidOIB((String)((Object)map2))) {
                        validationResult.addError("Supplier: Nevaljan OIB '" + (String)((Object)map2) + "'");
                        arrayList.add("Supplier OIB: '" + (String)((Object)map2) + "'");
                    }
                }
                if ((map2 = HelperFunctions.getMapFromObject(map4, "partytaxscheme")) != null && (object = HelperFunctions.getString(map2, "companyid")) != null && !((String)object).equals(HelperFunctions.getString(HelperFunctions.getMapFromObject(map4, "partyidentification"), "id"))) {
                    ++n2;
                    if (!HelperFunctions.isValidOIB((String)object)) {
                        validationResult.addError("Supplier TaxScheme: Nevaljan OIB '" + (String)object + "'");
                        arrayList.add("Supplier Tax OIB: '" + (String)object + "'");
                    }
                }
            }
            if ((map4 = HelperFunctions.getMapFromObject(map, "accountingcustomerparty")) != null && (map3 = HelperFunctions.getMapFromObject(map4, "party")) != null) {
                map2 = HelperFunctions.getMapFromObject(map3, "partyidentification");
                if (map2 != null && (object = HelperFunctions.getString(map2, "id")) != null) {
                    ++n2;
                    if (!HelperFunctions.isValidOIB((String)object)) {
                        validationResult.addError("Customer: Nevaljan OIB '" + (String)object + "'");
                        arrayList.add("Customer OIB: '" + (String)object + "'");
                    }
                }
                if ((object = HelperFunctions.getMapFromObject(map3, "partytaxscheme")) != null && (map4 = HelperFunctions.getString((Map<String, Object>)object, "companyid")) != null && !((String)((Object)map4)).equals(HelperFunctions.getString(HelperFunctions.getMapFromObject(map3, "partyidentification"), "id"))) {
                    ++n2;
                    if (!HelperFunctions.isValidOIB((String)((Object)map4))) {
                        validationResult.addError("Customer TaxScheme: Nevaljan OIB '" + (String)((Object)map4) + "'");
                        arrayList.add("Customer Tax OIB: '" + (String)((Object)map4) + "'");
                    }
                }
            }
            if ((map3 = HelperFunctions.getMapFromObject(map, "hrfisk20data")) != null && (map2 = HelperFunctions.getString(map3, "hroperatoroib")) != null) {
                ++n2;
                if (!HelperFunctions.isValidOIB((String)((Object)map2))) {
                    validationResult.addError("HR Operator: Nevaljan OIB '" + (String)((Object)map2) + "'");
                    arrayList.add("Operator OIB: '" + (String)((Object)map2) + "'");
                }
            }
            map2 = MathValidationTester.b(HelperFunctions.getMapFromObject(map, "accountingsupplierparty"));
            object = MathValidationTester.b(HelperFunctions.getMapFromObject(map, "accountingcustomerparty"));
            if (map2 != null && object != null && ((String)((Object)map2)).equals(object)) {
                validationResult.addError("Supplier i Customer imaju isti OIB: '" + (String)((Object)map2) + "'");
                arrayList.add("Duplicate OIB: '" + (String)((Object)map2) + "'");
            }
            if (arrayList.isEmpty() && n2 > 0) {
                HelperFunctions.log("\u2705 OIB-ovi su valjani (" + n2 + " provjeren" + (n2 == 1 ? "" : "o") + ")");
                return;
            }
            if (n2 == 0) {
                HelperFunctions.log("\u26a0\ufe0f Nema OIB-ova za validaciju");
                return;
            }
            HelperFunctions.log("\u274c Prona\u0111eni neva\u017ee\u0107i OIB-ovi: " + String.join((CharSequence)", ", arrayList));
        }

        private static String b(Map<String, Object> map) {
            if (map == null) {
                return null;
            }
            if ((map = HelperFunctions.getMapFromObject(map, "party")) == null) {
                return null;
            }
            if ((map = HelperFunctions.getMapFromObject(map, "partyidentification")) != null) {
                return HelperFunctions.getString(map, "id");
            }
            return null;
        }

        private static Map<String, Map<String, Object>> b() {
            if (c != null) {
                return c;
            }
            try {
                Iterator iterator = "fiskalizacija20\\json\\KPD2025.json";
                if (HrFiskalizator.p != null && HrFiskalizator.p.getProperty("RADNIFOLDER") != null) {
                    iterator = HrFiskalizator.p.getProperty("RADNIFOLDER") + "\\fiskalizacija20\\json\\KPD2025.json";
                }
                iterator = new String(Files.readAllBytes(Paths.get((String)((Object)iterator), new String[0])), "UTF-8");
                Serializable serializable = new ObjectMapper();
                iterator = ((ObjectMapper)serializable).readValue((String)((Object)iterator), Map.class);
                iterator = (List)iterator.get("klasifikacije");
                serializable = new HashMap();
                if (iterator != null) {
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        Map map = (Map)iterator.next();
                        String string = (String)map.get("code");
                        String string2 = (String)map.get("fullCode");
                        Boolean bl2 = (Boolean)map.get("isActive");
                        if (bl2 == null || !bl2.booleanValue() || string == null) continue;
                        serializable.put(string, map);
                        if (string2 == null || string2.equals(string)) continue;
                        serializable.put(string2, map);
                    }
                }
                c = serializable;
                HelperFunctions.log("\u2705 U\u010ditano " + c.size() + " validnih KPD kodova iz JSON datoteke");
                return c;
            }
            catch (Exception exception) {
                HelperFunctions.log("\u274c Gre\u0161ka pri u\u010ditavanju KPD kodova: " + exception.getMessage());
                return new HashMap<String, Map<String, Object>>();
            }
        }

        public static class ValidationResult
        extends HelperFunctions.ValidationResult {
        }
    }

    public class TestResult {
        private String a;
        private boolean b;
        private String c;
        private String d;
        private long e;
        private /* synthetic */ EinvoiceZahtjevTester f;

        public TestResult(EinvoiceZahtjevTester einvoiceZahtjevTester, String string, boolean bl2, String string2, String string3, long l2) {
            this.f = einvoiceZahtjevTester;
            this.a = string;
            this.b = bl2;
            this.c = string2;
            this.d = string3;
            this.e = l2;
        }

        public String getTestName() {
            return this.a;
        }

        public boolean isPassed() {
            return this.b;
        }

        public String getMessage() {
            return this.c;
        }

        public String getDetails() {
            return this.d;
        }

        public long getExecutionTime() {
            return this.e;
        }

        public String toString() {
            return String.format("%s %s - %s (%.2fms)", this.b ? "\u2705" : "\u274c", this.a, this.c, (double)this.e / 1000000.0);
        }
    }
}

