/*
 * Decompiled with CFR 0.152.
 */
package fiskalizacija20.testeri;

import UTIL.VFileUtils;
import UTIL.XMLtester;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jknack.handlebars.Handlebars;
import fiskalizacija20.XmlTemplateFiller;
import fiskalizacija20.testeri.HelperFunctions;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EvidentirajERacunZahtjevTester {
    public static String TEMPLATE_PATH;
    public static String XSD_PATH;
    public static String SCHEMATRON_XSL_PATH;
    public static boolean DEVOUT;
    public static String templateContent;
    public static String jsonContent;
    private static Map<String, Object> a;
    private static String b;
    private List<TestResult> c = new ArrayList<TestResult>();
    private int d = 0;
    private int e = 0;

    private static boolean a() {
        try {
            Iterator iterator = HelperFunctions.createCaseInsensitiveObjectMapper();
            iterator = ((ObjectMapper)((Object)iterator)).readValue(jsonContent, Map.class);
            a = HelperFunctions.convertKeysToLowercase((Map<String, Object>)((Object)iterator));
            try {
                iterator = (Map)((Map)a.get("evidentirajeracunzahtjev")).get("eracun");
                iterator = (List)iterator.get("stavkaeracuna");
                if (iterator != null) {
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        Map map = (Map)iterator.next();
                        Object v2 = map.get("kolicina");
                        Object v3 = map.get("artiklnetocijena");
                        if (v2 == null || v3 == null) continue;
                        double d2 = Double.parseDouble(v2.toString());
                        double d3 = Double.parseDouble(v3.toString());
                        double d4 = d2 * d3;
                        map.put("neto", String.format("%.2f", d4));
                        HelperFunctions.log("\u2705 Izra\u010dunat neto za stavku: " + d2 + " \u00d7 " + d3 + " = " + String.format("%.2f", d4));
                    }
                }
            }
            catch (Exception exception) {
                HelperFunctions.log("\u26a0\ufe0f Gre\u0161ka pri izra\u010dunavanju neto za stavke: " + exception.getMessage());
            }
            HelperFunctions.log("\u2705 Globalni JSON uspje\u0161no inicijaliziran i konvertiran u lovercase");
            return true;
        }
        catch (Exception exception) {
            HelperFunctions.log("\u2717 Gre\u0161ka pri inicijalizaciji globalnog JSON-a: " + exception.getMessage());
            return false;
        }
    }

    public void runAllTests(XmlTemplateFiller object, XmlTemplateFiller._config _config2) {
        boolean bl2;
        Object object2;
        Object object3;
        Map<String, Object> map;
        Map<String, Object> map2;
        HelperFunctions.log("\ud83d\udd27 Pokretanje JSON-specifi\u010dnih testova za EvidentirajERacunZahtjev...");
        if (!EvidentirajERacunZahtjevTester.a()) {
            HelperFunctions.log("\u274c Prekidam testove zbog gre\u0161ke u inicijalizaciji JSON-a");
            return;
        }
        try {
            b = ((XmlTemplateFiller)object).FillTemplate(_config2.JSON_CONTENT, _config2);
            HelperFunctions.log("\u2705 Globalni CreditNote XML uspje\u0161no generiran pomo\u0107u XmlTemplateFiller (" + b.length() + " znakova)");
        }
        catch (Exception exception) {
            HelperFunctions.log("\u274c Prekidam testove zbog gre\u0161ke u generiranju XML-a: " + exception.getMessage());
            return;
        }
        object = this;
        long l2 = System.nanoTime();
        try {
            Handlebars handlebars = new Handlebars();
            map2 = handlebars.compileInline(templateContent);
            if (map2 != null) {
                super.a("Template Compilation", true, "Template uspje\u0161no kompajliran", "Handlebars template spreman za kori\u0161tenje", l2);
            } else {
                super.a("Template Compilation", false, "Template kompilacija vratila null", "Neo\u010dekivani rezultat kompilacije", l2);
            }
        }
        catch (Exception exception) {
            super.a("Template Compilation", false, "Gre\u0161ka pri kompilaciji template-a", exception.getMessage(), l2);
        }
        object = this;
        l2 = System.nanoTime();
        try {
            boolean bl3 = b.contains("<?xml") || b.contains("<efis:EvidentirajERacunZahtjev");
            map2 = HelperFunctions.getCIM(a, "evidentirajeracunzahtjev");
            if (map2 == null) {
                super.a("Template Processing", false, "Request je null", "evidentirajeracunzahtjev klju\u010d nije prona\u0111en", l2);
            } else {
                boolean bl4 = b.contains("efis:id=");
                map = HelperFunctions.getCIM(map2, "eracun");
                if (map == null) {
                    super.a("Template Processing", false, "eRacun je null", "eracun klju\u010d nije prona\u0111en", l2);
                } else {
                    boolean bl5;
                    Map<String, Object> map3;
                    object3 = HelperFunctions.getCIS(map, "oibizd");
                    if (object3 == null && (map3 = HelperFunctions.getCIM(map, "izdavatelj")) != null) {
                        object3 = HelperFunctions.getCIS(map3, "oibporeznibroj");
                    }
                    boolean bl6 = object3 != null && b.contains((CharSequence)object3);
                    boolean bl7 = bl5 = b.contains("Stavka") || b.contains("PDV") || b.contains("RaspodjelaPdv") || b.contains("StavkaERacuna");
                    if (bl3 && bl4 && bl6 && bl5) {
                        super.a("Template Processing", true, "Template processing potpuno uspje\u0161an", "Svi podaci iz JSON-a pravilno procesovani", l2);
                    } else {
                        super.a("Template Processing", false, "Problem u template processing", "XML=" + bl3 + ", ReqID=" + bl4 + ", OIB=" + bl6 + ", Loops=" + bl5, l2);
                    }
                }
            }
        }
        catch (Exception exception) {
            super.a("Template Processing", false, "Gre\u0161ka pri template processing", exception.getMessage(), l2);
        }
        object = this;
        l2 = System.nanoTime();
        try {
            object2 = HelperFunctions.getCIM(a, "evidentirajeracunzahtjev");
            map2 = HelperFunctions.getCIM(object2, "eracun");
            String string = HelperFunctions.getCIS(map2, "brojdokumenta");
            map = HelperFunctions.getCIS(map2, "datumizdavanja");
            object3 = HelperFunctions.getCIM(map2, "izdavatelj");
            String string2 = HelperFunctions.getCIS(object3, "oibporeznibroj");
            Object object4 = HelperFunctions.getCIM(map2, "primatelj");
            object4 = HelperFunctions.getCIS(object4, "oibporeznibroj");
            boolean bl8 = string != null && map != null && string2 != null && object4 != null;
            Object object5 = HelperFunctions.getCIM(map2, "dokumentukupaniznos");
            object4 = new BigDecimal(HelperFunctions.getCIS(object5, "iznosbezpdv"));
            object2 = new BigDecimal(HelperFunctions.getCIS(object5, "pdv"));
            object5 = new BigDecimal(HelperFunctions.getCIS(object5, "iznosspdv"));
            object4 = ((BigDecimal)object4).add((BigDecimal)object2);
            boolean bl9 = ((BigDecimal)object4).compareTo((BigDecimal)object5) == 0;
            object5 = (List)map2.get("stavkaeracuna");
            boolean bl10 = bl2 = object5 != null && !object5.isEmpty();
            if (bl8 && bl9 && bl2) {
                super.a("Business Validation", true, "Sva poslovna pravila zadovoljena", "Obavezni podaci, matematika i stavke su ispravni", l2);
            } else {
                super.a("Business Validation", false, "Problemi sa poslovnim pravilima", "RequiredFields=" + bl8 + ", Math=" + bl9 + ", Stavke=" + bl2, l2);
            }
        }
        catch (Exception exception) {
            super.a("Business Validation", false, "Gre\u0161ka pri poslovnoj validaciji", exception.getMessage(), l2);
        }
        this.runXMLTests();
        object = this;
        l2 = System.nanoTime();
        try {
            try {
                Files.readAllBytes(Paths.get("nonexistent-template.xml", new String[0]));
                super.a("Error Handling", false, "Nije uhva\u0107ena gre\u0161ka za nepostoje\u0107i template", "Treba baciti IOException", l2);
            }
            catch (IOException iOException) {
                try {
                    object2 = HelperFunctions.createCaseInsensitiveObjectMapper();
                    ((ObjectMapper)object2).readValue("{invalid json", Map.class);
                    super.a("Error Handling", false, "Nije uhva\u0107ena gre\u0161ka za neispravni JSON", "Treba baciti JsonProcessingException", l2);
                }
                catch (Exception exception) {
                    super.a("Error Handling", true, "Gre\u0161ke se pravilno hvataju", "IOException i JsonProcessingException uhva\u0107eni", l2);
                }
            }
        }
        catch (Exception exception) {
            super.a("Error Handling", false, "Neo\u010dekivana gre\u0161ka u error handling testu", exception.getMessage(), l2);
        }
        object = this;
        l2 = System.nanoTime();
        try {
            object2 = HelperFunctions.getCIM(a, "evidentirajeracunzahtjev");
            map2 = HelperFunctions.getCIM(object2, "eracun");
            String string = HelperFunctions.getCIS(map2, "brojdokumenta");
            boolean bl11 = string != null && string.length() >= 3;
            object3 = HelperFunctions.getCIS(map2, "datumizdavanja");
            boolean bl12 = object3 != null && ((String)object3).matches("\\d{4}-\\d{2}-\\d{2}");
            Object object6 = HelperFunctions.getCIM(map2, "izdavatelj");
            object6 = HelperFunctions.getCIS(object6, "oibporeznibroj");
            Map<String, Object> map4 = HelperFunctions.getCIM(map2, "primatelj");
            String string3 = HelperFunctions.getCIS(map4, "oibporeznibroj");
            boolean bl13 = object6 != null && ((String)object6).length() == 11 && string3 != null && string3.length() == 11;
            object2 = (List)map2.get("stavkaeracuna");
            boolean bl14 = bl2 = object2 != null && !object2.isEmpty();
            if (bl11 && bl12 && bl13 && bl2) {
                super.a("Edge Cases", true, "Edge cases pravilno obra\u0111eni", "Broj ra\u010duna, format datuma, du\u017eina OIB-a i stavke ispravni", l2);
            } else {
                super.a("Edge Cases", false, "Problemi sa edge cases", "BrojRac=" + bl11 + ", DatumFormat=" + bl12 + ", OIBLength=" + bl13 + ", Stavke=" + bl2, l2);
            }
        }
        catch (Exception exception) {
            super.a("Edge Cases", false, "Gre\u0161ka pri testiranju edge cases", exception.getMessage(), l2);
        }
        object = this;
        l2 = System.nanoTime();
        try {
            double d2;
            long l3 = System.nanoTime();
            for (int i2 = 0; i2 < 10; ++i2) {
                Handlebars handlebars = new Handlebars();
                object3 = handlebars.compileInline(templateContent);
                object3.apply(a);
            }
            long l4 = System.nanoTime() - l3;
            double d3 = (double)l4 / 10.0 / 1000000.0;
            if (d2 < 100.0) {
                super.a("Performance", true, "Performanse odli\u010dne", "Prosje\u010dno vrijeme: " + String.format("%.2f", d3) + "ms po iteraciji", l2);
            } else {
                super.a("Performance", false, "Performanse prespore", "Prosje\u010dno vrijeme: " + String.format("%.2f", d3) + "ms po iteraciji", l2);
            }
        }
        catch (Exception exception) {
            super.a("Performance", false, "Gre\u0161ka pri testiranju performansi", exception.getMessage(), l2);
        }
        this.b();
    }

    public void runXMLTests() {
        boolean bl2;
        Object object;
        Object object2;
        HelperFunctions.log("\ud83d\udd27 Pokretanje XML-specifi\u010dnih testova...");
        if (b == null || b.isEmpty()) {
            HelperFunctions.log("\u274c XML nije dostupan za XML testove");
            return;
        }
        EvidentirajERacunZahtjevTester evidentirajERacunZahtjevTester = this;
        long l2 = System.nanoTime();
        try {
            if (b == null || b.isEmpty()) {
                evidentirajERacunZahtjevTester.a("XSD Validation", false, "Globalni XML rezultat nije dostupan", "globalXmlResult je null ili prazan", l2);
            } else {
                object2 = b;
                object = new XMLtester();
                if (HelperFunctions.isXsdFileNotFoundError((String)(object = ((XMLtester)object).testXmlAgainstXsdFile((String)object2, XSD_PATH)))) {
                    evidentirajERacunZahtjevTester.a("XSD Validation", true, "\nPresko\u010dena jer XSD file " + XSD_PATH + " nije prona\u0111en!", "XSD file nedostaje: " + (String)object, l2);
                } else {
                    boolean bl3 = HelperFunctions.isXsdValidationSuccessful((String)object);
                    bl2 = HelperFunctions.hasXsdValidationErrors((String)object);
                    if (bl3 && !bl2) {
                        evidentirajERacunZahtjevTester.a("XSD Validation", true, "XML uspje\u0161no validiran protiv XSD sheme", "XML je u skladu sa " + XSD_PATH, l2);
                    } else {
                        evidentirajERacunZahtjevTester.a("XSD Validation", false, "XSD validacija neuspje\u0161na", "Rezultat: " + (String)(object != null ? object : "null"), l2);
                    }
                }
            }
        }
        catch (IOException iOException) {
            evidentirajERacunZahtjevTester.a("XSD Validation", false, "IO gre\u0161ka pri XSD validaciji", iOException.getMessage(), l2);
        }
        catch (Exception exception) {
            evidentirajERacunZahtjevTester.a("XSD Validation", false, "Gre\u0161ka pri XSD validaciji", exception.getMessage(), l2);
        }
        evidentirajERacunZahtjevTester = this;
        l2 = System.nanoTime();
        try {
            if (b == null || b.isEmpty()) {
                evidentirajERacunZahtjevTester.a("Schematron Validation", false, "Globalni XML rezultat nije dostupan", "globalXmlResult je null ili prazan", l2);
            } else {
                object2 = b;
                object = new File(SCHEMATRON_XSL_PATH);
                if (!((File)object).exists()) {
                    evidentirajERacunZahtjevTester.a("Schematron Validation", true, "\nPresko\u010dena jer Schematron XSL " + SCHEMATRON_XSL_PATH + " nije prona\u0111en!", "Schematron file nedostaje: " + SCHEMATRON_XSL_PATH, l2);
                } else {
                    object = new XMLtester();
                    object2 = ((XMLtester)object).validateAgainstSchematron((String)object2, SCHEMATRON_XSL_PATH, false);
                    bl2 = ((XMLtester.SchematronValidationResult)object2).isValid();
                    int n2 = ((XMLtester.SchematronValidationResult)object2).getErrors();
                    int n3 = ((XMLtester.SchematronValidationResult)object2).getWarnings();
                    if (bl2 && n2 == 0) {
                        String string = String.format("Pro\u0161lo svih %d pravila", ((XMLtester.SchematronValidationResult)object2).getSuccessfulAssertions());
                        if (((XMLtester.SchematronValidationResult)object2).getWarnings() > 0) {
                            string = string + String.format(" (%d upozorenja)", ((XMLtester.SchematronValidationResult)object2).getWarnings());
                        }
                        evidentirajERacunZahtjevTester.a("Schematron Validation", true, " EvidentirajERacunZahtjev poslovna pravila zadovoljena \n - " + string, "", l2);
                    } else if (n2 > 0) {
                        String string = "Prona\u0111eno " + n2 + " gre\u0161aka";
                        if (n3 > 0) {
                            string = string + " i " + n3 + " upozorenja";
                        }
                        string = string + ":\n" + ((XMLtester.SchematronValidationResult)object2).getErrorMessages();
                        evidentirajERacunZahtjevTester.a("Schematron Validation", false, "Schematron validacija neuspje\u0161na - " + n2, string, l2);
                    } else {
                        evidentirajERacunZahtjevTester.a("Schematron Validation", true, "Schematron validacija uspje\u0161na sa upozorenjima", n3 + " upozorenja prona\u0111eno", l2);
                    }
                }
            }
        }
        catch (Exception exception) {
            evidentirajERacunZahtjevTester.a("Schematron Validation", false, "Gre\u0161ka pri Schematron validaciji", exception.getMessage(), l2);
        }
        HelperFunctions.log("\u2705 XML testovi zavr\u0161eni!");
    }

    private void a(String object, boolean bl2, String string, String string2, long l2) {
        long l3 = System.nanoTime() - l2;
        object = new TestResult(this, (String)object, bl2, string, string2, l3);
        this.c.add((TestResult)object);
        if (bl2) {
            ++this.d;
        } else {
            ++this.e;
        }
        HelperFunctions.log(((TestResult)object).toString());
        if (!bl2 && string2 != null && !string2.isEmpty()) {
            HelperFunctions.log("    Detalji: " + string2);
        }
    }

    private void b() {
        HelperFunctions.log("\n" + HelperFunctions.hr80());
        HelperFunctions.log("\ud83d\udcca REZULTATI TESTOVA");
        HelperFunctions.log(HelperFunctions.hr80());
        HelperFunctions.log("Ukupno testova: " + this.c.size());
        HelperFunctions.log("\u2705 Pro\u0161lo: " + this.d);
        HelperFunctions.log("\u274c Palo: " + this.e);
        double d2 = (double)this.d / (double)this.c.size() * 100.0;
        HelperFunctions.log("Uspje\u0161nost: " + String.format("%.1f", d2) + "%");
        if (this.e > 0) {
            HelperFunctions.log("\n\u274c NEUSPJE\u0160NI TESTOVI:");
            for (TestResult testResult : this.c) {
                if (testResult.isPassed()) continue;
                HelperFunctions.log("  - " + testResult.getTestName() + ": " + testResult.getMessage());
            }
        }
        if (!HelperFunctions.getCallingMethodInfo().contains("utilXMLMethod")) {
            HelperFunctions.log("\n" + HelperFunctions.hr80());
            if (d2 == 100.0) {
                HelperFunctions.log("\ud83c\udf89 SVI TESTOVI USPJE\u0160NI! Template i JSON rade perfektno.");
            } else if (d2 >= 90.0) {
                HelperFunctions.log("\u26a0\ufe0f VE\u0106INA TESTOVA USPJE\u0160NA. Postoje manji problemi.");
            } else {
                HelperFunctions.log("\u274c VELIKI PROBLEMI. Potrebno rje\u0161avanje gre\u0161aka.");
            }
            HelperFunctions.log(HelperFunctions.hr80());
        }
    }

    public static boolean validateJsonData(Map<String, Object> map) {
        try {
            map = HelperFunctions.getCIM(map, "evidentirajeracunzahtjev");
            if (map == null) {
                HelperFunctions.log("Nedostaje EvidentirajERacunZahtjev root element");
                return false;
            }
            boolean bl2 = HelperFunctions.containsKeyCI(map, "zaglavlje");
            boolean bl3 = HelperFunctions.containsKeyCI(map, "eracun");
            if (!bl2 || !bl3) {
                HelperFunctions.log("Nedostaju obavezni elementi (zaglavlje, eRacun)");
                return false;
            }
            HelperFunctions.log("Osnovna struktura eRacuna validna");
            return true;
        }
        catch (Exception exception) {
            HelperFunctions.log("Gre\u0161ka pri validaciji eRacun podataka: " + exception.getMessage());
            return false;
        }
    }

    public static boolean validateXml(String string) {
        try {
            boolean bl2;
            boolean bl3 = string.contains("<?xml") || string.contains("<efis:EvidentirajERacunZahtjev");
            boolean bl4 = string.contains("EvidentirajERacunZahtjev");
            boolean bl5 = string.contains("<efis:Zaglavlje>") || string.contains("Zaglavlje");
            boolean bl6 = bl2 = string.contains("<efis:ERacun>") || string.contains("ERacun");
            if (!(bl3 && bl4 && bl5 && bl2)) {
                HelperFunctions.log("XML struktura eRacuna neispravna");
                return false;
            }
            HelperFunctions.log("XML struktura eRacuna validna");
            return true;
        }
        catch (Exception exception) {
            HelperFunctions.log("Gre\u0161ka pri XML validaciji eRacuna: " + exception.getMessage());
            return false;
        }
    }

    public static void main(String[] object) {
        XmlTemplateFiller xmlTemplateFiller = new XmlTemplateFiller();
        XmlTemplateFiller._config _config2 = new XmlTemplateFiller._config(xmlTemplateFiller);
        new XmlTemplateFiller._config(xmlTemplateFiller).ROOTELEMENT = XmlTemplateFiller.RootElementType.fromString("EvidentirajERacunZahtjev");
        HelperFunctions.clearPrintout();
        object = ((String[])object).length > 0 ? VFileUtils.readFile(object[0]) : VFileUtils.readFile("ULAZNIJSON\\EvidentirajERacunZahtjev_kompletan.json");
        _config2.JSON_CONTENT = object;
        System.out.println(xmlTemplateFiller.RedirectorZadataka((String)object, "TESTIRAJLOGIKU", xmlTemplateFiller, _config2));
    }

    public static void utilXMLMethod(String object, XmlTemplateFiller._config _config2) {
        DEVOUT = false;
        b = object;
        XSD_PATH = _config2.ROOTELEMENT.getXsdPath();
        SCHEMATRON_XSL_PATH = _config2.ROOTELEMENT.getXslPath();
        object = new EvidentirajERacunZahtjevTester();
        ((EvidentirajERacunZahtjevTester)object).runXMLTests();
        super.b();
    }

    public static void utilMethod(XmlTemplateFiller xmlTemplateFiller, XmlTemplateFiller._config _config2) {
        DEVOUT = false;
        XSD_PATH = _config2.ROOTELEMENT.getXsdPath();
        TEMPLATE_PATH = _config2.TEMPLATEPATH;
        SCHEMATRON_XSL_PATH = _config2.ROOTELEMENT.getXslPath();
        EvidentirajERacunZahtjevTester evidentirajERacunZahtjevTester = new EvidentirajERacunZahtjevTester();
        templateContent = _config2.TEMPLATECONTENT;
        jsonContent = _config2.JSON_CONTENT;
        evidentirajERacunZahtjevTester.runAllTests(xmlTemplateFiller, _config2);
    }

    static {
        XSD_PATH = "fiskalizacija20\\eizvjestavanjexsd\\EvidentirajERacunZahtjev.xsd";
        SCHEMATRON_XSL_PATH = "fiskalizacija20\\xsl\\HR-EvidentirajERacunZahtjev-AI.xsl";
        DEVOUT = false;
        templateContent = null;
        jsonContent = null;
        a = null;
        b = null;
    }

    public class TestResult {
        private String a;
        private boolean b;
        private String c;
        private String d;
        private long e;
        private /* synthetic */ EvidentirajERacunZahtjevTester f;

        public TestResult(EvidentirajERacunZahtjevTester evidentirajERacunZahtjevTester, String string, boolean bl2, String string2, String string3, long l2) {
            this.f = evidentirajERacunZahtjevTester;
            this.a = string;
            this.b = bl2;
            this.c = string2;
            this.d = string3;
            this.e = l2;
        }

        public String getTestName() {
            return this.a;
        }

        public boolean isPassed() {
            return this.b;
        }

        public String getMessage() {
            return this.c;
        }

        public String getDetails() {
            return this.d;
        }

        public long getExecutionTime() {
            return this.e;
        }

        public String toString() {
            return String.format("%s %s - %s (%.2fms)", this.b ? "\u2705" : "\u274c", this.a, this.c, (double)this.e / 1000000.0);
        }
    }
}

