/*
 * Decompiled with CFR 0.152.
 */
package fiskalizacija20.testeri;

import UTIL.VFileUtils;
import UTIL.XMLtester;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import fiskalizacija20.XmlTemplateFiller;
import fiskalizacija20.testeri.HelperFunctions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EvidentirajOdbijanjeZahtjevTester {
    public static String XSD_PATH = null;
    public static String TEMPLATE = null;
    public static String JSON_STRING = null;
    public static boolean DEVOUT = false;
    public static String templateContent = null;
    public static String jsonContent = null;
    private static String a;
    private List<TestResult> b = new ArrayList<TestResult>();
    private int c = 0;
    private int d = 0;
    private Map<String, Object> e;

    public void runAllTests(XmlTemplateFiller object, XmlTemplateFiller._config _config2) {
        boolean bl2;
        boolean bl3;
        boolean bl4;
        String string;
        boolean bl5;
        String string2;
        Object object2;
        Object object3;
        Object object4;
        this.a();
        try {
            a = ((XmlTemplateFiller)object).FillTemplate(_config2.JSON_CONTENT, _config2);
            HelperFunctions.log("\u2705 Globalni CreditNote XML uspje\u0161no generiran pomo\u0107u XmlTemplateFiller (" + a.length() + " znakova)");
        }
        catch (Exception exception) {
            HelperFunctions.log("\u274c Prekidam testove zbog gre\u0161ke u generiranju XML-a: " + exception.getMessage());
            return;
        }
        object = this;
        long l2 = System.nanoTime();
        try {
            object4 = new Handlebars();
            object3 = ((Handlebars)object4).compileInline(templateContent);
            if (object3 != null) {
                super.a("Template Compilation", true, "Template uspje\u0161no kompajliran", "Handlebars template spreman za popunjavanje", l2);
            } else {
                super.a("Template Compilation", false, "Template kompilacija vratila null", "Neo\u010dekivani rezultat kompilacije", l2);
            }
        }
        catch (Exception exception) {
            super.a("Template Compilation", false, "Gre\u0161ka pri kompilaciji template-a", exception.getMessage(), l2);
        }
        object = this;
        l2 = System.nanoTime();
        try {
            if (a == null || a.isEmpty()) {
                super.a("Template Processing", false, "Globalni XML rezultat nije dostupan", "globalXmlResult je null ili prazan", l2);
            } else {
                object4 = a;
                object3 = (Map)((EvidentirajOdbijanjeZahtjevTester)object).e.get("evidentirajodbijanjezahtjev");
                object2 = object3 != null ? (Map)object3.get("odbijanje") : null;
                string2 = object2 != null ? (String)object2.get("oibporeznibrojizdavatelja") : null;
                String string3 = object2 != null ? (String)object2.get("razlogodbijanja") : null;
                bl5 = (((String)object4).contains("eizv:id=\"") || ((String)object4).contains("efis:id=\"")) && !((String)object4).contains("{{uuid}}");
                boolean bl6 = bl5 && string2 != null && ((String)object4).contains(string2) && string3 != null && ((String)object4).contains(string3);
                string = object2 != null ? (String)object2.get("oibporeznibrojprimatelja") : null;
                bl4 = bl5 && string2 != null && ((String)object4).contains(string2) && string != null && ((String)object4).contains(string);
                boolean bl7 = ((String)object4).contains("{{") && ((String)object4).contains("}}");
                bl3 = bl6 && ((String)object4).length() > 300;
                boolean bl8 = bl2 = bl4 && !bl7;
                if (bl3 && bl2) {
                    super.a("Template Processing", true, "Template procesiranje uspje\u0161no", "Rezultat: " + ((String)object4).length() + " znakova, Handlebars i popunjavanje rade", l2);
                } else {
                    super.a("Template Processing", false, "Template procesiranje ima gre\u0161ke", "Filling=" + bl3 + ", Handlebars=" + bl2 + ", Unfilled=" + bl7, l2);
                }
            }
        }
        catch (Exception exception) {
            super.a("Template Processing", false, "Gre\u0161ka pri template procesiranju", exception.getMessage(), l2);
        }
        object = this;
        l2 = System.nanoTime();
        try {
            if (((EvidentirajOdbijanjeZahtjevTester)object).e == null) {
                super.a("Business Validation", false, "Globalni JSON nije dostupan", "globalJsonData je null", l2);
            } else {
                object4 = (Map)((EvidentirajOdbijanjeZahtjevTester)object).e.get("evidentirajodbijanjezahtjev");
                Object object5 = (Map)object4.get("odbijanje");
                object2 = (String)object5.get("oibporeznibrojizdavatelja");
                string2 = (String)object5.get("oibporeznibrojprimatelja");
                boolean bl9 = HelperFunctions.isValidOIB((String)object2);
                bl5 = HelperFunctions.isValidOIB(string2);
                String string4 = (String)object5.get("datumizdavanja");
                string = (String)object5.get("datumodbijanja");
                bl4 = string.compareTo(string4) >= 0;
                object5 = (String)object5.get("razlogodbijanja");
                bl3 = object5 != null && !((String)object5).trim().isEmpty();
                bl2 = object2 != null && string2 != null && !((String)object2).equals(string2);
                boolean bl10 = string != null && string4 != null && string.compareTo(string4) >= 0;
                boolean bl11 = object5 != null && ((String)object5).trim().length() >= 3 && ((String)object5).length() <= 500;
                ArrayList<String> arrayList = new ArrayList<String>();
                if (!bl9) {
                    arrayList.add("OIB izdavatelja (" + (String)(object2 != null ? object2 : "null") + ") nije validan");
                }
                if (!bl5) {
                    arrayList.add("OIB primatelja (" + (string2 != null ? string2 : "null") + ") nije validan");
                }
                if (!bl4) {
                    arrayList.add("Datum odbijanja (" + string + ") mora biti nakon datuma izdavanja (" + string4 + ")");
                }
                if (!bl3) {
                    arrayList.add("Razlog odbijanja ne smije biti prazan ili null");
                }
                if (!bl2) {
                    arrayList.add("OIB izdavatelja i primatelja moraju biti razli\u010diti (trenutno su isti: " + (String)object2 + ")");
                }
                if (!bl10) {
                    arrayList.add("Datum odbijanja mora biti jednak ili nakon datuma izdavanja");
                }
                if (!bl11) {
                    if (object5 == null) {
                        arrayList.add("Razlog odbijanja ne smije biti null");
                    } else if (((String)object5).trim().length() < 3) {
                        arrayList.add("Razlog odbijanja mora imati najmanje 3 karaktera (trenutno: " + ((String)object5).length() + ")");
                    } else if (((String)object5).length() > 500) {
                        arrayList.add("Razlog odbijanja ne smije biti du\u017ei od 500 karaktera (trenutno: " + ((String)object5).length() + ")");
                    }
                }
                if (arrayList.isEmpty()) {
                    super.a("Business Validation", true, "Sva business validacija uspje\u0161na", "Svi uvjeti validacije su zadovoljeni", l2);
                } else {
                    string4 = String.join((CharSequence)"; ", arrayList);
                    super.a("Business Validation", false, "Business validacija ima " + arrayList.size() + " gre\u0161aka", string4, l2);
                }
            }
        }
        catch (Exception exception) {
            super.a("Business Validation", false, "Gre\u0161ka pri business validaciji", exception.getMessage(), l2);
        }
        this.runXMLTests();
        object = this;
        l2 = System.nanoTime();
        try {
            Map map = (Map)((EvidentirajOdbijanjeZahtjevTester)object).e.get("evidentirajodbijanjezahtjev");
            Object object6 = (Map)map.get("odbijanje");
            object2 = (String)object6.get("razlogodbijanja");
            boolean bl12 = object2 != null && ((String)object2).length() >= 5;
            String string5 = (String)object6.get("datumizdavanja");
            bl5 = string5.matches("\\d{4}-\\d{2}-\\d{2}");
            String string6 = (String)object6.get("oibporeznibrojizdavatelja");
            string = (String)object6.get("oibporeznibrojprimatelja");
            bl4 = string6.length() == 11 && string.length() == 11;
            object6 = (String)object6.get("brojdokumenta");
            boolean bl13 = bl3 = object6 != null && !((String)object6).trim().isEmpty();
            if (bl12 && bl5 && bl4 && bl3) {
                super.a("Edge Cases", true, "Edge cases pravilno obra\u0111eni", "Minimalna du\u017eina razloga, format datuma, du\u017eina OIB-a i broj dokumenta ispravni", l2);
            } else {
                super.a("Edge Cases", false, "Problemi sa edge cases", "RazlogMin=" + bl12 + ", DatumFormat=" + bl5 + ", OIBLength=" + bl4 + ", BrojDok=" + bl3, l2);
            }
        }
        catch (Exception exception) {
            super.a("Edge Cases", false, "Gre\u0161ka pri testiranju edge cases", exception.getMessage(), l2);
        }
        object = this;
        l2 = System.nanoTime();
        try {
            double d2;
            long l3 = System.nanoTime();
            for (int i2 = 0; i2 < 10; ++i2) {
                Handlebars handlebars = new Handlebars();
                Template template = handlebars.compileInline(templateContent);
                template.apply(((EvidentirajOdbijanjeZahtjevTester)object).e);
            }
            long l4 = System.nanoTime() - l3;
            double d3 = (double)l4 / 10.0 / 1000000.0;
            if (d2 < 50.0) {
                super.a("Performance", true, "Performanse odli\u010dne", "Prosje\u010dno vrijeme: " + String.format("%.2f", d3) + "ms po iteraciji", l2);
            } else {
                super.a("Performance", false, "Performanse prespore", "Prosje\u010dno vrijeme: " + String.format("%.2f", d3) + "ms po iteraciji", l2);
            }
        }
        catch (Exception exception) {
            super.a("Performance", false, "Gre\u0161ka pri testiranju performansi", exception.getMessage(), l2);
        }
        this.b();
    }

    public void runXMLTests() {
        Object object;
        EvidentirajOdbijanjeZahtjevTester evidentirajOdbijanjeZahtjevTester = this;
        long l2 = System.nanoTime();
        try {
            if (a == null || a.isEmpty()) {
                evidentirajOdbijanjeZahtjevTester.a("XSD Validation", false, "Globalni XML rezultat nije dostupan", "globalXmlResult je null ili prazan", l2);
            } else {
                String string = a;
                object = new XMLtester();
                if (HelperFunctions.isXsdFileNotFoundError(string = ((XMLtester)object).testXmlAgainstXsdFile(string, XSD_PATH))) {
                    evidentirajOdbijanjeZahtjevTester.a("XSD Validation", true, "\nPresko\u010dena jer XSD file " + XSD_PATH + " nije prona\u0111en!", "XSD file nedostaje: " + string, l2);
                } else {
                    boolean bl2 = HelperFunctions.isXsdValidationSuccessful(string);
                    boolean bl3 = HelperFunctions.hasXsdValidationErrors(string);
                    if (bl2 && !bl3) {
                        evidentirajOdbijanjeZahtjevTester.a("XSD Validation", true, "XML uspje\u0161no validiran protiv XSD sheme", "XML je u skladu sa " + XSD_PATH, l2);
                    } else {
                        evidentirajOdbijanjeZahtjevTester.a("XSD Validation", false, "XSD validacija neuspje\u0161na", "Rezultat: " + (string != null ? string.substring(0, Math.min(200, string.length())) : "null"), l2);
                    }
                }
            }
        }
        catch (IOException iOException) {
            evidentirajOdbijanjeZahtjevTester.a("XSD Validation", false, "IO gre\u0161ka pri XSD validaciji", iOException.getMessage(), l2);
        }
        catch (Exception exception) {
            evidentirajOdbijanjeZahtjevTester.a("XSD Validation", false, "Gre\u0161ka pri XSD validaciji", exception.getMessage(), l2);
        }
        evidentirajOdbijanjeZahtjevTester = this;
        l2 = System.nanoTime();
        try {
            Files.readAllBytes(Paths.get("nonexistent-template.xml", new String[0]));
            evidentirajOdbijanjeZahtjevTester.a("Error Handling", false, "Nije uhva\u0107ena gre\u0161ka za nepostoje\u0107i template", "Treba baciti IOException", l2);
            return;
        }
        catch (IOException iOException) {
            try {
                object = HelperFunctions.createCaseInsensitiveObjectMapper();
                ((ObjectMapper)object).readValue("{invalid json", Map.class);
                evidentirajOdbijanjeZahtjevTester.a("Error Handling", false, "Nije uhva\u0107ena gre\u0161ka za neispravni JSON", "Treba baciti JsonProcessingException", l2);
                return;
            }
            catch (Exception exception) {
                evidentirajOdbijanjeZahtjevTester.a("Error Handling", true, "Gre\u0161ke se pravilno hvataju", "IOException i JsonProcessingException uhva\u0107eni", l2);
                return;
            }
        }
    }

    private boolean a() {
        try {
            if (jsonContent == null || jsonContent.isEmpty()) {
                HelperFunctions.log("\u274c JSON sadr\u017eaj nije dostupan za inicijalizaciju");
                return false;
            }
            Object object = HelperFunctions.createCaseInsensitiveObjectMapper();
            object = ((ObjectMapper)object).readValue(jsonContent, Map.class);
            this.e = HelperFunctions.convertKeysToLowercase((Map<String, Object>)object);
            HelperFunctions.log("\u2705 Globalni JSON uspje\u0161no inicijalizovan");
            return true;
        }
        catch (Exception exception) {
            HelperFunctions.log("\u274c Gre\u0161ka pri inicijalizaciji globalnog JSON-a: " + exception.getMessage());
            this.e = null;
            return false;
        }
    }

    private void a(String object, boolean bl2, String string, String string2, long l2) {
        long l3 = System.nanoTime() - l2;
        object = new TestResult(this, (String)object, bl2, string, string2, l3);
        this.b.add((TestResult)object);
        if (bl2) {
            ++this.c;
        } else {
            ++this.d;
        }
        HelperFunctions.log(((TestResult)object).toString());
        if (!bl2 && string2 != null && !string2.isEmpty()) {
            HelperFunctions.log("    Detalji: " + string2);
        }
    }

    private void b() {
        HelperFunctions.log("\n" + HelperFunctions.hr80());
        HelperFunctions.log("\ud83d\udcca REZULTATI TESTOVA");
        HelperFunctions.log(HelperFunctions.hr80());
        HelperFunctions.log("Ukupno testova: " + this.b.size());
        HelperFunctions.log("\u2705 Pro\u0161lo: " + this.c);
        HelperFunctions.log("\u274c Palo: " + this.d);
        double d2 = (double)this.c / (double)this.b.size() * 100.0;
        HelperFunctions.log("Uspje\u0161nost: " + String.format("%.1f", d2) + "%");
        if (this.d > 0) {
            HelperFunctions.log("\n\u274c NEUSPJE\u0160NI TESTOVI:");
            for (TestResult testResult : this.b) {
                if (testResult.isPassed()) continue;
                HelperFunctions.log("  - " + testResult.getTestName() + ": " + testResult.getMessage());
            }
        }
        HelperFunctions.log("\n" + HelperFunctions.hr80());
        if (!HelperFunctions.getCallingMethodInfo().contains("utilXMLMethod")) {
            if (d2 >= 90.0) {
                HelperFunctions.log("\ud83c\udf89 SVI TESTOVI USPJE\u0160NI! Template i JSON rade perfektno.");
            } else if (d2 >= 75.0) {
                HelperFunctions.log("\u26a0\ufe0f VE\u0106INA TESTOVA USPJE\u0160NA. Postoje manji problemi.");
            } else {
                HelperFunctions.log("\u274c VELIKI PROBLEMI. Potrebno rje\u0161avanje gre\u0161aka.");
            }
            HelperFunctions.log(HelperFunctions.hr80());
        }
    }

    public static boolean validateJsonData(Map<String, Object> map) {
        try {
            map = (Map)map.get("evidentirajodbijanjezahtjev");
            if (map == null) {
                HelperFunctions.log("Nedostaje EvidentirajOdbijanjeZahtjev root element");
                return false;
            }
            boolean bl2 = map.containsKey("zaglavlje");
            boolean bl3 = map.containsKey("odbijanje");
            if (!bl2 || !bl3) {
                HelperFunctions.log("Nedostaju obavezni elementi (zaglavlje, odbijanje)");
                return false;
            }
            Map map2 = (Map)map.get("zaglavlje");
            if (map2 != null && !map2.containsKey("datumvrijemeslanja")) {
                HelperFunctions.log("Nedostaje datumVrijemeSlanja u zaglavlju");
                return false;
            }
            if ((map = (Map)map.get("odbijanje")) != null) {
                if (!map.containsKey("brojracuna") && !map.containsKey("brojdokumenta")) {
                    HelperFunctions.log("Nedostaje brojracuna ili brojdokumenta u odbijanju");
                    return false;
                }
                if (!map.containsKey("razlogodbijanja")) {
                    HelperFunctions.log("Nedostaje razlogodbijanja u odbijanju");
                    return false;
                }
            }
            HelperFunctions.log("Osnovna struktura odbijanja validna (validacija putem tester klase)");
            return true;
        }
        catch (Exception exception) {
            HelperFunctions.log("Greska pri validaciji odbijanje podataka: " + exception.getMessage());
            return false;
        }
    }

    public static boolean validateXml(String string) {
        try {
            boolean bl2;
            boolean bl3 = string.contains("<eizv:EvidentirajOdbijanjeZahtjev");
            boolean bl4 = string.contains("EvidentirajOdbijanjeZahtjev");
            boolean bl5 = string.contains("<eizv:Zaglavlje>") || string.contains("Zaglavlje");
            boolean bl6 = bl2 = string.contains("<eizv:Odbijanje>") || string.contains("Odbijanje");
            if (!(bl3 && bl4 && bl5 && bl2)) {
                HelperFunctions.log("XML struktura odbijanja neispravna");
                return false;
            }
            if (!string.contains("brojRacuna") && !string.contains("brojDokumenta")) {
                HelperFunctions.log("XML nedostaju obavezni elementi brojRacuna ili brojDokumenta");
                return false;
            }
            if (!string.contains("razlogoOdbijanja")) {
                HelperFunctions.log("XML nedostaje obavezni element razlogOdbijanja");
                return false;
            }
            HelperFunctions.log("XML struktura odbijanja validna (validacija putem tester klase)");
            return true;
        }
        catch (Exception exception) {
            HelperFunctions.log("Greska pri XML validaciji odbijanja: " + exception.getMessage());
            return false;
        }
    }

    public static void main(String[] object) {
        XmlTemplateFiller xmlTemplateFiller = new XmlTemplateFiller();
        XmlTemplateFiller._config _config2 = new XmlTemplateFiller._config(xmlTemplateFiller);
        new XmlTemplateFiller._config(xmlTemplateFiller).ROOTELEMENT = XmlTemplateFiller.RootElementType.fromString("EvidentirajOdbijanjeZahtjev");
        HelperFunctions.clearPrintout();
        object = ((String[])object).length > 0 ? VFileUtils.readFile(object[0]) : VFileUtils.readFile("ULAZNIJSON\\EvidentirajOdbijanjeZahtjev.json");
        _config2.JSON_CONTENT = object;
        System.out.println(xmlTemplateFiller.RedirectorZadataka((String)object, "TESTIRAJLOGIKU", xmlTemplateFiller, _config2));
    }

    public static void utilXMLMethod(String object, XmlTemplateFiller._config _config2) {
        DEVOUT = false;
        a = object;
        XSD_PATH = _config2.ROOTELEMENT.getXsdPath();
        object = new EvidentirajOdbijanjeZahtjevTester();
        ((EvidentirajOdbijanjeZahtjevTester)object).runXMLTests();
        super.b();
    }

    public static void utilMethod(XmlTemplateFiller xmlTemplateFiller, XmlTemplateFiller._config _config2) {
        DEVOUT = false;
        XSD_PATH = _config2.ROOTELEMENT.getXsdPath();
        EvidentirajOdbijanjeZahtjevTester evidentirajOdbijanjeZahtjevTester = new EvidentirajOdbijanjeZahtjevTester();
        templateContent = _config2.TEMPLATECONTENT;
        jsonContent = _config2.JSON_CONTENT;
        evidentirajOdbijanjeZahtjevTester.runAllTests(xmlTemplateFiller, _config2);
    }

    public class TestResult {
        private String a;
        private boolean b;
        private String c;
        private String d;
        private long e;
        private /* synthetic */ EvidentirajOdbijanjeZahtjevTester f;

        public TestResult(EvidentirajOdbijanjeZahtjevTester evidentirajOdbijanjeZahtjevTester, String string, boolean bl2, String string2, String string3, long l2) {
            this.f = evidentirajOdbijanjeZahtjevTester;
            this.a = string;
            this.b = bl2;
            this.c = string2;
            this.d = string3;
            this.e = l2;
        }

        public String getTestName() {
            return this.a;
        }

        public boolean isPassed() {
            return this.b;
        }

        public String getMessage() {
            return this.c;
        }

        public String getDetails() {
            return this.d;
        }

        public long getExecutionTime() {
            return this.e;
        }

        public String toString() {
            return String.format("%s %s - %s (%.2fms)", this.b ? "\u2705" : "\u274c", this.a, this.c, (double)this.e / 1000000.0);
        }
    }
}

