/*
 * Decompiled with CFR 0.152.
 */
package fiskalizacija20.testeri;

import UTIL.VFileUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import fiskalizacija.HrFiskalizator;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class HelperFunctions {
    private static final StringBuilder a = new StringBuilder();
    public static final int DECIMAL_PRECISION = 2;
    public static final RoundingMode ROUNDING_MODE = RoundingMode.HALF_UP;

    public static void log(String string) {
        a.append(string).append("\n");
    }

    public static void clearPrintout() {
        a.setLength(0);
    }

    public static String getPrintout() {
        return a.toString();
    }

    public static void savePrintoutToFile(String string) {
        try {
            if (!HelperFunctions.ensureDirectoryExists(string)) {
                return;
            }
            Files.write(Paths.get(string, new String[0]), a.toString().getBytes("UTF-8"), new OpenOption[0]);
            System.out.println("Printout sa\u010duvan u: " + string);
            return;
        }
        catch (IOException iOException) {
            System.err.println("Gre\u0161ka pri \u010duvanju printout fajla: " + iOException.getMessage());
            return;
        }
    }

    public static byte[] getPrintoutUtf8Bytes() {
        try {
            return a.toString().getBytes("UTF-8");
        }
        catch (Exception exception) {
            System.err.println("Gre\u0161ka pri konverziji u UTF-8: " + exception.getMessage());
            return a.toString().getBytes();
        }
    }

    public static boolean ensureDirectoryExists(String object) {
        try {
            object = new File((String)object);
            object = ((File)object).getParentFile();
            if (object != null && !((File)object).exists()) {
                boolean bl2 = ((File)object).mkdirs();
                if (bl2) {
                    HelperFunctions.log("Kreiran direktorij: " + ((File)object).getAbsolutePath());
                    return true;
                }
                HelperFunctions.log("Nije mogu\u0107e kreirati direktorij: " + ((File)object).getAbsolutePath());
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            HelperFunctions.log("Gre\u0161ka pri provjeri direktorija: " + exception.getMessage());
            return false;
        }
    }

    public static Map<String, Object> initializeJsonData(String map) {
        try {
            ObjectMapper objectMapper = HelperFunctions.createCaseInsensitiveObjectMapper();
            map = objectMapper.readValue((String)((Object)map), Map.class);
            map = HelperFunctions.convertKeysToLowercase(map);
            HelperFunctions.log("\u2713 Globalni JSON uspje\u0161no inicijalizovan i konvertovan u lowercase");
            return map;
        }
        catch (Exception exception) {
            HelperFunctions.log("\u2717 Gre\u0161ka pri inicijalizaciji globalnog JSON-a: " + exception.getMessage());
            return null;
        }
    }

    public static String generateXmlFromTemplate(String object, Map<String, Object> map) {
        try {
            Handlebars handlebars = new Handlebars();
            object = handlebars.compileInline((String)object);
            object = object.apply(map);
            HelperFunctions.log("\u2713 Globalni XML uspje\u0161no generisan (" + ((String)object).length() + " znakova)");
            return object;
        }
        catch (Exception exception) {
            HelperFunctions.log("\u2717 Gre\u0161ka pri generisanju globalnog XML-a: " + exception.getMessage());
            return null;
        }
    }

    public static Map<String, String> setStandardFilePaths(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            if (HrFiskalizator.p != null && HrFiskalizator.p.getProperty("RADNIFOLDER") != null) {
                String string2 = HrFiskalizator.p.getProperty("RADNIFOLDER") + "\\";
                hashMap.put("OUTPUT_DIR", string2 + "AI\\OUTPUT\\");
                hashMap.put("TEMPLATE_PATH", string2 + "f2templates\\" + string);
                hashMap.put("JSON_PATH", string2 + "Simple_UBL_Invoice_Example.json");
                hashMap.put("XSD_PATH", string2 + "eracunxsd\\maindoc\\UBL-Invoice-2.1.xsd");
            } else {
                hashMap.put("OUTPUT_DIR", "");
                hashMap.put("TEMPLATE_PATH", "f2templates\\" + string);
                hashMap.put("JSON_PATH", "Simple_UBL_Invoice_Example.json");
                hashMap.put("XSD_PATH", "eracunxsd\\maindoc\\UBL-Invoice-2.1.xsd");
            }
        }
        catch (Exception exception) {
            HelperFunctions.log("Gre\u0161ka pri postavljanju file putanja: " + exception.getMessage());
        }
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Object> convertKeysToLowercase(Map<String, Object> object) {
        if (object == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry entry : object.entrySet()) {
            void list;
            String string = ((String)entry.getKey()).toLowerCase();
            Object v2 = entry.getValue();
            if (v2 instanceof Map) {
                Map<String, Object> map = HelperFunctions.convertKeysToLowercase((Map)v2);
            } else if (v2 instanceof List) {
                List<Object> list2 = HelperFunctions.convertListKeysToLowercase((List)v2);
            }
            hashMap.put(string, list);
        }
        return hashMap;
    }

    public static List<Object> convertListKeysToLowercase(List<Object> object) {
        if (object == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (e2 instanceof Map) {
                arrayList.add(HelperFunctions.convertKeysToLowercase((Map)e2));
                continue;
            }
            arrayList.add(e2);
        }
        return arrayList;
    }

    public static String detectJsonFile(String fileArray) {
        if (!(fileArray = new File((String)fileArray)).exists() || !fileArray.isDirectory()) {
            return null;
        }
        if ((fileArray = fileArray.listFiles((file, string) -> string.endsWith(".json"))) == null || fileArray.length == 0) {
            return null;
        }
        return fileArray[0].getAbsolutePath();
    }

    public static String setTemplateContent(String string, String string2) {
        String string3 = null;
        try {
            string3 = string == null ? VFileUtils.readFile(string2) : string;
        }
        catch (IOException iOException) {
            HrFiskalizator.logger.log(Level.SEVERE, iOException.getMessage());
        }
        return string3;
    }

    public static String setJsonContent(String string, String string2) {
        String string3 = null;
        try {
            if (string == null) {
                VFileUtils.readFile(string2);
            } else {
                string3 = string;
            }
        }
        catch (IOException iOException) {
            HrFiskalizator.logger.log(Level.SEVERE, iOException.getMessage());
        }
        return string3;
    }

    public static String removeEmptyLines(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return string.replaceAll("(?m)^\\s*$[\r\n]*", "").replaceAll("(?m)^[ \t]+$[\r\n]*", "").replaceAll("\n\n+", "\n");
    }

    public static String removeXmlComments(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return string.replaceAll("(?s)<!--.*?-->", "").replaceAll("(?m)^\\s*$[\r\n]*", "");
    }

    public static boolean isValidKPDCode(String string, Map<String, Map<String, Object>> map) {
        if (string == null || string.trim().isEmpty()) {
            return false;
        }
        if (map.containsKey(string = string.trim())) {
            return true;
        }
        return !string.startsWith("A") && map.containsKey("A" + string);
    }

    public static String findSimilarKPDCodes(String string, Map<String, Map<String, Object>> map) {
        ArrayList<String> arrayList = new ArrayList<String>();
        string = string.replaceAll("[^0-9.]", "");
        for (String string2 : map.keySet()) {
            Object object = map.get(string2);
            object = (String)object.get("name");
            if (string.length() < 4 || !string2.contains(string.substring(0, 4))) continue;
            arrayList.add(string2 + " (" + (String)object + ")");
            if (arrayList.size() < 3) continue;
        }
        return String.join((CharSequence)", ", arrayList);
    }

    public static boolean isValidOIB(String string) {
        if (string == null || string.trim().isEmpty()) {
            return false;
        }
        if ((string = string.trim()).length() != 11) {
            return false;
        }
        if (!string.matches("\\d{11}")) {
            return false;
        }
        return HelperFunctions.validateOIBChecksum(string);
    }

    public static TestResult addTestResult(String object, boolean bl2, String string, String string2, long l2, List<TestResult> list) {
        long l3 = System.nanoTime() - l2;
        object = new TestResult((String)object, bl2, string, string2, l3);
        if (list != null) {
            list.add((TestResult)object);
        }
        HelperFunctions.log(((TestResult)object).toString());
        if (!bl2 && string2 != null && !string2.isEmpty()) {
            HelperFunctions.log("    Detalji: " + string2);
        }
        return object;
    }

    public static void logSuccess(String string, String string2) {
        HelperFunctions.log("[PASS] " + string + " - " + string2);
    }

    public static void logError(String string, String string2) {
        HelperFunctions.log("[FAIL] " + string + " - " + string2);
    }

    public static void logTiming(String string, long l2, long l3) {
        double d2 = (double)(l3 - l2) / 1000000.0;
        HelperFunctions.log("\u23f1\ufe0f " + string + " izvr\u0161en za " + String.format("%.2f", d2) + "ms");
    }

    public static void printTestSummary(List<TestResult> object) {
        if (object == null || object.isEmpty()) {
            HelperFunctions.log("Nema test rezultata za prikaz");
            return;
        }
        int n2 = 0;
        int n3 = 0;
        Iterator<TestResult> iterator = object.iterator();
        while (iterator.hasNext()) {
            TestResult testResult = iterator.next();
            if (testResult.isPassed()) {
                ++n2;
                continue;
            }
            ++n3;
        }
        HelperFunctions.log("\n" + HelperFunctions.hr80());
        HelperFunctions.log("\ud83d\udcca REZULTATI TESTOVA (OPTIMIZOVANA VERZIJA)");
        HelperFunctions.log(HelperFunctions.hr80());
        HelperFunctions.log("Ukupno testova: " + object.size());
        HelperFunctions.log("\u2705 Pro\u0161lo: " + n2);
        HelperFunctions.log("\u274c Palo: " + n3);
        double d2 = (double)n2 / (double)object.size() * 100.0;
        HelperFunctions.log("Uspje\u0161nost: " + String.format("%.1f", d2) + "%");
        if (n3 > 0) {
            HelperFunctions.log("\n\u274c NEUSPJE\u0160NI TESTOVI:");
            object = object.iterator();
            while (object.hasNext()) {
                TestResult testResult = (TestResult)object.next();
                if (testResult.isPassed()) continue;
                HelperFunctions.log("  - " + testResult.getTestName() + ": " + testResult.getMessage());
            }
        }
        HelperFunctions.log("\n" + HelperFunctions.hr80());
        if (d2 == 100.0) {
            HelperFunctions.log("\ud83c\udf89 SVI TESTOVI USPJE\u0160NI! Template i JSON rade perfektno.");
        } else if (d2 >= 90.0) {
            HelperFunctions.log("\u26a0\ufe0f VE\u0106INA TESTOVA USPJE\u0160NA. Postoje manji problemi.");
        } else {
            HelperFunctions.log("\u274c VELIKI PROBLEMI. Potrebno rje\u0161avanje gre\u0161aka.");
        }
        HelperFunctions.log(HelperFunctions.hr80());
    }

    public static String loadFileContent(String string) {
        try {
            return VFileUtils.readFile(string);
        }
        catch (IOException iOException) {
            HelperFunctions.log("Gre\u0161ka pri u\u010ditavanju fajla " + string + ": " + iOException.getMessage());
            return null;
        }
    }

    public static boolean validateFileExists(String string) {
        if (string == null || string.trim().isEmpty()) {
            HelperFunctions.log("File path je null ili prazan");
            return false;
        }
        File file = new File(string);
        boolean bl2 = file.exists() && file.isFile();
        if (!bl2) {
            HelperFunctions.log("Fajl ne postoji: " + string);
        }
        return bl2;
    }

    public static String loadTemplateContent(String string, String string2) {
        if (string != null && !string.trim().isEmpty()) {
            HelperFunctions.log("Koristi direktan template sadr\u017eaj");
            return string;
        }
        if (HelperFunctions.validateFileExists(string2) && (string = HelperFunctions.loadFileContent(string2)) != null) {
            HelperFunctions.log("Template uspe\u0161no u\u010ditan iz: " + string2);
            return string;
        }
        HelperFunctions.log("Nije mogu\u0107e u\u010ditati template ni iz template stringa ni iz fajla");
        return null;
    }

    public static String loadJsonContent(String string, String string2) {
        if (string != null && !string.trim().isEmpty()) {
            HelperFunctions.log("Koristi direktan JSON sadr\u017eaj");
            return string;
        }
        if (HelperFunctions.validateFileExists(string2) && (string = HelperFunctions.loadFileContent(string2)) != null) {
            HelperFunctions.log("JSON uspe\u0161no u\u010ditan iz: " + string2);
            return string;
        }
        HelperFunctions.log("Nije mogu\u0107e u\u010ditati JSON ni iz JSON stringa ni iz fajla");
        return null;
    }

    public static String processHandlebarsTemplate(String object, Map<String, Object> map) {
        try {
            Handlebars handlebars = new Handlebars();
            object = handlebars.compileInline((String)object);
            return object.apply(map);
        }
        catch (Exception exception) {
            HelperFunctions.log("Gre\u0161ka pri procesiranju Handlebars template-a: " + exception.getMessage());
            return null;
        }
    }

    public static Template compileHandlebarsTemplate(String string) {
        try {
            Handlebars handlebars = new Handlebars();
            return handlebars.compileInline(string);
        }
        catch (Exception exception) {
            HelperFunctions.log("Gre\u0161ka pri kompajliranju Handlebars template-a: " + exception.getMessage());
            return null;
        }
    }

    public static boolean testTemplateCompilation(String object) {
        return (object = HelperFunctions.compileHandlebarsTemplate((String)object)) != null;
    }

    public static boolean testTemplateProcessing(String string, Map<String, Object> map) {
        return (string = HelperFunctions.processHandlebarsTemplate(string, map)) != null && !string.trim().isEmpty();
    }

    public static String hr80() {
        return HelperFunctions.repeatString("=", 80);
    }

    public static String getCallingMethodInfo() {
        Object object = Thread.currentThread().getStackTrace();
        if (((StackTraceElement[])object).length > 3) {
            object = object[3];
            String string = ((StackTraceElement)object).getClassName();
            string = string.substring(string.lastIndexOf(46) + 1);
            String string2 = ((StackTraceElement)object).getMethodName();
            int n2 = ((StackTraceElement)object).getLineNumber();
            return String.format("%s.%s() (linija %d)", string, string2, n2);
        }
        return "unknown";
    }

    public static String getCallingMethodName() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray.length > 3) {
            return stackTraceElementArray[3].getMethodName();
        }
        return "unknown";
    }

    public static String getCallingClassName() {
        Object object = Thread.currentThread().getStackTrace();
        if (((StackTraceElement[])object).length > 3) {
            object = object[3].getClassName();
            return ((String)object).substring(((String)object).lastIndexOf(46) + 1);
        }
        return "unknown";
    }

    public static StackTraceElement getCallingStackElement() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray.length > 3) {
            return stackTraceElementArray[3];
        }
        return null;
    }

    public static String repeatString(String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static ObjectMapper createCaseInsensitiveObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS, true);
        return objectMapper;
    }

    public static boolean isValidCurrencyFormat(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        Pattern pattern = Pattern.compile("^\\d+\\.\\d{2}$");
        return pattern.matcher(string).matches();
    }

    public static boolean isValidPercentageFormat(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        Pattern pattern = Pattern.compile("^\\d+(\\.\\d{1,2})?$");
        return pattern.matcher(string).matches();
    }

    public static List<String> validateXmlAgainstXsd(String string, String object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            File file = new File((String)object);
            if (!file.exists()) {
                arrayList.add("XSD fajl ne postoji: " + (String)object);
                return arrayList;
            }
            object = schemaFactory.newSchema(file);
            object = ((Schema)object).newValidator();
            ((Validator)object).setErrorHandler(new ErrorHandler(arrayList){
                private /* synthetic */ List a;
                {
                    this.a = list;
                }

                @Override
                public final void warning(SAXParseException sAXParseException) {
                    if (!sAXParseException.getMessage().contains("schemaLocation")) {
                        this.a.add("WARNING: " + sAXParseException.getMessage());
                    }
                }

                @Override
                public final void error(SAXParseException sAXParseException) {
                    this.a.add("ERROR: " + sAXParseException.getMessage());
                }

                @Override
                public final void fatalError(SAXParseException sAXParseException) {
                    this.a.add("FATAL: " + sAXParseException.getMessage());
                }
            });
            ((Validator)object).validate(new StreamSource(new StringReader(string)));
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            if (exception.getMessage() != null && exception2.getMessage().contains("schemaLocation")) {
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setNamespaceAware(true);
                    documentBuilderFactory.setValidating(false);
                    object = documentBuilderFactory.newDocumentBuilder();
                    object = ((DocumentBuilder)object).parse(new InputSource(new StringReader(string)));
                    if (object != null) {
                        return arrayList;
                    }
                }
                catch (Exception exception3) {
                    arrayList.add("Alternative validation failed: " + exception3.getMessage());
                }
            }
            arrayList.add("Exception during validation: " + exception2.getMessage());
        }
        return arrayList;
    }

    public static boolean checkJsonPath(JsonNode jsonNode, String stringArray) {
        for (String string : stringArray.split("\\.")) {
            if (jsonNode == null || !jsonNode.has(string)) {
                return false;
            }
            jsonNode = jsonNode.get(string);
        }
        return jsonNode != null;
    }

    public static Double parseCurrencyStrict(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return null;
        }
        if (object instanceof String) {
            if (!((String)(object = ((String)object).trim())).matches("^\\d+\\.\\d{2}$")) {
                return null;
            }
            try {
                object = new BigDecimal((String)object);
                return ((BigDecimal)object).doubleValue();
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    public static boolean isValidEmail(String string) {
        if (string == null || string.trim().isEmpty()) {
            return false;
        }
        String string2 = "^[a-zA-Z0-9_+&*-]+(?:\\.[a-zA-Z0-9_+&*-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,7}$";
        return string.matches(string2);
    }

    public static boolean isValidCroatianPostalCode(String string) {
        if (string == null || string.length() != 5) {
            return false;
        }
        try {
            int n2 = Integer.parseInt(string);
            return n2 >= 10000 && n2 <= 53296;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isValidCroatianVATRate(double d2) {
        return d2 == 0.0 || d2 == 5.0 || d2 == 13.0 || d2 == 25.0;
    }

    public static void formatNumericValues(Map<String, Object> object) {
        for (Map.Entry entry : object.entrySet()) {
            Object object2 = entry.getValue();
            if (object2 instanceof Number) {
                object2 = HelperFunctions.formatNumberToTwoDecimals((Number)object2);
                entry.setValue(object2);
                continue;
            }
            if (object2 instanceof Map) {
                HelperFunctions.formatNumericValues((Map)object2);
                continue;
            }
            if (!(object2 instanceof List)) continue;
            HelperFunctions.formatNumericValuesInList((List)object2);
        }
    }

    public static String formatNumberToTwoDecimals(Number object) {
        if (!(object = String.valueOf(object)).contains(".")) {
            return object;
        }
        object = object.split("\\.");
        String string = object[0];
        if ((object = object[1]).length() == 1) {
            object = (String)object + "0";
        }
        return string + "." + (String)object;
    }

    public static void formatNumericValuesInList(List<Object> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object object = list.get(i2);
            if (object instanceof Map) {
                HelperFunctions.formatNumericValues((Map)object);
                continue;
            }
            if (!(object instanceof Number)) continue;
            object = HelperFunctions.formatNumberToTwoDecimals((Number)object);
            list.set(i2, object);
        }
    }

    public static Object getCaseInsensitiveValue(Map<String, Object> object, String string) {
        if (object == null || string == null) {
            return null;
        }
        Object object22 = object.get(string);
        if (object22 != null) {
            return object22;
        }
        for (Map.Entry entry : object.entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase(string)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static Map<String, Object> getCaseInsensitiveMap(Map<String, Object> object, String string) {
        if ((object = HelperFunctions.getCaseInsensitiveValue(object, string)) instanceof Map) {
            return (Map)object;
        }
        return null;
    }

    public static String getCaseInsensitiveString(Map<String, Object> object, String string) {
        if ((object = HelperFunctions.getCaseInsensitiveValue(object, string)) != null) {
            return object.toString();
        }
        return null;
    }

    public static boolean containsKeyCaseInsensitive(Map<String, Object> object, String string) {
        if (object == null || string == null) {
            return false;
        }
        if (object.containsKey(string)) {
            return true;
        }
        for (String string2 : object.keySet()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isXsdFileNotFoundError(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.toLowerCase()).contains("file not found") || string.contains("filenotfoundexception") || string.contains("no such file") || string.contains("cannot find") || string.contains("does not exist") || string.contains("unable to open") || string.contains("could not find the document") || string.contains("failed to read schema document");
    }

    public static boolean isXsdValidationSuccessful(String string) {
        return string == null || string.trim().isEmpty() || string.toLowerCase().contains("ispravan") || string.toLowerCase().contains("validation successful") || string.toLowerCase().contains("valid");
    }

    public static boolean hasXsdValidationErrors(String string) {
        return string != null && (string.toLowerCase().contains("neispravan") || string.toLowerCase().contains("error") || string.toLowerCase().contains("exception") || string.toLowerCase().contains("invalid") || string.toLowerCase().contains("not found"));
    }

    public static Object getCIV(Map<String, Object> map, String string) {
        return HelperFunctions.getCaseInsensitiveValue(map, string);
    }

    public static Map<String, Object> getCIM(Map<String, Object> map, String string) {
        return HelperFunctions.getCaseInsensitiveMap(map, string);
    }

    public static String getCIS(Map<String, Object> map, String string) {
        return HelperFunctions.getCaseInsensitiveString(map, string);
    }

    public static boolean containsKeyCI(Map<String, Object> map, String string) {
        return HelperFunctions.containsKeyCaseInsensitive(map, string);
    }

    public static Map<String, Object> getMapFromObject(Map<String, Object> map, String string) {
        if (map != null) {
            return (Map)map.get(string.toLowerCase());
        }
        return null;
    }

    public static List<Map<String, Object>> getListFromObject(Map<String, Object> map, String string) {
        if (map != null) {
            return (List)map.get(string.toLowerCase());
        }
        return null;
    }

    public static String getString(Map<String, Object> map, String string) {
        if ((map = map != null ? map.get(string.toLowerCase()) : null) != null) {
            return map.toString();
        }
        return null;
    }

    public static BigDecimal getDecimal(Map<String, Object> object, String string) {
        if (object == null) {
            return null;
        }
        if ((object = object.get(string.toLowerCase())) == null) {
            return null;
        }
        try {
            if (object instanceof BigDecimal) {
                return (BigDecimal)object;
            }
            if (object instanceof Number) {
                return new BigDecimal(object.toString());
            }
            return new BigDecimal(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static boolean validateOIBChecksum(String string) {
        try {
            int n2;
            int n3;
            int[] nArray = new int[11];
            for (n3 = 0; n3 < 11; ++n3) {
                nArray[n3] = Character.getNumericValue(string.charAt(n3));
            }
            n3 = nArray[10];
            int n4 = 10;
            for (n2 = 0; n2 < 10; ++n2) {
                if ((n4 = (nArray[n2] + n4) % 10) == 0) {
                    n4 = 10;
                }
                n4 = 2 * n4 % 11;
            }
            n2 = (11 - n4) % 10;
            return n2 == n3;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isValidDateFormat(String string) {
        if (string == null || string.trim().isEmpty()) {
            return false;
        }
        if (!string.matches("\\d{4}-\\d{2}-\\d{2}")) {
            return false;
        }
        try {
            LocalDate.parse(string);
            return true;
        }
        catch (DateTimeParseException dateTimeParseException) {
            return false;
        }
    }

    public static boolean isValidTimeFormat(String string) {
        if (string == null || string.trim().isEmpty()) {
            return false;
        }
        if (!string.matches("\\d{2}:\\d{2}:\\d{2}(\\.\\d{3})?")) {
            return false;
        }
        try {
            LocalTime.parse(string);
            return true;
        }
        catch (DateTimeParseException dateTimeParseException) {
            return false;
        }
    }

    public static boolean isLogicalDate(String string) {
        try {
            LocalDate.parse(string);
            return true;
        }
        catch (DateTimeParseException dateTimeParseException) {
            return false;
        }
    }

    public static boolean isFutureDate(String object) {
        try {
            object = LocalDate.parse((CharSequence)object);
            LocalDate localDate = LocalDate.now();
            return ((LocalDate)object).isAfter(localDate);
        }
        catch (DateTimeParseException dateTimeParseException) {
            return false;
        }
    }

    public static boolean isValidGTIN(String string) {
        if (string == null || string.trim().isEmpty()) {
            return false;
        }
        if (!(string = string.trim()).matches("\\d{8}|\\d{12}|\\d{13}|\\d{14}")) {
            return false;
        }
        return HelperFunctions.isValidGTINChecksum(string);
    }

    public static boolean isValidGTINChecksum(String string) {
        try {
            int n2;
            int n3;
            int n4 = 0;
            int n5 = string.length();
            for (n3 = 0; n3 < n5 - 1; ++n3) {
                n2 = Character.getNumericValue(string.charAt(n3));
                int n6 = (n5 - n3) % 2 == 0 ? 1 : 3;
                n4 += n2 * n6;
            }
            n3 = (10 - n4 % 10) % 10;
            n2 = Character.getNumericValue(string.charAt(n5 - 1));
            return n3 == n2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isValidHSCode(String string) {
        int n2;
        if (string == null || string.trim().isEmpty()) {
            return false;
        }
        if (!(string = string.trim()).matches("\\d{6}|\\d{8}|\\d{10}")) {
            return false;
        }
        return string.length() < 2 || (n2 = Integer.parseInt(string.substring(0, 2))) > 0 && n2 <= 99;
    }

    public static boolean isValidGeneralCommodityCode(String string) {
        if (string == null || string.trim().isEmpty()) {
            return false;
        }
        if (!(string = string.trim()).matches("[A-Za-z0-9.-]{3,20}")) {
            return false;
        }
        return !string.startsWith(".") && !string.startsWith("-") && !string.endsWith(".") && !string.endsWith("-");
    }

    public static class ValidationResult {
        private boolean a = true;
        private StringBuilder b = new StringBuilder();
        private int c = 0;

        public void addError(String string) {
            this.a = false;
            ++this.c;
            this.b.append(this.c).append(". ").append(string).append("\n");
        }

        public boolean isValid() {
            return this.a;
        }

        public String getErrors() {
            return this.b.toString();
        }

        public int getErrorCount() {
            return this.c;
        }

        public String toString() {
            if (this.a) {
                return "\u2705 Validacija uspje\u0161na";
            }
            return "\u274c Prona\u0111eno " + this.c + " gre\u0161aka:\n" + this.b.toString();
        }
    }

    public static class TestResult {
        private String a;
        private boolean b;
        private String c;
        private String d;
        private long e;

        public TestResult(String string, boolean bl2, String string2, String string3, long l2) {
            this.a = string;
            this.b = bl2;
            this.c = string2;
            this.d = string3;
            this.e = l2;
        }

        public String getTestName() {
            return this.a;
        }

        public boolean isPassed() {
            return this.b;
        }

        public String getMessage() {
            return this.c;
        }

        public String getDetails() {
            return this.d;
        }

        public long getExecutionTime() {
            return this.e;
        }

        public String toString() {
            return String.format("[%s] %s - %s (%.2fms)", this.b ? "PASS" : "FAIL", this.a, this.c, (double)this.e / 1000000.0);
        }
    }
}

