/*
 * Decompiled with CFR 0.152.
 */
package microsoft.sql;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public final class DateTimeOffset
implements Serializable,
Comparable<DateTimeOffset> {
    private final long a;
    private final int b;
    private final int c;
    private String d = null;

    private DateTimeOffset(Timestamp timestamp, int n2) {
        if (n2 < -840 || n2 > 840) {
            throw new IllegalArgumentException();
        }
        this.c = n2;
        n2 = timestamp.getNanos();
        if (n2 < 0 || n2 > 999999999) {
            throw new IllegalArgumentException();
        }
        n2 = (n2 + 50) / 100;
        this.b = 100 * (n2 % 10000000);
        this.a = timestamp.getTime() - (long)(timestamp.getNanos() / 1000000) + (long)(1000 * (n2 / 10000000));
        assert (this.c >= -840 && this.c <= 840) : "minutesOffset: " + this.c;
        assert (this.b >= 0 && this.b <= 999999999) : "nanos: " + this.b;
        assert (0 == this.b % 100) : "nanos: " + this.b;
        assert (0L == this.a % 1000L) : "utcMillis: " + this.a;
    }

    public static DateTimeOffset valueOf(Timestamp timestamp, int n2) {
        return new DateTimeOffset(timestamp, n2);
    }

    public static DateTimeOffset valueOf(Timestamp timestamp, Calendar calendar) {
        calendar.setTimeInMillis(timestamp.getTime());
        return new DateTimeOffset(timestamp, (calendar.get(15) + calendar.get(16)) / 60000);
    }

    public final String toString() {
        String string = this.d;
        if (string == null) {
            string = this.c < 0 ? String.format(Locale.US, "-%1$02d:%2$02d", -this.c / 60, -this.c % 60) : String.format(Locale.US, "+%1$02d:%2$02d", this.c / 60, this.c % 60);
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT" + string), Locale.US);
            calendar.setTimeInMillis(this.a);
            assert (this.b >= 0 && this.b <= 999999999);
            string = this.b == 0 ? String.format(Locale.US, "%1$tF %1$tT %2$s", calendar, string) : String.format(Locale.US, "%1$tF %1$tT.%2$s %3$s", calendar, BigDecimal.valueOf(this.b, 9).stripTrailingZeros().toPlainString().substring(2), string);
            this.d = string;
        }
        return string;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DateTimeOffset)) {
            return false;
        }
        object = (DateTimeOffset)object;
        return this.a == ((DateTimeOffset)object).a && this.b == ((DateTimeOffset)object).b && this.c == ((DateTimeOffset)object).c;
    }

    public final int hashCode() {
        assert (0L == this.a % 1000L);
        long l2 = this.a / 1000L;
        int n2 = 1148281 + (int)l2;
        n2 = n2 * 3217 + (int)(l2 / 60L * 60L * 24L * 365L);
        n2 = n2 * 3919 + this.b / 100000;
        n2 = n2 * 4463 + this.b / 1000;
        n2 = n2 * 5227 + this.b;
        n2 = n2 * 6689 + this.c;
        n2 = n2 * 7577 + this.c / 60;
        return n2;
    }

    public final Timestamp getTimestamp() {
        Timestamp timestamp = new Timestamp(this.a);
        timestamp.setNanos(this.b);
        return timestamp;
    }

    public final int getMinutesOffset() {
        return this.c;
    }

    @Override
    public final int compareTo(DateTimeOffset dateTimeOffset) {
        assert (this.b >= 0);
        assert (dateTimeOffset.b >= 0);
        if (this.a > dateTimeOffset.a) {
            return 1;
        }
        if (this.a < dateTimeOffset.a) {
            return -1;
        }
        return this.b - dateTimeOffset.b;
    }
}

