/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.IntPredicate;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Version;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.event.EventSource;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.accum.AccumulatorRegistry;
import net.sf.saxon.expr.compat.TypeChecker10;
import net.sf.saxon.expr.instruct.Debugger;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.SourceDocument;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.number.AbstractNumberer;
import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ICompilerService;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.OptimizerOptions;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.expr.sort.AlphanumericCollator;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.HTML5CaseBlindCollator;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.IntegratedFunctionLibrary;
import net.sf.saxon.functions.MathFunctionSet;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.functions.registry.ExsltCommonFunctionSet;
import net.sf.saxon.functions.registry.UseWhen30FunctionSet;
import net.sf.saxon.functions.registry.VendorFunctionSetHE;
import net.sf.saxon.functions.registry.XPath30FunctionSet;
import net.sf.saxon.functions.registry.XPath31FunctionSet;
import net.sf.saxon.functions.registry.XSLT30FunctionSet;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.CollationURIResolver;
import net.sf.saxon.lib.CollectionFinder;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.EnvironmentVariableResolver;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.FunctionAnnotationHandler;
import net.sf.saxon.lib.InvalidityReportGenerator;
import net.sf.saxon.lib.LocalizerFactory;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.ResourceCollection;
import net.sf.saxon.lib.ResourceFactory;
import net.sf.saxon.lib.SchemaURIResolver;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.SourceResolver;
import net.sf.saxon.lib.StandardCollationURIResolver;
import net.sf.saxon.lib.StandardEntityResolver;
import net.sf.saxon.lib.StandardEnvironmentVariableResolver;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.StandardLogger;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.lib.StandardURIResolver;
import net.sf.saxon.lib.StandardUnparsedTextResolver;
import net.sf.saxon.lib.StaticQueryContextFactory;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.lib.XQueryFunctionAnnotationHandler;
import net.sf.saxon.ma.arrays.ArrayFunctionSet;
import net.sf.saxon.ma.map.MapFunctionSet;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.AllElementsSpaceStrippingRule;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.IgnorableSpaceStrippingRule;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NotationSet;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.pattern.PatternParser30;
import net.sf.saxon.pull.PullSource;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryParser;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.resource.BinaryResource;
import net.sf.saxon.resource.CollectionURIResolverWrapper;
import net.sf.saxon.resource.JSONResource;
import net.sf.saxon.resource.StandardCollectionFinder;
import net.sf.saxon.resource.UnknownResource;
import net.sf.saxon.resource.UnparsedTextResource;
import net.sf.saxon.resource.XmlResource;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.serialize.charcode.CharacterSetFactory;
import net.sf.saxon.serialize.charcode.XMLCharacterData;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLEvaluate;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.TraceCodeInjector;
import net.sf.saxon.trace.XSLTTraceCodeInjector;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.ConfigurationReader;
import net.sf.saxon.trans.DynamicLoader;
import net.sf.saxon.trans.FunctionStreamability;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.PackageLoaderHE;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.TypeAliasManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.packages.IPackageLoader;
import net.sf.saxon.tree.tiny.TreeStatistics;
import net.sf.saxon.tree.util.DocumentNumberAllocator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringToDouble11;
import net.sf.saxon.z.IntHashSet;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.LexicalHandler;

public class Configuration
implements SourceResolver,
NotationSet {
    protected static Set<Feature> booleanFeatures = new HashSet<Feature>(40);
    private transient ApiProvider a = null;
    private transient CharacterSetFactory b;
    private Map<String, StringCollator> c = new HashMap<String, StringCollator>(10);
    private CollationURIResolver d = new StandardCollationURIResolver();
    private String e = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    protected CollectionFinder collectionFinder = new StandardCollectionFinder();
    private EnvironmentVariableResolver f = new StandardEnvironmentVariableResolver();
    private String g = null;
    private ParseOptions h = new ParseOptions();
    protected transient StaticQueryContext defaultStaticQueryContext;
    private StaticQueryContextFactory i = new StaticQueryContextFactory();
    protected OptimizerOptions optimizerOptions = OptimizerOptions.FULL_HE_OPTIMIZATION;
    protected CompilerInfo defaultXsltCompilerInfo = this.makeCompilerInfo();
    private String j = null;
    private DocumentNumberAllocator k = new DocumentNumberAllocator();
    private transient Debugger l = null;
    private String m = Locale.getDefault().getLanguage();
    private String n = Locale.getDefault().getCountry();
    private Properties o = new Properties();
    private transient DynamicLoader p = new DynamicLoader();
    private IntHashSet q = new IntHashSet(64);
    private List<ExternalObjectModel> r = new ArrayList<ExternalObjectModel>(4);
    private DocumentPool s = new DocumentPool();
    private IntegratedFunctionLibrary t = new IntegratedFunctionLibrary();
    private transient LocalizerFactory u;
    private NamePool v = new NamePool();
    protected Optimizer optimizer = null;
    private SerializerFactory w = new SerializerFactory(this);
    private volatile ConcurrentLinkedQueue<XMLReader> x = new ConcurrentLinkedQueue();
    private volatile ConcurrentLinkedQueue<XMLReader> y = new ConcurrentLinkedQueue();
    private String z;
    private transient SourceResolver A = this;
    private transient Logger B = new StandardLogger();
    private ModuleURIResolver C = Version.platform.makeStandardModuleURIResolver(this);
    private String D;
    private final StandardURIResolver E = new StandardURIResolver(this);
    private UnparsedTextURIResolver F = new StandardUnparsedTextResolver();
    private transient EarlyEvaluationContext G = null;
    private ConversionRules H = null;
    private transient TraceListener I = null;
    private String J = null;
    private String K = null;
    private String L = "S";
    protected transient TypeHierarchy typeHierarchy;
    private TypeChecker M = new TypeChecker();
    private TypeChecker10 N = new TypeChecker10();
    private transient URIResolver O;
    protected FunctionLibraryList builtInExtensionLibraryList;
    protected int xsdVersion = 11;
    private int P = 10;
    private int Q = 20;
    private int R = 31;
    private Comparator<String> S = (string, string2) -> 0;
    private Map<String, String> T = new HashMap<String, String>();
    private Map<String, ResourceFactory> U = new HashMap<String, ResourceFactory>();
    private Map<String, FunctionAnnotationHandler> V = new HashMap<String, FunctionAnnotationHandler>();
    protected int byteCodeThreshold = 100;
    private int W = 10000000;
    private TreeStatistics X = new TreeStatistics();
    public static final int RECOVER_SILENTLY = 0;
    public static final int RECOVER_WITH_WARNINGS = 1;
    public static final int DO_NOT_RECOVER = 2;
    public static final int XML10 = 10;
    public static final int XML11 = 11;
    public static final int XSLT = 50;
    public static final int XQUERY = 51;
    public static final int XML_SCHEMA = 52;
    public static final int JAVA_APPLICATION = 53;
    public static final int XPATH = 54;
    public static final int XSD10 = 10;
    public static final int XSD11 = 11;
    private static LexicalHandler Y = new DefaultHandler2();

    public Configuration() {
        this.init();
    }

    public static Configuration newConfiguration() {
        Object object = Configuration.class;
        try {
            return (Configuration)((Class)object).newInstance();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            throw new RuntimeException("Cannot instantiate a Configuration", (Throwable)object);
        }
    }

    public static InputStream locateResource(String string, List<String> list, List<ClassLoader> list2) {
        URL uRL;
        string = "net/sf/saxon/data/" + string;
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            list.add("Failed to getContextClassLoader() - continuing\n");
        }
        InputStream inputStream = null;
        if (classLoader != null) {
            classLoader.getResource(string);
            inputStream = classLoader.getResourceAsStream(string);
            if (inputStream == null) {
                list.add("Cannot read " + string + " file located using ClassLoader " + classLoader + " - continuing\n");
            }
        }
        if (inputStream == null && (classLoader = Configuration.class.getClassLoader()) != null && (inputStream = classLoader.getResourceAsStream(string)) == null) {
            list.add("Cannot read " + string + " file located using ClassLoader " + classLoader + " - continuing\n");
        }
        if (inputStream == null && (uRL = ClassLoader.getSystemResource(string)) != null) {
            try {
                inputStream = uRL.openStream();
            }
            catch (IOException iOException) {
                list.add("IO error " + iOException.getMessage() + " reading " + string + " located using getSystemResource(): using defaults");
                inputStream = null;
            }
        }
        list2.add(classLoader);
        return inputStream;
    }

    public static StreamSource locateResourceSource(String string, List<String> list, List<ClassLoader> list2) {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            list.add("Failed to getContextClassLoader() - continuing\n");
        }
        InputStream inputStream = null;
        URL uRL = null;
        if (classLoader != null) {
            uRL = classLoader.getResource(string);
            inputStream = classLoader.getResourceAsStream(string);
            if (inputStream == null) {
                list.add("Cannot read " + string + " file located using ClassLoader " + classLoader + " - continuing\n");
            }
        }
        if (inputStream == null && (classLoader = Configuration.class.getClassLoader()) != null && (inputStream = classLoader.getResourceAsStream(string)) == null) {
            list.add("Cannot read " + string + " file located using ClassLoader " + classLoader + " - continuing\n");
        }
        list2.add(classLoader);
        return new StreamSource(inputStream, uRL.toString());
    }

    public static Configuration readConfiguration(Source source) {
        Configuration configuration = Configuration.newConfiguration();
        return configuration.readConfigurationFile(source);
    }

    public static Configuration readConfiguration(Source source, Configuration configuration) {
        Configuration configuration2 = Configuration.newConfiguration();
        return configuration2.readConfigurationFile(source, configuration);
    }

    public static Configuration instantiateConfiguration(String string, ClassLoader clazz) {
        if (clazz == null) {
            try {
                clazz = Thread.currentThread().getContextClassLoader();
            }
            catch (Exception exception) {
                System.err.println("Failed to getContextClassLoader() - continuing");
            }
        }
        if (clazz != null) {
            try {
                clazz = ((ClassLoader)((Object)clazz)).loadClass(string);
            }
            catch (Exception exception) {}
        }
        clazz = Class.forName(string);
        return (Configuration)clazz.newInstance();
    }

    public static boolean isAssertionsEnabled() {
        boolean bl2 = false;
        if (!Z) {
            bl2 = true;
        }
        return bl2;
    }

    protected Configuration readConfigurationFile(Source source) {
        return new ConfigurationReader().makeConfiguration(source);
    }

    protected Configuration readConfigurationFile(Source source, Configuration configuration) {
        ConfigurationReader configurationReader = this.makeConfigurationReader();
        configurationReader.setBaseConfiguration(configuration);
        return configurationReader.makeConfiguration(source);
    }

    protected ConfigurationReader makeConfigurationReader() {
        return new ConfigurationReader();
    }

    protected void init() {
        Version.platform.initialize(this);
        this.defaultXsltCompilerInfo.setURIResolver(this.getSystemURIResolver());
        StandardEntityResolver standardEntityResolver = new StandardEntityResolver();
        standardEntityResolver.setConfiguration(this);
        this.h.setEntityResolver(standardEntityResolver);
        this.internalSetBooleanProperty(Feature.PREFER_JAXP_PARSER, Boolean.TRUE);
        this.internalSetBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS, Boolean.TRUE);
        this.internalSetBooleanProperty(Feature.DISABLE_XSL_EVALUATE, Boolean.TRUE);
        this.registerFileExtension("xml", "application/xml");
        this.registerFileExtension("html", "application/html");
        this.registerFileExtension("atom", "application/atom");
        this.registerFileExtension("xsl", "application/xml+xslt");
        this.registerFileExtension("xslt", "application/xml+xslt");
        this.registerFileExtension("xsd", "application/xml+xsd");
        this.registerFileExtension("txt", "text/plain");
        this.registerFileExtension("MF", "text/plain");
        this.registerFileExtension("class", "application/java");
        this.registerFileExtension("json", "application/json");
        this.registerFileExtension("", "application/unknown");
        this.registerMediaType("application/xml", XmlResource.FACTORY);
        this.registerMediaType("text/xml", XmlResource.FACTORY);
        this.registerMediaType("application/html", XmlResource.FACTORY);
        this.registerMediaType("text/html", XmlResource.FACTORY);
        this.registerMediaType("application/atom", XmlResource.FACTORY);
        this.registerMediaType("application/xml+xslt", XmlResource.FACTORY);
        this.registerMediaType("application/xml+xsd", XmlResource.FACTORY);
        this.registerMediaType("application/rdf+xml", XmlResource.FACTORY);
        this.registerMediaType("text/plain", UnparsedTextResource.FACTORY);
        this.registerMediaType("application/java", BinaryResource.FACTORY);
        this.registerMediaType("application/binary", BinaryResource.FACTORY);
        this.registerMediaType("application/json", JSONResource.FACTORY);
        this.registerMediaType("application/unknown", UnknownResource.FACTORY);
        this.registerFunctionAnnotationHandler(new XQueryFunctionAnnotationHandler());
    }

    public static Configuration makeLicensedConfiguration(ClassLoader classLoader, String string) {
        if (string == null) {
            string = "com.saxonica.config.ProfessionalConfiguration";
        }
        try {
            return Configuration.instantiateConfiguration(string, classLoader);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    public void importLicenseDetails(Configuration configuration) {
    }

    public String getEditionCode() {
        return "HE";
    }

    public void setProcessor(ApiProvider apiProvider) {
        this.a = apiProvider;
    }

    public ApiProvider getProcessor() {
        return this.a;
    }

    public String getProductTitle() {
        return "Saxon-" + this.getEditionCode() + " " + Version.getProductVersion() + Version.platform.getPlatformSuffix() + " from Saxonica";
    }

    public void checkLicensedFeature(int n2, String string, int n3) {
        String string2 = n2 == 8 ? "PE" : "EE";
        string = "Requested feature (" + string + ") requires Saxon-" + string2;
        if (!Version.softwareEdition.equals("HE")) {
            string = string + ". You are using Saxon-" + Version.softwareEdition + " software, but the Configuration is an instance of " + this.getClass().getName() + "; to use this feature you need to create an instance of " + (n2 == 8 ? "com.saxonica.config.ProfessionalConfiguration" : "com.saxonica.config.EnterpriseConfiguration");
        }
        throw new LicenseException(string, 6);
    }

    public void disableLicensing() {
    }

    public boolean isFeatureAllowedBySecondaryLicense(int n2, int n3) {
        return false;
    }

    public boolean isLicensedFeature(int n2) {
        return false;
    }

    public String getLicenseFeature(String string) {
        return null;
    }

    public void displayLicenseMessage() {
    }

    public int registerLocalLicense(String string) {
        return -1;
    }

    public void setDynamicLoader(DynamicLoader dynamicLoader) {
        this.p = dynamicLoader;
    }

    public DynamicLoader getDynamicLoader() {
        return this.p;
    }

    public Class getClass(String string, boolean bl2, ClassLoader classLoader) {
        return this.p.getClass(string, bl2 ? this.B : null, classLoader);
    }

    public Object getInstance(String string, ClassLoader classLoader) {
        return this.p.getInstance(string, this.isTiming() ? this.B : null, classLoader);
    }

    public URIResolver getURIResolver() {
        if (this.O == null) {
            return this.E;
        }
        return this.O;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.O = uRIResolver;
        if (uRIResolver instanceof StandardURIResolver) {
            ((StandardURIResolver)uRIResolver).setConfiguration(this);
        }
        this.defaultXsltCompilerInfo.setURIResolver(uRIResolver);
    }

    public void setParameterizedURIResolver() {
        this.getSystemURIResolver().setRecognizeQueryParameters(true);
    }

    public StandardURIResolver getSystemURIResolver() {
        return this.E;
    }

    public URIResolver makeURIResolver(String string) {
        Object object = this.p.getInstance(string, null);
        if (object instanceof StandardURIResolver) {
            ((StandardURIResolver)object).setConfiguration(this);
        }
        if (object instanceof URIResolver) {
            return (URIResolver)object;
        }
        throw new XPathException("Class " + string + " is not a URIResolver");
    }

    public UnfailingErrorListener getErrorListener() {
        UnfailingErrorListener unfailingErrorListener = this.h.getErrorListener();
        if (unfailingErrorListener == null) {
            unfailingErrorListener = new StandardErrorListener();
            ((StandardErrorListener)unfailingErrorListener).setLogger(this.B);
            ((StandardErrorListener)unfailingErrorListener).setRecoveryPolicy(this.defaultXsltCompilerInfo.getRecoveryPolicy());
            this.h.setErrorListener(unfailingErrorListener);
        }
        return unfailingErrorListener;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.h.setErrorListener(errorListener);
        this.getDefaultXsltCompilerInfo().setErrorListener(errorListener);
        this.getDefaultStaticQueryContext().setErrorListener(errorListener);
    }

    public Logger getLogger() {
        return this.B;
    }

    public void reportFatalError(XPathException xPathException) {
        if (!xPathException.hasBeenReported()) {
            this.getErrorListener().fatalError(xPathException);
            xPathException.setHasBeenReported(true);
        }
    }

    public void setStandardErrorOutput(PrintStream printStream) {
        if (!(this.B instanceof StandardLogger)) {
            this.B = new StandardLogger();
        }
        ((StandardLogger)this.B).setPrintStream(printStream);
    }

    public void setLogger(Logger logger) {
        this.B = logger;
    }

    public PrintStream getStandardErrorOutput() {
        if (this.B instanceof StandardLogger) {
            return ((StandardLogger)this.B).getPrintStream();
        }
        return null;
    }

    public void setXMLVersion(int n2) {
        this.P = n2;
        this.H = null;
    }

    public int getXMLVersion() {
        return this.P;
    }

    public ParseOptions getParseOptions() {
        return this.h;
    }

    public void setMediaQueryEvaluator(Comparator<String> comparator) {
        this.S = comparator;
    }

    public Comparator<String> getMediaQueryEvaluator() {
        return this.S;
    }

    public void setConversionRules(ConversionRules conversionRules) {
        this.H = conversionRules;
    }

    public ConversionRules getConversionRules() {
        if (this.H == null) {
            Configuration configuration = this;
            synchronized (configuration) {
                ConversionRules conversionRules = new ConversionRules();
                conversionRules.setTypeHierarchy(this.getTypeHierarchy());
                conversionRules.setNotationSet(this);
                if (this.xsdVersion == 10) {
                    conversionRules.setStringToDoubleConverter(StringToDouble.getInstance());
                    conversionRules.setURIChecker(StandardURIChecker.getInstance());
                } else {
                    conversionRules.setStringToDoubleConverter(StringToDouble11.getInstance());
                }
                conversionRules.setAllowYearZero(this.xsdVersion != 10);
                this.H = conversionRules;
                return this.H;
            }
        }
        return this.H;
    }

    public int getXsdVersion() {
        return this.xsdVersion;
    }

    public XPathContext getConversionContext() {
        if (this.G == null) {
            this.G = new EarlyEvaluationContext(this);
        }
        return this.G;
    }

    public IntPredicate getValidCharacterChecker() {
        if (this.P == 10) {
            return XMLCharacterData::isValid10;
        }
        return XMLCharacterData::isValid11;
    }

    public int getTreeModel() {
        return this.h.getModel().getSymbolicValue();
    }

    public void setTreeModel(int n2) {
        this.h.setModel(TreeModel.getTreeModel(n2));
    }

    public boolean isLineNumbering() {
        return this.h.isLineNumbering();
    }

    public void setLineNumbering(boolean bl2) {
        this.h.setLineNumbering(bl2);
    }

    public void setXIncludeAware(boolean bl2) {
        this.h.setXIncludeAware(bl2);
    }

    public boolean isXIncludeAware() {
        return this.h.isXIncludeAware();
    }

    public TraceListener getTraceListener() {
        return this.I;
    }

    public TraceListener makeTraceListener() {
        if (this.I != null) {
            return this.I;
        }
        if (this.J != null) {
            try {
                Configuration configuration = this;
                return configuration.makeTraceListener(configuration.J);
            }
            catch (ClassCastException classCastException) {
                throw new XPathException(classCastException);
            }
        }
        return null;
    }

    public void setTraceListener(TraceListener traceListener) {
        this.I = traceListener;
        this.setCompileWithTracing(traceListener != null);
        this.internalSetBooleanProperty(Feature.ALLOW_MULTITHREADING, Boolean.FALSE);
    }

    public void setTraceListenerClass(String string) {
        if (string == null) {
            this.J = null;
            this.setCompileWithTracing(false);
            return;
        }
        try {
            this.makeTraceListener(string);
        }
        catch (XPathException xPathException) {
            throw new IllegalArgumentException(string + ": " + xPathException.getMessage());
        }
        this.J = string;
        this.setCompileWithTracing(true);
    }

    public String getTraceListenerClass() {
        return this.J;
    }

    public void setTraceListenerOutputFile(String string) {
        this.K = string;
    }

    public String getTraceListenerOutputFile() {
        return this.K;
    }

    public boolean isCompileWithTracing() {
        return this.getBooleanProperty(Feature.COMPILE_WITH_TRACING);
    }

    public void setCompileWithTracing(boolean bl2) {
        this.internalSetBooleanProperty(Feature.COMPILE_WITH_TRACING, bl2);
        if (this.defaultXsltCompilerInfo != null) {
            if (bl2) {
                this.defaultXsltCompilerInfo.setCodeInjector(new XSLTTraceCodeInjector());
            } else {
                this.defaultXsltCompilerInfo.setCodeInjector(null);
            }
        }
        if (this.defaultStaticQueryContext != null) {
            if (bl2) {
                this.defaultStaticQueryContext.setCodeInjector(new TraceCodeInjector());
                return;
            }
            this.defaultStaticQueryContext.setCodeInjector(null);
        }
    }

    public TraceListener makeTraceListener(String string) {
        Object object = this.p.getInstance(string, null);
        if (object instanceof TraceListener) {
            string = this.getTraceListenerOutputFile();
            if (string != null) {
                try {
                    ((TraceListener)object).setOutputDestination(new StandardLogger(new PrintStream(string)));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new XPathException(fileNotFoundException);
                }
            }
            return (TraceListener)object;
        }
        throw new XPathException("Class " + string + " is not a TraceListener");
    }

    public BuiltInFunctionSet getXSLT30FunctionSet() {
        return XSLT30FunctionSet.getInstance();
    }

    public BuiltInFunctionSet getUseWhenFunctionSet() {
        return UseWhen30FunctionSet.getInstance();
    }

    public BuiltInFunctionSet getXPath30FunctionSet() {
        return XPath30FunctionSet.getInstance();
    }

    public BuiltInFunctionSet getXPath31FunctionSet() {
        return XPath31FunctionSet.getInstance();
    }

    public BuiltInFunctionSet getXQueryUpdateFunctionSet() {
        return null;
    }

    public SystemFunction makeSystemFunction(String string, int n2) {
        try {
            return this.getXSLT30FunctionSet().makeFunction(string, n2);
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    public void registerExtensionFunction(ExtensionFunctionDefinition extensionFunctionDefinition) {
        this.t.registerFunction(extensionFunctionDefinition);
    }

    public IntegratedFunctionLibrary getIntegratedFunctionLibrary() {
        return this.t;
    }

    public FunctionLibraryList getBuiltInExtensionLibraryList() {
        if (this.builtInExtensionLibraryList == null) {
            this.builtInExtensionLibraryList = new FunctionLibraryList();
            this.builtInExtensionLibraryList.addFunctionLibrary(VendorFunctionSetHE.getInstance());
            this.builtInExtensionLibraryList.addFunctionLibrary(MathFunctionSet.getInstance());
            this.builtInExtensionLibraryList.addFunctionLibrary(MapFunctionSet.getInstance());
            this.builtInExtensionLibraryList.addFunctionLibrary(ArrayFunctionSet.getInstance());
            this.builtInExtensionLibraryList.addFunctionLibrary(ExsltCommonFunctionSet.getInstance());
        }
        return this.builtInExtensionLibraryList;
    }

    public void addExtensionBinders(FunctionLibraryList functionLibraryList) {
    }

    public Function getSystemFunction(StructuredQName structuredQName, int n2) {
        throw new XPathException("Dynamic functions require Saxon-PE or higher");
    }

    public UserFunction newUserFunction(boolean bl2, FunctionStreamability functionStreamability) {
        return new UserFunction();
    }

    public void registerCollation(String string, StringCollator stringCollator) {
        this.c.put(string, stringCollator);
    }

    public void setCollationURIResolver(CollationURIResolver collationURIResolver) {
        this.d = collationURIResolver;
    }

    public CollationURIResolver getCollationURIResolver() {
        return this.d;
    }

    public StringCollator getCollation(String string) {
        if (string == null || string.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            return CodepointCollator.getInstance();
        }
        if (string.equals("http://www.w3.org/2005/xpath-functions/collation/html-ascii-case-insensitive")) {
            return HTML5CaseBlindCollator.getInstance();
        }
        if (string.startsWith("http://saxon.sf.net/collation/alphaNumeric?base=")) {
            return new AlphanumericCollator(this.getCollation(string.substring(48)));
        }
        StringCollator stringCollator = this.c.get(string);
        if (stringCollator == null) {
            stringCollator = this.getCollationURIResolver().resolve(string, this);
        }
        return stringCollator;
    }

    public StringCollator getCollation(String string, String string2) {
        if (string.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            return CodepointCollator.getInstance();
        }
        try {
            String string3 = ResolveURI.makeAbsolute(string, string2).toString();
            return this.getCollation(string3);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XPathException("Collation name is not a valid URI: " + string + " (base = " + string2 + ")", "FOCH0002");
        }
    }

    public StringCollator getCollation(String string, String string2, String string3) {
        if (string.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            return CodepointCollator.getInstance();
        }
        try {
            StringCollator stringCollator;
            String string4 = string;
            if (string2 != null) {
                string4 = ResolveURI.makeAbsolute(string, string2).toString();
            }
            if ((stringCollator = this.getCollation(string4)) == null) {
                throw new XPathException("Unknown collation " + string4, string3);
            }
            return stringCollator;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XPathException("Collation name is not a valid URI: " + string + " (base = " + string2 + ")", string3);
        }
    }

    public String getDefaultCollationName() {
        return this.e;
    }

    public void setDefaultCollection(String string) {
        this.g = string;
    }

    public String getDefaultCollection() {
        return this.g;
    }

    public void setCollectionURIResolver(CollectionURIResolver collectionURIResolver) {
        this.setCollectionFinder(new CollectionURIResolverWrapper(collectionURIResolver));
    }

    public CollectionURIResolver getCollectionURIResolver() {
        if (this.collectionFinder instanceof CollectionURIResolverWrapper) {
            return ((CollectionURIResolverWrapper)this.collectionFinder).getCollectionURIResolver();
        }
        return null;
    }

    public void setCollectionFinder(CollectionFinder collectionFinder) {
        this.collectionFinder = collectionFinder;
    }

    public CollectionFinder getCollectionFinder() {
        return this.collectionFinder;
    }

    public void registerCollection(String string, ResourceCollection resourceCollection) {
        if (!(this.collectionFinder instanceof StandardCollectionFinder)) {
            throw new IllegalStateException("Current CollectionFinder is not a StandardCollectionFinder");
        }
        ((StandardCollectionFinder)this.collectionFinder).registerCollection(string, resourceCollection);
    }

    public void registerFileExtension(String string, String string2) {
        this.T.put(string, string2);
    }

    public void registerMediaType(String string, ResourceFactory resourceFactory) {
        this.U.put(string, resourceFactory);
    }

    public String getMediaTypeForFileExtension(String string) {
        if ((string = this.T.get(string)) == null) {
            string = this.T.get("");
        }
        return string;
    }

    public ResourceFactory getResourceFactoryForMediaType(String string) {
        return this.U.get(string);
    }

    public void setLocalizerFactory(LocalizerFactory localizerFactory) {
        this.u = localizerFactory;
    }

    public LocalizerFactory getLocalizerFactory() {
        return this.u;
    }

    public void setDefaultLanguage(String string) {
        ValidationFailure validationFailure = ((StringConverter)StringConverter.StringToLanguage.INSTANCE).validate(string);
        if (validationFailure != null) {
            throw new IllegalArgumentException("The default language must be a valid language code");
        }
        this.m = string;
    }

    public String getDefaultLanguage() {
        return this.m;
    }

    public void setDefaultCountry(String string) {
        this.n = string;
    }

    public String getDefaultCountry() {
        return this.n;
    }

    public void setDefaultRegexEngine(String string) {
        if (!("J".equals(string) || "N".equals(string) || "S".equals(string))) {
            throw new IllegalArgumentException("Regex engine must be S|J|N");
        }
        this.L = string;
    }

    public String getDefaultRegexEngine() {
        return this.L;
    }

    public RegularExpression compileRegularExpression(CharSequence charSequence, String string, String string2, List<String> list) {
        return Version.platform.compileRegularExpression(this, charSequence, string, string2, list);
    }

    public Numberer makeNumberer(String string, String string2) {
        if (this.u == null) {
            Numberer_en numberer_en = new Numberer_en();
            if (string != null) {
                ((AbstractNumberer)numberer_en).setLanguage(string);
            }
            if (string2 != null) {
                numberer_en.setCountry(string2);
            }
            return numberer_en;
        }
        Numberer numberer = this.u.getNumberer(string, string2);
        if (numberer == null) {
            numberer = new Numberer_en();
        }
        return numberer;
    }

    public void setModuleURIResolver(ModuleURIResolver moduleURIResolver) {
        this.getDefaultStaticQueryContext().setModuleURIResolver(moduleURIResolver);
    }

    public void setModuleURIResolver(String string) {
        Object object = this.p.getInstance(string, null);
        if (object instanceof ModuleURIResolver) {
            this.setModuleURIResolver((ModuleURIResolver)object);
            return;
        }
        throw new XPathException("Class " + string + " is not a ModuleURIResolver");
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.getDefaultStaticQueryContext().getModuleURIResolver();
    }

    public ModuleURIResolver getStandardModuleURIResolver() {
        return this.C;
    }

    public UnparsedTextURIResolver getUnparsedTextURIResolver() {
        return this.F;
    }

    public void setUnparsedTextURIResolver(UnparsedTextURIResolver unparsedTextURIResolver) {
        this.F = unparsedTextURIResolver;
    }

    public CompilerInfo getDefaultXsltCompilerInfo() {
        if (this.defaultXsltCompilerInfo.getErrorListener() == null) {
            this.defaultXsltCompilerInfo.setErrorListener(this.getErrorListener());
        }
        return this.defaultXsltCompilerInfo;
    }

    public StaticQueryContext getDefaultStaticQueryContext() {
        if (this.defaultStaticQueryContext == null) {
            this.defaultStaticQueryContext = this.makeStaticQueryContext(false);
        }
        return this.defaultStaticQueryContext;
    }

    protected StaticQueryContext makeStaticQueryContext(boolean bl2) {
        return this.i.newStaticQueryContext(this, bl2);
    }

    public void registerFunctionAnnotationHandler(FunctionAnnotationHandler functionAnnotationHandler) {
        this.V.put(functionAnnotationHandler.getAssertionNamespace(), functionAnnotationHandler);
    }

    public FunctionAnnotationHandler getFunctionAnnotationHandler(String string) {
        return this.V.get(string);
    }

    public int getRecoveryPolicy() {
        return this.defaultXsltCompilerInfo.getRecoveryPolicy();
    }

    public void setRecoveryPolicy(int n2) {
        this.defaultXsltCompilerInfo.setRecoveryPolicy(n2);
    }

    public int getStreamability() {
        return 0;
    }

    public String getMessageEmitterClass() {
        return this.defaultXsltCompilerInfo.getMessageReceiverClassName();
    }

    public void setMessageEmitterClass(String string) {
        this.defaultXsltCompilerInfo.setMessageReceiverClassName(string);
    }

    public String getSourceParserClass() {
        return this.z;
    }

    public void setSourceParserClass(String string) {
        this.z = string;
    }

    public String getStyleParserClass() {
        return this.D;
    }

    public void setStyleParserClass(String string) {
        this.D = string;
    }

    public OutputURIResolver getOutputURIResolver() {
        return this.defaultXsltCompilerInfo.getOutputURIResolver();
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.defaultXsltCompilerInfo.setOutputURIResolver(outputURIResolver);
    }

    public void setSerializerFactory(SerializerFactory serializerFactory) {
        this.w = serializerFactory;
    }

    public SerializerFactory getSerializerFactory() {
        return this.w;
    }

    public CharacterSetFactory getCharacterSetFactory() {
        if (this.b == null) {
            this.b = new CharacterSetFactory();
        }
        return this.b;
    }

    public void setDefaultSerializationProperties(Properties properties) {
        this.o = properties;
    }

    public Properties getDefaultSerializationProperties() {
        return this.o;
    }

    public SerializationProperties obtainDefaultSerializationProperties() {
        return new SerializationProperties(this.o);
    }

    public void processResultDocument(ResultDocument resultDocument, Expression expression, XPathContext xPathContext) {
        resultDocument.processInstruction(expression, xPathContext);
    }

    public <F extends Item<?>, T extends Item<?>> SequenceIterator<T> getMultithreadedItemMappingIterator(SequenceIterator<F> sequenceIterator, ItemMappingFunction<F, T> itemMappingFunction) {
        return new ItemMappingIterator<F, T>(sequenceIterator, itemMappingFunction);
    }

    public boolean isTiming() {
        return this.q.contains(77);
    }

    public void setTiming(boolean bl2) {
        if (bl2) {
            this.q.add(77);
            return;
        }
        this.q.remove(77);
    }

    public boolean isVersionWarning() {
        return this.defaultXsltCompilerInfo.isVersionWarning();
    }

    public void setVersionWarning(boolean bl2) {
        this.defaultXsltCompilerInfo.setVersionWarning(bl2);
    }

    public boolean isValidation() {
        return this.h.getDTDValidationMode() == 1 || this.h.getDTDValidationMode() == 2;
    }

    public void setValidation(boolean bl2) {
        this.h.setDTDValidationMode(bl2 ? 1 : 4);
    }

    public FilterFactory makeDocumentProjector(PathMap.PathMapRoot pathMapRoot) {
        throw new UnsupportedOperationException("Document projection requires Saxon-EE");
    }

    public FilterFactory makeDocumentProjector(XQueryExpression xQueryExpression) {
        throw new UnsupportedOperationException("Document projection requires Saxon-EE");
    }

    public int getSchemaValidationMode() {
        return this.h.getSchemaValidationMode();
    }

    public void setSchemaValidationMode(int n2) {
        this.h.setSchemaValidationMode(n2);
    }

    public void setValidationWarnings(boolean bl2) {
        this.h.setContinueAfterValidationErrors(bl2);
    }

    public boolean isValidationWarnings() {
        return this.h.isContinueAfterValidationErrors();
    }

    public void setExpandAttributeDefaults(boolean bl2) {
        this.h.setExpandAttributeDefaults(bl2);
    }

    public boolean isExpandAttributeDefaults() {
        return this.h.isExpandAttributeDefaults();
    }

    public NamePool getNamePool() {
        return this.v;
    }

    public void setNamePool(NamePool namePool) {
        this.v = namePool;
    }

    public TypeHierarchy getTypeHierarchy() {
        if (this.typeHierarchy == null) {
            this.typeHierarchy = new TypeHierarchy(this);
        }
        return this.typeHierarchy;
    }

    public TypeChecker getTypeChecker(boolean bl2) {
        if (bl2) {
            return this.N;
        }
        return this.M;
    }

    public TypeAliasManager makeTypeAliasManager() {
        return new TypeAliasManager();
    }

    public DocumentNumberAllocator getDocumentNumberAllocator() {
        return this.k;
    }

    public void setDocumentNumberAllocator(DocumentNumberAllocator documentNumberAllocator) {
        this.k = documentNumberAllocator;
    }

    public boolean isCompatible(Configuration configuration) {
        return this.v == configuration.v && this.k == configuration.k;
    }

    public DocumentPool getGlobalDocumentPool() {
        return this.s;
    }

    public boolean isStripsAllWhiteSpace() {
        return this.h.getSpaceStrippingRule() == AllElementsSpaceStrippingRule.getInstance();
    }

    public void setStripsAllWhiteSpace(boolean bl2) {
        if (bl2) {
            this.h.setSpaceStrippingRule(AllElementsSpaceStrippingRule.getInstance());
        }
    }

    public XMLReader createXMLParser() {
        XMLReader xMLReader;
        if (this.getSourceParserClass() != null) {
            Configuration configuration = this;
            xMLReader = configuration.makeParser(configuration.getSourceParserClass());
        } else {
            xMLReader = Configuration.a();
        }
        return xMLReader;
    }

    public XMLReader getSourceParser() {
        XMLReader xMLReader;
        if (this.x == null) {
            this.x = new ConcurrentLinkedQueue();
        }
        if ((xMLReader = this.x.poll()) != null) {
            return xMLReader;
        }
        if (this.getSourceParserClass() != null) {
            Configuration configuration = this;
            xMLReader = configuration.makeParser(configuration.getSourceParserClass());
        } else {
            xMLReader = Configuration.a();
        }
        if (this.isTiming()) {
            Object object = xMLReader;
            Configuration configuration = this;
            object = object.getClass().getName();
            configuration.B.info("Using parser " + (String)object);
        }
        try {
            Sender.configureParser(xMLReader);
        }
        catch (XPathException xPathException) {
            throw new TransformerFactoryConfigurationError(xPathException);
        }
        if (this.isValidation()) {
            try {
                xMLReader.setFeature("http://xml.org/sax/features/validation", true);
            }
            catch (SAXException sAXException) {
                throw new TransformerFactoryConfigurationError("The XML parser does not support validation");
            }
        }
        return xMLReader;
    }

    public synchronized void reuseSourceParser(XMLReader xMLReader) {
        if (this.x == null) {
            this.x = new ConcurrentLinkedQueue();
        }
        try {
            try {
                xMLReader.setContentHandler(null);
                if (xMLReader.getEntityResolver() == this.h.getEntityResolver()) {
                    xMLReader.setEntityResolver(null);
                }
                xMLReader.setDTDHandler(null);
                xMLReader.setErrorHandler(null);
                xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", Y);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {}
            this.x.offer(xMLReader);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private static XMLReader a() {
        return Version.platform.loadParser();
    }

    public synchronized XMLReader getStyleParser() {
        XMLReader xMLReader;
        if (this.y == null) {
            this.y = new ConcurrentLinkedQueue();
        }
        if ((xMLReader = this.y.poll()) != null) {
            return xMLReader;
        }
        if (this.getStyleParserClass() != null) {
            Configuration configuration = this;
            xMLReader = configuration.makeParser(configuration.getStyleParserClass());
        } else {
            xMLReader = Configuration.a();
            StandardEntityResolver standardEntityResolver = new StandardEntityResolver();
            standardEntityResolver.setConfiguration(this);
            xMLReader.setEntityResolver(standardEntityResolver);
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            throw new TransformerFactoryConfigurationError(sAXException);
        }
        return xMLReader;
    }

    public synchronized void reuseStyleParser(XMLReader xMLReader) {
        if (this.y == null) {
            this.y = new ConcurrentLinkedQueue();
        }
        try {
            try {
                xMLReader.setContentHandler(null);
                xMLReader.setDTDHandler(null);
                xMLReader.setErrorHandler(null);
                xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", Y);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {}
            this.y.offer(xMLReader);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void loadSchema(String string) {
        Configuration configuration = this;
        configuration.readSchema(configuration.makePipelineConfiguration(), "", string, null);
    }

    public String readSchema(PipelineConfiguration pipelineConfiguration, String string, String string2, String string3) {
        this.needEnterpriseEdition();
        return null;
    }

    public void readMultipleSchemas(PipelineConfiguration pipelineConfiguration, String string, Collection<String> collection, String string2) {
        this.needEnterpriseEdition();
    }

    public String readInlineSchema(NodeInfo nodeInfo, String string, ErrorListener errorListener) {
        this.needEnterpriseEdition();
        return null;
    }

    protected void needEnterpriseEdition() {
        throw new UnsupportedOperationException("You need the Enterprise Edition of Saxon (with an EnterpriseConfiguration) for this operation");
    }

    public void addSchemaSource(Source source) {
        this.addSchemaSource(source, this.getErrorListener());
    }

    public void addSchemaSource(Source source, ErrorListener errorListener) {
        this.needEnterpriseEdition();
    }

    public void addSchemaForBuiltInNamespace(String string) {
    }

    public boolean isSchemaAvailable(String string) {
        return false;
    }

    public void clearSchemaCache() {
    }

    public Set<String> getImportedNamespaces() {
        return Collections.emptySet();
    }

    public void sealNamespace(String string) {
    }

    public Collection<GlobalParam> getDeclaredSchemaParameters() {
        return null;
    }

    public Iterator<? extends SchemaType> getExtensionsOfType(SchemaType object) {
        object = Collections.emptySet();
        return object.iterator();
    }

    public void importComponents(Source source) {
        this.needEnterpriseEdition();
    }

    public void exportComponents(Receiver receiver) {
        this.needEnterpriseEdition();
    }

    public Function getSchemaAsFunctionItem() {
        return null;
    }

    public Function getSchemaComponentAsFunctionItem(String string, QNameValue qNameValue) {
        return null;
    }

    public SchemaDeclaration getElementDeclaration(int n2) {
        return null;
    }

    public SchemaDeclaration getElementDeclaration(StructuredQName structuredQName) {
        return null;
    }

    public SchemaDeclaration getAttributeDeclaration(int n2) {
        return null;
    }

    public SchemaDeclaration getAttributeDeclaration(StructuredQName structuredQName) {
        return null;
    }

    public SchemaType getSchemaType(StructuredQName structuredQName) {
        if (structuredQName.hasURI("http://www.w3.org/2001/XMLSchema")) {
            return BuiltInType.getSchemaTypeByLocalName(structuredQName.getLocalPart());
        }
        return null;
    }

    public ItemType makeUserUnionType(List<AtomicType> list) {
        return null;
    }

    @Override
    public boolean isDeclaredNotation(String string, String string2) {
        return false;
    }

    public void checkTypeDerivationIsOK(SchemaType schemaType, SchemaType schemaType2, int n2) {
    }

    public void prepareValidationReporting(XPathContext xPathContext, ParseOptions parseOptions) {
    }

    public Receiver getDocumentValidator(Receiver receiver, String string, ParseOptions parseOptions, Location location) {
        return receiver;
    }

    public Receiver getElementValidator(Receiver receiver, ParseOptions parseOptions, Location location) {
        return receiver;
    }

    public SimpleType validateAttribute(StructuredQName structuredQName, CharSequence charSequence, int n2) {
        return BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    public Receiver getAnnotationStripper(Receiver receiver) {
        return receiver;
    }

    public XMLReader makeParser(String object) {
        try {
            Object object2 = this.p.getInstance((String)object, null);
            if (object2 instanceof XMLReader) {
                return (XMLReader)object2;
            }
            if (object2 instanceof SAXParserFactory) {
                try {
                    object = ((SAXParserFactory)object2).newSAXParser();
                    return ((SAXParser)object).getXMLReader();
                }
                catch (ParserConfigurationException | SAXException exception) {
                    throw new XPathException(exception);
                }
            }
        }
        catch (XPathException xPathException) {
            throw new TransformerFactoryConfigurationError(xPathException);
        }
        throw new TransformerFactoryConfigurationError("Class " + (String)object + " is not a SAX2 XMLReader or SAXParserFactory");
    }

    public XPathParser newExpressionParser(String object, boolean bl2, int n2) {
        if ("XQ".equals(object)) {
            if (bl2) {
                throw new XPathException("XQuery Update is supported only in Saxon-EE");
            }
            if (n2 == 31 || n2 == 30 || n2 == 10) {
                object = new XQueryParser();
                ((XPathParser)object).setLanguage(3, 31);
                return object;
            }
            throw new XPathException("Unknown XQuery version " + n2);
        }
        if ("XP".equals(object)) {
            if (n2 == 31 || n2 == 30 || n2 == 305 || n2 == 20) {
                object = new XPathParser();
                ((XPathParser)object).setLanguage(0, n2);
                return object;
            }
            throw new XPathException("Unknown XPath version " + n2);
        }
        if ("PATTERN".equals(object)) {
            if (n2 == 30 || n2 == 20 || n2 == 305 || n2 == 31) {
                return new PatternParser30();
            }
            throw new XPathException("Unknown XPath version " + n2);
        }
        throw new XPathException("Unknown expression language " + (String)object);
    }

    public ExpressionPresenter newExpressionExporter(String string, OutputStream outputStream, StylesheetPackage stylesheetPackage) {
        throw new XPathException("Exporting a stylesheet requires Saxon-EE");
    }

    public void setDebugger(Debugger debugger) {
        this.l = debugger;
    }

    public Debugger getDebugger() {
        return this.l;
    }

    public SlotManager makeSlotManager() {
        if (this.l == null) {
            return new SlotManager();
        }
        return this.l.makeSlotManager();
    }

    public Receiver makeStreamingTransformer(XPathContext xPathContext, Mode mode, ParameterSet parameterSet, ParameterSet parameterSet2) {
        throw new XPathException("Streaming is only available in Saxon-EE");
    }

    public Expression makeStreamInstruction(Expression expression, Expression expression2, boolean bl2, ParseOptions parseOptions, PackageData packageData, Location location, RetainedStaticContext retainedStaticContext) {
        expression = new SourceDocument(expression, expression2, parseOptions);
        expression.setLocation(location);
        expression.setRetainedStaticContext(retainedStaticContext);
        return expression;
    }

    public java.util.function.Function<SequenceIterator<?>, FocusTrackingIterator<?>> getFocusTrackerFactory(Executable executable, boolean bl2) {
        return FocusTrackingIterator::new;
    }

    public void checkStrictStreamability(XSLTemplate xSLTemplate, Expression expression) {
    }

    public boolean isStreamedNode(NodeInfo nodeInfo) {
        return false;
    }

    public OptimizerOptions getOptimizerOptions() {
        return this.optimizerOptions.intersect(OptimizerOptions.FULL_HE_OPTIMIZATION);
    }

    public Optimizer obtainOptimizer() {
        if (this.optimizer == null) {
            this.optimizer = new Optimizer(this);
            this.optimizer.setOptimizerOptions(this.optimizerOptions.intersect(OptimizerOptions.FULL_HE_OPTIMIZATION));
            return this.optimizer;
        }
        return this.optimizer;
    }

    public Optimizer obtainOptimizer(OptimizerOptions optimizerOptions) {
        Optimizer optimizer = new Optimizer(this);
        optimizer.setOptimizerOptions(optimizerOptions.intersect(OptimizerOptions.FULL_HE_OPTIMIZATION));
        return optimizer;
    }

    public Expression makeFunctionSequenceCoercer(SpecificFunctionType specificFunctionType, Expression expression, RoleDiagnostic roleDiagnostic) {
        throw new XPathException("Function coercion requires Saxon-PE or higher");
    }

    public ContextItemStaticInfo makeContextItemStaticInfo(ItemType itemType, boolean bl2) {
        return new ContextItemStaticInfo(itemType, bl2);
    }

    public ContextItemStaticInfo getDefaultContextItemStaticInfo() {
        return ContextItemStaticInfo.DEFAULT;
    }

    public XQueryExpression makeXQueryExpression(Expression expression, QueryModule queryModule, boolean bl2) {
        return new XQueryExpression(expression, queryModule, false);
    }

    public Sequence<?> makeClosure(Expression expression, int n2, XPathContext xPathContext) {
        if (this.getBooleanProperty(Feature.EAGER_EVALUATION)) {
            SequenceIterator<?> sequenceIterator = expression.iterate(xPathContext);
            return sequenceIterator.materialize();
        }
        Closure closure = n2 > 1 ? new MemoClosure() : new Closure();
        closure.setExpression(expression);
        closure.setSavedXPathContext(xPathContext.newContext());
        closure.saveContext(expression, xPathContext);
        return closure;
    }

    public GroundedValue<?> makeSequenceExtent(Expression expression, int n2, XPathContext xPathContext) {
        return expression.iterate(xPathContext).materialize();
    }

    public StyleNodeFactory makeStyleNodeFactory(Compilation compilation) {
        return new StyleNodeFactory(this, compilation);
    }

    public Expression makeEvaluateInstruction(XSLEvaluate xSLEvaluate, ComponentDeclaration componentDeclaration) {
        return new ErrorExpression(new XPathException("xsl:evaluate is not available in this configuration", "XTDE3175"));
    }

    public StylesheetPackage makeStylesheetPackage() {
        return new StylesheetPackage(this);
    }

    public AccumulatorRegistry makeAccumulatorRegistry() {
        return new AccumulatorRegistry();
    }

    public void registerExternalObjectModel(ExternalObjectModel externalObjectModel) {
        try {
            this.getClass(externalObjectModel.getDocumentClassName(), false, null);
        }
        catch (XPathException xPathException) {
            return;
        }
        if (this.r == null) {
            this.r = new ArrayList<ExternalObjectModel>(4);
        }
        if (!this.r.contains(externalObjectModel)) {
            this.r.add(externalObjectModel);
        }
    }

    public ExternalObjectModel getExternalObjectModel(String string) {
        for (ExternalObjectModel externalObjectModel : this.r) {
            if (!externalObjectModel.getIdentifyingURI().equals(string)) continue;
            return externalObjectModel;
        }
        return null;
    }

    public ExternalObjectModel getExternalObjectModel(Class clazz) {
        for (ExternalObjectModel externalObjectModel : this.r) {
            PJConverter pJConverter = externalObjectModel.getPJConverter(clazz);
            if (pJConverter == null) continue;
            return externalObjectModel;
        }
        return null;
    }

    public List<ExternalObjectModel> getExternalObjectModels() {
        return this.r;
    }

    public synchronized JavaExternalObjectType getJavaExternalObjectType(Class clazz) {
        return new JavaExternalObjectType(this, clazz);
    }

    public Map<String, Function> makeMethodMap(Class clazz, String string) {
        throw new UnsupportedOperationException();
    }

    public MapItem externalObjectAsMap(ObjectValue objectValue, String string) {
        throw new UnsupportedOperationException();
    }

    public Expression makeObjectLookupExpression(Expression expression, Expression expression2) {
        throw new UnsupportedOperationException();
    }

    public NodeInfo unravel(Source source) {
        Object object = this.getExternalObjectModels();
        if (!(source instanceof NodeInfo)) {
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (ExternalObjectModel)object.next();
                if ((object2 = object2.unravel(source, this)) == null) continue;
                if (!object2.getConfiguration().isCompatible(this)) {
                    throw new IllegalArgumentException("Externally supplied Node belongs to the wrong Configuration");
                }
                return object2;
            }
        }
        if (source instanceof NodeInfo) {
            if (!((NodeInfo)source).getConfiguration().isCompatible(this)) {
                throw new IllegalArgumentException("Externally supplied NodeInfo belongs to the wrong Configuration");
            }
            return (NodeInfo)source;
        }
        throw new IllegalArgumentException("A source of class " + source.getClass() + " is not recognized by any registered object model");
    }

    public boolean isExtensionElementAvailable(StructuredQName structuredQName) {
        return false;
    }

    public void setStaticQueryContextFactory(StaticQueryContextFactory staticQueryContextFactory) {
        this.i = staticQueryContextFactory;
    }

    public StaticQueryContext newStaticQueryContext() {
        return this.makeStaticQueryContext(true);
    }

    public PendingUpdateList newPendingUpdateList() {
        throw new UnsupportedOperationException("XQuery update is supported only in Saxon-EE");
    }

    public PipelineConfiguration makePipelineConfiguration() {
        PipelineConfiguration pipelineConfiguration = new PipelineConfiguration(this);
        pipelineConfiguration.setURIResolver(this.getURIResolver());
        pipelineConfiguration.setParseOptions(new ParseOptions(this.h));
        pipelineConfiguration.setErrorListener(this.getErrorListener());
        return pipelineConfiguration;
    }

    public SchemaURIResolver makeSchemaURIResolver(URIResolver uRIResolver) {
        return null;
    }

    public static Configuration getConfiguration(XPathContext xPathContext) {
        return xPathContext.getConfiguration();
    }

    public void setSourceResolver(SourceResolver sourceResolver) {
        this.A = sourceResolver;
    }

    public SourceResolver getSourceResolver() {
        return this.A;
    }

    @Override
    public Source resolveSource(Source source, Configuration configuration) {
        if (source instanceof AugmentedSource) {
            return source;
        }
        if (source instanceof StreamSource) {
            return source;
        }
        if (source instanceof SAXSource) {
            return source;
        }
        if (source instanceof DOMSource) {
            return source;
        }
        if (source instanceof NodeInfo) {
            return source;
        }
        if (source instanceof PullSource) {
            return source;
        }
        if (source instanceof StAXSource) {
            return source;
        }
        if (source instanceof EventSource) {
            return source;
        }
        return null;
    }

    public TreeInfo buildDocumentTree(Source source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (source instanceof AugmentedSource) {
            return this.buildDocumentTree(((AugmentedSource)source).getContainedSource(), ((AugmentedSource)source).getParseOptions());
        }
        return this.buildDocumentTree(source, new ParseOptions(this.h));
    }

    public TreeInfo buildDocumentTree(Source object, ParseOptions object2) {
        if (object == null) {
            throw new NullPointerException("source");
        }
        boolean bl2 = false;
        try {
            object2 = new ParseOptions((ParseOptions)object2);
            Object object3 = this.resolveSource((Source)object, this);
            if (object3 == null) {
                throw new XPathException("Unknown source class " + object.getClass().getName());
            }
            object = object3;
            if (object instanceof AugmentedSource) {
                ((ParseOptions)object2).merge(((AugmentedSource)object).getParseOptions());
            }
            ((ParseOptions)object2).applyDefaults(this);
            bl2 = ((ParseOptions)object2).isPleaseCloseAfterUse();
            object3 = ((ParseOptions)object2).getModel();
            boolean bl3 = ((ParseOptions)object2).isLineNumbering();
            PipelineConfiguration pipelineConfiguration = this.makePipelineConfiguration();
            pipelineConfiguration.setParseOptions((ParseOptions)object2);
            object3 = ((TreeModel)object3).makeBuilder(pipelineConfiguration);
            ((Builder)object3).setTiming(this.isTiming());
            ((Builder)object3).setLineNumbering(bl3);
            ((Builder)object3).setPipelineConfiguration(pipelineConfiguration);
            ((Builder)object3).setSystemId(object.getSystemId());
            Sender.send((Source)object, new NamespaceReducer((Receiver)object3), (ParseOptions)object2);
            object2 = ((Builder)object3).getCurrentRoot();
            if (object2.getNodeKind() != 9) {
                throw new XPathException("Source object represents a node other than a document node");
            }
            ((Builder)object3).reset();
            object2 = object2.getTreeInfo();
            return object2;
        }
        finally {
            if (bl2) {
                ParseOptions.close((Source)object);
            }
        }
    }

    public DocumentInfo buildDocument(Source source) {
        source = this.buildDocumentTree(source);
        source = source.getRootNode();
        return new DocumentInfo((NodeInfo)source);
    }

    public DocumentInfo buildDocument(Source source, ParseOptions parseOptions) {
        source = this.buildDocumentTree(source, parseOptions);
        source = source.getRootNode();
        return new DocumentInfo((NodeInfo)source);
    }

    public TreeStatistics getTreeStatistics() {
        return this.X;
    }

    public Receiver makeEmitter(String object, Properties properties) {
        Object object2;
        int n2 = ((String)object).indexOf(125);
        object = ((String)object).substring(n2 + 1);
        n2 = ((String)object).indexOf(58);
        object = ((String)object).substring(n2 + 1);
        try {
            object2 = this.p.getInstance((String)object, null);
        }
        catch (XPathException xPathException) {
            throw new XPathException("Cannot create user-supplied output method. " + xPathException.getMessage(), "SXCH0004");
        }
        if (object2 instanceof Receiver) {
            return (Receiver)object2;
        }
        if (object2 instanceof ContentHandler) {
            object = new ContentHandlerProxy();
            ((ContentHandlerProxy)object).setUnderlyingContentHandler((ContentHandler)object2);
            ((ContentHandlerProxy)object).setOutputProperties(properties);
            return object;
        }
        throw new XPathException("Output method " + (String)object + " is neither a Receiver nor a SAX2 ContentHandler");
    }

    public void setConfigurationProperty(String string, Object object) {
        Feature<?> feature = Feature.byName(string);
        if (feature == null) {
            if (string.startsWith("http://saxon.sf.net/feature/parserFeature?uri=")) {
                feature = string.substring(46);
                try {
                    feature = URLDecoder.decode((String)((Object)feature), "utf-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new IllegalArgumentException(unsupportedEncodingException);
                }
                this.h.addParserFeature((String)((Object)feature), Configuration.requireBoolean(string, object));
                return;
            }
            if (string.startsWith("http://saxon.sf.net/feature/parserProperty?uri=")) {
                feature = string.substring(47);
                try {
                    feature = URLDecoder.decode((String)((Object)feature), "utf-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new IllegalArgumentException(unsupportedEncodingException);
                }
                this.h.addParserProperties((String)((Object)feature), object);
                return;
            }
            throw new IllegalArgumentException("Unrecognized configuration feature: " + string);
        }
        this.setConfigurationProperty(feature, object);
    }

    public <T> void setConfigurationProperty(Feature<T> object, T t2) {
        String string = ((Feature)object).name;
        if (booleanFeatures.contains(object)) {
            if (object == Feature.COMPILE_WITH_TRACING) {
                boolean bl2 = Configuration.requireBoolean(string, t2);
                this.setCompileWithTracing(bl2);
            } else if (object == Feature.DTD_VALIDATION) {
                boolean bl3 = Configuration.requireBoolean(string, t2);
                this.setValidation(bl3);
            } else if (object == Feature.EXPAND_ATTRIBUTE_DEFAULTS) {
                boolean bl4 = Configuration.requireBoolean(string, t2);
                this.setExpandAttributeDefaults(bl4);
            }
            this.internalSetBooleanProperty((Feature)object, t2);
            return;
        }
        block2 : switch (((Feature)object).code) {
            case 6: {
                if (!(t2 instanceof CollationURIResolver)) {
                    throw new IllegalArgumentException("COLLATION_URI_RESOLVER value must be an instance of net.sf.saxon.lib.CollationURIResolver");
                }
                this.setCollationURIResolver((CollationURIResolver)t2);
                return;
            }
            case 7: {
                Configuration configuration = this;
                configuration.setCollationURIResolver((CollationURIResolver)configuration.instantiateClassName(string, t2, CollationURIResolver.class));
                return;
            }
            case 10: {
                if (!(t2 instanceof CollectionURIResolver)) {
                    throw new IllegalArgumentException("COLLECTION_URI_RESOLVER value must be an instance of net.sf.saxon.lib.CollectionURIResolver");
                }
                this.setCollectionURIResolver((CollectionURIResolver)t2);
                return;
            }
            case 11: {
                Configuration configuration = this;
                configuration.setCollectionURIResolver((CollectionURIResolver)configuration.instantiateClassName(string, t2, CollectionURIResolver.class));
                return;
            }
            case 8: {
                if (!(t2 instanceof CollectionFinder)) {
                    throw new IllegalArgumentException("COLLECTION_FINDER value must be an instance of net.sf.saxon.lib.ICollectionFinder");
                }
                this.setCollectionFinder((CollectionFinder)t2);
                return;
            }
            case 9: {
                Configuration configuration = this;
                configuration.setCollectionFinder((CollectionFinder)configuration.instantiateClassName(string, t2, CollectionFinder.class));
                return;
            }
            case 17: {
                this.e = t2.toString();
                return;
            }
            case 18: {
                this.setDefaultCollection(t2.toString());
                return;
            }
            case 19: {
                this.setDefaultCountry(t2.toString());
                return;
            }
            case 20: {
                this.setDefaultLanguage(t2.toString());
                return;
            }
            case 21: {
                this.setDefaultRegexEngine(t2.toString());
                return;
            }
            case 25: {
                int n2;
                ParseOptions parseOptions;
                boolean bl5 = Configuration.requireBoolean(string, t2);
                if (bl5) {
                    parseOptions = this.h;
                    n2 = 2;
                } else {
                    parseOptions = this.h;
                    n2 = this.isValidation() ? 1 : 4;
                }
                parseOptions.setDTDValidationMode(n2);
                this.internalSetBooleanProperty(Feature.DTD_VALIDATION_RECOVERABLE, bl5);
                return;
            }
            case 27: {
                if ("".equals(t2)) {
                    this.h.setEntityResolver(null);
                    return;
                }
                this.h.setEntityResolver((EntityResolver)this.instantiateClassName(string, t2, EntityResolver.class));
                return;
            }
            case 28: {
                if (!(t2 instanceof EnvironmentVariableResolver)) {
                    throw new IllegalArgumentException("ENVIRONMENT_VARIABLE_RESOLVER value must be an instance of net.sf.saxon.lib.EnvironmentVariableResolver");
                }
                this.f = (EnvironmentVariableResolver)t2;
                return;
            }
            case 29: {
                this.f = (EnvironmentVariableResolver)this.instantiateClassName(string, t2, EnvironmentVariableResolver.class);
                return;
            }
            case 30: {
                Configuration configuration = this;
                configuration.setErrorListener((ErrorListener)configuration.instantiateClassName(string, t2, ErrorListener.class));
                return;
            }
            case 38: {
                boolean bl6 = Configuration.requireBoolean(string, t2);
                this.setLineNumbering(bl6);
                return;
            }
            case 41: {
                if (!(t2 instanceof String)) {
                    throw new IllegalArgumentException("MESSAGE_EMITTER_CLASS class must be a String");
                }
                this.setMessageEmitterClass((String)t2);
                return;
            }
            case 42: {
                if (!(t2 instanceof ModuleURIResolver)) {
                    throw new IllegalArgumentException("MODULE_URI_RESOLVER value must be an instance of net.sf.saxon.lib.ModuleURIResolver");
                }
                this.setModuleURIResolver((ModuleURIResolver)t2);
                return;
            }
            case 43: {
                Configuration configuration = this;
                configuration.setModuleURIResolver((ModuleURIResolver)configuration.instantiateClassName(string, t2, ModuleURIResolver.class));
                return;
            }
            case 46: {
                if (!(t2 instanceof NamePool)) {
                    throw new IllegalArgumentException("NAME_POOL value must be an instance of net.sf.saxon.om.NamePool");
                }
                this.setNamePool((NamePool)t2);
                return;
            }
            case 48: {
                int n3;
                this.optimizerOptions = t2 instanceof Integer ? ((n3 = ((Integer)t2).intValue()) == 0 ? new OptimizerOptions(0) : OptimizerOptions.FULL_EE_OPTIMIZATION) : ((string = this.requireString(string, t2)).matches("[0-9]+") ? ("0".equals(string) ? new OptimizerOptions(0) : OptimizerOptions.FULL_EE_OPTIMIZATION) : new OptimizerOptions(string));
                if (this.optimizer != null) {
                    this.optimizer.setOptimizerOptions(this.optimizerOptions);
                }
                this.internalSetBooleanProperty(Feature.GENERATE_BYTE_CODE, this.optimizerOptions.isSet(64));
                this.defaultXsltCompilerInfo.setOptimizerOptions(this.optimizerOptions);
                return;
            }
            case 49: {
                if (!(t2 instanceof OutputURIResolver)) {
                    throw new IllegalArgumentException("OUTPUT_URI_RESOLVER value must be an instance of net.sf.saxon.lib.OutputURIResolver");
                }
                this.setOutputURIResolver((OutputURIResolver)t2);
                return;
            }
            case 50: {
                Configuration configuration = this;
                configuration.setOutputURIResolver((OutputURIResolver)configuration.instantiateClassName(string, t2, OutputURIResolver.class));
                return;
            }
            case 53: {
                boolean bl7 = Configuration.requireBoolean(string, t2);
                this.getSystemURIResolver().setRecognizeQueryParameters(bl7);
                return;
            }
            case 54: {
                Configuration configuration = this;
                configuration.setRecoveryPolicy(configuration.requireInteger(string, t2));
                return;
            }
            case 55: {
                int n4;
                if (!(t2 instanceof String)) {
                    throw new IllegalArgumentException("RECOVERY_POLICY_NAME value must be a String");
                }
                if (t2.equals("recoverSilently")) {
                    n4 = 0;
                } else if (t2.equals("recoverWithWarnings")) {
                    n4 = 1;
                } else if (t2.equals("doNotRecover")) {
                    n4 = 2;
                } else {
                    throw new IllegalArgumentException("Unrecognized value of RECOVERY_POLICY_NAME = '" + t2 + "': must be 'recoverSilently', 'recoverWithWarnings', or 'doNotRecover'");
                }
                this.setRecoveryPolicy(n4);
                return;
            }
            case 119: {
                this.W = this.requireInteger(string, t2);
                return;
            }
            case 62: {
                Configuration configuration = this;
                configuration.setSerializerFactory((SerializerFactory)configuration.instantiateClassName(string, t2, SerializerFactory.class));
                return;
            }
            case 60: {
                Configuration configuration = this;
                configuration.setSchemaValidationMode(configuration.requireInteger(((Feature)object).name, t2));
                return;
            }
            case 61: {
                object = this.requireString(((Feature)object).name, t2);
                this.setSchemaValidationMode(Validation.getCode((String)object));
                return;
            }
            case 63: {
                Configuration configuration = this;
                configuration.setSourceParserClass(configuration.requireString(((Feature)object).name, t2));
                return;
            }
            case 64: {
                Configuration configuration = this;
                configuration.setSourceResolver((SourceResolver)configuration.instantiateClassName(string, t2, SourceResolver.class));
                return;
            }
            case 67: {
                try {
                    this.setStandardErrorOutput(new PrintStream(new FileOutputStream((String)t2, true), true));
                    return;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new IllegalArgumentException(fileNotFoundException);
                }
            }
            case 71: {
                switch (this.requireString(string, t2)) {
                    case "all": {
                        this.h.setSpaceStrippingRule(AllElementsSpaceStrippingRule.getInstance());
                        break block2;
                    }
                    case "none": {
                        this.h.setSpaceStrippingRule(NoElementsSpaceStrippingRule.getInstance());
                        break block2;
                    }
                    case "ignorable": {
                        this.h.setSpaceStrippingRule(IgnorableSpaceStrippingRule.getInstance());
                        break block2;
                    }
                }
                throw new IllegalArgumentException("Unrecognized value STRIP_WHITESPACE = '" + t2 + "': must be 'all', 'none', or 'ignorable'");
            }
            case 72: {
                Configuration configuration = this;
                configuration.setStyleParserClass(configuration.requireString(string, t2));
                return;
            }
            case 77: {
                this.setTiming(Configuration.requireBoolean(string, t2));
                return;
            }
            case 79: {
                if (!(t2 instanceof TraceListener)) {
                    throw new IllegalArgumentException("TRACE_LISTENER is of wrong class");
                }
                this.setTraceListener((TraceListener)t2);
                return;
            }
            case 80: {
                Configuration configuration = this;
                configuration.setTraceListenerClass(configuration.requireString(string, t2));
                return;
            }
            case 81: {
                Configuration configuration = this;
                configuration.setTraceListenerOutputFile(configuration.requireString(string, t2));
                return;
            }
            case 83: {
                Configuration configuration = this;
                configuration.setTreeModel(configuration.requireInteger(string, t2));
                return;
            }
            case 84: {
                switch (this.requireString(string, t2)) {
                    case "tinyTree": {
                        this.setTreeModel(1);
                        break block2;
                    }
                    case "tinyTreeCondensed": {
                        this.setTreeModel(2);
                        break block2;
                    }
                    case "linkedTree": {
                        this.setTreeModel(0);
                        break block2;
                    }
                    case "jdom": {
                        this.setTreeModel(3);
                        break block2;
                    }
                    case "jdom2": {
                        this.setTreeModel(4);
                        break block2;
                    }
                }
                throw new IllegalArgumentException("Unrecognized value TREE_MODEL_NAME = '" + t2 + "': must be linkedTree|tinyTree|tinyTreeCondensed");
            }
            case 85: {
                this.setUnparsedTextURIResolver((UnparsedTextURIResolver)t2);
                return;
            }
            case 86: {
                Configuration configuration = this;
                configuration.setUnparsedTextURIResolver((UnparsedTextURIResolver)configuration.instantiateClassName(string, t2, UnparsedTextURIResolver.class));
                return;
            }
            case 87: {
                Configuration configuration = this;
                configuration.setURIResolver((URIResolver)configuration.instantiateClassName(string, t2, URIResolver.class));
                return;
            }
            case 90: {
                this.h.setUseXsiSchemaLocation(Configuration.requireBoolean(string, t2));
                return;
            }
            case 91: {
                this.h.setAddCommentsAfterValidationErrors(Configuration.requireBoolean(string, t2));
                return;
            }
            case 92: {
                this.setValidationWarnings(Configuration.requireBoolean(string, t2));
                return;
            }
            case 93: {
                this.setVersionWarning(Configuration.requireBoolean(string, t2));
                return;
            }
            case 94: {
                this.setXIncludeAware(Configuration.requireBoolean(string, t2));
                return;
            }
            case 120: {
                int n5 = this.requireInteger(string, t2);
                if (n5 != 20 && n5 != 30 && n5 != 31) {
                    throw new IllegalArgumentException("XPath version for XSD must be 20 (XPath 2.0), 30 (XPath 3.0), or 31 (XPath 3.1)");
                }
                this.Q = n5;
                return;
            }
            case 121: {
                int n6 = this.requireInteger(string, t2);
                if (n6 != 20 && n6 != 30 && n6 != 305 && n6 != 31) {
                    throw new IllegalArgumentException("XPath version for XSLT must be 20 (XPath 2.0), 30 (XPath 3.0), 31 (XPath 3.1), or 305 (XPath 3.0 with XSLT-defined extensions)");
                }
                this.R = n6;
                return;
            }
            case 98: {
                this.getDefaultStaticQueryContext().setUpdatingEnabled(Configuration.requireBoolean(string, t2));
                return;
            }
            case 99: {
                this.getDefaultStaticQueryContext().setConstructionMode(Validation.getCode(t2.toString()));
                return;
            }
            case 100: {
                this.getDefaultStaticQueryContext().setDefaultElementNamespace(t2.toString());
                return;
            }
            case 101: {
                this.getDefaultStaticQueryContext().setDefaultFunctionNamespace(t2.toString());
                return;
            }
            case 102: {
                this.getDefaultStaticQueryContext().setEmptyLeast(Configuration.requireBoolean(string, t2));
                return;
            }
            case 103: {
                this.getDefaultStaticQueryContext().setInheritNamespaces(Configuration.requireBoolean(string, t2));
                return;
            }
            case 105: {
                this.getDefaultStaticQueryContext().setPreserveBoundarySpace(Configuration.requireBoolean(string, t2));
                return;
            }
            case 106: {
                this.getDefaultStaticQueryContext().setPreserveNamespaces(Configuration.requireBoolean(string, t2));
                return;
            }
            case 107: {
                object = new XPathParser();
                ((XPathParser)object).setLanguage(2, 31);
                try {
                    object = ((XPathParser)object).parseSequenceType(t2.toString(), new IndependentContext(this));
                    if (((SequenceType)object).getCardinality() != 16384) {
                        throw new IllegalArgumentException("Context item type must have no occurrence indicator");
                    }
                    this.getDefaultStaticQueryContext().setRequiredContextItemType(((SequenceType)object).getPrimaryType());
                    return;
                }
                catch (XPathException xPathException) {
                    throw new IllegalArgumentException(xPathException);
                }
            }
            case 108: {
                this.getDefaultStaticQueryContext().setSchemaAware(Configuration.requireBoolean(string, t2));
                return;
            }
            case 109: {
                this.getDefaultStaticQueryContext().setErrorListener((ErrorListener)this.instantiateClassName(string, t2, ErrorListener.class));
                return;
            }
            case 110: {
                if (!"3.1".equals(t2)) {
                    this.getErrorListener().warning(new XPathException("XQuery version ignored: only \"3.1\" is recognized"));
                }
                this.getDefaultStaticQueryContext().setLanguageVersion(31);
                return;
            }
            case 95: {
                object = this.requireString(string, t2);
                if (!((String)object).equals("1.0") && !((String)object).equals("1.1")) {
                    throw new IllegalArgumentException("XML_VERSION value must be \"1.0\" or \"1.1\" as a String");
                }
                this.setXMLVersion(((String)object).equals("1.0") ? 10 : 11);
                return;
            }
            case 111: {
                string = this.requireString(string, t2);
                if (!string.equals("1.0") && !string.equals("1.1")) {
                    throw new IllegalArgumentException("XSD_VERSION value must be \"1.0\" or \"1.1\" as a String");
                }
                this.xsdVersion = t2.equals("1.0") ? 10 : 11;
                this.H = null;
                return;
            }
            case 112: {
                this.getDefaultXsltCompilerInfo().setAssertionsEnabled(Configuration.requireBoolean(string, t2));
                return;
            }
            case 113: {
                object = this.requireString(string, t2);
                this.getDefaultXsltCompilerInfo().setDefaultInitialMode(StructuredQName.fromClarkName((String)object));
                return;
            }
            case 114: {
                object = this.requireString(string, t2);
                this.getDefaultXsltCompilerInfo().setDefaultInitialTemplate(StructuredQName.fromClarkName((String)object));
                return;
            }
            case 115: {
                this.getDefaultXsltCompilerInfo().setSchemaAware(Configuration.requireBoolean(string, t2));
                return;
            }
            case 116: {
                this.getDefaultXsltCompilerInfo().setErrorListener((ErrorListener)this.instantiateClassName(string, t2, ErrorListener.class));
                return;
            }
            case 117: {
                this.getDefaultXsltCompilerInfo().setURIResolver((URIResolver)this.instantiateClassName(string, t2, URIResolver.class));
                return;
            }
            case 118: {
                int n7;
                if ("1.0".equals(t2)) {
                    n7 = 10;
                } else if ("2.0".equals(t2)) {
                    n7 = 20;
                } else if ("2.1".equals(t2)) {
                    n7 = 30;
                } else if ("3.0".equals(t2)) {
                    n7 = 30;
                } else if ("0.0".equals(t2)) {
                    n7 = 0;
                } else {
                    throw new IllegalArgumentException("XSLT version must be 0.0, 1.0, 2.0, or 3.0");
                }
                this.getDefaultXsltCompilerInfo().setXsltVersion(n7);
                return;
            }
            default: {
                throw new IllegalArgumentException("Unknown configuration property " + string);
            }
        }
    }

    public static boolean requireBoolean(String string, Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            if ("true".equals(object = ((String)object).trim()) || "on".equals(object) || "yes".equals(object) || "1".equals(object)) {
                return true;
            }
            if ("false".equals(object) || "off".equals(object) || "no".equals(object) || "0".equals(object)) {
                return false;
            }
            throw new IllegalArgumentException(string + " must be 'true' or 'false' (or on|off, yes|no, 1|0)");
        }
        throw new IllegalArgumentException(string + " must be a boolean (or a string representing a boolean)");
    }

    protected int requireInteger(String string, Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(string + " must be an integer");
            }
        }
        throw new IllegalArgumentException(string + " must be an integer (or a string representing an integer)");
    }

    protected void internalSetBooleanProperty(Feature feature, Object object) {
        boolean bl2 = Configuration.requireBoolean(feature.name, object);
        if (bl2) {
            this.q.add(feature.code);
            return;
        }
        this.q.remove(feature.code);
    }

    public boolean getBooleanProperty(Feature feature) {
        return this.q.contains(feature.code);
    }

    public void setBooleanProperty(String string, boolean bl2) {
        this.setConfigurationProperty(string, (Object)bl2);
    }

    public void setBooleanProperty(Feature<Boolean> feature, boolean bl2) {
        this.setConfigurationProperty(feature, bl2);
    }

    protected String requireString(String string, Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        throw new IllegalArgumentException("The value of " + string + " must be a string");
    }

    protected Object instantiateClassName(String string, Object object, Class<?> clazz) {
        if (!(object instanceof String)) {
            throw new IllegalArgumentException(string + " must be a String");
        }
        try {
            Object object2 = this.getInstance((String)object, null);
            if (!clazz.isAssignableFrom(object2.getClass())) {
                throw new IllegalArgumentException("Error in " + string + ": Class " + object + " does not implement " + clazz.getName());
            }
            return object2;
        }
        catch (XPathException xPathException) {
            throw new IllegalArgumentException("Cannot use " + object + " as the value of " + string + ". " + xPathException.getMessage());
        }
    }

    public Object getConfigurationProperty(String string) {
        Feature<?> feature = Feature.byName(string);
        if (feature == null) {
            throw new IllegalArgumentException("Unknown configuration property " + string);
        }
        return this.getConfigurationProperty(feature);
    }

    public <T> T getConfigurationProperty(Feature<T> object) {
        if (booleanFeatures.contains(object)) {
            return (T)Boolean.valueOf(this.getBooleanProperty((Feature)object));
        }
        switch (((Feature)object).code) {
            case 6: {
                return (T)this.getCollationURIResolver();
            }
            case 7: {
                return (T)this.getCollationURIResolver().getClass().getName();
            }
            case 10: {
                return (T)this.getCollectionURIResolver();
            }
            case 11: {
                return (T)this.getCollectionURIResolver().getClass().getName();
            }
            case 13: {
                return (T)this;
            }
            case 17: {
                return (T)this.e;
            }
            case 18: {
                return (T)this.getDefaultCollection();
            }
            case 19: {
                return (T)this.getDefaultCountry();
            }
            case 20: {
                return (T)this.getDefaultLanguage();
            }
            case 24: {
                return (T)Boolean.valueOf(this.isValidation());
            }
            case 25: {
                return (T)Boolean.valueOf(this.h.getDTDValidationMode() == 2);
            }
            case 30: {
                return (T)this.getErrorListener().getClass().getName();
            }
            case 27: {
                object = this.h.getEntityResolver();
                if (object == null) {
                    return (T)"";
                }
                return (T)object.getClass().getName();
            }
            case 28: {
                return (T)this.f;
            }
            case 29: {
                return (T)this.f.getClass().getName();
            }
            case 31: {
                return (T)Boolean.valueOf(this.isExpandAttributeDefaults());
            }
            case 38: {
                return (T)Boolean.valueOf(this.isLineNumbering());
            }
            case 41: {
                return (T)this.getMessageEmitterClass();
            }
            case 42: {
                return (T)this.getModuleURIResolver();
            }
            case 43: {
                return (T)this.getModuleURIResolver().getClass().getName();
            }
            case 46: {
                return (T)this.getNamePool();
            }
            case 48: {
                return (T)this.optimizerOptions.toString();
            }
            case 49: {
                return (T)this.getOutputURIResolver();
            }
            case 50: {
                return (T)this.getOutputURIResolver().getClass().getName();
            }
            case 53: {
                return (T)Boolean.valueOf(this.getSystemURIResolver().queryParametersAreRecognized());
            }
            case 54: {
                return (T)Integer.valueOf(this.getRecoveryPolicy());
            }
            case 55: {
                switch (this.getRecoveryPolicy()) {
                    case 0: {
                        return (T)"recoverSilently";
                    }
                    case 1: {
                        return (T)"recoverWithWarnings";
                    }
                    case 2: {
                        return (T)"doNotRecover";
                    }
                }
                throw new IllegalStateException();
            }
            case 119: {
                return (T)Integer.valueOf(this.W);
            }
            case 60: {
                return (T)Integer.valueOf(this.getSchemaValidationMode());
            }
            case 61: {
                return (T)Validation.toString(this.getSchemaValidationMode());
            }
            case 62: {
                return (T)this.getSerializerFactory().getClass().getName();
            }
            case 63: {
                return (T)this.getSourceParserClass();
            }
            case 64: {
                return (T)this.getSourceResolver().getClass().getName();
            }
            case 71: {
                object = this.getParseOptions().getSpaceStrippingRule();
                if (object == AllElementsSpaceStrippingRule.getInstance()) {
                    return (T)"all";
                }
                if (object == null || object == IgnorableSpaceStrippingRule.getInstance()) {
                    return (T)"ignorable";
                }
                return (T)"none";
            }
            case 72: {
                return (T)this.getStyleParserClass();
            }
            case 77: {
                return (T)Boolean.valueOf(this.isTiming());
            }
            case 79: {
                return (T)this.I;
            }
            case 80: {
                return (T)this.J;
            }
            case 81: {
                return (T)this.K;
            }
            case 83: {
                return (T)Integer.valueOf(this.getTreeModel());
            }
            case 84: {
                switch (this.getTreeModel()) {
                    default: {
                        return (T)"tinyTree";
                    }
                    case 2: {
                        return (T)"tinyTreeCondensed";
                    }
                    case 0: 
                }
                return (T)"linkedTree";
            }
            case 85: {
                return (T)this.getUnparsedTextURIResolver();
            }
            case 86: {
                return (T)this.getUnparsedTextURIResolver().getClass().getName();
            }
            case 87: {
                return (T)this.getURIResolver().getClass().getName();
            }
            case 90: {
                return (T)Boolean.valueOf(this.h.isUseXsiSchemaLocation());
            }
            case 91: {
                return (T)Boolean.valueOf(this.h.isAddCommentsAfterValidationErrors());
            }
            case 92: {
                return (T)Boolean.valueOf(this.isValidationWarnings());
            }
            case 93: {
                return (T)Boolean.valueOf(this.isVersionWarning());
            }
            case 94: {
                return (T)Boolean.valueOf(this.isXIncludeAware());
            }
            case 95: {
                if (this.getXMLVersion() == 10) {
                    return (T)"1.0";
                }
                return (T)"1.1";
            }
            case 98: {
                return (T)Boolean.valueOf(this.getDefaultStaticQueryContext().isUpdatingEnabled());
            }
            case 99: {
                return (T)Integer.valueOf(this.getDefaultStaticQueryContext().getConstructionMode());
            }
            case 100: {
                return (T)this.getDefaultStaticQueryContext().getDefaultElementNamespace();
            }
            case 101: {
                return (T)this.getDefaultStaticQueryContext().getDefaultFunctionNamespace();
            }
            case 102: {
                return (T)Boolean.valueOf(this.getDefaultStaticQueryContext().isEmptyLeast());
            }
            case 103: {
                return (T)Boolean.valueOf(this.getDefaultStaticQueryContext().isInheritNamespaces());
            }
            case 105: {
                return (T)Boolean.valueOf(this.getDefaultStaticQueryContext().isPreserveBoundarySpace());
            }
            case 106: {
                return (T)Boolean.valueOf(this.getDefaultStaticQueryContext().isPreserveNamespaces());
            }
            case 107: {
                return (T)this.getDefaultStaticQueryContext().getRequiredContextItemType();
            }
            case 108: {
                return (T)Boolean.valueOf(this.getDefaultStaticQueryContext().isSchemaAware());
            }
            case 109: {
                return (T)this.getDefaultStaticQueryContext().getErrorListener().getClass().getName();
            }
            case 110: {
                return (T)"3.1";
            }
            case 120: {
                return (T)Integer.valueOf(this.Q);
            }
            case 121: {
                return (T)Integer.valueOf(this.R);
            }
            case 111: {
                if (this.xsdVersion == 10) {
                    return (T)"1.0";
                }
                return (T)"1.1";
            }
            case 112: {
                return (T)Boolean.valueOf(this.getDefaultXsltCompilerInfo().isAssertionsEnabled());
            }
            case 113: {
                return (T)this.getDefaultXsltCompilerInfo().getDefaultInitialMode().getClarkName();
            }
            case 114: {
                return (T)this.getDefaultXsltCompilerInfo().getDefaultInitialTemplate().getClarkName();
            }
            case 115: {
                return (T)Boolean.valueOf(this.getDefaultXsltCompilerInfo().isSchemaAware());
            }
            case 116: {
                return (T)this.getDefaultXsltCompilerInfo().getErrorListener().getClass().getName();
            }
            case 117: {
                return (T)this.getDefaultXsltCompilerInfo().getURIResolver().getClass().getName();
            }
            case 118: {
                return (T)Integer.valueOf(30);
            }
        }
        throw new IllegalArgumentException("Unknown configuration property " + ((Feature)object).name);
    }

    public boolean isGenerateByteCode(int n2) {
        return false;
    }

    public boolean isDeferredByteCode(int n2) {
        return false;
    }

    public boolean isJITEnabled() {
        return false;
    }

    public void close() {
        if (this.B != null) {
            this.B.close();
        }
    }

    public IPackageLoader makePackageLoader() {
        return new PackageLoaderHE(this);
    }

    public InvalidityReportGenerator createValidityReporter() {
        throw new UnsupportedOperationException("Loading compiled packages requires Saxon-EE (even when no license is needed)");
    }

    public int getCountDown() {
        return this.byteCodeThreshold;
    }

    public SimpleMode makeMode(StructuredQName structuredQName, CompilerInfo compilerInfo) {
        return new SimpleMode(structuredQName);
    }

    public TemplateRule makeTemplateRule() {
        return new TemplateRule();
    }

    public XPathContextMajor.ThreadManager makeThreadManager() {
        return null;
    }

    public CompilerInfo makeCompilerInfo() {
        return new CompilerInfo(this);
    }

    public ICompilerService makeCompilerService(int n2) {
        return null;
    }

    public void createByteCodeReport(String string) {
    }

    public void setLabel(String string) {
        this.j = string;
    }

    public String getLabel() {
        return this.j;
    }

    static {
        booleanFeatures.add(Feature.ALLOW_EXTERNAL_FUNCTIONS);
        booleanFeatures.add(Feature.ALLOW_MULTITHREADING);
        booleanFeatures.add(Feature.ALLOW_SYNTAX_EXTENSIONS);
        booleanFeatures.add(Feature.ASSERTIONS_CAN_SEE_COMMENTS);
        booleanFeatures.add(Feature.COMPILE_WITH_TRACING);
        booleanFeatures.add(Feature.DEBUG_BYTE_CODE);
        booleanFeatures.add(Feature.DISABLE_XSL_EVALUATE);
        booleanFeatures.add(Feature.DISPLAY_BYTE_CODE);
        booleanFeatures.add(Feature.DTD_VALIDATION);
        booleanFeatures.add(Feature.EAGER_EVALUATION);
        booleanFeatures.add(Feature.EXPAND_ATTRIBUTE_DEFAULTS);
        booleanFeatures.add(Feature.EXPATH_FILE_DELETE_TEMPORARY_FILES);
        booleanFeatures.add(Feature.GENERATE_BYTE_CODE);
        booleanFeatures.add(Feature.IGNORE_SAX_SOURCE_PARSER);
        booleanFeatures.add(Feature.IMPLICIT_SCHEMA_IMPORTS);
        booleanFeatures.add(Feature.MARK_DEFAULTED_ATTRIBUTES);
        booleanFeatures.add(Feature.MONITOR_HOT_SPOT_BYTE_CODE);
        booleanFeatures.add(Feature.MULTIPLE_SCHEMA_IMPORTS);
        booleanFeatures.add(Feature.PRE_EVALUATE_DOC_FUNCTION);
        booleanFeatures.add(Feature.PREFER_JAXP_PARSER);
        booleanFeatures.add(Feature.RETAIN_DTD_ATTRIBUTE_TYPES);
        booleanFeatures.add(Feature.STABLE_COLLECTION_URI);
        booleanFeatures.add(Feature.STABLE_UNPARSED_TEXT);
        booleanFeatures.add(Feature.STREAMING_FALLBACK);
        booleanFeatures.add(Feature.STRICT_STREAMABILITY);
        booleanFeatures.add(Feature.SUPPRESS_EVALUATION_EXPIRY_WARNING);
        booleanFeatures.add(Feature.SUPPRESS_XPATH_WARNINGS);
        booleanFeatures.add(Feature.SUPPRESS_XSLT_NAMESPACE_CHECK);
        booleanFeatures.add(Feature.TRACE_EXTERNAL_FUNCTIONS);
        booleanFeatures.add(Feature.TRACE_OPTIMIZER_DECISIONS);
        booleanFeatures.add(Feature.USE_PI_DISABLE_OUTPUT_ESCAPING);
        booleanFeatures.add(Feature.USE_TYPED_VALUE_CACHE);
        booleanFeatures.add(Feature.XQUERY_MULTIPLE_MODULE_IMPORTS);
    }

    public static class LicenseFeature {
        public static final int SCHEMA_VALIDATION = 1;
        public static final int ENTERPRISE_XSLT = 2;
        public static final int ENTERPRISE_XQUERY = 4;
        public static final int PROFESSIONAL_EDITION = 8;
    }

    public static interface ApiProvider {
    }
}

