/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.Sink;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Bindery;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.CollectionFinder;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.lib.DelegatingErrorListener;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.StandardURIResolver;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.om.AllElementsSpaceStrippingRule;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.MemoSequence;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.resource.CollectionURIResolverWrapper;
import net.sf.saxon.trace.TraceEventMulticaster;
import net.sf.saxon.trans.KeyIndex;
import net.sf.saxon.trans.StylesheetCache;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.RuleManager;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.wrapper.SpaceStrippedDocument;
import net.sf.saxon.tree.wrapper.SpaceStrippedNode;
import net.sf.saxon.tree.wrapper.TypeStrippedDocument;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.z.IntHashMap;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Controller
implements ContextOriginator {
    private Configuration a;
    protected Executable executable;
    protected Item<?> globalContextItem;
    private boolean b;
    private Map<PackageData, Bindery> c;
    private GlobalParameterSet d;
    private boolean e = true;
    private Map<GlobalVariable, Set<GlobalVariable>> f = new HashMap<GlobalVariable, Set<GlobalVariable>>();
    protected TraceListener traceListener;
    private boolean g;
    private Logger h;
    private StandardURIResolver i;
    private URIResolver j;
    protected Receiver principalResult;
    protected String principalResultURI;
    private UnparsedTextURIResolver k;
    private String l;
    protected UnfailingErrorListener errorListener;
    private TreeModel m = TreeModel.TINY_TREE;
    private DocumentPool n;
    private IntHashMap<Map<Long, KeyIndex>> o;
    private HashMap<String, Object> p;
    private NodeInfo q = null;
    private int r = -1;
    private DateTimeValue s;
    private boolean t = false;
    private PathMap u = null;
    protected int validationMode = 0;
    protected boolean inUse = false;
    private boolean v = true;
    private CollectionFinder w = null;
    public static final String ANONYMOUS_PRINCIPAL_OUTPUT_URI = "dummy:/anonymous/principal/result";
    private StylesheetCache x = null;
    private Function<SequenceIterator<?>, FocusTrackingIterator<?>> y = FocusTrackingIterator::new;
    private Function<SequenceIterator<?>, FocusTrackingIterator<?>> z;

    public Controller(Configuration configuration) {
        this.a = configuration;
        this.executable = new Executable(configuration);
        this.n = new DocumentPool();
        this.reset();
    }

    public Controller(Configuration configuration, Executable executable) {
        this.a = configuration;
        this.executable = executable;
        this.n = new DocumentPool();
        this.reset();
    }

    public void reset() {
        Object object;
        this.d = new GlobalParameterSet();
        this.y = this.a.getFocusTrackerFactory(this.executable, false);
        this.z = this.a.getFocusTrackerFactory(this.executable, true);
        this.i = this.a.getSystemURIResolver();
        this.j = this.a.getURIResolver();
        this.k = this.a.getUnparsedTextURIResolver();
        Controller controller = this;
        controller.setErrorListener(controller.a.getErrorListener());
        this.validationMode = this.a.getSchemaValidationMode();
        if (this.errorListener instanceof StandardErrorListener) {
            object = ((StandardErrorListener)this.errorListener).getLogger();
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(this.executable.getHostLanguage());
            ((StandardErrorListener)this.errorListener).setLogger((Logger)object);
        }
        this.traceListener = null;
        this.h = this.a.getLogger();
        try {
            object = this.a.makeTraceListener();
        }
        catch (XPathException xPathException) {
            throw new IllegalStateException(xPathException.getMessage());
        }
        if (object != null) {
            this.addTraceListener((TraceListener)object);
        }
        Controller controller2 = this;
        controller2.setModel(controller2.a.getParseOptions().getModel());
        this.globalContextItem = null;
        this.s = null;
        this.t = false;
        this.clearPerTransformationData();
    }

    protected synchronized void clearPerTransformationData() {
        this.p = new HashMap(20);
        this.principalResult = null;
        this.g = false;
        this.q = null;
        this.r = -1;
        this.x = null;
        this.o = null;
        if (!this.b) {
            this.globalContextItem = null;
        }
    }

    public Configuration getConfiguration() {
        return this.a;
    }

    public Sequence<?> getParameter(StructuredQName structuredQName) {
        return this.d.get(structuredQName);
    }

    public GroundedValue<?> getConvertedParameter(StructuredQName groundedValue, SequenceType object, XPathContext object2) {
        if ((groundedValue = this.d.convertParameterValue((StructuredQName)((Object)groundedValue), (SequenceType)object, this.e, (XPathContext)object2)) != null) {
            Object t2;
            object = this.getConfiguration();
            object2 = groundedValue.iterate();
            while ((t2 = object2.next()) != null) {
                if (!(t2 instanceof NodeInfo) || ((Configuration)object).isCompatible(((NodeInfo)t2).getConfiguration())) continue;
                throw new XPathException("A node supplied in a global parameter must be built using the same Configuration that was used to compile the stylesheet or query", "SXXP0004");
            }
            if (groundedValue instanceof NodeInfo && ((NodeInfo)groundedValue).getNodeKind() == 9) {
                object = ((NodeInfo)groundedValue).getRoot().getSystemId();
                try {
                    if (object != null && new URI((String)object).isAbsolute() && ((DocumentPool)(object2 = this.getDocumentPool())).find((String)object) == null) {
                        ((DocumentPool)object2).add(((NodeInfo)groundedValue).getTreeInfo(), (String)object);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            groundedValue = groundedValue.materialize();
        }
        return groundedValue;
    }

    public void setBaseOutputURI(String string) {
        this.principalResultURI = string;
    }

    public String getBaseOutputURI() {
        return this.principalResultURI;
    }

    public Receiver getPrincipalResult() {
        return this.principalResult;
    }

    public synchronized SequenceOutputter allocateSequenceOutputter(int n2) {
        PipelineConfiguration pipelineConfiguration = this.makePipelineConfiguration();
        return new SequenceOutputter(pipelineConfiguration, n2);
    }

    public synchronized SequenceOutputter allocateSequenceOutputter() {
        PipelineConfiguration pipelineConfiguration = this.makePipelineConfiguration();
        return new SequenceOutputter(pipelineConfiguration, 20);
    }

    public PipelineConfiguration makePipelineConfiguration() {
        PipelineConfiguration pipelineConfiguration = this.a.makePipelineConfiguration();
        pipelineConfiguration.setURIResolver(this.j == null ? this.i : this.j);
        pipelineConfiguration.getParseOptions().setSchemaValidationMode(this.validationMode);
        pipelineConfiguration.getParseOptions().setErrorListener(this.errorListener);
        pipelineConfiguration.setController(this);
        Executable executable = this.getExecutable();
        if (executable != null) {
            pipelineConfiguration.setHostLanguage(executable.getHostLanguage());
        }
        return pipelineConfiguration;
    }

    public void setErrorListener(ErrorListener errorListener) {
        if (errorListener instanceof UnfailingErrorListener) {
            this.errorListener = (UnfailingErrorListener)errorListener;
            return;
        }
        this.errorListener = new DelegatingErrorListener(errorListener);
    }

    public UnfailingErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void recoverableError(XPathException xPathException) {
        if (this.executable.getHostLanguage() == 51) {
            throw xPathException;
        }
        if (this.executable.getHostLanguage() == 50) {
            this.errorListener.warning(xPathException);
            return;
        }
        this.errorListener.error(xPathException);
    }

    public void reportFatalError(XPathException xPathException) {
        if (!xPathException.hasBeenReported()) {
            if (xPathException.getHostLanguage() == null) {
                if (this.executable.getHostLanguage() == 50) {
                    xPathException.setHostLanguage("XSLT");
                } else if (this.executable.getHostLanguage() == 51) {
                    xPathException.setHostLanguage("XQuery");
                }
            }
            this.getErrorListener().fatalError(xPathException);
            xPathException.setHasBeenReported(true);
        }
    }

    public void warning(String string, String string2, Location location) {
        this.getErrorListener().warning(new XPathException(string, string2, location));
    }

    protected void handleXPathException(XPathException xPathException) {
        Throwable throwable = xPathException.getException();
        if (throwable instanceof SAXParseException) {
            throwable = (SAXParseException)throwable;
            if ((throwable = ((SAXException)throwable).getException()) instanceof RuntimeException) {
                this.reportFatalError(xPathException);
            }
        } else {
            this.reportFatalError(xPathException);
        }
        throw xPathException;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public DocumentPool getDocumentPool() {
        return this.n;
    }

    public void clearDocumentPool() {
        for (PackageData packageData : this.getExecutable().getPackages()) {
            this.n.discardIndexes(packageData.getKeyManager());
        }
        this.n = new DocumentPool();
    }

    public synchronized Bindery getBindery(PackageData packageData) {
        Bindery bindery = this.c.get(packageData);
        if (bindery == null) {
            bindery = new Bindery(packageData);
            this.c.put(packageData, bindery);
        }
        return bindery;
    }

    public void setGlobalContextItem(Item item) {
        this.setGlobalContextItem(item, false);
    }

    public void setGlobalContextItem(Item item, boolean bl2) {
        if (!bl2) {
            if (this.globalContextItem instanceof SpaceStrippedNode && ((SpaceStrippedNode)this.globalContextItem).getUnderlyingNode() == item) {
                return;
            }
            if (item instanceof NodeInfo) {
                item = this.prepareInputTree((NodeInfo)item);
            }
        }
        if (this.globalContextItem instanceof NodeInfo) {
            NodeInfo nodeInfo = (NodeInfo)this.globalContextItem;
            if (nodeInfo.getConfiguration() == null) {
                throw new XPathException("The supplied source document must be associated with a Configuration");
            }
            if (!nodeInfo.getConfiguration().isCompatible(this.executable.getConfiguration())) {
                throw new XPathException("Source document and stylesheet must use the same or compatible Configurations", "SXXP0004");
            }
            if (nodeInfo.getTreeInfo().isTyped() && !this.executable.isSchemaAware()) {
                throw new XPathException("Cannot use a schema-validated source document unless the stylesheet is schema-aware");
            }
        }
        this.globalContextItem = item;
        this.b = true;
    }

    public void clearGlobalContextItem() {
        this.globalContextItem = null;
        this.b = false;
    }

    public Item<?> getGlobalContextItem() {
        return this.globalContextItem;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.j = uRIResolver;
        if (uRIResolver instanceof StandardURIResolver) {
            ((StandardURIResolver)uRIResolver).setConfiguration(this.getConfiguration());
        }
    }

    public URIResolver getURIResolver() {
        return this.j;
    }

    public URIResolver getStandardURIResolver() {
        return this.i;
    }

    public void setUnparsedTextURIResolver(UnparsedTextURIResolver unparsedTextURIResolver) {
        this.k = unparsedTextURIResolver;
    }

    public UnparsedTextURIResolver getUnparsedTextURIResolver() {
        return this.k;
    }

    public void setCollectionURIResolver(CollectionURIResolver collectionURIResolver) {
        this.setCollectionFinder(new CollectionURIResolverWrapper(collectionURIResolver));
    }

    public CollectionURIResolver getCollectionURIResolver() {
        CollectionFinder collectionFinder = this.getCollectionFinder();
        if (collectionFinder instanceof CollectionURIResolverWrapper) {
            return ((CollectionURIResolverWrapper)collectionFinder).getCollectionURIResolver();
        }
        return null;
    }

    public CollectionFinder getCollectionFinder() {
        if (this.w == null) {
            this.w = this.a.getCollectionFinder();
        }
        return this.w;
    }

    public void setCollectionFinder(CollectionFinder collectionFinder) {
        this.w = collectionFinder;
    }

    public void setDefaultCollection(String string) {
        this.l = string;
    }

    public String getDefaultCollection() {
        if (this.l == null) {
            return this.getConfiguration().getDefaultCollection();
        }
        return this.l;
    }

    public int getSchemaValidationMode() {
        return this.validationMode;
    }

    public void setSchemaValidationMode(int n2) {
        this.validationMode = n2;
    }

    public void setModel(TreeModel treeModel) {
        this.m = treeModel;
    }

    public TreeModel getModel() {
        return this.m;
    }

    public Builder makeBuilder() {
        Builder builder = this.m.makeBuilder(this.makePipelineConfiguration());
        builder.setTiming(this.a.isTiming());
        builder.setLineNumbering(this.a.isLineNumbering());
        return builder;
    }

    public void setStripSourceTrees(boolean bl2) {
        this.v = bl2;
    }

    public boolean isStripSourceTree() {
        return this.v;
    }

    protected boolean isStylesheetContainingStripSpace() {
        SpaceStrippingRule spaceStrippingRule;
        return this.executable instanceof PreparedStylesheet && (spaceStrippingRule = ((PreparedStylesheet)this.executable).getTopLevelPackage().getSpaceStrippingRule()) != null && spaceStrippingRule != NoElementsSpaceStrippingRule.getInstance();
    }

    public boolean isStylesheetStrippingTypeAnnotations() {
        return this.executable instanceof PreparedStylesheet && ((PreparedStylesheet)this.executable).getTopLevelPackage().isStripsTypeAnnotations();
    }

    public Stripper makeStripper(Receiver receiver) {
        if (receiver == null) {
            receiver = new Sink(this.makePipelineConfiguration());
        }
        return new Stripper(this.getSpaceStrippingRule(), receiver);
    }

    public SpaceStrippingRule getSpaceStrippingRule() {
        SpaceStrippingRule spaceStrippingRule;
        if (this.a.getParseOptions().getSpaceStrippingRule() == AllElementsSpaceStrippingRule.getInstance()) {
            return AllElementsSpaceStrippingRule.getInstance();
        }
        if (this.executable instanceof PreparedStylesheet && (spaceStrippingRule = ((PreparedStylesheet)this.executable).getTopLevelPackage().getSpaceStrippingRule()) != null) {
            return spaceStrippingRule;
        }
        return NoElementsSpaceStrippingRule.getInstance();
    }

    public void registerDocument(TreeInfo treeInfo, DocumentURI documentURI) {
        if (!this.getExecutable().isSchemaAware() && !Untyped.getInstance().equals(treeInfo.getRootNode().getSchemaType())) {
            boolean bl2 = this.getExecutable().getHostLanguage() == 50;
            String string = bl2 ? "The source document has been schema-validated, but the stylesheet is not schema-aware. A stylesheet is schema-aware if either (a) it contains an xsl:import-schema declaration, or (b) the stylesheet compiler was configured to be schema-aware." : "The source document has been schema-validated, but the query is not schema-aware. A query is schema-aware if either (a) it contains an 'import schema' declaration, or (b) the query compiler was configured to be schema-aware.";
            throw new XPathException(string);
        }
        if (documentURI != null) {
            this.n.add(treeInfo, documentURI);
        }
    }

    public RuleManager getRuleManager() {
        Executable executable = this.getExecutable();
        if (executable instanceof PreparedStylesheet) {
            return ((PreparedStylesheet)this.getExecutable()).getRuleManager();
        }
        return null;
    }

    public void setTraceListener(TraceListener traceListener) {
        this.traceListener = traceListener;
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public final boolean isTracing() {
        return this.traceListener != null && !this.g;
    }

    public final void pauseTracing(boolean bl2) {
        this.g = bl2;
    }

    public void addTraceListener(TraceListener traceListener) {
        if (traceListener != null) {
            this.traceListener = TraceEventMulticaster.add(this.traceListener, traceListener);
        }
    }

    public void removeTraceListener(TraceListener traceListener) {
        this.traceListener = TraceEventMulticaster.remove(this.traceListener, traceListener);
    }

    public void setTraceFunctionDestination(Logger logger) {
        this.h = logger;
    }

    public Logger getTraceFunctionDestination() {
        return this.h;
    }

    public void initializeController(GlobalParameterSet globalParameterSet) {
        block3: {
            this.c = new HashMap<PackageData, Bindery>();
            try {
                this.executable.checkSuppliedParameters(globalParameterSet);
            }
            catch (XPathException xPathException) {
                XPathException xPathException2 = xPathException;
                if (xPathException.hasBeenReported()) break block3;
                this.getErrorListener().fatalError(xPathException2);
                throw xPathException2;
            }
        }
        this.d = globalParameterSet;
        this.globalContextItem = this.executable.checkInitialContextItem(this.globalContextItem, this.newXPathContext());
        if (this.traceListener != null) {
            this.traceListener.open(this);
            Controller controller = this;
            controller.preEvaluateGlobals(controller.newXPathContext());
        }
    }

    public void setApplyFunctionConversionRulesToExternalVariables(boolean bl2) {
        this.e = bl2;
    }

    public synchronized Object getUserData(Object object, String string) {
        object = object.hashCode() + " " + string;
        return this.p.get(object);
    }

    public synchronized void setUserData(Object object, String string, Object object2) {
        object = object.hashCode() + " " + string;
        if (object2 == null) {
            this.p.remove(object);
            return;
        }
        this.p.put((String)object, object2);
    }

    public synchronized IntHashMap<Map<Long, KeyIndex>> getLocalIndexes() {
        if (this.o == null) {
            this.o = new IntHashMap();
        }
        return this.o;
    }

    public synchronized void setRememberedNumber(NodeInfo nodeInfo, int n2) {
        this.q = nodeInfo;
        this.r = n2;
    }

    public synchronized int getRememberedNumber(NodeInfo nodeInfo) {
        if (this.q == nodeInfo) {
            return this.r;
        }
        return -1;
    }

    protected void checkReadiness() {
        if (this.inUse) {
            throw new IllegalStateException("The Controller is being used recursively or concurrently. This is not permitted.");
        }
        if (this.c == null) {
            throw new IllegalStateException("The Controller has not been initialized");
        }
        this.inUse = true;
        this.clearPerTransformationData();
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been prepared");
        }
        if (!this.t) {
            this.s = null;
        }
    }

    public NodeInfo makeSourceTree(Source source, int n2) {
        if (source instanceof SAXSource && this.a.getBooleanProperty(Feature.IGNORE_SAX_SOURCE_PARSER)) {
            ((SAXSource)source).setXMLReader(null);
        }
        Builder builder = this.makeBuilder();
        builder.setUseEventLocation(true);
        if (builder instanceof TinyBuilder) {
            ((TinyBuilder)builder).setStatistics(this.a.getTreeStatistics().SOURCE_DOCUMENT_STATISTICS);
        }
        Receiver receiver = builder;
        SpaceStrippingRule spaceStrippingRule = NoElementsSpaceStrippingRule.getInstance();
        if (this.a.isStripsAllWhiteSpace() || this.isStylesheetContainingStripSpace() || n2 == 1 || n2 == 2) {
            receiver = this.makeStripper(builder);
            spaceStrippingRule = this.getSpaceStrippingRule();
        }
        if (this.isStylesheetStrippingTypeAnnotations()) {
            receiver = this.a.getAnnotationStripper(receiver);
        }
        PipelineConfiguration pipelineConfiguration = builder.getPipelineConfiguration();
        pipelineConfiguration.getParseOptions().setSchemaValidationMode(n2);
        receiver.setPipelineConfiguration(pipelineConfiguration);
        Sender.send(source, receiver, null);
        if (source instanceof AugmentedSource && ((AugmentedSource)source).isPleaseCloseAfterUse()) {
            ((AugmentedSource)source).close();
        }
        NodeInfo nodeInfo = builder.getCurrentRoot();
        builder.reset();
        if (source.getSystemId() != null) {
            this.registerDocument(nodeInfo.getTreeInfo(), new DocumentURI(source.getSystemId()));
        }
        nodeInfo.getTreeInfo().setSpaceStrippingRule(spaceStrippingRule);
        return nodeInfo;
    }

    public NodeInfo prepareInputTree(Source source) {
        Object object;
        TreeInfo treeInfo;
        source = this.getConfiguration().unravel(source);
        if (this.isStylesheetStrippingTypeAnnotations() && (treeInfo = source.getTreeInfo()).isTyped()) {
            object = new TypeStrippedDocument(treeInfo);
            source = ((TypeStrippedDocument)object).wrap((NodeInfo)source);
        }
        if (this.v && this.isStylesheetContainingStripSpace()) {
            treeInfo = source.getTreeInfo();
            object = this.getSpaceStrippingRule();
            if (treeInfo.getSpaceStrippingRule() != object) {
                if (!SpaceStrippedNode.isPreservedNode((NodeInfo)source, (SpaceStrippedDocument)(treeInfo = new SpaceStrippedDocument(treeInfo, (SpaceStrippingRule)object)), source.getParent())) {
                    return null;
                }
                source = ((SpaceStrippedDocument)treeInfo).wrap((NodeInfo)source);
            }
        }
        return source;
    }

    public void preEvaluateGlobals(XPathContext xPathContext) {
        for (PackageData packageData : this.getExecutable().getPackages()) {
            for (GlobalVariable globalVariable : packageData.getGlobalVariableList()) {
                if (globalVariable.isUnused()) continue;
                try {
                    globalVariable.evaluateVariable(xPathContext, globalVariable.getDeclaringComponent());
                }
                catch (XPathException xPathException) {
                    this.getBindery(globalVariable.getPackageData()).setGlobalVariable(globalVariable, new Bindery.FailureValue(xPathException));
                }
            }
        }
    }

    public synchronized void registerGlobalVariableDependency(GlobalVariable globalVariable2, GlobalVariable globalVariable3) {
        if (globalVariable2 == globalVariable3) {
            throw new XPathException.Circularity("Circular dependency among global variables: " + globalVariable2.getVariableQName().getDisplayName() + " depends on its own value");
        }
        Set<GlobalVariable> set = this.f.get(globalVariable3);
        if (set != null) {
            if (set.contains(globalVariable2)) {
                throw new XPathException.Circularity("Circular dependency among variables: " + globalVariable2.getVariableQName().getDisplayName() + " depends on the value of " + globalVariable3.getVariableQName().getDisplayName() + ", which depends directly or indirectly on the value of " + globalVariable2.getVariableQName().getDisplayName());
            }
            for (GlobalVariable globalVariable4 : set) {
                this.registerGlobalVariableDependency(globalVariable2, globalVariable4);
            }
        }
        set = this.f.computeIfAbsent(globalVariable2, globalVariable -> new HashSet());
        set.add(globalVariable3);
    }

    public void setCurrentDateTime(DateTimeValue dateTimeValue) {
        if (this.s == null) {
            if (((AtomicValue)dateTimeValue).getComponent(AccessorFn.Component.TIMEZONE) == null) {
                throw new XPathException("No timezone is present in supplied value of current date/time");
            }
            this.s = dateTimeValue;
            this.t = true;
            return;
        }
        throw new IllegalStateException("Current date and time can only be set once, and cannot subsequently be changed");
    }

    public DateTimeValue getCurrentDateTime() {
        if (this.s == null) {
            this.s = DateTimeValue.now();
        }
        return this.s;
    }

    public int getImplicitTimezone() {
        return this.getCurrentDateTime().getTimezoneInMinutes();
    }

    public XPathContextMajor newXPathContext() {
        XPathContextMajor xPathContextMajor = new XPathContextMajor(this);
        xPathContextMajor.setCurrentOutputUri(this.principalResultURI);
        return xPathContextMajor;
    }

    public void setUseDocumentProjection(PathMap pathMap) {
        this.u = pathMap;
    }

    public PathMap getPathMapForDocumentProjection() {
        return this.u;
    }

    public synchronized StylesheetCache getStylesheetCache() {
        if (this.x == null) {
            this.x = new StylesheetCache();
        }
        return this.x;
    }

    public Function<SequenceIterator<?>, FocusTrackingIterator<?>> getFocusTrackerFactory(boolean bl2) {
        if (bl2 && this.z != null) {
            return this.z;
        }
        return this.y;
    }

    public void setFocusTrackerFactory(Function<SequenceIterator<?>, FocusTrackingIterator<?>> function) {
        this.y = function;
    }

    public void setMultithreadedFocusTrackerFactory(Function<SequenceIterator<?>, FocusTrackingIterator<?>> function) {
        this.z = function;
    }

    public void setMemoizingFocusTrackerFactory() {
        this.setFocusTrackerFactory(sequenceIterator -> {
            FocusTrackingIterator focusTrackingIterator;
            if ((sequenceIterator.getProperties() & 1) == 0 && !(sequenceIterator instanceof GroupIterator) && !(sequenceIterator instanceof RegexIterator)) {
                try {
                    focusTrackingIterator = new MemoSequence(sequenceIterator);
                    focusTrackingIterator = FocusTrackingIterator.track(((MemoSequence)((Object)focusTrackingIterator)).iterate());
                }
                catch (XPathException xPathException) {}
            }
            focusTrackingIterator = FocusTrackingIterator.track(sequenceIterator);
            return focusTrackingIterator;
        });
    }
}

