/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.NamedTemplate;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.VisibilityProvenance;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.trans.rules.RuleManager;

public class PreparedStylesheet
extends Executable {
    private HashMap<URI, PreparedStylesheet> a;
    private RuleManager b;
    private HashMap<StructuredQName, NamedTemplate> c;
    private Map<SymbolicName, Component> d;
    private StructuredQName e;
    private StructuredQName f;
    private int g;
    private String h;
    private OutputURIResolver i;
    private GlobalParameterSet j;

    public PreparedStylesheet(Compilation compilation) {
        super(compilation.getConfiguration());
        CompilerInfo compilerInfo = compilation.getCompilerInfo();
        this.setHostLanguage(50);
        if (compilerInfo.isSchemaAware()) {
            int n2 = compilation.getPackageData().getLocalLicenseId();
            this.getConfiguration().checkLicensedFeature(2, "schema-aware XSLT", n2);
            this.schemaAware = true;
        }
        if (compilerInfo.getErrorListener() == null) {
            compilerInfo.setErrorListener(this.getConfiguration().getErrorListener());
        }
        this.f = compilerInfo.getDefaultInitialMode();
        this.e = compilerInfo.getDefaultInitialTemplate();
        this.g = compilerInfo.getRecoveryPolicy();
        this.h = compilerInfo.getMessageReceiverClassName();
        this.i = compilerInfo.getOutputURIResolver();
        this.j = compilation.getParameters();
    }

    public XsltController newController() {
        Object object = this.getConfiguration();
        object = new XsltController((Configuration)object, this);
        ((XsltController)object).setMessageReceiverClassName(this.h);
        ((XsltController)object).setOutputURIResolver(this.i);
        ((XsltController)object).setRecoveryPolicy(this.g);
        if (this.f != null) {
            try {
                ((XsltController)object).setInitialMode(this.f);
            }
            catch (XPathException xPathException) {}
        }
        return object;
    }

    public GlobalParameterSet getCompileTimeParams() {
        return this.j;
    }

    @Override
    public void checkSuppliedParameters(GlobalParameterSet object) {
        Object object2;
        for (Map.Entry<StructuredQName, GlobalParam> object3 : this.getGlobalParameters().entrySet()) {
            if (!object3.getValue().isRequiredParam()) continue;
            object2 = object3.getKey();
            if (this.getCompileTimeParams().get((StructuredQName)object2) != null || object != null && ((GlobalParameterSet)object).get((StructuredQName)object2) != null) continue;
            object = new XPathException("No value supplied for required parameter " + ((StructuredQName)object2).getDisplayName());
            ((XPathException)object).setErrorCode(this.getHostLanguage() == 51 ? "XPDY0002" : "XTDE0050");
            throw object;
        }
        for (StructuredQName structuredQName : ((GlobalParameterSet)object).getKeys()) {
            object2 = this.getGlobalParameter(structuredQName);
            if (object2 != null && ((GlobalVariable)object2).isStatic()) {
                throw new XPathException("Parameter $" + structuredQName.getDisplayName() + " cannot be supplied dynamically because it is declared as static");
            }
            if (!this.j.containsKey(structuredQName)) continue;
            throw new XPathException("Parameter $" + structuredQName.getDisplayName() + " cannot be supplied dynamically because a value was already supplied at compile time");
        }
        for (StructuredQName structuredQName : this.j.getKeys()) {
            ((GlobalParameterSet)object).put(structuredQName, this.j.get(structuredQName));
        }
    }

    @Override
    public StylesheetPackage getTopLevelPackage() {
        return (StylesheetPackage)super.getTopLevelPackage();
    }

    public void setRuleManager(RuleManager ruleManager) {
        this.b = ruleManager;
    }

    public RuleManager getRuleManager() {
        return this.b;
    }

    public NamedTemplate getNamedTemplate(StructuredQName structuredQName) {
        if (this.c == null) {
            return null;
        }
        return this.c.get(structuredQName);
    }

    public void putNamedTemplate(StructuredQName structuredQName, NamedTemplate namedTemplate) {
        if (this.c == null) {
            this.c = new HashMap(32);
        }
        this.c.put(structuredQName, namedTemplate);
    }

    public StructuredQName getDefaultInitialTemplateName() {
        return this.e;
    }

    public void setComponentIndex(Map<SymbolicName, Component> map) {
        this.d = map;
    }

    public Component getComponent(SymbolicName symbolicName) {
        return this.d.get(symbolicName);
    }

    public boolean isEligibleInitialComponent(Component component) {
        if (component == null) {
            return false;
        }
        if (component.getVisibility() == Visibility.PUBLIC || component.getVisibility() == Visibility.FINAL) {
            return true;
        }
        StylesheetPackage stylesheetPackage = this.getTopLevelPackage();
        return stylesheetPackage.isImplicitPackage() && component.getActor().getDeclaredVisibility() == null;
    }

    public boolean isEligibleInitialMode(Component.M m2) {
        if (m2 == null) {
            return false;
        }
        if (m2.getVisibility() == Visibility.PUBLIC || m2.getVisibility() == Visibility.FINAL) {
            return true;
        }
        if (m2.getActor().isUnnamedMode()) {
            return true;
        }
        StylesheetPackage stylesheetPackage = this.getTopLevelPackage();
        if (m2.getActor().getModeName().equals(stylesheetPackage.getDefaultMode())) {
            return true;
        }
        return !stylesheetPackage.isDeclaredModes() && !m2.getActor().isEmpty() && (m2.getVisibilityProvenance() == VisibilityProvenance.DEFAULTED || m2.getVisibility() != Visibility.PRIVATE);
    }

    public Iterator<NamedTemplate> iterateNamedTemplates() {
        if (this.c == null) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        return this.c.values().iterator();
    }

    public void explainNamedTemplates(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("namedTemplates");
        if (this.c != null) {
            for (NamedTemplate namedTemplate : this.c.values()) {
                expressionPresenter.startElement("template");
                expressionPresenter.emitAttribute("name", namedTemplate.getTemplateName().getDisplayName());
                expressionPresenter.emitAttribute("line", "" + namedTemplate.getLineNumber());
                expressionPresenter.emitAttribute("module", namedTemplate.getSystemId());
                if (namedTemplate.getBody() != null) {
                    namedTemplate.getBody().export(expressionPresenter);
                }
                expressionPresenter.endElement();
            }
        }
        expressionPresenter.endElement();
    }

    public SerializationProperties getDeclaredSerializationProperties() {
        SerializationProperties serializationProperties = this.getPrimarySerializationProperties();
        return new SerializationProperties(new Properties(serializationProperties.getProperties()), this.getCharacterMapIndex());
    }

    public PreparedStylesheet getCachedStylesheet(String object, String string) {
        URI uRI = null;
        try {
            uRI = new URI(string).resolve((String)object);
        }
        catch (URISyntaxException uRISyntaxException) {}
        object = null;
        if (uRI != null && this.a != null) {
            object = this.a.get(uRI);
        }
        return object;
    }

    public void putCachedStylesheet(String string, String string2, PreparedStylesheet preparedStylesheet) {
        URI uRI = null;
        try {
            uRI = new URI(string2).resolve(string);
        }
        catch (URISyntaxException uRISyntaxException) {}
        if (uRI != null) {
            if (this.a == null) {
                this.a = new HashMap(4);
            }
            this.a.put(uRI, preparedStylesheet);
        }
    }

    public void explain(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("stylesheet");
        expressionPresenter.namespace("fn", "http://www.w3.org/2005/xpath-functions");
        expressionPresenter.namespace("xs", "http://www.w3.org/2001/XMLSchema");
        this.explainGlobalVariables(expressionPresenter);
        this.b.explainTemplateRules(expressionPresenter);
        this.explainNamedTemplates(expressionPresenter);
        expressionPresenter.startElement("accumulators");
        for (Accumulator object2 : this.getTopLevelPackage().getAccumulatorRegistry().getAllAccumulators()) {
            ((Actor)object2).export(expressionPresenter);
        }
        expressionPresenter.endElement();
        Iterator<FunctionLibrary> iterator = this.getFunctionLibrary();
        List<FunctionLibrary> list = ((FunctionLibraryList)((Object)iterator)).getLibraryList();
        expressionPresenter.startElement("functions");
        for (FunctionLibrary functionLibrary : list) {
            if (!(functionLibrary instanceof ExecutableFunctionLibrary)) continue;
            Iterator<UserFunction> iterator2 = ((ExecutableFunctionLibrary)functionLibrary).iterateFunctions();
            while (iterator2.hasNext()) {
                UserFunction userFunction = iterator2.next();
                ((Actor)userFunction).export(expressionPresenter);
            }
        }
        expressionPresenter.endElement();
        expressionPresenter.endElement();
        expressionPresenter.close();
    }
}

