/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Version;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.lib.StandardLogger;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.query.QueryReader;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.query.UpdateAgent;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.TimingCodeInjector;
import net.sf.saxon.trace.TimingTraceListener;
import net.sf.saxon.trace.XQueryTraceListener;
import net.sf.saxon.trans.CommandLineOptions;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.wrapper.AbstractVirtualNode;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.value.DateTimeValue;
import org.xml.sax.InputSource;

public class Query {
    protected Processor processor;
    protected Configuration config;
    protected boolean showTime = false;
    protected int repeat = 1;
    protected String sourceFileName = null;
    protected String queryFileName = null;
    protected boolean useURLs = false;
    protected String outputFileName = null;
    protected String moduleURIResolverClass = null;
    protected final String uriResolverClass;
    protected boolean explain = false;
    protected boolean wrap = false;
    protected boolean projection = false;
    protected boolean streaming = false;
    protected boolean updating = false;
    protected boolean writeback = false;
    protected boolean backup = true;
    protected String explainOutputFileName = null;
    private StandardLogger a = new StandardLogger();
    private boolean b = false;
    private boolean c = true;

    public Query() {
        this.uriResolverClass = null;
    }

    protected Configuration getConfiguration() {
        return this.config;
    }

    public static void main(String[] stringArray) {
        new Query().doQuery(stringArray, "java net.sf.saxon.Query");
    }

    public void setPermittedOptions(CommandLineOptions commandLineOptions) {
        commandLineOptions.addRecognizedOption("backup", 1, "Save updated documents before overwriting");
        commandLineOptions.addRecognizedOption("catalog", 258, "Use specified catalog file to resolve URIs");
        commandLineOptions.addRecognizedOption("config", 258, "Use specified configuration file");
        commandLineOptions.addRecognizedOption("cr", 259, "Use specified collection URI resolver class");
        commandLineOptions.addRecognizedOption("dtd", 4, "Validate using DTD");
        commandLineOptions.setPermittedValues("dtd", new String[]{"on", "off", "recover"}, "on");
        commandLineOptions.addRecognizedOption("expand", 1, "Expand attribute defaults from DTD or Schema");
        commandLineOptions.addRecognizedOption("explain", 2, "Display compiled expression tree and optimization decisions");
        commandLineOptions.addRecognizedOption("ext", 1, "Allow calls to Java extension functions and xsl:result-document");
        commandLineOptions.addRecognizedOption("init", 3, "User-supplied net.sf.saxon.lib.Initializer class to initialize the Saxon Configuration");
        commandLineOptions.addRecognizedOption("l", 1, "Maintain line numbers for source documents");
        commandLineOptions.addRecognizedOption("mr", 259, "Use named ModuleURIResolver class");
        commandLineOptions.addRecognizedOption("now", 264, "Run with specified current date/time");
        commandLineOptions.addRecognizedOption("o", 258, "Use specified file for primary output");
        commandLineOptions.addRecognizedOption("opt", 265, "Enable/disable optimization options [-]cfgklmsvwx");
        commandLineOptions.addRecognizedOption("outval", 260, "Action when validation of output file fails");
        commandLineOptions.setPermittedValues("outval", new String[]{"recover", "fatal"}, null);
        commandLineOptions.addRecognizedOption("p", 1, "Recognize query parameters in URI passed to doc()");
        commandLineOptions.addRecognizedOption("projection", 1, "Use source document projection");
        commandLineOptions.addRecognizedOption("q", 258, "Query filename");
        commandLineOptions.addRecognizedOption("qs", 265, "Query string (usually in quotes)");
        commandLineOptions.addRecognizedOption("quit", 257, "Quit JVM if query fails");
        commandLineOptions.addRecognizedOption("r", 259, "Use named URIResolver class");
        commandLineOptions.addRecognizedOption("repeat", 261, "Run N times for performance measurement");
        commandLineOptions.addRecognizedOption("s", 258, "Source file for primary input");
        commandLineOptions.addRecognizedOption("sa", 1, "Run in schema-aware mode");
        commandLineOptions.addRecognizedOption("scmin", 2, "Pre-load schema in SCM format");
        commandLineOptions.addRecognizedOption("stream", 1, "Execute in streamed mode");
        commandLineOptions.addRecognizedOption("strip", 260, "Handling of whitespace text nodes in source documents");
        commandLineOptions.setPermittedValues("strip", new String[]{"none", "all", "ignorable"}, null);
        commandLineOptions.addRecognizedOption("t", 1, "Display version and timing information");
        commandLineOptions.addRecognizedOption("T", 3, "Use named TraceListener class, or standard TraceListener");
        commandLineOptions.addRecognizedOption("TB", 2, "Trace hotspot bytecode generation to specified XML file");
        commandLineOptions.addRecognizedOption("TJ", 1, "Debug binding and execution of extension functions");
        commandLineOptions.setPermittedValues("TJ", new String[]{"on", "off"}, "on");
        commandLineOptions.addRecognizedOption("tree", 260, "Use specified tree model for source documents");
        commandLineOptions.addRecognizedOption("Tlevel", 9, "Level of detail for trace listener output");
        commandLineOptions.setPermittedValues("Tlevel", new String[]{"none", "low", "normal", "high"}, "normal");
        commandLineOptions.addRecognizedOption("Tout", 2, "File for trace listener output");
        commandLineOptions.addRecognizedOption("TP", 2, "Use profiling trace listener, with specified output file");
        commandLineOptions.addRecognizedOption("traceout", 258, "File for output of trace() messages");
        commandLineOptions.setPermittedValues("tree", new String[]{"linked", "tiny", "tinyc"}, null);
        commandLineOptions.addRecognizedOption("u", 1, "Interpret filename arguments as URIs");
        commandLineOptions.setPermittedValues("u", new String[]{"on", "off"}, "on");
        commandLineOptions.addRecognizedOption("update", 260, "Enable or disable XQuery updates, or enable the syntax but discard the updates");
        commandLineOptions.setPermittedValues("update", new String[]{"on", "off", "discard"}, null);
        commandLineOptions.addRecognizedOption("val", 4, "Apply validation to source documents");
        commandLineOptions.setPermittedValues("val", new String[]{"strict", "lax"}, "strict");
        commandLineOptions.addRecognizedOption("wrap", 1, "Wrap result sequence in XML elements");
        commandLineOptions.addRecognizedOption("x", 259, "Use named XMLReader class for parsing source documents");
        commandLineOptions.addRecognizedOption("xi", 1, "Expand XInclude directives in source documents");
        commandLineOptions.addRecognizedOption("xmlversion", 260, "Indicate whether XML 1.1 is supported");
        commandLineOptions.setPermittedValues("xmlversion", new String[]{"1.0", "1.1"}, null);
        commandLineOptions.addRecognizedOption("xsd", 263, "List of schema documents to be preloaded");
        commandLineOptions.addRecognizedOption("xsdversion", 260, "Indicate whether XSD 1.1 is supported");
        commandLineOptions.setPermittedValues("xsdversion", new String[]{"1.0", "1.1"}, null);
        commandLineOptions.addRecognizedOption("xsiloc", 1, "Load schemas named in xsi:schemaLocation (default on)");
        commandLineOptions.addRecognizedOption("?", 512, "Display command line help text");
    }

    protected void doQuery(String[] stringArray, String object) {
        String string;
        StringBuilder stringBuilder;
        Query query;
        block56: {
            Object object2;
            block57: {
                object = new CommandLineOptions();
                this.setPermittedOptions((CommandLineOptions)object);
                try {
                    ((CommandLineOptions)object).setActualOptions(stringArray);
                }
                catch (XPathException xPathException) {
                    this.quit(xPathException.getMessage(), 2);
                }
                boolean bl2 = false;
                object2 = ((CommandLineOptions)object).getOptionValue("config");
                if (object2 != null) {
                    try {
                        this.config = Configuration.readConfiguration(new StreamSource((String)object2));
                        bl2 = this.config.isLicensedFeature(4);
                    }
                    catch (XPathException xPathException) {
                        this.quit(xPathException.getMessage(), 2);
                    }
                }
                if (this.config == null && !bl2) {
                    bl2 = ((CommandLineOptions)object).testIfSchemaAware();
                }
                if (this.config == null) {
                    this.config = Configuration.newConfiguration();
                }
                this.processor = new Processor(this.config);
                try {
                    int n2;
                    Object object3;
                    Object object4;
                    this.parseOptions((CommandLineOptions)object);
                    object2 = this.processor.newXQueryCompiler();
                    ((XQueryCompiler)object2).setSchemaAware(bl2);
                    if (this.updating) {
                        ((XQueryCompiler)object2).setUpdatingEnabled(true);
                    }
                    if (this.config.getTraceListener() != null) {
                        ((XQueryCompiler)object2).setCompileWithTracing(true);
                    }
                    if (this.moduleURIResolverClass != null) {
                        object4 = this.config.getInstance(this.moduleURIResolverClass, null);
                        if (!(object4 instanceof ModuleURIResolver)) {
                            this.badUsage(this.moduleURIResolverClass + " is not a ModuleURIResolver");
                        }
                        ((XQueryCompiler)object2).setModuleURIResolver((ModuleURIResolver)object4);
                    }
                    if (this.uriResolverClass != null) {
                        this.config.setURIResolver(this.config.makeURIResolver(this.uriResolverClass));
                    }
                    this.config.displayLicenseMessage();
                    if (bl2 && !this.config.isLicensedFeature(4)) {
                        if ("EE".equals(this.config.getEditionCode())) {
                            this.quit("Installed license does not allow schema-aware query", 2);
                        } else {
                            this.quit("Schema-aware query requires Saxon Enterprise Edition", 2);
                        }
                    }
                    if (this.explain) {
                        this.config.setBooleanProperty(Feature.TRACE_OPTIMIZER_DECISIONS, true);
                    }
                    ((XQueryCompiler)object2).setStreaming(this.streaming);
                    object4 = null;
                    if (this.sourceFileName != null) {
                        Query query2 = this;
                        object4 = query2.processSourceFile(query2.sourceFileName, this.useURLs);
                    }
                    long l2 = System.nanoTime();
                    if (this.showTime) {
                        System.err.println("Analyzing query from " + this.queryFileName);
                    }
                    XQueryExecutable xQueryExecutable = null;
                    try {
                        xQueryExecutable = this.compileQuery((XQueryCompiler)object2, this.queryFileName, this.useURLs);
                        if (this.showTime) {
                            long l3 = System.nanoTime();
                            System.err.println("Analysis time: " + (double)(l3 - l2) / 1000000.0 + " milliseconds");
                        }
                    }
                    catch (SaxonApiException saxonApiException) {
                        SaxonApiException saxonApiException2 = saxonApiException;
                        if (saxonApiException.getCause() instanceof XPathException) {
                            object3 = (XPathException)saxonApiException2.getCause();
                            int n3 = -1;
                            object2 = null;
                            if (((XPathException)object3).getLocator() != null) {
                                n3 = ((XPathException)object3).getLocator().getLineNumber();
                                object2 = ((XPathException)object3).getLocator().getSystemId();
                            }
                            if (((XPathException)object3).hasBeenReported()) {
                                this.quit("Static error(s) in query", 2);
                            } else if (n3 == -1) {
                                System.err.println("Static error in query: " + ((Throwable)object3).getMessage());
                            } else {
                                System.err.println("Static error at line " + n3 + " of " + (String)object2 + ':');
                                System.err.println(((Throwable)object3).getMessage());
                            }
                            xQueryExecutable = null;
                            if (this.c) {
                                System.exit(2);
                            }
                            throw new RuntimeException((Throwable)object3);
                        }
                        this.quit(saxonApiException2.getMessage(), 2);
                    }
                    if (this.explain && xQueryExecutable != null) {
                        Serializer serializer = this.explainOutputFileName == null || this.explainOutputFileName.equals("") ? this.processor.newSerializer(System.err) : this.processor.newSerializer(new File(this.explainOutputFileName));
                        serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
                        serializer.setOutputProperty(Serializer.Property.INDENT, "yes");
                        serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
                        if (!"HE".equals(this.processor.getSaxonEdition())) {
                            serializer.setOutputProperty(Serializer.Property.SAXON_INDENT_SPACES, "2");
                        }
                        xQueryExecutable.explain(serializer);
                    }
                    xQueryExecutable.getUnderlyingCompiledQuery().setAllowDocumentProjection(this.projection);
                    XQueryEvaluator xQueryEvaluator = xQueryExecutable.load();
                    xQueryEvaluator.setTraceFunctionDestination(this.a);
                    if (((CommandLineOptions)object).getOptionValue("now") != null) {
                        object3 = ((CommandLineOptions)object).getOptionValue("now");
                        ConversionResult conversionResult = DateTimeValue.makeDateTimeValue((CharSequence)object3, this.config.getConversionRules());
                        if (conversionResult instanceof DateTimeValue) {
                            xQueryEvaluator.getUnderlyingQueryContext().setCurrentDateTime((DateTimeValue)conversionResult);
                        } else {
                            System.err.println("Invalid dateTime: " + (String)object3 + " (ignored)");
                        }
                    }
                    if (this.uriResolverClass != null) {
                        xQueryEvaluator.setURIResolver(this.config.makeURIResolver(this.uriResolverClass));
                    }
                    this.processSource((Source)object4, xQueryExecutable, xQueryEvaluator);
                    ((CommandLineOptions)object).setParams(this.processor, xQueryEvaluator::setExternalVariable);
                    l2 = System.nanoTime();
                    long l4 = 0L;
                    for (n2 = 0; n2 < this.repeat; ++n2) {
                        Object object5;
                        Object object6;
                        try {
                            if (this.outputFileName != null) {
                                object6 = new File(this.outputFileName);
                                if (((File)object6).isDirectory()) {
                                    this.quit("Output is a directory", 2);
                                }
                                Query.createFileIfNecessary((File)object6);
                                object5 = new FileOutputStream((File)object6);
                            } else {
                                object5 = System.out;
                            }
                            object6 = this.processor.newSerializer((OutputStream)object5);
                            try {
                                ((CommandLineOptions)object).setSerializationProperties((Serializer)object6);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                this.quit(illegalArgumentException.getMessage(), 2);
                            }
                            if (this.updating && xQueryExecutable.isUpdateQuery()) {
                                ((Serializer)object6).setOutputProperties(xQueryExecutable.getUnderlyingCompiledQuery().getExecutable().getPrimarySerializationProperties().getProperties());
                                this.runUpdate(xQueryExecutable, xQueryEvaluator, (Serializer)object6);
                            } else {
                                this.runQuery(xQueryExecutable, xQueryEvaluator, (Source)object4, (Destination)object6);
                            }
                        }
                        catch (SaxonApiException saxonApiException) {
                            object5 = saxonApiException;
                            if (saxonApiException.getCause() instanceof XPathException && ((XPathException)((Throwable)object5).getCause()).hasBeenReported()) {
                                object6 = ((XPathException)((Throwable)object5).getCause()).isTypeError() ? "type" : "dynamic";
                                this.quit("Query failed with " + (String)object6 + " error: " + ((Throwable)object5).getCause().getMessage(), 2);
                            }
                            throw object5;
                        }
                        if (!this.showTime) continue;
                        long l5 = System.nanoTime();
                        if (n2 >= 3) {
                            l4 += l5 - l2;
                        }
                        if (this.repeat < 100) {
                            System.err.println("Execution time: " + CommandLineOptions.showExecutionTimeNano(l5 - l2));
                            System.err.println("Memory used: " + CommandLineOptions.showMemoryUsed());
                        } else if (l4 > 1000000000000L) break;
                        l2 = l5;
                    }
                    if (this.repeat > 3) {
                        System.err.println("Average execution time: " + CommandLineOptions.showExecutionTimeNano(l4 / (long)(n2 - 3)));
                    }
                    if (((CommandLineOptions)object).getOptionValue("TB") != null) {
                        this.config.createByteCodeReport(((CommandLineOptions)object).getOptionValue("TB"));
                    }
                    return;
                }
                catch (TerminationException terminationException) {
                    this.quit(terminationException.getMessage(), 1);
                    return;
                }
                catch (SchemaException schemaException) {
                    query = this;
                    stringBuilder = new StringBuilder("Schema processing failed: ");
                    string = schemaException.getMessage();
                    break block56;
                }
                catch (SaxonApiException | LicenseException | XPathException exception) {
                    query = this;
                    stringBuilder = new StringBuilder("Query processing failed: ");
                }
                catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                    object2 = transformerFactoryConfigurationError;
                    transformerFactoryConfigurationError.printStackTrace();
                    this.quit("Query processing failed", 2);
                    return;
                }
                catch (Exception exception) {
                    object2 = exception;
                    exception.printStackTrace();
                    query = this;
                    stringBuilder = new StringBuilder("Fatal error during query: ").append(object2.getClass().getName()).append(": ");
                    if (((Throwable)object2).getMessage() != null) break block57;
                    string = " (no message)";
                    break block56;
                }
            }
            string = ((Throwable)object2).getMessage();
        }
        query.quit(stringBuilder.append(string).toString(), 2);
    }

    protected void parseOptions(CommandLineOptions object) {
        Object object2;
        ((CommandLineOptions)object).applyToConfiguration(this.processor);
        this.c = !"off".equals(((CommandLineOptions)object).getOptionValue("quit"));
        this.backup = "on".equals(((CommandLineOptions)object).getOptionValue("backup"));
        this.explainOutputFileName = ((CommandLineOptions)object).getOptionValue("explain");
        this.explain = this.explainOutputFileName != null;
        this.moduleURIResolverClass = ((CommandLineOptions)object).getOptionValue("mr");
        this.outputFileName = ((CommandLineOptions)object).getOptionValue("o");
        this.streaming = "on".equals(((CommandLineOptions)object).getOptionValue("stream"));
        String string = ((CommandLineOptions)object).getOptionValue("p");
        if ("on".equals(string)) {
            this.config.setParameterizedURIResolver();
            this.useURLs = true;
        }
        this.projection = "on".equals(((CommandLineOptions)object).getOptionValue("projection"));
        string = ((CommandLineOptions)object).getOptionValue("q");
        if (string != null) {
            this.queryFileName = string;
        }
        if ((string = ((CommandLineOptions)object).getOptionValue("qs")) != null) {
            this.queryFileName = "{" + string + "}";
        }
        if ((string = ((CommandLineOptions)object).getOptionValue("qversion")) != null && !"3.1".equals(string)) {
            System.err.println("-qversion ignored: 3.1 is assumed");
        }
        if ((string = ((CommandLineOptions)object).getOptionValue("repeat")) != null) {
            this.repeat = Integer.parseInt(string);
        }
        this.sourceFileName = ((CommandLineOptions)object).getOptionValue("s");
        string = ((CommandLineOptions)object).getOptionValue("t");
        if ("on".equals(string)) {
            System.err.println(this.config.getProductTitle());
            System.err.println(Version.platform.getPlatformVersion());
            this.config.setTiming(true);
            this.showTime = true;
        }
        if ((string = ((CommandLineOptions)object).getOptionValue("traceout")) != null) {
            switch (string) {
                case "#err": {
                    break;
                }
                case "#out": {
                    this.a = new StandardLogger(System.out);
                    break;
                }
                case "#null": {
                    this.a = null;
                    break;
                }
                default: {
                    try {
                        this.a = new StandardLogger(new File(string));
                        this.b = true;
                        break;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.badUsage("Trace output file " + string + " cannot be created");
                    }
                }
            }
        }
        if ((string = ((CommandLineOptions)object).getOptionValue("T")) != null) {
            if ("".equals(string)) {
                this.a((CommandLineOptions)object);
            } else {
                this.config.setTraceListenerClass(string);
            }
            this.config.setLineNumbering(true);
        }
        if ((string = ((CommandLineOptions)object).getOptionValue("Tout")) != null) {
            this.config.setTraceListenerOutputFile(string);
            if (((CommandLineOptions)object).getOptionValue("T") == null) {
                this.a((CommandLineOptions)object);
            }
        }
        if ((string = ((CommandLineOptions)object).getOptionValue("TB")) != null) {
            this.config.setBooleanProperty(Feature.MONITOR_HOT_SPOT_BYTE_CODE, true);
        }
        if ((string = ((CommandLineOptions)object).getOptionValue("TP")) != null) {
            object2 = new TimingTraceListener();
            this.config.setTraceListener((TraceListener)object2);
            this.config.setLineNumbering(true);
            this.config.getDefaultStaticQueryContext().setCodeInjector(new TimingCodeInjector());
            if (!string.isEmpty()) {
                try {
                    ((TimingTraceListener)object2).setOutputDestination(new StandardLogger(new File(string)));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.badUsage("Trace output file " + string + " cannot be created");
                }
            }
        }
        if ((string = ((CommandLineOptions)object).getOptionValue("u")) != null) {
            this.useURLs = "on".equals(string);
        }
        if ((string = ((CommandLineOptions)object).getOptionValue("update")) != null) {
            if (!"off".equals(string)) {
                this.updating = true;
            }
            this.writeback = !"discard".equals(string);
        }
        this.wrap = "on".equals(((CommandLineOptions)object).getOptionValue("wrap"));
        string = ((CommandLineOptions)object).getOptionValue("x");
        if (string != null) {
            this.config.setSourceParserClass(string);
        }
        object2 = ((CommandLineOptions)object).getOptionValue("xsd");
        string = ((CommandLineOptions)object).getOptionValue("?");
        if (string != null) {
            this.badUsage("");
        }
        this.applyLocalOptions((CommandLineOptions)object, this.config);
        List<String> list = ((CommandLineOptions)object).getPositionalOptions();
        int n2 = 0;
        if (this.queryFileName == null) {
            if (list.size() == 0) {
                this.badUsage("No query file name");
            }
            ++n2;
            this.queryFileName = list.get(0);
        }
        if (n2 < list.size()) {
            this.badUsage("Unrecognized option: " + list.get(n2));
        }
        if ((object = ((CommandLineOptions)object).getOptionValue("scmin")) != null) {
            this.config.importComponents(new StreamSource((String)object));
        }
        if (object2 != null) {
            CommandLineOptions.loadAdditionalSchemas(this.config, (String)object2);
        }
    }

    private void a(CommandLineOptions object) {
        XQueryTraceListener xQueryTraceListener = new XQueryTraceListener();
        String string = ((CommandLineOptions)object).getOptionValue("Tout");
        if (string != null) {
            try {
                xQueryTraceListener.setOutputDestination(new StandardLogger(new PrintStream(string)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.badUsage("Cannot write to " + string);
            }
        }
        if ((string = ((CommandLineOptions)object).getOptionValue("Tlevel")) != null) {
            switch (string) {
                case "none": {
                    xQueryTraceListener.setLevelOfDetail(0);
                    break;
                }
                case "low": {
                    xQueryTraceListener.setLevelOfDetail(1);
                    break;
                }
                case "normal": {
                    xQueryTraceListener.setLevelOfDetail(2);
                    break;
                }
                case "high": {
                    xQueryTraceListener.setLevelOfDetail(3);
                }
            }
        }
        this.config.setTraceListener(xQueryTraceListener);
    }

    protected void applyLocalOptions(CommandLineOptions commandLineOptions, Configuration configuration) {
    }

    protected Source processSourceFile(String object, boolean bl2) {
        Source source;
        if (bl2 || CommandLineOptions.isImplicitURI((String)object)) {
            source = this.config.getURIResolver().resolve((String)object, null);
            if (source == null) {
                source = this.config.getSystemURIResolver().resolve((String)object, null);
            }
        } else if (((String)object).equals("-")) {
            object = new File(System.getProperty("user.dir")).toURI().toASCIIString();
            source = new StreamSource(System.in, (String)object);
        } else {
            if (!((File)(object = new File((String)object))).exists()) {
                this.quit("Source file " + object + " does not exist", 2);
            }
            if (Version.platform.isJava()) {
                object = new InputSource(((File)object).toURI().toString());
                source = new SAXSource((InputSource)object);
            } else {
                source = new StreamSource(((File)object).toURI().toString());
            }
        }
        return source;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected XQueryExecutable compileQuery(XQueryCompiler object, String object2, boolean bl2) {
        if (((String)object2).equals("-")) {
            InputStreamReader inputStreamReader = new InputStreamReader(System.in);
            ((XQueryCompiler)object).setBaseURI(new File(System.getProperty("user.dir")).toURI());
            return ((XQueryCompiler)object).compile(inputStreamReader);
        }
        if (((String)object2).startsWith("{") && ((String)object2).endsWith("}")) {
            String string = ((String)object2).substring(1, ((String)object2).length() - 1);
            ((XQueryCompiler)object).setBaseURI(new File(System.getProperty("user.dir")).toURI());
            return ((XQueryCompiler)object).compile(string);
        }
        if (bl2 || CommandLineOptions.isImplicitURI((String)object2)) {
            Object[] objectArray;
            ModuleURIResolver moduleURIResolver = ((XQueryCompiler)object).getModuleURIResolver();
            boolean bl3 = false;
            if (moduleURIResolver == null) {
                moduleURIResolver = this.getConfiguration().getStandardModuleURIResolver();
                bl3 = true;
            }
            while (true) {
                objectArray = new String[]{object2};
                try {
                    objectArray = moduleURIResolver.resolve(null, null, (String[])objectArray);
                }
                catch (Exception exception) {
                    object2 = exception;
                    if (exception instanceof XPathException) {
                        throw new SaxonApiException((Throwable)object2);
                    }
                    object = new XPathException("Exception in ModuleURIResolver: ", (Throwable)object2);
                    ((XPathException)object).setErrorCode("XQST0059");
                    throw new SaxonApiException((Throwable)object);
                }
                if (objectArray != null) break;
                if (bl3) {
                    this.quit("System problem: standard ModuleURIResolver returned null", 4);
                    continue;
                }
                moduleURIResolver = this.getConfiguration().getStandardModuleURIResolver();
                bl3 = true;
            }
            if (objectArray.length != 1 || !(objectArray[0] instanceof StreamSource)) {
                this.quit("Module URI Resolver must return a single StreamSource", 2);
            }
            try {
                object2 = QueryReader.readSourceQuery((StreamSource)objectArray[0], this.config.getValidCharacterChecker());
                return ((XQueryCompiler)object).compile((String)object2);
            }
            catch (XPathException xPathException) {
                throw new SaxonApiException(xPathException);
            }
        }
        FileInputStream fileInputStream = new FileInputStream((String)object2);
        Throwable throwable = null;
        try {
            ((XQueryCompiler)object).setBaseURI(new File((String)object2).toURI());
            object = ((XQueryCompiler)object).compile(fileInputStream);
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (throwable != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable4;
                } else {
                    ((InputStream)fileInputStream).close();
                }
                throw throwable4;
            }
        }
        ((InputStream)fileInputStream).close();
        return object;
    }

    protected void explain(XQueryExpression xQueryExpression) {
        Object object = this.explainOutputFileName == null || "".equals(this.explainOutputFileName) ? System.err : new FileOutputStream(new File(this.explainOutputFileName));
        SerializationProperties serializationProperties = ExpressionPresenter.makeDefaultProperties(this.config);
        object = this.config.getSerializerFactory().getReceiver(new StreamResult((OutputStream)object), serializationProperties);
        object = new ExpressionPresenter(this.config, (Receiver)object);
        xQueryExpression.explain((ExpressionPresenter)object);
    }

    protected void processSource(Source object, XQueryExecutable xQueryExecutable, XQueryEvaluator xQueryEvaluator) {
        if (object != null && !this.streaming) {
            DocumentBuilder documentBuilder = this.processor.newDocumentBuilder();
            if (xQueryExecutable.isUpdateQuery()) {
                documentBuilder.setTreeModel(TreeModel.LINKED_TREE);
            }
            if (this.showTime) {
                System.err.println("Processing " + object.getSystemId());
            }
            if (!xQueryExecutable.getUnderlyingCompiledQuery().usesContextItem()) {
                System.err.println("Source document ignored - query can be evaluated without reference to the context item");
                return;
            }
            if (this.projection) {
                documentBuilder.setDocumentProjectionQuery(xQueryExecutable);
                if (this.explain) {
                    xQueryExecutable.getUnderlyingCompiledQuery().explainPathMap();
                }
            }
            documentBuilder.setDTDValidation(this.getConfiguration().getBooleanProperty(Feature.DTD_VALIDATION));
            if (this.getConfiguration().getBooleanProperty(Feature.DTD_VALIDATION_RECOVERABLE)) {
                object = new AugmentedSource((Source)object, this.getConfiguration().getParseOptions());
            }
            object = documentBuilder.build((Source)object);
            xQueryEvaluator.setContextItem((XdmItem)object);
        }
    }

    protected void runQuery(XQueryExecutable object, XQueryEvaluator xQueryEvaluator, Source source, Destination destination) {
        try {
            if (this.wrap) {
                try {
                    object = ((XQueryExecutable)object).getUnderlyingCompiledQuery();
                    object = ((XQueryExpression)object).iterator(xQueryEvaluator.getUnderlyingQueryContext());
                    object = QueryResult.wrap(object, this.config);
                    object = XdmValue.wrap(((AbstractVirtualNode)object).getUnderlyingNode());
                    this.processor.writeXdmValue((XdmValue)object, destination);
                    destination.closeAndNotify();
                }
                catch (XPathException xPathException) {
                    throw new SaxonApiException(xPathException);
                }
            } else if (this.streaming) {
                xQueryEvaluator.runStreamed(source, destination);
            } else {
                xQueryEvaluator.run(destination);
            }
            if (this.b && this.a != null) {
                ((Logger)this.a).close();
                return;
            }
        }
        catch (Throwable throwable) {
            if (this.b && this.a != null) {
                ((Logger)this.a).close();
            }
            throw throwable;
        }
    }

    protected void runUpdate(XQueryExecutable xQueryExecutable, XQueryEvaluator xQueryEvaluator, Serializer serializer) {
        try {
            if (serializer.getOutputProperty(Serializer.Property.METHOD) == null) {
                serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
            }
            if (this.writeback) {
                ArrayList arrayList = new ArrayList(3);
                UpdateAgent updateAgent = (object2, object3) -> {
                    try {
                        Object object4;
                        object3 = ((Controller)object3).getDocumentPool();
                        object3 = ((DocumentPool)((Object)object3)).getDocumentURI(object2);
                        if (object3 != null) {
                            Comparable<URI> comparable;
                            NodeInfo nodeInfo = object2;
                            PrintStream printStream = this.showTime ? System.err : null;
                            boolean bl2 = this.backup;
                            object2 = serializer;
                            serializer = nodeInfo;
                            switch (nodeInfo.getNodeKind()) {
                                case 9: {
                                    break;
                                }
                                case 1: {
                                    object4 = serializer.getParent();
                                    if (object4 == null || object4.getNodeKind() == 9) break;
                                    throw new SaxonApiException("Cannot rewrite an element node unless it is top-level");
                                }
                                default: {
                                    throw new SaxonApiException("Node to be rewritten must be a document or element node");
                                }
                            }
                            object4 = serializer.getSystemId();
                            if (object4 == null || ((String)object4).isEmpty()) {
                                throw new SaxonApiException("Cannot rewrite a document with no known URI");
                            }
                            try {
                                comparable = new URI((String)object4);
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                throw new SaxonApiException("SystemId of updated document is not a valid URI: " + (String)object4);
                            }
                            object4 = new File((URI)comparable);
                            comparable = ((File)object4).getParentFile();
                            if (bl2 && ((File)object4).exists()) {
                                boolean bl3;
                                File file = new File((File)comparable, ((File)object4).getName() + ".bak");
                                if (printStream != null) {
                                    printStream.println("Creating backup file " + file);
                                }
                                if (!(bl3 = ((File)object4).renameTo(file))) {
                                    throw new SaxonApiException("Failed to create backup file of " + file);
                                }
                            }
                            if (!((File)object4).exists()) {
                                if (printStream != null) {
                                    printStream.println("Creating file " + object4);
                                }
                                try {
                                    ((File)object4).createNewFile();
                                }
                                catch (IOException iOException) {
                                    throw new SaxonApiException("Failed to create new file " + object4);
                                }
                            } else if (printStream != null) {
                                printStream.println("Overwriting file " + object4);
                            }
                        } else {
                            if (this.showTime) {
                                System.err.println("Updated document discarded because it was not read using doc()");
                            }
                            return;
                        }
                        ((Serializer)((Object)object2)).setOutputFile((File)object4);
                        ((Serializer)((Object)object2)).getProcessor().writeXdmValue(XdmValue.wrap(serializer), (Destination)((Object)object2));
                    }
                    catch (SaxonApiException saxonApiException) {
                        System.err.println(saxonApiException.getMessage());
                        arrayList.add(saxonApiException);
                    }
                };
                xQueryEvaluator.run();
                try {
                    xQueryExecutable.getUnderlyingCompiledQuery().runUpdate(xQueryEvaluator.getUnderlyingQueryContext(), updateAgent);
                }
                catch (XPathException xPathException) {
                    throw new SaxonApiException(xPathException);
                }
                if (!arrayList.isEmpty()) {
                    throw (SaxonApiException)arrayList.get(0);
                }
            } else {
                try {
                    if (xQueryEvaluator.getContextItem() != null) {
                        Set<MutableNodeInfo> set = xQueryExecutable.getUnderlyingCompiledQuery().runUpdate(xQueryEvaluator.getUnderlyingQueryContext());
                        Object t2 = xQueryEvaluator.getContextItem().getUnderlyingValue().head();
                        if (t2 instanceof NodeInfo && set.contains(t2)) {
                            this.processor.writeXdmValue(xQueryEvaluator.getContextItem(), serializer);
                        }
                    }
                }
                catch (XPathException xPathException) {
                    throw new SaxonApiException(xPathException);
                }
            }
            if (this.b && this.a != null) {
                ((Logger)this.a).close();
                return;
            }
        }
        catch (Throwable throwable) {
            if (this.b && this.a != null) {
                ((Logger)this.a).close();
            }
            throw throwable;
        }
    }

    protected void quit(String string, int n2) {
        System.err.println(string);
        if (this.c) {
            System.exit(n2);
            return;
        }
        throw new RuntimeException(string);
    }

    protected void badUsage(String string) {
        if (!"".equals(string)) {
            System.err.println(string);
        }
        if (!this.showTime) {
            System.err.println(this.config.getProductTitle());
        }
        System.err.println("Usage: see http://www.saxonica.com/documentation/index.html#!using-xquery/commandline");
        System.err.println("Format: " + CommandLineOptions.getCommandName(this) + " options params");
        CommandLineOptions commandLineOptions = new CommandLineOptions();
        this.setPermittedOptions(commandLineOptions);
        System.err.println("Options available:" + commandLineOptions.displayPermittedOptions());
        System.err.println("Use -XYZ:? for details of option XYZ");
        System.err.println("Params: ");
        System.err.println("  param=value           Set query string parameter");
        System.err.println("  +param=filename       Set query document parameter");
        System.err.println("  ?param=expression     Set query parameter using XPath");
        System.err.println("  !param=value          Set serialization parameter");
        if (this.c) {
            System.exit("".equals(string) ? 0 : 2);
            return;
        }
        throw new RuntimeException(string);
    }

    public static void createFileIfNecessary(File file) {
        if (!file.exists()) {
            File file2 = file.getParentFile();
            if (file2 != null && !file2.exists()) {
                file2.mkdirs();
            }
            file.createNewFile();
        }
    }
}

