/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.Version;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalContextRequirement;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.StandardLogger;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SchemaValidator;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltPackage;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.AbstractTraceListener;
import net.sf.saxon.trace.TimingCodeInjector;
import net.sf.saxon.trace.TimingTraceListener;
import net.sf.saxon.trace.XSLTTraceListener;
import net.sf.saxon.trans.CommandLineOptions;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.packages.PackageDetails;
import net.sf.saxon.trans.packages.PackageLibrary;
import net.sf.saxon.value.DateTimeValue;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class Transform {
    protected Processor processor;
    protected XsltCompiler compiler;
    protected boolean useURLs = false;
    protected boolean showTime = false;
    protected int repeat = 1;
    protected String sourceParserName = null;
    protected boolean schemaAware = false;
    protected boolean allowExit = true;
    protected boolean run = true;

    public static void main(String[] stringArray) {
        new Transform().doTransform(stringArray, "java net.sf.saxon.Transform");
    }

    public void setPermittedOptions(CommandLineOptions commandLineOptions) {
        commandLineOptions.addRecognizedOption("a", 1, "Use <?xml-stylesheet?> processing instruction to identify stylesheet");
        commandLineOptions.addRecognizedOption("catalog", 258, "Use specified catalog file to resolve URIs");
        commandLineOptions.addRecognizedOption("config", 258, "Use specified configuration file");
        commandLineOptions.addRecognizedOption("cr", 259, "Use specified collection URI resolver class");
        commandLineOptions.addRecognizedOption("diag", 2, "Display runtime diagnostics");
        commandLineOptions.addRecognizedOption("dtd", 4, "Validate using DTD");
        commandLineOptions.setPermittedValues("dtd", new String[]{"on", "off", "recover"}, "on");
        commandLineOptions.addRecognizedOption("ea", 1, "Enable assertions");
        commandLineOptions.addRecognizedOption("expand", 1, "Expand attribute defaults from DTD or Schema");
        commandLineOptions.addRecognizedOption("explain", 2, "Display compiled expression tree and optimization decisions in human-readable form");
        commandLineOptions.addRecognizedOption("export", 2, "Display compiled expression tree and optimization decisions for exportation");
        commandLineOptions.addRecognizedOption("ext", 1, "Allow calls to Java extension functions and xsl:result-document");
        commandLineOptions.addRecognizedOption("im", 262, "Name of initial mode");
        commandLineOptions.addRecognizedOption("init", 3, "User-supplied net.sf.saxon.lib.Initializer class to initialize the Saxon Configuration");
        commandLineOptions.addRecognizedOption("it", 6, "Name of initial template");
        commandLineOptions.addRecognizedOption("jit", 1, "Just-in-time compilation");
        commandLineOptions.addRecognizedOption("l", 1, "Maintain line numbers for source documents");
        commandLineOptions.addRecognizedOption("lib", 263, "List of file names of library packages used by the stylesheet");
        commandLineOptions.addRecognizedOption("license", 1, "Check for local license file");
        commandLineOptions.addRecognizedOption("m", 3, "Use named class to handle xsl:message output");
        commandLineOptions.addRecognizedOption("nogo", 1, "Compile only, no evaluation");
        commandLineOptions.addRecognizedOption("now", 264, "Run with specified current date/time");
        commandLineOptions.addRecognizedOption("o", 258, "Use specified file for primary output");
        commandLineOptions.addRecognizedOption("opt", 265, "Enable/disable optimization options [-]cfgjklmrsvwx");
        commandLineOptions.addRecognizedOption("or", 259, "Use named OutputURIResolver class");
        commandLineOptions.addRecognizedOption("outval", 260, "Action when validation of output file fails");
        commandLineOptions.setPermittedValues("outval", new String[]{"recover", "fatal"}, null);
        commandLineOptions.addRecognizedOption("p", 1, "Recognize query parameters in URI passed to doc()");
        commandLineOptions.addRecognizedOption("quit", 257, "Quit JVM if transformation fails");
        commandLineOptions.addRecognizedOption("r", 259, "Use named URIResolver class");
        commandLineOptions.addRecognizedOption("relocate", 1, "Produce relocatable packages");
        commandLineOptions.addRecognizedOption("repeat", 261, "Run N times for performance measurement");
        commandLineOptions.addRecognizedOption("s", 258, "Source file for primary input");
        commandLineOptions.addRecognizedOption("sa", 1, "Run in schema-aware mode");
        commandLineOptions.addRecognizedOption("scmin", 2, "Pre-load schema in SCM format");
        commandLineOptions.addRecognizedOption("strip", 260, "Handling of whitespace text nodes in source documents");
        commandLineOptions.setPermittedValues("strip", new String[]{"none", "all", "ignorable"}, null);
        commandLineOptions.addRecognizedOption("t", 1, "Display version and timing information, and names of output files");
        commandLineOptions.addRecognizedOption("target", 260, "Target Saxon edition for execution via -export");
        commandLineOptions.setPermittedValues("target", new String[]{"EE", "PE", "HE", "JS", "JS2"}, null);
        commandLineOptions.addRecognizedOption("T", 3, "Use named TraceListener class, or standard TraceListener");
        commandLineOptions.addRecognizedOption("TB", 2, "Trace hotspot bytecode generation to specified XML file");
        commandLineOptions.addRecognizedOption("TJ", 1, "Debug binding and execution of extension functions");
        commandLineOptions.setPermittedValues("TJ", new String[]{"on", "off"}, "on");
        commandLineOptions.addRecognizedOption("Tlevel", 9, "Level of detail for trace listener output");
        commandLineOptions.setPermittedValues("Tlevel", new String[]{"none", "low", "normal", "high"}, "normal");
        commandLineOptions.addRecognizedOption("Tout", 2, "File for trace listener output");
        commandLineOptions.addRecognizedOption("TP", 2, "Use profiling trace listener, with specified output file");
        commandLineOptions.addRecognizedOption("threads", 261, "Run stylesheet on directory of files divided in N threads");
        commandLineOptions.addRecognizedOption("tree", 260, "Use specified tree model for source documents");
        commandLineOptions.setPermittedValues("tree", new String[]{"linked", "tiny", "tinyc"}, null);
        commandLineOptions.addRecognizedOption("traceout", 258, "File for output of trace() and -T output");
        commandLineOptions.addRecognizedOption("u", 1, "Interpret filename arguments as URIs");
        commandLineOptions.setPermittedValues("u", new String[]{"on", "off"}, "on");
        commandLineOptions.addRecognizedOption("val", 4, "Apply validation to source documents");
        commandLineOptions.setPermittedValues("val", new String[]{"strict", "lax"}, "strict");
        commandLineOptions.addRecognizedOption("versionmsg", 1, "No longer used");
        commandLineOptions.addRecognizedOption("warnings", 260, "Handling of recoverable dynamic errors");
        commandLineOptions.setPermittedValues("warnings", new String[]{"silent", "recover", "fatal"}, null);
        commandLineOptions.addRecognizedOption("x", 259, "Use named XMLReader class for parsing source documents");
        commandLineOptions.addRecognizedOption("xi", 1, "Expand XInclude directives in source documents");
        commandLineOptions.addRecognizedOption("xmlversion", 260, "Indicate whether XML 1.1 is supported");
        commandLineOptions.setPermittedValues("xmlversion", new String[]{"1.0", "1.1"}, null);
        commandLineOptions.addRecognizedOption("xsd", 263, "List of schema documents to be preloaded");
        commandLineOptions.addRecognizedOption("xsdversion", 260, "Indicate whether XSD 1.1 is supported");
        commandLineOptions.setPermittedValues("xsdversion", new String[]{"1.0", "1.1"}, null);
        commandLineOptions.addRecognizedOption("xsiloc", 1, "Load schemas named in xsi:schemaLocation (default on)");
        commandLineOptions.addRecognizedOption("xsl", 258, "Main stylesheet file");
        commandLineOptions.addRecognizedOption("y", 259, "Use named XMLReader class for parsing stylesheet and schema documents");
        commandLineOptions.addRecognizedOption("?", 512, "Display command line help text");
    }

    public void doTransform(String[] object, String iterator) {
        block142: {
            String string;
            StringBuilder stringBuilder;
            Transform transform;
            Object object2;
            iterator = null;
            Object object3 = null;
            Object object4 = null;
            Object object5 = null;
            boolean bl2 = false;
            String string2 = null;
            boolean bl3 = false;
            boolean bl4 = false;
            Object object6 = null;
            Object object7 = null;
            Object object8 = null;
            Object var14_21 = null;
            boolean bl5 = false;
            int n2 = 0;
            boolean bl6 = true;
            CommandLineOptions commandLineOptions = new CommandLineOptions();
            this.setPermittedOptions(commandLineOptions);
            try {
                commandLineOptions.setActualOptions((String[])object);
            }
            catch (XPathException xPathException) {
                this.quit(xPathException.getMessage(), 2);
            }
            this.schemaAware = false;
            object = commandLineOptions.getOptionValue("config");
            if (object != null) {
                try {
                    object = Configuration.readConfiguration(new StreamSource((String)object));
                    this.initializeConfiguration((Configuration)object);
                    this.processor = new Processor((Configuration)object);
                    this.schemaAware = ((Configuration)object).isLicensedFeature(2);
                }
                catch (XPathException xPathException) {
                    this.quit(xPathException.getMessage(), 2);
                }
            }
            if (this.processor == null && !this.schemaAware) {
                this.schemaAware = commandLineOptions.testIfSchemaAware();
            }
            if (this.processor == null) {
                this.processor = new Processor(true);
                object = this.processor.getUnderlyingConfiguration();
                this.initializeConfiguration((Configuration)object);
                try {
                    Transform transform2 = this;
                    transform2.setFactoryConfiguration(transform2.schemaAware, null);
                    object2 = ((Configuration)object).getDefaultXsltCompilerInfo();
                    if (this.schemaAware) {
                        ((CompilerInfo)object2).setSchemaAware(true);
                    } else {
                        ((CompilerInfo)object2).setSchemaAware(false);
                    }
                }
                catch (Exception exception) {
                    object2 = exception;
                    exception.printStackTrace();
                    this.quit(((Throwable)object2).getMessage(), 2);
                }
            }
            object = this.processor.getUnderlyingConfiguration();
            try {
                Logger logger;
                List<Source> list;
                Object object9;
                commandLineOptions.applyToConfiguration(this.processor);
                this.compiler = this.processor.newXsltCompiler();
                this.allowExit = !"off".equals(commandLineOptions.getOptionValue("quit"));
                int n3 = "on".equals(commandLineOptions.getOptionValue("a"));
                object2 = commandLineOptions.getOptionValue("explain");
                if (object2 != null) {
                    bl3 = true;
                    this.processor.setConfigurationProperty(Feature.TRACE_OPTIMIZER_DECISIONS, Boolean.TRUE);
                    bl6 = false;
                    this.compiler.setJustInTimeCompilation(false);
                    if (!"".equals(object2)) {
                        object6 = object2;
                    }
                }
                if ((object2 = commandLineOptions.getOptionValue("export")) != null) {
                    bl4 = true;
                    bl6 = false;
                    this.compiler.setJustInTimeCompilation(false);
                    if (!"".equals(object2)) {
                        object7 = object2;
                    }
                }
                if ((object2 = commandLineOptions.getOptionValue("target")) != null) {
                    this.compiler.setTargetEdition((String)object2);
                }
                if ((object2 = commandLineOptions.getOptionValue("relocate")) != null && !"off".equals(object2)) {
                    this.compiler.setRelocatable(true);
                }
                if ((object2 = commandLineOptions.getOptionValue("jit")) != null) {
                    if ("on".equals(object2) && object7 == null && this.run) {
                        if (bl4) {
                            bl6 = false;
                            System.err.println("Warning: -jit:on is ignored when -export:on is set");
                        } else {
                            bl6 = true;
                        }
                    } else if ("off".equals(object2)) {
                        bl6 = false;
                    }
                    this.compiler.setJustInTimeCompilation(bl6);
                }
                if ((object2 = commandLineOptions.getOptionValue("lib")) != null) {
                    object9 = new StringTokenizer((String)object2, File.pathSeparator);
                    Object object10 = new HashSet<File>();
                    while (((StringTokenizer)object9).hasMoreTokens()) {
                        object2 = ((StringTokenizer)object9).nextToken();
                        object10.add(new File((String)object2));
                    }
                    object2 = null;
                    try {
                        object2 = new PackageLibrary(this.compiler.getUnderlyingCompilerInfo(), (Set<File>)object10);
                    }
                    catch (XPathException xPathException) {
                        this.quit(xPathException.getMessage(), 2);
                    }
                    this.compiler.getUnderlyingCompilerInfo().setPackageLibrary((PackageLibrary)object2);
                }
                if ((object2 = commandLineOptions.getOptionValue("o")) != null) {
                    object5 = object2;
                }
                if ((object2 = commandLineOptions.getOptionValue("nogo")) != null) {
                    if ("on".equals(commandLineOptions.getOptionValue("jit"))) {
                        System.err.println("Warning: -jit:on is ignored when -nogo is set");
                    }
                    this.run = false;
                    this.compiler.setJustInTimeCompilation(false);
                }
                if ("on".equals(object2 = commandLineOptions.getOptionValue("p"))) {
                    ((Configuration)object).setParameterizedURIResolver();
                    this.useURLs = true;
                }
                if ((object2 = commandLineOptions.getOptionValue("repeat")) != null) {
                    try {
                        this.repeat = Integer.parseInt((String)object2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.badUsage("Bad number after -repeat");
                    }
                }
                if ((object2 = commandLineOptions.getOptionValue("s")) != null) {
                    iterator = object2;
                }
                if ((object2 = commandLineOptions.getOptionValue("threads")) != null) {
                    n2 = Integer.parseInt((String)object2);
                }
                if ((object2 = commandLineOptions.getOptionValue("t")) != null) {
                    System.err.println(((Configuration)object).getProductTitle());
                    System.err.println(Version.platform.getPlatformVersion());
                    this.processor.setConfigurationProperty(Feature.TIMING, Boolean.TRUE);
                    this.showTime = true;
                }
                if ((object2 = commandLineOptions.getOptionValue("T")) != null) {
                    TraceListener traceListener = "".equals(object2) ? new XSLTTraceListener() : ((Configuration)object).makeTraceListener((String)object2);
                    this.processor.setConfigurationProperty(Feature.TRACE_LISTENER, traceListener);
                    this.processor.setConfigurationProperty(Feature.LINE_NUMBERING, Boolean.TRUE);
                    object9 = commandLineOptions.getOptionValue("Tout");
                    if (object9 != null) {
                        traceListener.setOutputDestination(new StandardLogger(new File((String)object9)));
                    }
                    if ((object2 = commandLineOptions.getOptionValue("Tlevel")) != null && traceListener instanceof AbstractTraceListener) {
                        switch (object2) {
                            case "none": {
                                ((AbstractTraceListener)traceListener).setLevelOfDetail(0);
                                break;
                            }
                            case "low": {
                                ((AbstractTraceListener)traceListener).setLevelOfDetail(1);
                                break;
                            }
                            case "normal": {
                                ((AbstractTraceListener)traceListener).setLevelOfDetail(2);
                                break;
                            }
                            case "high": {
                                ((AbstractTraceListener)traceListener).setLevelOfDetail(3);
                            }
                        }
                    }
                }
                if ((list = commandLineOptions.getOptionValue("TB")) != null) {
                    ((Configuration)object).setBooleanProperty(Feature.MONITOR_HOT_SPOT_BYTE_CODE, true);
                }
                if ((list = commandLineOptions.getOptionValue("TP")) != null) {
                    TimingTraceListener timingTraceListener = new TimingTraceListener();
                    this.processor.setConfigurationProperty(Feature.TRACE_LISTENER, timingTraceListener);
                    this.processor.setConfigurationProperty(Feature.LINE_NUMBERING, Boolean.TRUE);
                    this.compiler.getUnderlyingCompilerInfo().setCodeInjector(new TimingCodeInjector());
                    if (!((String)((Object)list)).isEmpty()) {
                        timingTraceListener.setOutputDestination(new StandardLogger(new File((String)((Object)list))));
                    }
                }
                if ((list = commandLineOptions.getOptionValue("traceout")) == null) {
                    logger = ((Configuration)object).getLogger();
                } else {
                    switch (list) {
                        case "#err": {
                            logger = new StandardLogger();
                            break;
                        }
                        case "#out": {
                            logger = new StandardLogger(System.out);
                            break;
                        }
                        case "#null": {
                            logger = null;
                            break;
                        }
                        default: {
                            logger = new StandardLogger(new File((String)((Object)list)));
                            bl5 = true;
                        }
                    }
                }
                list = commandLineOptions.getOptionValue("u");
                if (list != null) {
                    this.useURLs = "on".equals(list);
                }
                if ((list = commandLineOptions.getOptionValue("x")) != null) {
                    this.sourceParserName = list;
                    this.processor.setConfigurationProperty(Feature.SOURCE_PARSER_CLASS, this.sourceParserName);
                }
                if ((list = commandLineOptions.getOptionValue("xsd")) != null) {
                    object8 = list;
                }
                if ((list = commandLineOptions.getOptionValue("xsdversion")) != null) {
                    this.processor.setConfigurationProperty(Feature.XSD_VERSION, list);
                }
                if ((list = commandLineOptions.getOptionValue("xsl")) != null) {
                    object3 = list;
                }
                if ((list = commandLineOptions.getOptionValue("y")) != null) {
                    string2 = list;
                    this.processor.setConfigurationProperty(Feature.STYLE_PARSER_CLASS, list);
                }
                if ((list = commandLineOptions.getOptionValue("?")) != null) {
                    this.badUsage("");
                }
                if (!((Configuration)object).getEditionCode().equals("HE")) {
                    object9 = commandLineOptions.getOptionValue("license");
                    if (object9 == null || "on".equals(object9)) {
                        ((Configuration)object).displayLicenseMessage();
                    } else {
                        ((Configuration)object).disableLicensing();
                    }
                }
                this.applyLocalOptions(commandLineOptions, (Configuration)object);
                if (commandLineOptions.getOptionValue("it") != null && n3 != 0) {
                    this.badUsage("-it and -a options cannot be used together");
                }
                object9 = commandLineOptions.getPositionalOptions();
                int n4 = 0;
                if (this.run && commandLineOptions.getOptionValue("it") == null && iterator == null) {
                    if (object9.size() == 0) {
                        this.badUsage("No source file name");
                    }
                    ++n4;
                    iterator = object9.get(0);
                }
                if (n3 == 0 && object3 == null) {
                    if (object9.size() == n4) {
                        this.badUsage("No stylesheet file name");
                    }
                    object3 = object9.get(n4++);
                }
                if (n4 < object9.size()) {
                    this.badUsage("Unrecognized option: " + object9.get(n4));
                }
                if ((list = commandLineOptions.getOptionValue("scmin")) != null) {
                    ((Configuration)object).importComponents(new StreamSource((String)((Object)list)));
                }
                if (object8 != null) {
                    CommandLineOptions.loadAdditionalSchemas((Configuration)object, (String)object8);
                }
                commandLineOptions.applyStaticParams(this.compiler);
                list = new ArrayList();
                if (iterator != null) {
                    boolean bl7 = this.sourceParserName != null;
                    bl2 = CommandLineOptions.loadDocuments((String)((Object)iterator), this.useURLs, this.processor, bl7, list);
                    list = this.preprocess(list);
                    if (bl2) {
                        if (object5 == null) {
                            this.quit("To process a directory, -o must be specified", 2);
                        } else if (((String)object5).equals(iterator)) {
                            this.quit("Output directory must be different from input", 2);
                        } else {
                            object4 = new File((String)object5);
                            if (!((File)object4).isDirectory()) {
                                this.quit("Input is a directory, but output is not", 2);
                            }
                        }
                    }
                }
                if (object5 != null && !bl2 && ((File)(object4 = new File((String)object5))).isDirectory()) {
                    this.quit("Output is a directory, but input is not", 2);
                }
                if (n3 != 0) {
                    if (bl2) {
                        File file = object4;
                        object5 = logger;
                        object4 = commandLineOptions;
                        object3 = file;
                        iterator = list;
                        object = this;
                        n3 = 0;
                        iterator = iterator.iterator();
                        while (iterator.hasNext()) {
                            Source source = (Source)iterator.next();
                            string2 = Transform.a(source);
                            try {
                                super.a(source, string2, (File)object3, (CommandLineOptions)object4, (Logger)object5);
                            }
                            catch (SaxonApiException saxonApiException) {
                                ++n3;
                                System.err.println("While processing " + string2 + ": " + saxonApiException.getMessage() + '\n');
                            }
                        }
                        if (n3 > 0) {
                            throw new XPathException(n3 + " transformation" + (n3 == 1 ? "" : "s") + " failed");
                        }
                    } else {
                        this.a((Source)list.get(0), null, (File)object4, commandLineOptions, logger);
                    }
                    break block142;
                }
                long l2 = Transform.now();
                boolean bl8 = this.useURLs || CommandLineOptions.isImplicitURI((String)object3);
                object5 = null;
                Source source = null;
                object8 = null;
                if (bl8) {
                    source = ((Configuration)object).getURIResolver().resolve((String)object3, null);
                    if (source == null) {
                        source = ((Configuration)object).getSystemURIResolver().resolve((String)object3, null);
                    }
                } else if (((String)object3).equals("-")) {
                    object9 = new File(System.getProperty("user.dir")).toURI().toASCIIString();
                    if (string2 == null) {
                        source = new StreamSource(System.in, (String)object9);
                    } else if (Version.platform.isJava()) {
                        object8 = ((Configuration)object).getStyleParser();
                        InputSource inputSource = new InputSource(System.in);
                        inputSource.setSystemId((String)object9);
                        source = new SAXSource((XMLReader)object8, inputSource);
                    } else {
                        source = new StreamSource(System.in, (String)object9);
                    }
                } else {
                    Object object11;
                    object9 = ((Configuration)object).getDefaultXsltCompilerInfo().getPackageLibrary();
                    PackageDetails packageDetails = ((PackageLibrary)object9).findDetailsForAlias((String)object3);
                    if (packageDetails != null) {
                        object11 = this.compiler.obtainPackageWithAlias((String)object3);
                        object5 = ((XsltPackage)object11).link();
                    } else {
                        object11 = new File((String)object3);
                        if (!((File)object11).exists()) {
                            this.quit("Stylesheet file " + object11 + " does not exist", 2);
                        }
                        if (string2 == null) {
                            source = new StreamSource(((File)object11).toURI().toString());
                        } else {
                            InputSource inputSource = new InputSource(((File)object11).toURI().toString());
                            object8 = ((Configuration)object).getStyleParser();
                            source = new SAXSource((XMLReader)object8, inputSource);
                        }
                    }
                }
                if (source == null && object5 == null) {
                    this.quit("URIResolver for stylesheet file must return a Source", 2);
                }
                if (object5 == null) {
                    int n5 = this.repeat;
                    if (n5 > 20) {
                        n5 = 20;
                    }
                    for (int i2 = 0; i2 < n5; ++i2) {
                        object5 = this.compiler.compile(source);
                        if (this.schemaAware) {
                            int n6 = ((XsltExecutable)object5).getUnderlyingCompiledStylesheet().getTopLevelPackage().getLocalLicenseId();
                            ((Configuration)object).checkLicensedFeature(2, "schema-aware XSLT", n6);
                        }
                        if (object8 != null) {
                            ((Configuration)object).reuseStyleParser((XMLReader)object8);
                        }
                        if (!this.showTime) continue;
                        long l3 = Transform.now();
                        System.err.println("Stylesheet compilation time: " + CommandLineOptions.showExecutionTimeNano(l3 - l2));
                        l2 = l3;
                    }
                }
                if (bl3) {
                    Serializer serializer = object6 == null ? this.processor.newSerializer(System.err) : this.processor.newSerializer(new File((String)object6));
                    serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
                    serializer.setOutputProperty(Serializer.Property.INDENT, "yes");
                    serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
                    if (((Configuration)object).isLicensedFeature(8)) {
                        serializer.setOutputProperty(Serializer.Property.SAXON_INDENT_SPACES, "2");
                    }
                    ((XsltExecutable)object5).explain(serializer);
                }
                if (bl4) {
                    ((XsltExecutable)object5).export(new FileOutputStream((String)object7));
                    if (this.showTime) {
                        System.err.println("Stylesheet exported to: " + new File((String)object7).getAbsolutePath());
                    }
                }
                if (this.run) {
                    try {
                        if (bl2) {
                            if (n2 > 0 && list.size() > 1) {
                                int n7;
                                if (n2 > list.size()) {
                                    n2 = list.size();
                                }
                                int n8 = list.size() / n2;
                                int n9 = list.size() % n2;
                                Object object12 = new a[n2];
                                int n10 = 0;
                                for (int i3 = 0; i3 < list.size(); i3 += n8 + n7) {
                                    n7 = n10 < n9 ? 1 : 0;
                                    int n11 = i3;
                                    object12[n10] = new a(this, i3, (XsltExecutable)object5, list.subList(n11, n11 + n8 + n7), (File)object4, commandLineOptions, logger);
                                    object12[n10].start();
                                    ++n10;
                                }
                                a[] aArray = object12;
                                n10 = ((a[])object12).length;
                                for (int i4 = 0; i4 < n10; ++i4) {
                                    object12 = aArray[i4];
                                    object12.join();
                                }
                            } else {
                                this.a(list, (XsltExecutable)object5, (File)object4, commandLineOptions, logger);
                            }
                        } else {
                            Source source2 = list == null || list.isEmpty() ? null : list.get(0);
                            this.processFile(source2, (XsltExecutable)object5, (File)object4, commandLineOptions, logger);
                        }
                    }
                    finally {
                        if (bl5 && logger != null) {
                            logger.close();
                        }
                    }
                }
                if (commandLineOptions.getOptionValue("TB") != null) {
                    ((Configuration)object).createByteCodeReport(commandLineOptions.getOptionValue("TB"));
                }
                return;
            }
            catch (TerminationException terminationException) {
                this.quit(terminationException.getMessage(), 1);
                return;
            }
            catch (SaxonApiException saxonApiException) {
                this.quit(saxonApiException.getMessage(), 2);
                return;
            }
            catch (TransformerException | TransformerFactoryConfigurationError | LicenseException throwable) {
                transform = this;
                stringBuilder = new StringBuilder("Transformation failed: ");
                string = throwable.getMessage();
            }
            catch (Exception exception) {
                object2 = exception;
                exception.printStackTrace();
                transform = this;
                stringBuilder = new StringBuilder("Fatal error during transformation: ").append(object2.getClass().getName()).append(": ");
                string = ((Throwable)object2).getMessage() == null ? " (no message)" : ((Throwable)object2).getMessage();
            }
            transform.quit(stringBuilder.append(string).toString(), 2);
        }
    }

    protected void initializeConfiguration(Configuration configuration) {
    }

    public void setFactoryConfiguration(boolean bl2, String string) {
    }

    protected void applyLocalOptions(CommandLineOptions commandLineOptions, Configuration configuration) {
    }

    public List<Source> preprocess(List<Source> list) {
        return list;
    }

    protected Configuration getConfiguration() {
        return this.processor.getUnderlyingConfiguration();
    }

    protected void quit(String string, int n2) {
        System.err.println(string);
        if (this.allowExit) {
            System.exit(n2);
            return;
        }
        throw new RuntimeException(string);
    }

    private static File a(File file, String string, XsltExecutable object) {
        object = ((XsltExecutable)object).getUnderlyingCompiledStylesheet().getPrimarySerializationProperties().getProperty("media-type");
        String string2 = ".xml";
        if ("text/html".equals(object)) {
            string2 = ".html";
        } else if ("text/plain".equals(object)) {
            string2 = ".txt";
        }
        object = string;
        if (string.endsWith(".xml") || string.endsWith(".XML")) {
            object = string.substring(0, string.length() - 4);
        }
        return new File(file, (String)object + string2);
    }

    private void a(Source object, String object2, File file, CommandLineOptions commandLineOptions, Logger object3) {
        if (this.showTime) {
            System.err.println("Processing " + object.getSystemId() + " using associated stylesheet");
        }
        long l2 = Transform.now();
        object = this.processor.newDocumentBuilder().build((Source)object);
        Object object4 = this.compiler.getAssociatedStylesheet(((XdmNode)object).asSource(), null, null, null);
        XsltExecutable xsltExecutable = this.compiler.compile((Source)object4);
        if (this.showTime) {
            System.err.println("Prepared associated stylesheet " + object4.getSystemId());
        }
        object3 = this.newTransformer(xsltExecutable, commandLineOptions, (Logger)object3);
        object4 = file;
        if (object4 != null && ((File)object4).isDirectory()) {
            object4 = Transform.a((File)object4, (String)object2, xsltExecutable);
        }
        object2 = file == null ? this.processor.newSerializer(System.out) : this.processor.newSerializer((File)object4);
        try {
            commandLineOptions.setSerializationProperties((Serializer)object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.quit(illegalArgumentException.getMessage(), 2);
        }
        ((Xslt30Transformer)object3).setGlobalContextItem((XdmItem)object);
        ((Xslt30Transformer)object3).applyTemplates((XdmValue)object, (Destination)object2);
        if (this.showTime) {
            long l3 = Transform.now();
            System.err.println("Execution time: " + CommandLineOptions.showExecutionTimeNano(l3 - l2));
        }
    }

    protected Xslt30Transformer newTransformer(XsltExecutable object, CommandLineOptions commandLineOptions, Logger object2) {
        object = ((XsltExecutable)object).load30();
        new HashMap();
        ((Xslt30Transformer)object).getUnderlyingController().getExecutable();
        ((Xslt30Transformer)object).setTraceFunctionDestination((Logger)object2);
        object2 = commandLineOptions.getOptionValue("im");
        if (object2 != null) {
            ((Xslt30Transformer)object).setInitialMode(QName.fromClarkName((String)object2));
        }
        if ((object2 = commandLineOptions.getOptionValue("now")) != null) {
            try {
                object2 = (DateTimeValue)DateTimeValue.makeDateTimeValue((CharSequence)object2, this.getConfiguration().getConversionRules()).asAtomic();
                ((Xslt30Transformer)object).getUnderlyingController().setCurrentDateTime((DateTimeValue)object2);
            }
            catch (XPathException xPathException) {
                throw new SaxonApiException("Failed to set current time", xPathException);
            }
        }
        if ("on".equals(commandLineOptions.getOptionValue("ea"))) {
            ((Xslt30Transformer)object).getUnderlyingController().setAssertionsEnabled(true);
        } else if ("off".equals(commandLineOptions.getOptionValue("ea"))) {
            ((Xslt30Transformer)object).getUnderlyingController().setAssertionsEnabled(true);
        }
        return object;
    }

    protected static long now() {
        return System.nanoTime();
    }

    private void a(List<Source> object, XsltExecutable xsltExecutable, File file, CommandLineOptions commandLineOptions, Logger logger) {
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Source source = (Source)object.next();
            String string = Transform.a(source);
            try {
                File file2 = Transform.a(file, string, xsltExecutable);
                this.processFile(source, xsltExecutable, file2, commandLineOptions, logger);
            }
            catch (SaxonApiException saxonApiException) {
                ++n2;
                System.err.println("While processing " + string + ": " + saxonApiException.getMessage() + '\n');
            }
        }
        if (n2 > 0) {
            throw new SaxonApiException(n2 + " transformation" + (n2 == 1 ? "" : "s") + " failed");
        }
    }

    private static String a(Source object) {
        try {
            object = new URI(object.getSystemId()).getPath();
            while (true) {
                int n2;
                if ((n2 = ((String)object).indexOf(47)) < 0) {
                    return object;
                }
                object = ((String)object).substring(n2 + 1);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException.getMessage());
        }
    }

    protected void processFile(Source source, XsltExecutable xsltExecutable, File file, CommandLineOptions commandLineOptions, Logger logger) {
        long l2 = 0L;
        int n2 = 0;
        int n3 = this.repeat / 2 - 1;
        for (int i2 = 0; i2 < this.repeat; ++i2) {
            Object object;
            Object object2;
            String string;
            Serializer serializer;
            Object object3;
            if (this.showTime) {
                String string2 = "Processing ";
                string2 = source != null ? string2 + source.getSystemId() : string2 + " (no source document)";
                String string3 = commandLineOptions.getOptionValue("im");
                if (string3 != null) {
                    string2 = string2 + " initial mode = " + string3;
                }
                if ((object3 = commandLineOptions.getOptionValue("it")) != null) {
                    string2 = string2 + " initial template = " + (String)(((String)object3).isEmpty() ? "xsl:initial-template" : object3);
                }
                System.err.println(string2);
            }
            long l3 = Transform.now();
            if (i2 == n3) {
                n2 = 0;
                l2 = 0L;
            }
            ++n2;
            if (i2 < n3) {
                logger = null;
            }
            object3 = this.newTransformer(xsltExecutable, commandLineOptions, logger);
            if (file == null) {
                ((Xslt30Transformer)object3).setBaseOutputURI(new File(System.getProperty("user.dir")).toURI().toASCIIString());
                serializer = this.processor.newSerializer(System.out);
            } else {
                serializer = this.processor.newSerializer(file);
            }
            try {
                commandLineOptions.setSerializationProperties(serializer);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.quit(illegalArgumentException.getMessage(), 2);
            }
            String string4 = serializer.getOutputProperty(Serializer.Property.BUILD_TREE);
            boolean bl2 = "yes".equals(string4) ? true : !"no".equals(string4) && !"json".equals(string = serializer.getOutputProperty(Serializer.Property.METHOD)) && !"adaptive".equals(string);
            string = commandLineOptions.getOptionValue("it");
            if (source != null) {
                boolean bl3;
                object2 = xsltExecutable.getUnderlyingCompiledStylesheet();
                object = ((Executable)object2).getGlobalContextRequirement();
                if (object == null) {
                    bl3 = string != null || !((Xslt30Transformer)object3).getUnderlyingController().getInitialMode().isDeclaredStreamable();
                } else {
                    boolean bl4 = bl3 = !((GlobalContextRequirement)object).isAbsentFocus();
                }
                if (bl3) {
                    DocumentBuilder documentBuilder = this.processor.newDocumentBuilder();
                    if (!((StylesheetPackage)(object2 = ((PreparedStylesheet)object2).getTopLevelPackage())).isStripsTypeAnnotations()) {
                        int n4 = this.getConfiguration().getSchemaValidationMode();
                        if (n4 == 1) {
                            documentBuilder.setSchemaValidator(this.processor.getSchemaManager().newSchemaValidator());
                        } else if (n4 == 2) {
                            SchemaValidator schemaValidator = this.processor.getSchemaManager().newSchemaValidator();
                            schemaValidator.setLax(true);
                            documentBuilder.setSchemaValidator(schemaValidator);
                        }
                    }
                    documentBuilder.setDTDValidation(this.getConfiguration().getBooleanProperty(Feature.DTD_VALIDATION));
                    documentBuilder.setWhitespaceStrippingPolicy(xsltExecutable.getWhitespaceStrippingPolicy());
                    if (this.getConfiguration().getBooleanProperty(Feature.DTD_VALIDATION_RECOVERABLE)) {
                        source = new AugmentedSource(source, this.getConfiguration().getParseOptions());
                    }
                    XdmNode xdmNode = documentBuilder.build(source);
                    ((Xslt30Transformer)object3).setGlobalContextItem(xdmNode, true);
                    source = xdmNode.asSource();
                }
            }
            commandLineOptions.applyFileParams(this.processor, (Xslt30Transformer)object3);
            if (string != null) {
                object2 = string.isEmpty() ? new QName("xsl", "http://www.w3.org/1999/XSL/Transform", "initial-template") : QName.fromClarkName(string);
                if (bl2) {
                    ((Xslt30Transformer)object3).callTemplate((QName)object2, serializer);
                } else {
                    object = ((Xslt30Transformer)object3).callTemplate((QName)object2);
                    serializer.serializeXdmValue((XdmValue)object);
                }
            } else if (bl2) {
                ((Xslt30Transformer)object3).applyTemplates(source, (Destination)serializer);
            } else {
                object2 = ((Xslt30Transformer)object3).applyTemplates(source);
                serializer.serializeXdmValue((XdmValue)object2);
            }
            long l4 = Transform.now();
            l2 += l4 - l3;
            if (this.showTime) {
                System.err.println("Execution time: " + CommandLineOptions.showExecutionTimeNano(l4 - l3));
                System.err.println("Memory used: " + CommandLineOptions.showMemoryUsed());
                if (this.repeat > 1) {
                    System.err.println("-------------------------------");
                    Runtime.getRuntime().gc();
                }
            }
            if (this.repeat == 999999 && l2 > 60000L) break;
        }
        if (this.repeat > 1) {
            System.err.println("*** Average execution time over last " + n2 + " runs: " + CommandLineOptions.showExecutionTimeNano(l2 / (long)n2));
        }
    }

    protected void badUsage(String string) {
        if (!"".equals(string)) {
            System.err.println(string);
        }
        if (!this.showTime) {
            System.err.println(this.getConfiguration().getProductTitle());
        }
        System.err.println("Usage: see http://www.saxonica.com/documentation/index.html#!using-xsl/commandline");
        System.err.println("Format: " + CommandLineOptions.getCommandName(this) + " options params");
        CommandLineOptions commandLineOptions = new CommandLineOptions();
        this.setPermittedOptions(commandLineOptions);
        System.err.println("Options available:" + commandLineOptions.displayPermittedOptions());
        System.err.println("Use -XYZ:? for details of option XYZ");
        System.err.println("Params: ");
        System.err.println("  param=value           Set stylesheet string parameter");
        System.err.println("  +param=filename       Set stylesheet document parameter");
        System.err.println("  ?param=expression     Set stylesheet parameter using XPath");
        System.err.println("  !param=value          Set serialization parameter");
        if (this.allowExit) {
            if ("".equals(string)) {
                System.exit(0);
                return;
            }
            System.exit(2);
            return;
        }
        throw new RuntimeException(string);
    }

    final class a
    extends Thread {
        private File a;
        private XsltExecutable b;
        private CommandLineOptions c;
        private Logger d;
        private List<Source> e;
        private int f;
        private /* synthetic */ Transform g;

        a(Transform transform, int n2, XsltExecutable xsltExecutable, List<Source> list, File file, CommandLineOptions commandLineOptions, Logger logger) {
            this.g = transform;
            this.f = n2;
            this.b = xsltExecutable;
            this.e = list;
            this.c = commandLineOptions;
            this.a = file;
            this.d = logger;
        }

        @Override
        public final void run() {
            try {
                this.g.a(this.e, this.b, this.a, this.c, this.d);
                return;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
                return;
            }
        }
    }
}

