/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.util.SteppingNavigator;
import net.sf.saxon.tree.util.SteppingNode;
import net.sf.saxon.tree.wrapper.AbstractNodeWrapper;
import net.sf.saxon.tree.wrapper.SiblingCountingNode;
import net.sf.saxon.type.UType;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMNodeWrapper
extends AbstractNodeWrapper
implements SteppingNode<DOMNodeWrapper>,
SiblingCountingNode {
    protected Node node;
    protected short nodeKind;
    private DOMNodeWrapper a;
    protected DocumentWrapper docWrapper;
    protected int index;
    protected int span = 1;
    private NamespaceBinding[] b = null;

    protected DOMNodeWrapper(Node node, DocumentWrapper documentWrapper, DOMNodeWrapper dOMNodeWrapper, int n2) {
        this.node = node;
        this.a = dOMNodeWrapper;
        this.index = n2;
        this.docWrapper = documentWrapper;
    }

    protected static DOMNodeWrapper makeWrapper(Node node, DocumentWrapper documentWrapper) {
        if (node == null) {
            throw new NullPointerException("NodeWrapper#makeWrapper: Node must not be null");
        }
        if (documentWrapper == null) {
            throw new NullPointerException("NodeWrapper#makeWrapper: DocumentWrapper must not be null");
        }
        return DOMNodeWrapper.makeWrapper(node, documentWrapper, null, -1);
    }

    protected static DOMNodeWrapper makeWrapper(Node node, DocumentWrapper documentWrapper, DOMNodeWrapper dOMNodeWrapper, int n2) {
        DOMNodeWrapper dOMNodeWrapper2;
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                dOMNodeWrapper2 = (DOMNodeWrapper)documentWrapper.getRootNode();
                if (dOMNodeWrapper2 != null) break;
                dOMNodeWrapper2 = new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2).nodeKind = (short)9;
                break;
            }
            case 1: {
                dOMNodeWrapper2 = new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2).nodeKind = 1;
                break;
            }
            case 2: {
                dOMNodeWrapper2 = new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2).nodeKind = (short)2;
                break;
            }
            case 3: {
                dOMNodeWrapper2 = new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2).nodeKind = (short)3;
                break;
            }
            case 4: {
                dOMNodeWrapper2 = new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2).nodeKind = (short)3;
                break;
            }
            case 8: {
                dOMNodeWrapper2 = new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2).nodeKind = (short)8;
                break;
            }
            case 7: {
                dOMNodeWrapper2 = new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2).nodeKind = (short)7;
                break;
            }
            case 5: {
                throw new IllegalStateException("DOM contains entity reference nodes, which Saxon does not support. The DOM should be built using the expandEntityReferences() option");
            }
            default: {
                throw new IllegalArgumentException("Unsupported node type in DOM! " + node.getNodeType() + " instance " + node);
            }
        }
        dOMNodeWrapper2.treeInfo = documentWrapper;
        return dOMNodeWrapper2;
    }

    @Override
    public DocumentWrapper getTreeInfo() {
        return (DocumentWrapper)this.treeInfo;
    }

    @Override
    public Node getUnderlyingNode() {
        return this.node;
    }

    @Override
    public int getNodeKind() {
        return this.nodeKind;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DOMNodeWrapper)) {
            return false;
        }
        if (this.docWrapper.domLevel3) {
            Node node = this.docWrapper.docNode;
            synchronized (node) {
                return this.node.isSameNode(((DOMNodeWrapper)object).node);
            }
        }
        DOMNodeWrapper dOMNodeWrapper = (DOMNodeWrapper)object;
        if (this.getNodeKind() == dOMNodeWrapper.getNodeKind()) {
            String string = dOMNodeWrapper.getLocalPart();
            object = this.getLocalPart();
            boolean bl2 = object == null ? string == null : ((String)object).equals(string);
            if (bl2 && this.getSiblingPosition() == dOMNodeWrapper.getSiblingPosition() && ((AbstractNodeWrapper)this.getParent()).equals(dOMNodeWrapper.getParent())) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int compareOrder(NodeInfo nodeInfo) {
        if (nodeInfo instanceof DOMNodeWrapper && this.docWrapper.domLevel3) {
            block8: {
                if (((AbstractNodeWrapper)this).equals(nodeInfo)) {
                    return 0;
                }
                try {
                    Node node = this.docWrapper.docNode;
                    // MONITORENTER : node
                    short s2 = this.node.compareDocumentPosition(((DOMNodeWrapper)nodeInfo).node);
                    if ((s2 & 0xA) != 0) {
                        // MONITOREXIT : node
                        return 1;
                    }
                    if ((s2 & 0x14) == 0) break block8;
                }
                catch (DOMException dOMException) {}
                return -1;
            }
            // MONITOREXIT : node
        }
        if (!(nodeInfo instanceof SiblingCountingNode)) return -nodeInfo.compareOrder(this);
        return Navigator.compareOrder(this, (SiblingCountingNode)nodeInfo);
    }

    @Override
    public CharSequence getStringValueCS() {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            switch (this.nodeKind) {
                case 1: 
                case 9: {
                    NodeList nodeList = this.node.getChildNodes();
                    FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
                    DOMNodeWrapper.expandStringValue(nodeList, fastStringBuffer);
                    return fastStringBuffer;
                }
                case 2: {
                    return DOMNodeWrapper.a(((Attr)this.node).getValue());
                }
                case 3: {
                    if (this.span == 1) {
                        return DOMNodeWrapper.a(this.node.getNodeValue());
                    }
                    FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
                    Node node2 = this.node;
                    for (int i2 = 0; i2 < this.span; ++i2) {
                        fastStringBuffer.append(DOMNodeWrapper.a(node2.getNodeValue()));
                        node2 = node2.getNextSibling();
                    }
                    return fastStringBuffer.condense();
                }
                case 7: 
                case 8: {
                    return DOMNodeWrapper.a(this.node.getNodeValue());
                }
            }
            return "";
        }
    }

    private static String a(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static void expandStringValue(NodeList nodeList, FastStringBuffer fastStringBuffer) {
        int n2 = nodeList.getLength();
        block5: for (int i2 = 0; i2 < n2; ++i2) {
            Node node = nodeList.item(i2);
            switch (node.getNodeType()) {
                case 1: {
                    DOMNodeWrapper.expandStringValue(node.getChildNodes(), fastStringBuffer);
                    continue block5;
                }
                case 7: 
                case 8: {
                    continue block5;
                }
                case 10: {
                    continue block5;
                }
                default: {
                    fastStringBuffer.append(DOMNodeWrapper.a(node.getNodeValue()));
                }
            }
        }
    }

    @Override
    public String getLocalPart() {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            switch (this.getNodeKind()) {
                case 1: 
                case 2: {
                    return DOMNodeWrapper.getLocalName(this.node);
                }
                case 7: {
                    return this.node.getNodeName();
                }
            }
            return "";
        }
    }

    public static String getLocalName(Node object) {
        String string = object.getLocalName();
        if (string == null) {
            int n2 = ((String)(object = object.getNodeName())).indexOf(58);
            if (n2 >= 0) {
                return ((String)object).substring(n2 + 1);
            }
            return object;
        }
        return string;
    }

    @Override
    public String getURI() {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            if (this.nodeKind == 1) {
                return DOMNodeWrapper.a((Element)this.node);
            }
            if (this.nodeKind == 2) {
                String string;
                block13: {
                    Node node2 = (Attr)this.node;
                    String string2 = node2.getNamespaceURI();
                    if (string2 != null) {
                        string = string2;
                    } else {
                        string2 = node2.getNodeName();
                        int n2 = string2.indexOf(58);
                        if (n2 < 0) {
                            string = "";
                        } else {
                            String string3 = "xmlns:" + string2.substring(0, n2);
                            if (string3.equals("xmlns:xml")) {
                                string = "http://www.w3.org/XML/1998/namespace";
                            } else {
                                node2 = node2.getOwnerElement();
                                do {
                                    if (!((Element)node2).hasAttribute(string3)) continue;
                                    string = ((Element)node2).getAttribute(string3);
                                    break block13;
                                } while ((node2 = node2.getParentNode()) != null && node2.getNodeType() == 1);
                                throw new IllegalStateException("Undeclared namespace prefix in attribute name " + string2 + " in DOM input");
                            }
                        }
                    }
                }
                return string;
            }
            return "";
        }
    }

    private static String a(Element node) {
        String string = node.getNamespaceURI();
        if (string != null) {
            return string;
        }
        string = node.getNodeName();
        int n2 = string.indexOf(58);
        String string2 = n2 < 0 ? "xmlns" : "xmlns:" + string.substring(0, n2);
        if (string2.equals("xmlns:xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        do {
            if (!node.hasAttribute(string2)) continue;
            return node.getAttribute(string2);
        } while ((node = node.getParentNode()) != null && node.getNodeType() == 1);
        if (n2 < 0) {
            return "";
        }
        throw new IllegalStateException("Undeclared namespace prefix in element name " + string + " in DOM input");
    }

    @Override
    public String getPrefix() {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            int n2 = this.getNodeKind();
            if (n2 == 1 || n2 == 2) {
                String string = this.node.getNodeName();
                int n3 = string.indexOf(58);
                if (n3 < 0) {
                    return "";
                }
                return string.substring(0, n3);
            }
            return "";
        }
    }

    @Override
    public String getDisplayName() {
        switch (this.nodeKind) {
            case 1: 
            case 2: 
            case 7: {
                Node node = this.docWrapper.docNode;
                synchronized (node) {
                    return this.node.getNodeName();
                }
            }
        }
        return "";
    }

    @Override
    public DOMNodeWrapper getParent() {
        if (this.a == null) {
            Node node = this.docWrapper.docNode;
            synchronized (node) {
                switch (this.getNodeKind()) {
                    case 2: {
                        this.a = DOMNodeWrapper.makeWrapper(((Attr)this.node).getOwnerElement(), this.docWrapper);
                        break;
                    }
                    default: {
                        Node node2 = this.node.getParentNode();
                        if (node2 == null) {
                            return null;
                        }
                        this.a = DOMNodeWrapper.makeWrapper(node2, this.docWrapper);
                    }
                }
            }
        }
        return this.a;
    }

    @Override
    public int getSiblingPosition() {
        if (this.index == -1) {
            Node node = this.docWrapper.docNode;
            synchronized (node) {
                switch (this.nodeKind) {
                    case 1: 
                    case 3: 
                    case 7: 
                    case 8: {
                        int n2 = 0;
                        Node node2 = this.node;
                        while (true) {
                            if ((node2 = node2.getPreviousSibling()) == null) {
                                this.index = n2;
                                return n2;
                            }
                            ++n2;
                        }
                    }
                    case 2: {
                        int n3 = 0;
                        AxisIterator axisIterator = this.a.iterateAxis((byte)2);
                        while (true) {
                            NodeInfo nodeInfo;
                            if ((nodeInfo = axisIterator.next()) == null || Navigator.haveSameName(this, nodeInfo)) {
                                this.index = n3;
                                return n3;
                            }
                            ++n3;
                        }
                    }
                    case 13: {
                        int n4 = 0;
                        AxisIterator axisIterator = this.a.iterateAxis((byte)8);
                        while (true) {
                            NodeInfo nodeInfo;
                            if ((nodeInfo = axisIterator.next()) == null || Navigator.haveSameName(this, nodeInfo)) {
                                this.index = n4;
                                return n4;
                            }
                            ++n4;
                        }
                    }
                }
                this.index = 0;
                return this.index;
            }
        }
        return this.index;
    }

    @Override
    protected AxisIterator iterateAttributes(NodeTest nodeTest) {
        DOMNodeWrapper dOMNodeWrapper = this;
        AxisIterator axisIterator = new a(dOMNodeWrapper, dOMNodeWrapper);
        if (nodeTest != AnyNodeTest.getInstance()) {
            axisIterator = new Navigator.AxisFilter(axisIterator, nodeTest);
        }
        return axisIterator;
    }

    @Override
    protected AxisIterator iterateChildren(NodeTest nodeTest) {
        boolean bl2 = nodeTest.getUType() == UType.ELEMENT;
        DOMNodeWrapper dOMNodeWrapper = this;
        AxisIterator axisIterator = new Navigator.EmptyTextFilter(new b(dOMNodeWrapper, dOMNodeWrapper, true, true, bl2));
        if (nodeTest != AnyNodeTest.getInstance()) {
            axisIterator = new Navigator.AxisFilter(axisIterator, nodeTest);
        }
        return axisIterator;
    }

    @Override
    protected AxisIterator iterateSiblings(NodeTest nodeTest, boolean bl2) {
        boolean bl3 = nodeTest.getUType() == UType.ELEMENT;
        DOMNodeWrapper dOMNodeWrapper = this;
        AxisIterator axisIterator = new Navigator.EmptyTextFilter(new b(dOMNodeWrapper, dOMNodeWrapper, false, bl2, bl3));
        if (nodeTest != AnyNodeTest.getInstance()) {
            axisIterator = new Navigator.AxisFilter(axisIterator, nodeTest);
        }
        return axisIterator;
    }

    @Override
    protected AxisIterator iterateDescendants(NodeTest nodeTest, boolean bl2) {
        return new SteppingNavigator.DescendantAxisIterator<DOMNodeWrapper>(this, bl2, nodeTest);
    }

    @Override
    public String getAttributeValue(String object, String string) {
        object = new NameTest(2, (String)object, string, this.getNamePool());
        object = this.iterateAxis((byte)2, (NodeTest)object);
        if ((object = object.next()) == null) {
            return null;
        }
        return object.getStringValue();
    }

    @Override
    public NodeInfo getRoot() {
        return this.docWrapper.getRootNode();
    }

    @Override
    public boolean hasChildNodes() {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            return this.node.getNodeType() != 2 && this.node.hasChildNodes();
        }
    }

    @Override
    public void generateId(FastStringBuffer fastStringBuffer) {
        Navigator.appendSequentialKey(this, fastStringBuffer, true);
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] object) {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            if (this.node.getNodeType() == 1) {
                if (this.b != null) {
                    return this.b;
                }
                Object object2 = (Element)this.node;
                if ((object2 = object2.getAttributes()) == null) {
                    this.b = NamespaceBinding.EMPTY_ARRAY;
                    return NamespaceBinding.EMPTY_ARRAY;
                }
                int n2 = 0;
                int n3 = object2.getLength();
                for (int i2 = 0; i2 < n3; ++i2) {
                    Attr attr = (Attr)object2.item(i2);
                    String string = attr.getName();
                    if (string.equals("xmlns")) {
                        ++n2;
                        continue;
                    }
                    if (!string.startsWith("xmlns:")) continue;
                    ++n2;
                }
                if (n2 == 0) {
                    this.b = NamespaceBinding.EMPTY_ARRAY;
                    return NamespaceBinding.EMPTY_ARRAY;
                }
                NamespaceBinding[] namespaceBindingArray = object == null || n2 > ((NamespaceBinding[])object).length ? new NamespaceBinding[n2] : object;
                int n4 = 0;
                for (int i3 = 0; i3 < n3; ++i3) {
                    object = (Attr)object2.item(i3);
                    String string = object.getName();
                    if (string.equals("xmlns")) {
                        string = "";
                        object = object.getValue();
                        namespaceBindingArray[n4++] = new NamespaceBinding(string, (String)object);
                        continue;
                    }
                    if (!string.startsWith("xmlns:")) continue;
                    string = string.substring(6);
                    object = object.getValue();
                    namespaceBindingArray[n4++] = new NamespaceBinding(string, (String)object);
                }
                if (n2 < namespaceBindingArray.length) {
                    namespaceBindingArray[n2] = null;
                }
                this.b = Arrays.copyOf(namespaceBindingArray, namespaceBindingArray.length);
                return namespaceBindingArray;
            }
            return null;
        }
    }

    @Override
    public boolean isId() {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            return this.node instanceof Attr && ((Attr)this.node).isId();
        }
    }

    @Override
    public DOMNodeWrapper getNextSibling() {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            int n2;
            Node node2 = this.node;
            for (n2 = 0; n2 < this.span; ++n2) {
                node2 = node2.getNextSibling();
            }
            if (node2 != null) {
                short s2 = node2.getNodeType();
                n2 = s2;
                if (s2 == 10) {
                    node2 = node2.getNextSibling();
                } else if (n2 == 3 || n2 == 4) {
                    return this.a(node2);
                }
                return DOMNodeWrapper.makeWrapper(node2, this.docWrapper);
            }
            return null;
        }
    }

    private DOMNodeWrapper a(Node object) {
        Node node = object;
        int n2 = 1;
        while ((node = node.getNextSibling()) != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
            ++n2;
        }
        object = DOMNodeWrapper.makeWrapper((Node)object, this.docWrapper);
        v0.span = n2;
        return object;
    }

    @Override
    public DOMNodeWrapper getFirstChild() {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            Node node2 = this.node.getFirstChild();
            if (node2 != null) {
                if (node2.getNodeType() == 10) {
                    node2 = node2.getNextSibling();
                }
                if (node2.getNodeType() == 3 || node2.getNodeType() == 4) {
                    return this.a(node2);
                }
                return DOMNodeWrapper.makeWrapper(node2, this.docWrapper);
            }
            return null;
        }
    }

    @Override
    public DOMNodeWrapper getPreviousSibling() {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            Node node2 = this.node.getPreviousSibling();
            if (node2 != null) {
                int n2 = node2.getNodeType();
                if (n2 == 10) {
                    return null;
                }
                if (n2 == 3 || n2 == 4) {
                    Object object;
                    n2 = 1;
                    while ((object = node2.getPreviousSibling()) != null && (object.getNodeType() == 3 || object.getNodeType() == 4)) {
                        ++n2;
                        node2 = object;
                    }
                    object = DOMNodeWrapper.makeWrapper(node2, this.docWrapper);
                    DOMNodeWrapper.makeWrapper(node2, this.docWrapper).span = n2;
                    return object;
                }
                return DOMNodeWrapper.makeWrapper(node2, this.docWrapper);
            }
            return null;
        }
    }

    @Override
    public DOMNodeWrapper getSuccessorElement(DOMNodeWrapper object, String string, String string2) {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            Node node2;
            object = object == null ? null : ((DOMNodeWrapper)object).node;
            Node node3 = this.node;
            do {
                block10: {
                    Object object2 = object;
                    if (node3.hasChildNodes()) {
                        node2 = node3.getFirstChild();
                    } else if (object2 != null && node3.isSameNode((Node)object2)) {
                        node2 = null;
                    } else {
                        do {
                            Node node4;
                            if ((node4 = node3.getNextSibling()) == null) continue;
                            node2 = node4;
                            break block10;
                        } while ((node3 = node3.getParentNode()) != null && (object2 == null || !node3.isSameNode((Node)object2)));
                        node2 = null;
                    }
                }
                node3 = node2;
            } while (node2 != null && (node3.getNodeType() != 1 || string2 != null && !string2.equals(DOMNodeWrapper.getLocalName(node3)) || string != null && !string.equals(DOMNodeWrapper.a((Element)node3))));
            if (node3 == null) {
                return null;
            }
            return DOMNodeWrapper.makeWrapper(node3, this.docWrapper);
        }
    }

    private final class b
    implements AxisIterator,
    LookaheadIterator<NodeInfo> {
        private DOMNodeWrapper a;
        private DOMNodeWrapper b;
        private boolean c;
        private boolean d;
        private boolean e;
        private NodeList f;
        private int g;
        private int h;
        private int i;
        private /* synthetic */ DOMNodeWrapper j;

        public b(DOMNodeWrapper object, DOMNodeWrapper dOMNodeWrapper, boolean bl2, boolean bl3, boolean bl4) {
            this.j = object;
            object = dOMNodeWrapper.docWrapper.docNode;
            synchronized (object) {
                this.a = dOMNodeWrapper;
                this.c = bl2;
                this.d = bl3;
                this.e = bl4;
                this.i = 1;
                this.b = bl2 ? dOMNodeWrapper : dOMNodeWrapper.getParent();
                this.f = this.b.node.getChildNodes();
                this.g = this.f.getLength();
                if (bl2) {
                    this.i = 1;
                    this.h = bl3 ? -1 : this.g;
                } else {
                    this.h = dOMNodeWrapper.getSiblingPosition();
                    this.i = dOMNodeWrapper.span;
                }
                return;
            }
        }

        @Override
        public final boolean hasNext() {
            if (this.d) {
                return this.h + this.i < this.g;
            }
            return this.h > 0;
        }

        @Override
        public final NodeInfo next() {
            Node node = this.a.docWrapper.docNode;
            synchronized (node) {
                Object object;
                block11: while (true) {
                    int n2;
                    int n3;
                    if (this.d) {
                        Node node2;
                        short s2;
                        this.h += this.i;
                        if (this.h >= this.g) {
                            return null;
                        }
                        object = this;
                        n3 = 0;
                        int n4 = ((b)object).h;
                        n2 = ((b)object).g;
                        while (n4 < n2 && ((s2 = (node2 = ((b)object).f.item(n4)).getNodeType()) == 3 || s2 == 4)) {
                            ++n4;
                            ++n3;
                        }
                        this.i = n3 == 0 ? 1 : n3;
                        object = this.f.item(this.h);
                        switch (object.getNodeType()) {
                            case 10: {
                                continue block11;
                            }
                            case 1: {
                                break;
                            }
                            default: {
                                if (this.e) continue block11;
                            }
                        }
                        object = DOMNodeWrapper.makeWrapper((Node)object, this.j.docWrapper, this.b, this.h);
                        v0.span = this.i;
                        return object;
                    }
                    --this.h;
                    if (this.h < 0) {
                        return null;
                    }
                    object = this;
                    for (n3 = 0; ((b)object).h >= n3; ++n3) {
                        Node node3 = ((b)object).f.item(((b)object).h - n3);
                        short s3 = node3.getNodeType();
                        n2 = s3;
                        if (s3 != 3 && n2 != 4) break;
                    }
                    this.i = n3 == 0 ? 1 : n3;
                    this.h -= this.i - 1;
                    object = this.f.item(this.h);
                    switch (object.getNodeType()) {
                        case 10: {
                            continue block11;
                        }
                        case 1: {
                            break block11;
                        }
                        default: {
                            if (!this.e) break block11;
                            continue block11;
                        }
                    }
                    break;
                }
                object = DOMNodeWrapper.makeWrapper((Node)object, this.j.docWrapper, this.b, this.h);
                v2.span = this.i;
                return object;
            }
        }

        @Override
        public final int getProperties() {
            return 4;
        }
    }

    private final class a
    implements AxisIterator,
    LookaheadIterator<NodeInfo> {
        private ArrayList<Node> a = new ArrayList(10);
        private int b = 0;
        private DOMNodeWrapper c;
        private DOMNodeWrapper d;
        private /* synthetic */ DOMNodeWrapper e;

        public a(DOMNodeWrapper object, DOMNodeWrapper object2) {
            this.e = object;
            object = ((DOMNodeWrapper)object2).docWrapper.docNode;
            synchronized (object) {
                this.c = object2;
                object2 = ((DOMNodeWrapper)object2).node.getAttributes();
                if (object2 != null) {
                    int n2 = object2.getLength();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        String string = object2.item(i2).getNodeName();
                        if (string.startsWith("xmlns") && (string.length() == 5 || string.charAt(5) == ':')) continue;
                        this.a.add(object2.item(i2));
                    }
                }
                this.b = 0;
                return;
            }
        }

        @Override
        public final boolean hasNext() {
            return this.b < this.a.size();
        }

        @Override
        public final NodeInfo next() {
            if (this.b >= this.a.size()) {
                return null;
            }
            this.d = DOMNodeWrapper.makeWrapper(this.a.get(this.b), this.e.docWrapper, this.c, this.b);
            ++this.b;
            return this.d;
        }

        @Override
        public final int getProperties() {
            return 4;
        }
    }
}

