/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMNodeList;
import net.sf.saxon.dom.DOMSender;
import net.sf.saxon.dom.DOMWriter;
import net.sf.saxon.dom.DocumentOverNodeInfo;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceExtent;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMObjectModel
extends TreeModel
implements ExternalObjectModel {
    private static DOMObjectModel a = new DOMObjectModel();
    private static DocumentBuilderFactory b = null;

    public static DOMObjectModel getInstance() {
        return a;
    }

    @Override
    public String getDocumentClassName() {
        return "org.w3c.dom.Document";
    }

    @Override
    public String getIdentifyingURI() {
        return "http://java.sun.com/jaxp/xpath/dom";
    }

    @Override
    public String getName() {
        return "DOM";
    }

    @Override
    public PJConverter getPJConverter(Class<?> clazz) {
        if (Node.class.isAssignableFrom(clazz) && !NodeOverNodeInfo.class.isAssignableFrom(clazz)) {
            return new PJConverter(this){
                private /* synthetic */ DOMObjectModel a;
                {
                    this.a = dOMObjectModel;
                }

                @Override
                public final Object convert(Sequence<?> sequence, Class<?> clazz, XPathContext xPathContext) {
                    return DOMObjectModel.convertXPathValueToObject(sequence, clazz);
                }
            };
        }
        if (NodeList.class == clazz) {
            return new PJConverter(this){
                private /* synthetic */ DOMObjectModel a;
                {
                    this.a = dOMObjectModel;
                }

                @Override
                public final Object convert(Sequence<?> sequence, Class<?> clazz, XPathContext xPathContext) {
                    return DOMObjectModel.convertXPathValueToObject(sequence, clazz);
                }
            };
        }
        return null;
    }

    @Override
    public JPConverter getJPConverter(Class clazz, Configuration configuration) {
        if (Node.class.isAssignableFrom(clazz) && !NodeOverNodeInfo.class.isAssignableFrom(clazz)) {
            return new JPConverter(this){
                private /* synthetic */ DOMObjectModel a;
                {
                    this.a = dOMObjectModel;
                }

                @Override
                public final Sequence<?> convert(Object object, XPathContext xPathContext) {
                    return DOMObjectModel.a(this.a, (Node)object, xPathContext.getConfiguration());
                }

                @Override
                public final ItemType getItemType() {
                    return AnyNodeTest.getInstance();
                }
            };
        }
        if (NodeList.class.isAssignableFrom(clazz)) {
            return new JPConverter(this){
                private /* synthetic */ DOMObjectModel a;
                {
                    this.a = dOMObjectModel;
                }

                @Override
                public final Sequence<?> convert(Object object, XPathContext object2) {
                    object2 = object2.getConfiguration();
                    object = (NodeList)object;
                    int n2 = object.getLength();
                    Item[] itemArray = new NodeInfo[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        itemArray[i2] = DOMObjectModel.a(this.a, object.item(i2), (Configuration)object2);
                    }
                    return new SequenceExtent(itemArray);
                }

                @Override
                public final ItemType getItemType() {
                    return AnyNodeTest.getInstance();
                }

                @Override
                public final int getCardinality() {
                    return 57344;
                }
            };
        }
        if (DOMSource.class.isAssignableFrom(clazz)) {
            return new JPConverter(this){
                private /* synthetic */ DOMObjectModel a;
                {
                    this.a = dOMObjectModel;
                }

                @Override
                public final Sequence<?> convert(Object object, XPathContext xPathContext) {
                    return this.a.unravel((DOMSource)object, xPathContext.getConfiguration());
                }

                @Override
                public final ItemType getItemType() {
                    return AnyNodeTest.getInstance();
                }
            };
        }
        if (DocumentWrapper.class == clazz) {
            return new JPConverter(this){
                private /* synthetic */ DOMObjectModel a;
                {
                    this.a = dOMObjectModel;
                }

                @Override
                public final Sequence<?> convert(Object object, XPathContext xPathContext) {
                    return ((DocumentWrapper)object).getRootNode();
                }

                @Override
                public final ItemType getItemType() {
                    return AnyNodeTest.getInstance();
                }
            };
        }
        return null;
    }

    @Override
    public PJConverter getNodeListCreator(Object object) {
        if (object == null || object instanceof Node || object instanceof DOMSource || object instanceof DocumentWrapper || object instanceof VirtualNode && ((VirtualNode)object).getRealNode() instanceof Node) {
            return new PJConverter(this){
                private /* synthetic */ DOMObjectModel a;
                {
                    this.a = dOMObjectModel;
                }

                @Override
                public final Object convert(Sequence<?> sequence, Class<?> clazz, XPathContext xPathContext) {
                    return DOMObjectModel.convertXPathValueToObject(sequence, NodeList.class);
                }
            };
        }
        return null;
    }

    @Override
    public Receiver getDocumentBuilder(Result result) {
        if (result instanceof DOMResult) {
            DOMWriter dOMWriter = new DOMWriter();
            Object object = ((DOMResult)result).getNode();
            if (object instanceof NodeOverNodeInfo && !(((NodeOverNodeInfo)object).getUnderlyingNodeInfo() instanceof MutableNodeInfo)) {
                throw new XPathException("Supplied DOMResult is a non-mutable Saxon implementation");
            }
            Node node = ((DOMResult)result).getNextSibling();
            if (object == null) {
                try {
                    if (b == null) {
                        b = DocumentBuilderFactory.newInstance();
                    }
                    object = b.newDocumentBuilder();
                    object = ((DocumentBuilder)object).newDocument();
                    ((DOMResult)result).setNode((Node)object);
                    dOMWriter.setNode((Node)object);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new XPathException(parserConfigurationException);
                }
            } else {
                dOMWriter.setNode((Node)object);
                dOMWriter.setNextSibling(node);
            }
            return dOMWriter;
        }
        return null;
    }

    @Override
    public Builder makeBuilder(PipelineConfiguration pipelineConfiguration) {
        DOMWriter dOMWriter = new DOMWriter();
        ((Builder)dOMWriter).setPipelineConfiguration(pipelineConfiguration);
        return dOMWriter;
    }

    @Override
    public boolean sendSource(Source source, Receiver receiver) {
        if (source instanceof DOMSource) {
            DOMObjectModel.sendDOMSource((DOMSource)source, receiver);
            return true;
        }
        return false;
    }

    public static void sendDOMSource(DOMSource dOMSource, Receiver receiver) {
        Object object = dOMSource.getNode();
        if (object == null) {
            receiver.open();
            receiver.startDocument(0);
            receiver.endDocument();
            receiver.close();
            return;
        }
        object = new DOMSender((Node)object, receiver);
        ((DOMSender)object).setSystemId(dOMSource.getSystemId());
        receiver.open();
        ((DOMSender)object).send();
        receiver.close();
    }

    public NodeInfo wrap(Node node, Configuration object) {
        Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        object = new DocumentWrapper(document, node.getBaseURI(), (Configuration)object);
        return ((DocumentWrapper)object).wrap(node);
    }

    public NodeInfo copy(Node object, TreeModel object2, Configuration object3) {
        object3 = ((Configuration)object3).makePipelineConfiguration();
        object2 = ((TreeModel)object2).makeBuilder((PipelineConfiguration)object3);
        ((Builder)object2).open();
        Sender.send(new DOMSource((Node)object), (Receiver)object2, null);
        object = ((Builder)object2).getCurrentRoot();
        ((Builder)object2).close();
        return object;
    }

    @Override
    public NodeInfo unravel(Source source, Configuration configuration) {
        Node node;
        if (source instanceof DOMSource && !((node = ((DOMSource)source).getNode()) instanceof NodeOverNodeInfo)) {
            Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
            source = new DocumentWrapper(document, source.getSystemId(), configuration);
            return ((DocumentWrapper)source).wrap(node);
        }
        return null;
    }

    public static Object convertXPathValueToObject(Sequence<?> object, Class<?> clazz) {
        Object t2;
        boolean bl2;
        boolean bl3 = Node.class.isAssignableFrom(clazz) || clazz == NodeList.class || clazz.isArray() && Node.class.isAssignableFrom(clazz.getComponentType());
        boolean bl4 = bl2 = clazz == Object.class || clazz.isAssignableFrom(ArrayList.class) || clazz.isAssignableFrom(HashSet.class) || clazz.isArray() && clazz.getComponentType() == Object.class;
        if (!bl3 && !bl2) {
            return null;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(20);
        object = object.iterate();
        while ((t2 = object.next()) != null) {
            Object object2;
            if (t2 instanceof VirtualNode && (object2 = ((VirtualNode)t2).getRealNode()) instanceof Node) {
                arrayList.add((Node)object2);
                continue;
            }
            if (bl3) {
                if (t2 instanceof NodeInfo) {
                    arrayList.add(NodeOverNodeInfo.wrap((NodeInfo)t2));
                    continue;
                }
                throw new XPathException("Cannot convert XPath value to Java object: required class is " + clazz.getName() + "; supplied value has type " + Type.displayTypeName(t2));
            }
            return null;
        }
        if (arrayList.isEmpty() && !bl3) {
            return null;
        }
        if (Node.class.isAssignableFrom(clazz)) {
            if (arrayList.size() != 1) {
                throw new XPathException("Cannot convert XPath value to Java object: requires a single DOM Nodebut supplied value contains " + arrayList.size() + " nodes");
            }
            return arrayList.get(0);
        }
        if (clazz == NodeList.class) {
            return new DOMNodeList(arrayList);
        }
        if (clazz.isArray() && clazz.getComponentType() == Node.class) {
            return arrayList.toArray(new Node[0]);
        }
        if (clazz.isAssignableFrom(ArrayList.class)) {
            return arrayList;
        }
        if (clazz.isAssignableFrom(HashSet.class)) {
            return new HashSet<Node>(arrayList);
        }
        return null;
    }

    static /* synthetic */ NodeInfo a(DOMObjectModel object, Node node, Configuration object2) {
        TreeInfo treeInfo;
        if (node instanceof NodeOverNodeInfo) {
            return ((NodeOverNodeInfo)node).getUnderlyingNodeInfo();
        }
        Configuration configuration = object2;
        object2 = "";
        object = node;
        if (object instanceof DocumentOverNodeInfo) {
            treeInfo = (TreeInfo)((Object)((DocumentOverNodeInfo)object).getUnderlyingNodeInfo());
        } else if (object instanceof NodeOverNodeInfo) {
            treeInfo = ((NodeOverNodeInfo)object).getUnderlyingNodeInfo().getTreeInfo();
        } else if (object instanceof Node) {
            if (((Node)object).getNodeType() == 9) {
                object = (Document)object;
                treeInfo = new DocumentWrapper((Node)object, (String)object2, configuration);
            } else if (((Node)object).getNodeType() == 11) {
                object = (DocumentFragment)object;
                treeInfo = new DocumentWrapper((Node)object, (String)object2, configuration);
            } else {
                object = ((Node)object).getOwnerDocument();
                treeInfo = new DocumentWrapper((Node)object, (String)object2, configuration);
            }
        } else {
            throw new IllegalArgumentException("Unknown node class " + object.getClass());
        }
        object = treeInfo;
        object2 = node;
        object = treeInfo;
        return ((DocumentWrapper)treeInfo).wrap((Node)object2);
    }
}

