/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Untyped;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class DOMSender {
    private NamespaceReducer a;
    protected Node root;
    protected String systemId;
    private Stack<List<NamespaceBinding>> b = new Stack();
    private Node c;

    public DOMSender(Node node, Receiver receiver) {
        if (node == null) {
            throw new NullPointerException("startNode");
        }
        if (receiver == null) {
            throw new NullPointerException("receiver");
        }
        this.root = node;
        this.a = new NamespaceReducer(receiver);
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public void send() {
        this.a.setSystemId(this.systemId);
        Object object = ExplicitLocation.UNKNOWN_LOCATION;
        switch (this.root.getNodeType()) {
            case 9: 
            case 11: {
                NamedNodeMap namedNodeMap;
                Object object2;
                this.a.startDocument(0);
                object = this;
                if (((DOMSender)object).root instanceof Document && (object2 = ((Document)((DOMSender)object).root).getDoctype()) != null && (namedNodeMap = object2.getEntities()) != null) {
                    for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                        Entity entity = (Entity)namedNodeMap.item(i2);
                        if (entity.getNotationName() == null) continue;
                        String string = entity.getNodeName();
                        String string2 = entity.getSystemId();
                        try {
                            URI object4 = new URI(string2);
                            if (!object4.isAbsolute() && (object2 = ((DOMSender)object).root.getBaseURI()) != null) {
                                URI uRI = new URI((String)object2).resolve(object4);
                                string2 = uRI.toString();
                            }
                        }
                        catch (URISyntaxException uRISyntaxException) {}
                        String object3 = entity.getPublicId();
                        ((DOMSender)object).a.setUnparsedEntity(string, string2, object3);
                    }
                }
                DOMSender dOMSender = this;
                dOMSender.a(dOMSender.root);
                this.a.endDocument();
                return;
            }
            case 1: {
                DOMSender dOMSender = this;
                Element element = (Element)dOMSender.root;
                object = dOMSender;
                ArrayList<Element> arrayList = new ArrayList<Element>();
                ArrayList<NamespaceBinding> arrayList2 = new ArrayList<NamespaceBinding>();
                for (Node node = element; node != null && node.getNodeType() == 1; node = node.getParentNode()) {
                    arrayList.add((Element)node);
                }
                for (int i3 = arrayList.size() - 1; i3 >= 0; --i3) {
                    DOMSender.a((Element)arrayList.get(i3), arrayList2);
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (NamespaceBinding namespaceBinding : arrayList2) {
                    hashMap.put(namespaceBinding.getPrefix(), namespaceBinding.getURI());
                }
                if (hashMap.size() != arrayList2.size()) {
                    arrayList2 = new ArrayList();
                    for (Map.Entry entry : hashMap.entrySet()) {
                        arrayList2.add(new NamespaceBinding((String)entry.getKey(), (String)entry.getValue()));
                    }
                }
                ((DOMSender)object).b.push(arrayList2);
                super.a(element, true);
                ((DOMSender)object).b.pop();
                return;
            }
            case 3: 
            case 4: {
                this.a.characters(((CharacterData)this.root).getData(), (Location)object, 0);
                return;
            }
            case 8: {
                this.a.comment(((Comment)this.root).getData(), (Location)object, 0);
                return;
            }
            case 7: {
                this.a.processingInstruction(((ProcessingInstruction)this.root).getTarget(), ((ProcessingInstruction)this.root).getData(), (Location)object, 0);
                return;
            }
        }
        throw new IllegalStateException("DOMSender: unsupported kind of start node (" + this.root.getNodeType() + ")");
    }

    private NodeName a(String string, boolean bl2) {
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            String string2;
            if (bl2 && !(string2 = this.a("")).isEmpty()) {
                return new FingerprintedQName("", string2, string);
            }
            return new NoNamespaceName(string);
        }
        String string3 = string.substring(0, n2);
        String string4 = this.a(string3);
        if (string4 == null) {
            throw new IllegalStateException("Prefix " + string3 + " is not bound to any namespace");
        }
        return new FingerprintedQName(string3, string4, string.substring(n2 + 1));
    }

    private void a(Node object) {
        ExplicitLocation explicitLocation = ExplicitLocation.UNKNOWN_LOCATION;
        if (object.hasChildNodes()) {
            object = object.getChildNodes();
            int n2 = object.getLength();
            block9: for (int i2 = 0; i2 < n2; ++i2) {
                Object object2 = object.item(i2);
                this.c = object2;
                switch (object2.getNodeType()) {
                    case 9: 
                    case 11: {
                        continue block9;
                    }
                    case 1: {
                        object2 = (Element)object2;
                        ArrayList<NamespaceBinding> arrayList = new ArrayList<NamespaceBinding>();
                        this.b.push(arrayList);
                        DOMSender.a((Element)object2, arrayList);
                        this.a((Element)object2, !arrayList.isEmpty());
                        this.b.pop();
                        continue block9;
                    }
                    case 2: {
                        continue block9;
                    }
                    case 7: {
                        this.a.processingInstruction(((ProcessingInstruction)object2).getTarget(), ((ProcessingInstruction)object2).getData(), explicitLocation, 0);
                        continue block9;
                    }
                    case 8: {
                        object2 = ((Comment)object2).getData();
                        if (object2 == null) continue block9;
                        this.a.comment((CharSequence)object2, explicitLocation, 0);
                        continue block9;
                    }
                    case 3: 
                    case 4: {
                        object2 = ((CharacterData)object2).getData();
                        if (object2 == null) continue block9;
                        this.a.characters((CharSequence)object2, explicitLocation, 0);
                        continue block9;
                    }
                    case 5: {
                        this.a((Node)object2);
                    }
                }
            }
        }
    }

    public Node getCurrentNode() {
        return this.c;
    }

    private void a(Element element, boolean bl2) {
        Object object = this.a(element.getTagName(), true);
        ExplicitLocation explicitLocation = new ExplicitLocation(this.systemId, -1, -1);
        this.a.startElement((NodeName)object, Untyped.getInstance(), explicitLocation, 0);
        for (NamespaceBinding namespaceBinding : this.b.peek()) {
            this.a.namespace(namespaceBinding, 0);
        }
        object = element.getAttributes();
        if (object != null) {
            int n2 = object.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                Attr attr = (Attr)object.item(i2);
                int n3 = attr.isId() ? 2048 : 0;
                Object object2 = attr.getName();
                if (bl2 && (((String)object2).equals("xmlns") || ((String)object2).startsWith("xmlns:"))) continue;
                object2 = this.a((String)object2, false);
                this.a.attribute((NodeName)object2, BuiltInAtomicType.UNTYPED_ATOMIC, attr.getValue(), explicitLocation, n3);
            }
        }
        this.a.startContent();
        this.a(element);
        this.a.endElement();
    }

    private String a(String string) {
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        for (int i2 = this.b.size() - 1; i2 >= 0; --i2) {
            Object object = (List)this.b.get(i2);
            object = object.iterator();
            while (object.hasNext()) {
                NamespaceBinding namespaceBinding = (NamespaceBinding)object.next();
                if (!namespaceBinding.getPrefix().equals(string)) continue;
                return namespaceBinding.getURI();
            }
        }
        if (string.equals("")) {
            return "";
        }
        throw new IllegalStateException("No binding for namespace prefix " + string);
    }

    private static void a(Element element, List<NamespaceBinding> list) {
        Object object;
        try {
            object = element.getPrefix();
            String string = element.getNamespaceURI();
            if (object == null) {
                object = "";
            }
            if (string == null) {
                string = "";
            }
            if (!((String)object).isEmpty() || !string.isEmpty()) {
                list.add(new NamespaceBinding((String)object, string));
            }
        }
        catch (Throwable throwable) {}
        object = element.getAttributes();
        if (object == null) {
            return;
        }
        int n2 = object.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = (Attr)object.item(i2);
            String string = object2.getName();
            boolean bl2 = string.startsWith("xmlns");
            if (bl2 && string.length() == 5) {
                string = object2.getValue();
                list.add(new NamespaceBinding("", string));
                continue;
            }
            if (bl2 && string.startsWith("xmlns:")) {
                string = string.substring(6);
                object2 = object2.getValue();
                list.add(new NamespaceBinding(string, (String)object2));
                continue;
            }
            if (string.indexOf(58) < 0) continue;
            try {
                string = object2.getPrefix();
                object2 = object2.getNamespaceURI();
                list.add(new NamespaceBinding(string, (String)object2));
                continue;
            }
            catch (Throwable throwable) {}
        }
    }
}

