/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.saxon.dom.DocumentOverNodeInfo;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.Whitespace;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMWriter
extends Builder {
    private PipelineConfiguration a;
    private Node b;
    private Document c;
    private Node d;
    private int e = 0;
    private boolean f = true;
    private String g;

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        this.a = pipelineConfiguration;
        this.config = pipelineConfiguration.getConfiguration();
    }

    @Override
    public PipelineConfiguration getPipelineConfiguration() {
        return this.a;
    }

    @Override
    public void setSystemId(String string) {
        this.g = string;
    }

    @Override
    public void setUnparsedEntity(String string, String string2, String string3) {
    }

    @Override
    public String getSystemId() {
        return this.g;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void startDocument(int n2) {
        if (this.c == null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                this.c = documentBuilderFactory.newDocumentBuilder().newDocument();
                this.b = this.c;
                return;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new XPathException(parserConfigurationException);
            }
        }
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(NodeName object, SchemaType object2, Location location, int n2) {
        object2 = object.getDisplayName();
        object = object.getURI();
        try {
            object = this.c.createElementNS((String)("".equals(object) ? null : object), (String)object2);
            if (this.d != null && this.e == 0) {
                this.b.insertBefore((Node)object, this.d);
            } else {
                this.b.appendChild((Node)object);
            }
            this.b = object;
        }
        catch (DOMException dOMException) {
            throw new XPathException(dOMException);
        }
        ++this.e;
    }

    @Override
    public void namespace(NamespaceBindingSet object, int n2) {
        try {
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (NamespaceBinding)object.next();
                String string = ((NamespaceBinding)object2).getPrefix();
                object2 = ((NamespaceBinding)object2).getURI();
                Element element = (Element)this.b;
                if (((String)object2).equals("http://www.w3.org/XML/1998/namespace")) continue;
                if (string.isEmpty()) {
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", (String)object2);
                    continue;
                }
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, (String)object2);
            }
            return;
        }
        catch (DOMException dOMException) {
            throw new XPathException(dOMException);
        }
    }

    @Override
    public void attribute(NodeName object, SimpleType object2, CharSequence charSequence, Location object3, int n2) {
        object2 = object.getDisplayName();
        object3 = object.getURI();
        try {
            Element element = (Element)this.b;
            element.setAttributeNS((String)("".equals(object3) ? null : object3), (String)object2, charSequence.toString());
            if (object.equals(StandardNames.XML_ID_NAME) || (n2 & 0x800) != 0 || object.hasURI("http://www.w3.org/XML/1998/namespace") && object.getLocalPart().equals("id")) {
                object = object.getLocalPart();
                element.setIdAttributeNS((String)("".equals(object3) ? null : object3), (String)object, true);
            }
            return;
        }
        catch (DOMException dOMException) {
            throw new XPathException(dOMException);
        }
    }

    @Override
    public void startContent() {
    }

    @Override
    public void endElement() {
        if (this.f) {
            try {
                this.b.normalize();
            }
            catch (Throwable throwable) {
                this.f = false;
            }
        }
        this.b = this.b.getParentNode();
        --this.e;
    }

    @Override
    public void characters(CharSequence object, Location location, int n2) {
        if (this.e == 0 && this.d == null && Whitespace.isWhite((CharSequence)object)) {
            return;
        }
        try {
            object = this.c.createTextNode(object.toString());
            if (this.d == null || this.e != 0) {
                this.b.appendChild((Node)object);
                return;
            }
            this.b.insertBefore((Node)object, this.d);
        }
        catch (DOMException dOMException) {
            throw new XPathException(dOMException);
        }
    }

    @Override
    public void processingInstruction(String object, CharSequence charSequence, Location location, int n2) {
        try {
            object = this.c.createProcessingInstruction((String)object, charSequence.toString());
            if (this.d == null || this.e != 0) {
                this.b.appendChild((Node)object);
                return;
            }
            this.b.insertBefore((Node)object, this.d);
        }
        catch (DOMException dOMException) {
            throw new XPathException(dOMException);
        }
    }

    @Override
    public void comment(CharSequence object, Location location, int n2) {
        try {
            object = this.c.createComment(object.toString());
            if (this.d == null || this.e != 0) {
                this.b.appendChild((Node)object);
                return;
            }
            this.b.insertBefore((Node)object, this.d);
        }
        catch (DOMException dOMException) {
            throw new XPathException(dOMException);
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    public void setNode(Node node) {
        if (node == null) {
            return;
        }
        this.b = node;
        if (node.getNodeType() == 9) {
            this.c = (Document)node;
            return;
        }
        this.c = this.b.getOwnerDocument();
        if (this.c == null) {
            this.c = new DocumentOverNodeInfo();
        }
    }

    public void setNextSibling(Node node) {
        this.d = node;
    }

    @Override
    public NodeInfo getCurrentRoot() {
        return new DocumentWrapper(this.c, this.g, this.config).getRootNode();
    }

    protected Document getDOMDocumentNode() {
        return this.c;
    }
}

