/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMNodeWrapper;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import org.w3c.dom.Document;
import org.w3c.dom.Entity;
import org.w3c.dom.Node;

public class DocumentWrapper
extends GenericTreeInfo {
    protected boolean domLevel3;
    public final Node docNode;
    private Map<String, NodeInfo> a = null;

    public DocumentWrapper(Node node, String string, Configuration configuration) {
        super(configuration);
        if (node.getNodeType() != 9 && node.getNodeType() != 11) {
            throw new IllegalArgumentException("Node must be a DOM Document or DocumentFragment");
        }
        if (configuration.getExternalObjectModel(node.getClass()) == null) {
            throw new IllegalArgumentException("Node class " + node.getClass().getName() + " is not recognized in this Saxon configuration");
        }
        this.domLevel3 = true;
        this.docNode = node;
        DocumentWrapper documentWrapper = this;
        documentWrapper.setRootNode(documentWrapper.wrap(node));
        this.setSystemId(string);
    }

    public DOMNodeWrapper wrap(Node node) {
        return DOMNodeWrapper.makeWrapper(node, this);
    }

    public void setDOMLevel(int n2) {
        if (n2 != 2 && n2 != 3) {
            throw new IllegalArgumentException("DOM Level must be 2 or 3");
        }
        this.domLevel3 = n2 == 3;
    }

    public int getDOMLevel() {
        if (this.domLevel3) {
            return 3;
        }
        return 2;
    }

    @Override
    public NodeInfo selectID(String string, boolean bl2) {
        Node node = this.docNode;
        synchronized (node) {
            NodeInfo nodeInfo;
            Object object = ((DOMNodeWrapper)this.getRootNode()).node;
            if (object instanceof Document && (object = ((Document)object).getElementById(string)) != null) {
                return this.wrap((Node)object);
            }
            if (this.a != null) {
                return this.a.get(string);
            }
            this.a = new HashMap<String, NodeInfo>();
            object = this.getRootNode().iterateAxis((byte)4, NodeKindTest.ELEMENT);
            while ((nodeInfo = object.next()) != null) {
                String string2 = nodeInfo.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
                if (string2 == null) continue;
                this.a.put(string2, nodeInfo);
            }
            return this.a.get(string);
        }
    }

    @Override
    public Iterator<String> getUnparsedEntityNames() {
        Node node = this.docNode;
        synchronized (node) {
            Object object = ((DOMNodeWrapper)this.getRootNode()).node;
            if (object instanceof Document) {
                if ((object = ((Document)object).getDoctype()) == null) {
                    object = Collections.emptyList();
                    return object.iterator();
                }
                if ((object = object.getEntities()) == null) {
                    List list = Collections.emptyList();
                    return list.iterator();
                }
                ArrayList<String> arrayList = new ArrayList<String>(object.getLength());
                for (int i2 = 0; i2 < object.getLength(); ++i2) {
                    Entity entity = (Entity)object.item(i2);
                    if (entity.getNotationName() == null) continue;
                    arrayList.add(entity.getLocalName());
                }
                return arrayList.iterator();
            }
            return null;
        }
    }

    @Override
    public String[] getUnparsedEntity(String object) {
        Node node = this.docNode;
        synchronized (node) {
            Object object2 = ((DOMNodeWrapper)this.getRootNode()).node;
            if (object2 instanceof Document) {
                if ((object2 = ((Document)object2).getDoctype()) == null) {
                    return null;
                }
                if ((object2 = object2.getEntities()) == null) {
                    return null;
                }
                if ((object = (Entity)object2.getNamedItem((String)object)) == null || object.getNotationName() == null) {
                    return null;
                }
                object2 = object.getSystemId();
                try {
                    String string;
                    URI uRI = new URI((String)object2);
                    if (!uRI.isAbsolute() && (string = this.getRootNode().getBaseURI()) != null) {
                        uRI = new URI(string).resolve(uRI);
                        object2 = uRI.toString();
                    }
                }
                catch (URISyntaxException uRISyntaxException) {}
                return new String[]{object2, object.getPublicId()};
            }
            return null;
        }
    }
}

