/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.dom.AttrOverNodeInfo;
import net.sf.saxon.dom.DocumentOverNodeInfo;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.dom.TypeInfoImpl;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementOverNodeInfo
extends NodeOverNodeInfo
implements Element {
    @Override
    public String getTagName() {
        return this.node.getDisplayName();
    }

    @Override
    public NodeList getElementsByTagName(String string) {
        return DocumentOverNodeInfo.getElementsByTagName(this.node, string);
    }

    @Override
    public NodeList getElementsByTagNameNS(String string, String string2) {
        return DocumentOverNodeInfo.getElementsByTagNameNS(this.node, string, string2);
    }

    @Override
    public String getAttribute(String string) {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.node.iterateAxis((byte)2);
        do {
            if ((nodeInfo = axisIterator.next()) != null) continue;
            return "";
        } while (!nodeInfo.getDisplayName().equals(string));
        string = nodeInfo.getStringValue();
        if (string == null) {
            return "";
        }
        return string;
    }

    @Override
    public Attr getAttributeNode(String string) {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.node.iterateAxis((byte)2);
        do {
            if ((nodeInfo = axisIterator.next()) != null) continue;
            return null;
        } while (!nodeInfo.getDisplayName().equals(string));
        return (AttrOverNodeInfo)ElementOverNodeInfo.wrap(nodeInfo);
    }

    @Override
    public Attr setAttributeNode(Attr attr) {
        ElementOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public void removeAttribute(String string) {
        ElementOverNodeInfo.disallowUpdate();
    }

    @Override
    public Attr removeAttributeNode(Attr attr) {
        ElementOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public String getAttributeNS(String string, String string2) {
        string = string == null ? "" : string;
        if ((string = this.node.getAttributeValue(string, string2)) == null) {
            return "";
        }
        return string;
    }

    @Override
    public void setAttribute(String string, String string2) {
        ElementOverNodeInfo.disallowUpdate();
    }

    @Override
    public void setAttributeNS(String string, String string2, String string3) {
        ElementOverNodeInfo.disallowUpdate();
    }

    @Override
    public void removeAttributeNS(String string, String string2) {
        ElementOverNodeInfo.disallowUpdate();
    }

    @Override
    public Attr getAttributeNodeNS(String object, String string) {
        NamePool namePool = this.node.getConfiguration().getNamePool();
        object = new NameTest(2, (String)object, string, namePool);
        object = this.node.iterateAxis((byte)2, (NodeTest)object);
        return (Attr)((Object)ElementOverNodeInfo.wrap(object.next()));
    }

    @Override
    public Attr setAttributeNodeNS(Attr attr) {
        ElementOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public boolean hasAttribute(String string) {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.node.iterateAxis((byte)2);
        do {
            if ((nodeInfo = axisIterator.next()) != null) continue;
            return false;
        } while (!nodeInfo.getDisplayName().equals(string));
        return true;
    }

    @Override
    public boolean hasAttributeNS(String string, String string2) {
        String string3 = string = string == null ? "" : string;
        return this.node.getAttributeValue(string, string2) != null;
    }

    @Override
    public void setIdAttribute(String string, boolean bl2) {
        ElementOverNodeInfo.disallowUpdate();
    }

    @Override
    public void setIdAttributeNS(String string, String string2, boolean bl2) {
        ElementOverNodeInfo.disallowUpdate();
    }

    @Override
    public void setIdAttributeNode(Attr attr, boolean bl2) {
        ElementOverNodeInfo.disallowUpdate();
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        SchemaType schemaType = this.node.getSchemaType();
        if (schemaType == null || Untyped.getInstance().equals(schemaType) || BuiltInAtomicType.UNTYPED_ATOMIC.equals(schemaType)) {
            return null;
        }
        return new TypeInfoImpl(this.node.getConfiguration(), schemaType);
    }
}

