/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.util.ArrayList;
import net.sf.saxon.dom.AttrOverNodeInfo;
import net.sf.saxon.dom.DOMNodeList;
import net.sf.saxon.dom.DocumentOverNodeInfo;
import net.sf.saxon.dom.ElementOverNodeInfo;
import net.sf.saxon.dom.PIOverNodeInfo;
import net.sf.saxon.dom.TextOverNodeInfo;
import net.sf.saxon.dom.a;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class NodeOverNodeInfo
implements Node {
    protected NodeInfo node;

    public NodeInfo getUnderlyingNodeInfo() {
        return this.node;
    }

    public static NodeOverNodeInfo wrap(NodeInfo nodeInfo) {
        NodeOverNodeInfo nodeOverNodeInfo;
        if (nodeInfo == null) {
            return null;
        }
        switch (nodeInfo.getNodeKind()) {
            case 9: {
                nodeOverNodeInfo = new DocumentOverNodeInfo();
                break;
            }
            case 1: {
                nodeOverNodeInfo = new ElementOverNodeInfo();
                break;
            }
            case 2: {
                nodeOverNodeInfo = new AttrOverNodeInfo();
                break;
            }
            case 3: 
            case 8: {
                nodeOverNodeInfo = new TextOverNodeInfo();
                break;
            }
            case 7: {
                nodeOverNodeInfo = new PIOverNodeInfo();
                break;
            }
            case 13: {
                nodeOverNodeInfo = new AttrOverNodeInfo();
                break;
            }
            default: {
                return null;
            }
        }
        nodeOverNodeInfo.node = nodeInfo;
        return nodeOverNodeInfo;
    }

    @Override
    public final boolean isSameNode(Node node) {
        return node instanceof NodeOverNodeInfo && this.node.equals(((NodeOverNodeInfo)node).node);
    }

    public boolean equals(Object object) {
        return object instanceof Node && this.isSameNode((Node)object);
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    @Override
    public String getBaseURI() {
        return this.node.getBaseURI();
    }

    @Override
    public String getNodeName() {
        switch (this.node.getNodeKind()) {
            case 9: {
                return "#document";
            }
            case 1: {
                return this.node.getDisplayName();
            }
            case 2: {
                return this.node.getDisplayName();
            }
            case 3: {
                return "#text";
            }
            case 8: {
                return "#comment";
            }
            case 7: {
                return this.node.getLocalPart();
            }
            case 13: {
                if (this.node.getLocalPart().isEmpty()) {
                    return "xmlns";
                }
                return "xmlns:" + this.node.getLocalPart();
            }
        }
        return "#unknown";
    }

    @Override
    public String getLocalName() {
        switch (this.node.getNodeKind()) {
            case 1: 
            case 2: {
                return this.node.getLocalPart();
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                return null;
            }
            case 13: {
                if (this.node.getLocalPart().isEmpty()) {
                    return "xmlns";
                }
                return this.node.getLocalPart();
            }
        }
        return null;
    }

    @Override
    public boolean hasChildNodes() {
        return this.node.iterateAxis((byte)3).next() != null;
    }

    @Override
    public boolean hasAttributes() {
        return true;
    }

    @Override
    public short getNodeType() {
        short s2 = (short)this.node.getNodeKind();
        if (s2 == 13) {
            return 2;
        }
        return s2;
    }

    @Override
    public Node getParentNode() {
        return NodeOverNodeInfo.wrap(this.node.getParent());
    }

    @Override
    public Node getPreviousSibling() {
        return NodeOverNodeInfo.wrap(this.node.iterateAxis((byte)11).next());
    }

    @Override
    public Node getNextSibling() {
        return NodeOverNodeInfo.wrap(this.node.iterateAxis((byte)7).next());
    }

    @Override
    public Node getFirstChild() {
        return NodeOverNodeInfo.wrap(this.node.iterateAxis((byte)3).next());
    }

    @Override
    public Node getLastChild() {
        AxisIterator axisIterator = this.node.iterateAxis((byte)3);
        NodeInfo nodeInfo = null;
        NodeInfo nodeInfo2;
        while ((nodeInfo2 = axisIterator.next()) != null) {
            nodeInfo = nodeInfo2;
        }
        return NodeOverNodeInfo.wrap(nodeInfo);
    }

    @Override
    public String getNodeValue() {
        switch (this.node.getNodeKind()) {
            case 1: 
            case 9: {
                return null;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 13: {
                return this.node.getStringValue();
            }
        }
        return null;
    }

    @Override
    public void setNodeValue(String string) {
        NodeOverNodeInfo.disallowUpdate();
    }

    @Override
    public NodeList getChildNodes() {
        try {
            NodeInfo nodeInfo;
            ArrayList<Node> arrayList = new ArrayList<Node>(10);
            AxisIterator axisIterator = this.node.iterateAxis((byte)3);
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                arrayList.add(NodeOverNodeInfo.wrap(nodeInfo));
            }
            return new DOMNodeList(arrayList);
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    @Override
    public NamedNodeMap getAttributes() {
        if (this.node.getNodeKind() == 1) {
            return new a(this.node);
        }
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        return (Document)((Object)NodeOverNodeInfo.wrap(this.node.getRoot()));
    }

    @Override
    public Node insertBefore(Node node, Node node2) {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public Node replaceChild(Node node, Node node2) {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public Node removeChild(Node node) {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public Node appendChild(Node node) {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public Node cloneNode(boolean bl2) {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public void normalize() {
    }

    @Override
    public boolean isSupported(String string, String string2) {
        return !(!string.equalsIgnoreCase("XML") && !string.equalsIgnoreCase("Core") || string2 != null && !string2.isEmpty() && !string2.equals("3.0") && !string2.equals("2.0") && !string2.equals("1.0"));
    }

    @Override
    public String getNamespaceURI() {
        if (this.node.getNodeKind() == 13) {
            return "http://www.w3.org/2000/xmlns/";
        }
        String string = this.node.getURI();
        if ("".equals(string)) {
            return null;
        }
        return string;
    }

    @Override
    public String getPrefix() {
        if (this.node.getNodeKind() == 13) {
            if (this.node.getLocalPart().isEmpty()) {
                return null;
            }
            return "xmlns";
        }
        String string = this.node.getPrefix();
        if ("".equals(string)) {
            return null;
        }
        return string;
    }

    @Override
    public void setPrefix(String string) {
        NodeOverNodeInfo.disallowUpdate();
    }

    @Override
    public short compareDocumentPosition(Node node) {
        if (!(node instanceof NodeOverNodeInfo)) {
            return 1;
        }
        int n2 = this.node.compareOrder(((NodeOverNodeInfo)node).node);
        if (n2 == 0) {
            return 0;
        }
        if (n2 == -1) {
            n2 = 4;
            short s2 = this.compareDocumentPosition(node.getParentNode());
            if (s2 == 0 || (s2 & 0x10) != 0) {
                n2 = 20;
            }
            return (short)n2;
        }
        if (n2 == 1) {
            n2 = 2;
            short s3 = this.getParentNode().compareDocumentPosition(node);
            if (s3 == 0 || (s3 & 8) != 0) {
                n2 = 10;
            }
            return (short)n2;
        }
        throw new AssertionError();
    }

    @Override
    public String getTextContent() {
        if (this.node.getNodeKind() == 9) {
            return null;
        }
        return this.node.getStringValue();
    }

    @Override
    public void setTextContent(String string) {
        NodeOverNodeInfo.disallowUpdate();
    }

    @Override
    public String lookupPrefix(String string) {
        if (this.node.getNodeKind() == 9) {
            return null;
        }
        if (this.node.getNodeKind() == 1) {
            NodeInfo nodeInfo;
            AxisIterator axisIterator = this.node.iterateAxis((byte)8);
            while ((nodeInfo = axisIterator.next()) != null) {
                if (!nodeInfo.getStringValue().equals(string)) continue;
                return nodeInfo.getLocalPart();
            }
            return null;
        }
        return this.getParentNode().lookupPrefix(string);
    }

    @Override
    public boolean isDefaultNamespace(String string) {
        return string.equals(this.lookupNamespaceURI(""));
    }

    @Override
    public String lookupNamespaceURI(String string) {
        if (this.node.getNodeKind() == 9) {
            return null;
        }
        if (this.node.getNodeKind() == 1) {
            NodeInfo nodeInfo;
            AxisIterator axisIterator = this.node.iterateAxis((byte)8);
            while ((nodeInfo = axisIterator.next()) != null) {
                if (!nodeInfo.getLocalPart().equals(string)) continue;
                return nodeInfo.getStringValue();
            }
            return null;
        }
        return this.getParentNode().lookupNamespaceURI(string);
    }

    @Override
    public boolean isEqualNode(Node node) {
        if (!(node instanceof NodeOverNodeInfo)) {
            throw new IllegalArgumentException("Other Node must wrap a Saxon NodeInfo");
        }
        try {
            XPathContext xPathContext = this.node.getConfiguration().getConversionContext();
            return DeepEqual.deepEqual(SingletonIterator.makeIterator(this.node), SingletonIterator.makeIterator(((NodeOverNodeInfo)node).node), new GenericAtomicComparer(CodepointCollator.getInstance(), xPathContext), xPathContext, 46);
        }
        catch (XPathException xPathException) {
            return false;
        }
    }

    @Override
    public Object getFeature(String string, String string2) {
        return null;
    }

    @Override
    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public Object getUserData(String string) {
        return null;
    }

    protected static void disallowUpdate() {
        throw new UnsupportedOperationException("The Saxon DOM implementation cannot be updated");
    }
}

