/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.dom.DOMExceptionImpl;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.value.Whitespace;
import org.w3c.dom.Comment;
import org.w3c.dom.Text;

public class TextOverNodeInfo
extends NodeOverNodeInfo
implements Comment,
Text {
    @Override
    public String getData() {
        return this.node.getStringValue();
    }

    @Override
    public void setData(String string) {
        TextOverNodeInfo.disallowUpdate();
    }

    @Override
    public int getLength() {
        return this.node.getStringValue().length();
    }

    @Override
    public String substringData(int n2, int n3) {
        try {
            int n4 = n2;
            return this.node.getStringValue().substring(n4, n4 + n3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DOMExceptionImpl(1, "substringData: index out of bounds");
        }
    }

    @Override
    public void appendData(String string) {
        TextOverNodeInfo.disallowUpdate();
    }

    @Override
    public void insertData(int n2, String string) {
        TextOverNodeInfo.disallowUpdate();
    }

    @Override
    public void deleteData(int n2, int n3) {
        TextOverNodeInfo.disallowUpdate();
    }

    @Override
    public void replaceData(int n2, int n3, String string) {
        TextOverNodeInfo.disallowUpdate();
    }

    @Override
    public Text splitText(int n2) {
        TextOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public Text replaceWholeText(String string) {
        TextOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public boolean isElementContentWhitespace() {
        if (this.node.getNodeKind() != 3) {
            throw new UnsupportedOperationException("Method is defined only on text nodes");
        }
        if (!Whitespace.isWhite(this.node.getStringValue())) {
            return false;
        }
        Object object = this.node.getParent();
        if (object == null) {
            return false;
        }
        return (object = object.getSchemaType()).isComplexType() && !((ComplexType)object).isMixedContent();
    }

    @Override
    public String getWholeText() {
        if (this.node.getNodeKind() != 3) {
            throw new UnsupportedOperationException("Method is defined only on text nodes");
        }
        return this.node.getStringValue();
    }
}

