/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Properties;
import java.util.Stack;
import javax.xml.transform.sax.TransformerHandler;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ContentHandlerProxyLocator;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.Whitespace;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class ContentHandlerProxy
implements Receiver {
    private PipelineConfiguration a;
    private String b;
    protected ContentHandler handler;
    protected LexicalHandler lexicalHandler;
    private int c = 0;
    private boolean d = false;
    private boolean e = false;
    private Stack<String> f = new Stack();
    private Stack<String> g = new Stack();
    private ContentHandlerProxyTraceListener h;
    protected AttributeCollectionImpl pendingAttributes;
    private NodeName i = null;
    private Location j = ExplicitLocation.UNKNOWN_LOCATION;

    public void setUnderlyingContentHandler(ContentHandler contentHandler) {
        this.handler = contentHandler;
        if (contentHandler instanceof LexicalHandler) {
            this.lexicalHandler = (LexicalHandler)((Object)contentHandler);
        }
    }

    public ContentHandler getUnderlyingContentHandler() {
        return this.handler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        this.a = pipelineConfiguration;
    }

    @Override
    public PipelineConfiguration getPipelineConfiguration() {
        return this.a;
    }

    public Configuration getConfiguration() {
        return this.a.getConfiguration();
    }

    @Override
    public void setSystemId(String string) {
        this.b = string;
    }

    @Override
    public String getSystemId() {
        return this.b;
    }

    public ContentHandlerProxyTraceListener getTraceListener() {
        if (this.h == null) {
            this.h = new ContentHandlerProxyTraceListener();
        }
        return this.h;
    }

    public Location getCurrentLocation() {
        return this.j;
    }

    @Override
    public void setUnparsedEntity(String string, String string2, String string3) {
        if (this.handler instanceof TransformerHandler) {
            try {
                ((TransformerHandler)this.handler).unparsedEntityDecl(string, string3, string2, "unknown");
                return;
            }
            catch (SAXException sAXException) {
                throw new XPathException(sAXException);
            }
        }
    }

    public void setOutputProperties(Properties properties) {
        String string = properties.getProperty("{http://saxon.sf.net/}require-well-formed");
        if (string != null) {
            this.d = string.equals("yes");
        }
        if ((string = properties.getProperty("undeclare-prefixes")) != null) {
            this.e = string.equals("yes");
        }
    }

    public boolean isRequireWellFormed() {
        return this.d;
    }

    public void setRequireWellFormed(boolean bl2) {
        this.d = bl2;
    }

    public boolean isUndeclareNamespaces() {
        return this.e;
    }

    public void setUndeclareNamespaces(boolean bl2) {
        this.e = bl2;
    }

    @Override
    public void open() {
        this.pendingAttributes = new AttributeCollectionImpl(this.getPipelineConfiguration().getConfiguration());
        if (this.handler == null) {
            throw new IllegalStateException("ContentHandlerProxy.open(): no underlying handler provided");
        }
        try {
            ContentHandlerProxyLocator contentHandlerProxyLocator = new ContentHandlerProxyLocator(this);
            this.handler.setDocumentLocator(contentHandlerProxyLocator);
            this.handler.startDocument();
        }
        catch (SAXException sAXException) {
            SAXException sAXException2 = sAXException;
            ContentHandlerProxy.a(sAXException);
        }
        this.c = 0;
    }

    @Override
    public void close() {
        if (this.c >= 0) {
            try {
                this.handler.endDocument();
            }
            catch (SAXException sAXException) {
                SAXException sAXException2 = sAXException;
                ContentHandlerProxy.a(sAXException);
            }
        }
        this.c = -1;
    }

    @Override
    public void startDocument(int n2) {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(NodeName nodeName, SchemaType schemaType, Location location, int n2) {
        ++this.c;
        if (this.c <= 0 && this.d) {
            this.notifyNotWellFormed();
        }
        this.i = nodeName;
        this.j = location.saveLocation();
        this.g.push("##");
    }

    @Override
    public void namespace(NamespaceBindingSet object, int n2) {
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (NamespaceBinding)object.next();
            String string = ((NamespaceBinding)object2).getPrefix();
            if (string.equals("xml")) {
                return;
            }
            object2 = ((NamespaceBinding)object2).getURI();
            if (!this.e && ((String)object2).isEmpty() && !string.isEmpty()) {
                return;
            }
            try {
                this.handler.startPrefixMapping(string, (String)object2);
                this.g.push(string);
            }
            catch (SAXException sAXException) {
                object2 = sAXException;
                ContentHandlerProxy.a(sAXException);
            }
        }
    }

    @Override
    public void attribute(NodeName nodeName, SimpleType simpleType, CharSequence charSequence, Location location, int n2) {
        int n3 = this.pendingAttributes.findByNodeName(nodeName);
        if (n3 < 0) {
            this.pendingAttributes.addAttribute(nodeName, simpleType, charSequence.toString(), location, n2);
            return;
        }
        this.pendingAttributes.setAttribute(n3, nodeName, simpleType, charSequence.toString(), location, n2);
    }

    @Override
    public void startContent() {
        try {
            if (this.c > 0 || !this.d) {
                String string = this.i.getURI();
                String string2 = this.i.getLocalPart();
                String string3 = this.i.getDisplayName();
                this.handler.startElement(string, string2, string3, this.pendingAttributes);
                this.f.push(string);
                this.f.push(string2);
                this.f.push(string3);
                this.pendingAttributes.clear();
                this.i = null;
            }
            return;
        }
        catch (SAXException sAXException) {
            SAXException sAXException2 = sAXException;
            ContentHandlerProxy.a(sAXException);
            return;
        }
    }

    @Override
    public void endElement() {
        Object object;
        Object object2;
        if (this.c > 0) {
            try {
                assert (!this.f.isEmpty());
                object2 = this.f.pop();
                object = this.f.pop();
                String string = this.f.pop();
                this.handler.endElement(string, (String)object, (String)object2);
            }
            catch (SAXException sAXException) {
                object2 = sAXException;
                ContentHandlerProxy.a(sAXException);
            }
        }
        while (!((String)(object2 = this.g.pop())).equals("##")) {
            try {
                this.handler.endPrefixMapping((String)object2);
            }
            catch (SAXException sAXException) {
                object = sAXException;
                ContentHandlerProxy.a(sAXException);
            }
        }
        --this.c;
        if (this.d && this.c <= 0) {
            this.c = Integer.MIN_VALUE;
        }
    }

    @Override
    public void characters(CharSequence object, Location location, int n2) {
        this.j = location;
        boolean bl2 = (n2 & 1) != 0;
        if (bl2) {
            this.a(false);
        }
        try {
            if (this.c <= 0 && this.d) {
                if (!Whitespace.isWhite((CharSequence)object)) {
                    this.notifyNotWellFormed();
                }
            } else {
                this.handler.characters(object.toString().toCharArray(), 0, object.length());
            }
        }
        catch (SAXException sAXException) {
            object = sAXException;
            ContentHandlerProxy.a(sAXException);
        }
        if (bl2) {
            this.a(true);
        }
    }

    protected void notifyNotWellFormed() {
        XPathException xPathException = new XPathException("The result tree cannot be supplied to the ContentHandler because it is not well-formed XML");
        xPathException.setErrorCode("SXCH0002");
        throw xPathException;
    }

    @Override
    public void processingInstruction(String object, CharSequence charSequence, Location location, int n2) {
        this.j = location;
        try {
            this.handler.processingInstruction((String)object, charSequence.toString());
            return;
        }
        catch (SAXException sAXException) {
            object = sAXException;
            ContentHandlerProxy.a(sAXException);
            return;
        }
    }

    @Override
    public void comment(CharSequence object, Location location, int n2) {
        this.j = location;
        try {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.comment(object.toString().toCharArray(), 0, object.length());
            }
            return;
        }
        catch (SAXException sAXException) {
            object = sAXException;
            ContentHandlerProxy.a(sAXException);
            return;
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    private void a(boolean bl2) {
        try {
            this.handler.processingInstruction(bl2 ? "javax.xml.transform.enable-output-escaping" : "javax.xml.transform.disable-output-escaping", "");
            return;
        }
        catch (SAXException sAXException) {
            throw new AssertionError((Object)sAXException);
        }
    }

    private static void a(SAXException exception) {
        Exception exception2 = exception.getException();
        if (exception2 instanceof XPathException) {
            throw (XPathException)exception2;
        }
        if (exception2 instanceof SchemaException) {
            throw new XPathException(exception2);
        }
        exception = new XPathException(exception);
        ((XPathException)exception).setErrorCode("SXCH0003");
        throw exception;
    }

    public static class ContentHandlerProxyTraceListener
    implements TraceListener {
        private Stack<Item> a;

        @Override
        public void setOutputDestination(Logger logger) {
        }

        public Stack getContextItemStack() {
            return this.a;
        }

        @Override
        public void open(Controller controller) {
            this.a = new Stack();
        }

        @Override
        public void close() {
            this.a = null;
        }

        @Override
        public void enter(InstructionInfo instructionInfo, XPathContext xPathContext) {
        }

        @Override
        public void leave(InstructionInfo instructionInfo) {
        }

        @Override
        public void startCurrentItem(Item item) {
            if (this.a == null) {
                this.a = new Stack();
            }
            this.a.push(item);
        }

        @Override
        public void endCurrentItem(Item item) {
            this.a.pop();
        }
    }
}

