/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public abstract class Event {
    public abstract void replay(Receiver var1);

    public static class Append
    extends Event {
        private Item a;
        private Location b;
        private int c;

        public Append(Item item, Location location, int n2) {
            this.a = item;
            this.b = location;
            this.c = n2;
        }

        @Override
        public void replay(Receiver receiver) {
            receiver.append(this.a, this.b, this.c);
        }
    }

    public static class ProcessingInstruction
    extends Event {
        private String a;
        private String b;
        private Location c;
        private int d;

        public ProcessingInstruction(String string, CharSequence charSequence, Location location, int n2) {
            this.a = string;
            this.b = charSequence.toString();
            this.c = location;
            this.d = n2;
        }

        @Override
        public void replay(Receiver receiver) {
            receiver.processingInstruction(this.a, this.b, this.c, this.d);
        }
    }

    public static class Comment
    extends Event {
        private String a;
        private Location b;
        private int c;

        public Comment(CharSequence charSequence, Location location, int n2) {
            this.a = charSequence.toString();
            this.b = location;
            this.c = n2;
        }

        @Override
        public void replay(Receiver receiver) {
            receiver.comment(this.a, this.b, this.c);
        }
    }

    public static class Text
    extends Event {
        private String a;
        private Location b;
        private int c;

        public Text(CharSequence charSequence, Location location, int n2) {
            this.a = charSequence.toString();
            this.b = location;
            this.c = n2;
        }

        @Override
        public void replay(Receiver receiver) {
            receiver.characters(this.a, this.b, this.c);
        }
    }

    public static class StartContent
    extends Event {
        @Override
        public void replay(Receiver receiver) {
            receiver.startContent();
        }
    }

    public static class Namespace
    extends Event {
        private NamespaceBindingSet a;
        private int b;

        public Namespace(NamespaceBindingSet namespaceBindingSet, int n2) {
            this.a = namespaceBindingSet;
            this.b = n2;
        }

        @Override
        public void replay(Receiver receiver) {
            receiver.namespace(this.a, this.b);
        }
    }

    public static class Attribute
    extends Event {
        private NodeName a;
        private SimpleType b;
        private Location c;
        private String d;
        private int e;

        public Attribute(NodeName nodeName, SimpleType simpleType, Location location, CharSequence charSequence, int n2) {
            this.a = nodeName;
            this.b = simpleType;
            this.c = location;
            this.d = charSequence.toString();
            this.e = n2;
        }

        @Override
        public void replay(Receiver receiver) {
            receiver.attribute(this.a, this.b, this.d, this.c, this.e);
        }
    }

    public static class EndElement
    extends Event {
        @Override
        public void replay(Receiver receiver) {
            receiver.endElement();
        }
    }

    public static class StartElement
    extends Event {
        private NodeName a;
        private SchemaType b;
        private Location c;
        private int d;

        public StartElement(NodeName nodeName, SchemaType schemaType, Location location, int n2) {
            this.a = nodeName;
            this.b = schemaType;
            this.c = location;
            this.d = n2;
        }

        @Override
        public void replay(Receiver receiver) {
            receiver.startElement(this.a, this.b, this.c, this.d);
        }
    }

    public static class EndDocument
    extends Event {
        @Override
        public void replay(Receiver receiver) {
            receiver.endDocument();
        }
    }

    public static class StartDocument
    extends Event {
        private int a;

        public StartDocument(int n2) {
            this.a = n2;
        }

        @Override
        public void replay(Receiver receiver) {
            receiver.startDocument(this.a);
        }
    }
}

