/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.event.Event;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class EventBuffer
extends SequenceReceiver {
    private List<Event> a = new ArrayList<Event>();

    public EventBuffer(PipelineConfiguration pipelineConfiguration) {
        super(pipelineConfiguration);
    }

    @Override
    public void startDocument(int n2) {
        this.a.add(new Event.StartDocument(n2));
    }

    @Override
    public void endDocument() {
        this.a.add(new Event.EndDocument());
    }

    @Override
    public void startElement(NodeName nodeName, SchemaType schemaType, Location location, int n2) {
        this.a.add(new Event.StartElement(nodeName, schemaType, location, n2));
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindingSet, int n2) {
        this.a.add(new Event.Namespace(namespaceBindingSet, n2));
    }

    @Override
    public void attribute(NodeName nodeName, SimpleType simpleType, CharSequence charSequence, Location location, int n2) {
        this.a.add(new Event.Attribute(nodeName, simpleType, location, charSequence, n2));
    }

    @Override
    public void startContent() {
        this.a.add(new Event.StartContent());
    }

    @Override
    public void endElement() {
        this.a.add(new Event.EndElement());
    }

    @Override
    public void characters(CharSequence charSequence, Location location, int n2) {
        this.a.add(new Event.Text(charSequence, location, n2));
    }

    @Override
    public void processingInstruction(String string, CharSequence charSequence, Location location, int n2) {
        this.a.add(new Event.ProcessingInstruction(string, charSequence, location, n2));
    }

    @Override
    public void comment(CharSequence charSequence, Location location, int n2) {
        this.a.add(new Event.Comment(charSequence, location, n2));
    }

    @Override
    public void append(Item item, Location location, int n2) {
        this.a.add(new Event.Append(item, location, n2));
    }

    @Override
    public void close() {
    }

    public void replay(Receiver receiver) {
        for (Event event : this.a) {
            event.replay(receiver);
        }
    }
}

