/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.QuitParsingException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.tiny.CompressedWhitespace;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInListType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.Whitespace;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.LexicalHandler;

public class ReceivingContentHandler
implements ContentHandler,
DTDHandler,
LexicalHandler {
    private PipelineConfiguration a;
    private Receiver b;
    private boolean c = false;
    private LocalLocator d = new LocalLocator(ExplicitLocation.UNKNOWN_LOCATION);
    private boolean e;
    private Location f;
    private char[] g = new char[512];
    private int h = 0;
    private CharSlice i = new CharSlice(this.g, 0, 0);
    private NamespaceBinding[] j = new NamespaceBinding[20];
    private int k = 0;
    private boolean l = false;
    private boolean m = false;
    private boolean n = false;
    private boolean o = false;
    private boolean p = true;
    private HashMap<String, HashMap<String, NodeName>> q = new HashMap(10);
    private HashMap<String, NodeName> r = new HashMap(10);
    private int s = 0;
    private Stack<Integer> t;

    public void reset() {
        this.a = null;
        this.b = null;
        this.l = false;
        this.m = false;
        this.h = 0;
        this.i.setLength(0);
        this.k = 0;
        this.d = new LocalLocator(ExplicitLocation.UNKNOWN_LOCATION);
        this.n = false;
        this.o = false;
        this.e = false;
    }

    public void setReceiver(Receiver receiver) {
        this.b = receiver;
    }

    public Receiver getReceiver() {
        return this.b;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        this.a = pipelineConfiguration;
        Configuration configuration = pipelineConfiguration.getConfiguration();
        this.l = pipelineConfiguration.getParseOptions().getSpaceStrippingRule() != NoElementsSpaceStrippingRule.getInstance();
        this.m = configuration.getBooleanProperty(Feature.RETAIN_DTD_ATTRIBUTE_TYPES);
        if (!pipelineConfiguration.getParseOptions().isExpandAttributeDefaults()) {
            this.s = -1;
        } else if (configuration.getBooleanProperty(Feature.MARK_DEFAULTED_ATTRIBUTES)) {
            this.s = 1;
        }
        this.n = configuration.getConfigurationProperty(Feature.USE_PI_DISABLE_OUTPUT_ESCAPING);
        this.e = pipelineConfiguration.getParseOptions().isLineNumbering();
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.a;
    }

    public Configuration getConfiguration() {
        return this.a.getConfiguration();
    }

    public void setIgnoreIgnorableWhitespace(boolean bl2) {
        this.l = bl2;
    }

    public boolean isIgnoringIgnorableWhitespace() {
        return this.l;
    }

    @Override
    public void startDocument() {
        try {
            this.h = 0;
            this.k = 0;
            this.b.setPipelineConfiguration(this.a);
            String string = this.d.getSystemId();
            if (string != null) {
                this.b.setSystemId(this.d.getSystemId());
            }
            this.b.open();
            this.b.startDocument(0);
            return;
        }
        catch (QuitParsingException quitParsingException) {
            this.getPipelineConfiguration().getErrorListener().warning(quitParsingException);
            throw new SAXException(quitParsingException);
        }
        catch (XPathException xPathException) {
            throw new SAXException(xPathException);
        }
    }

    @Override
    public void endDocument() {
        try {
            this.a(true);
            this.b.endDocument();
            this.b.close();
            return;
        }
        catch (ValidationException validationException) {
            ValidationException validationException2 = validationException;
            validationException.setLocator(this.d);
            throw new SAXException(validationException2);
        }
        catch (QuitParsingException quitParsingException) {
            return;
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.maybeSetLocation(this.d);
            throw new SAXException(xPathException2);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.d = new LocalLocator(locator);
        if (!this.e) {
            this.f = this.d;
        }
    }

    @Override
    public void startPrefixMapping(String string, String string2) {
        if (string.equals("xmlns")) {
            return;
        }
        if (this.k >= this.j.length) {
            this.j = Arrays.copyOf(this.j, this.k << 1);
        }
        this.j[this.k++] = new NamespaceBinding(string, string2);
    }

    @Override
    public void endPrefixMapping(String string) {
    }

    @Override
    public void startElement(String object, String string, String object2, Attributes attributes) {
        try {
            int n2;
            this.a(true);
            object = this.a((String)object, string, (String)object2);
            this.b.startElement((NodeName)object, Untyped.getInstance(), this.d, 64);
            ++this.d.levelInEntity;
            for (n2 = 0; n2 < this.k; ++n2) {
                this.b.namespace(this.j[n2], 0);
            }
            for (n2 = 0; n2 < attributes.getLength(); ++n2) {
                int n3;
                int n4 = 64;
                object2 = attributes.getQName(n2);
                if (((String)object2).startsWith("xmlns") && (((String)object2).length() == 5 || ((String)object2).charAt(5) == ':')) continue;
                if (this.s != 0 && attributes instanceof Attributes2 && !((Attributes2)attributes).isSpecified((String)object2)) {
                    if (this.s == -1) continue;
                    n4 = 72;
                }
                object2 = this.a(attributes.getURI(n2), attributes.getLocalName(n2), attributes.getQName(n2));
                String string2 = attributes.getType(n2);
                SimpleType simpleType = BuiltInAtomicType.UNTYPED_ATOMIC;
                if (this.m) {
                    n3 = -1;
                    switch (string2.hashCode()) {
                        case 63966829: {
                            if (!string2.equals("CDATA")) break;
                            n3 = 0;
                            break;
                        }
                        case 2331: {
                            if (!string2.equals("ID")) break;
                            n3 = 1;
                            break;
                        }
                        case 69523832: {
                            if (!string2.equals("IDREF")) break;
                            n3 = 2;
                            break;
                        }
                        case -2139728421: {
                            if (!string2.equals("IDREFS")) break;
                            n3 = 3;
                            break;
                        }
                        case -1504708742: {
                            if (!string2.equals("NMTOKEN")) break;
                            n3 = 4;
                            break;
                        }
                        case 598669337: {
                            if (!string2.equals("NMTOKENS")) break;
                            n3 = 5;
                            break;
                        }
                        case 2050021347: {
                            if (!string2.equals("ENTITY")) break;
                            n3 = 6;
                            break;
                        }
                        case -1319487551: {
                            if (!string2.equals("ENTITIES")) break;
                            n3 = 7;
                        }
                    }
                    switch (n3) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            simpleType = BuiltInAtomicType.ID;
                            break;
                        }
                        case 2: {
                            simpleType = BuiltInAtomicType.IDREF;
                            break;
                        }
                        case 3: {
                            simpleType = BuiltInListType.IDREFS;
                            break;
                        }
                        case 4: {
                            simpleType = BuiltInAtomicType.NMTOKEN;
                            break;
                        }
                        case 5: {
                            simpleType = BuiltInListType.NMTOKENS;
                            break;
                        }
                        case 6: {
                            simpleType = BuiltInAtomicType.ENTITY;
                            break;
                        }
                        case 7: {
                            simpleType = BuiltInListType.ENTITIES;
                        }
                    }
                } else {
                    n3 = -1;
                    switch (string2.hashCode()) {
                        case 2331: {
                            if (!string2.equals("ID")) break;
                            n3 = 0;
                            break;
                        }
                        case 69523832: {
                            if (!string2.equals("IDREF")) break;
                            n3 = 1;
                            break;
                        }
                        case -2139728421: {
                            if (!string2.equals("IDREFS")) break;
                            n3 = 2;
                        }
                    }
                    switch (n3) {
                        case 0: {
                            n4 |= 0x800;
                            break;
                        }
                        case 1: {
                            n4 |= 0x1000;
                            break;
                        }
                        case 2: {
                            n4 |= 0x1000;
                        }
                    }
                }
                this.b.attribute((NodeName)object2, simpleType, attributes.getValue(n2), this.d, n4);
            }
            this.p = true;
            this.b.startContent();
            this.k = 0;
            return;
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.maybeSetLocation(this.d);
            throw new SAXException((Exception)object);
        }
    }

    private NodeName a(String object, String string, String string2) {
        Object object2;
        if (string2.isEmpty()) {
            throw new SAXException("Saxon requires an XML parser that reports the QName of each element");
        }
        if (string.isEmpty()) {
            throw new SAXException("Parser configuration problem: namespace reporting is not enabled");
        }
        HashMap<String, NodeName> hashMap = ((String)object).isEmpty() ? this.r : this.q.get(object);
        if (hashMap == null) {
            hashMap = new HashMap(50);
            this.q.put((String)object, hashMap);
            if (((String)object).isEmpty()) {
                this.r = hashMap;
            }
        }
        if ((object2 = hashMap.get(string2)) == null) {
            if (((String)object).isEmpty()) {
                object2 = new NoNamespaceName(string);
                hashMap.put(string2, (NodeName)object2);
                return object2;
            }
            object2 = NameChecker.getPrefix(string2);
            object = new FingerprintedQName((String)object2, (String)object, string);
            hashMap.put(string2, (NodeName)object);
            return object;
        }
        return object2;
    }

    @Override
    public void endElement(String object, String string, String string2) {
        try {
            ReceivingContentHandler receivingContentHandler = this;
            receivingContentHandler.a(!receivingContentHandler.p);
            --this.d.levelInEntity;
            this.b.endElement();
        }
        catch (ValidationException validationException) {
            object = validationException;
            validationException.maybeSetLocation(this.d);
            if (!((XPathException)object).hasBeenReported()) {
                this.a.getErrorListener().fatalError((TransformerException)object);
            }
            ((XPathException)object).setHasBeenReported(true);
            throw new SAXException((Exception)object);
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.maybeSetLocation(this.d);
            throw new SAXException((Exception)object);
        }
        this.p = false;
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) {
        while (this.h + n3 > this.g.length) {
            this.g = Arrays.copyOf(this.g, this.g.length << 1);
            this.i = new CharSlice(this.g, 0, 0);
        }
        System.arraycopy(cArray, n2, this.g, this.h, n3);
        this.h += n3;
        if (this.e) {
            this.f = this.d.saveLocation();
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n2, int n3) {
        if (!this.l) {
            this.characters(cArray, n2, n3);
        }
    }

    @Override
    public void processingInstruction(String string, String charSequence) {
        try {
            block10: {
                block9: {
                    this.a(true);
                    if (this.c) break block9;
                    if (string == null) break block10;
                    if (!NameChecker.isValidNCName(string)) {
                        throw new SAXException("Invalid processing instruction name (" + string + ')');
                    }
                    if (this.n) {
                        if (string.equals("javax.xml.transform.disable-output-escaping")) {
                            this.o = true;
                            return;
                        }
                        if (string.equals("javax.xml.transform.enable-output-escaping")) {
                            this.o = false;
                            return;
                        }
                    }
                    charSequence = charSequence == null ? "" : Whitespace.removeLeadingWhitespace(charSequence);
                    this.b.processingInstruction(string, charSequence, this.d, 0);
                }
                return;
            }
            this.comment(charSequence.toCharArray(), 0, charSequence.length());
        }
        catch (XPathException xPathException) {
            throw new SAXException(xPathException);
        }
    }

    @Override
    public void comment(char[] cArray, int n2, int n3) {
        try {
            this.a(true);
            if (!this.c) {
                this.b.comment(new CharSlice(cArray, n2, n3), this.d, 0);
            }
            return;
        }
        catch (XPathException xPathException) {
            throw new SAXException(xPathException);
        }
    }

    private void a(boolean bl2) {
        if (this.h > 0) {
            this.i.setLength(this.h);
            CharSequence charSequence = bl2 ? CompressedWhitespace.compress(this.i) : this.i;
            this.b.characters(charSequence, this.f, this.o ? 1 : 1024);
            this.h = 0;
            this.o = false;
        }
    }

    @Override
    public void skippedEntity(String string) {
    }

    @Override
    public void startDTD(String string, String string2, String string3) {
        this.c = true;
    }

    @Override
    public void endDTD() {
        this.c = false;
    }

    @Override
    public void startEntity(String string) {
        if (this.t == null) {
            this.t = new Stack();
        }
        this.t.push(this.d.levelInEntity);
        this.d.levelInEntity = 0;
    }

    @Override
    public void endEntity(String string) {
        this.d.levelInEntity = this.t.pop();
    }

    @Override
    public void startCDATA() {
    }

    @Override
    public void endCDATA() {
    }

    @Override
    public void notationDecl(String string, String string2, String string3) {
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String object, String string3) {
        string3 = object;
        if (this.d != null) {
            try {
                Object object2 = new URI((String)object);
                if (!((URI)object2).isAbsolute() && (object2 = this.d.getSystemId()) != null) {
                    object = new URI((String)object2).resolve((String)object);
                    string3 = ((URI)object).toString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        try {
            this.b.setUnparsedEntity(string, string3, string2);
            return;
        }
        catch (XPathException xPathException) {
            throw new SAXException(xPathException);
        }
    }

    public static class LocalLocator
    implements Location {
        private Locator a;
        public int levelInEntity;

        public LocalLocator(Locator locator) {
            this.a = locator;
            this.levelInEntity = 0;
        }

        @Override
        public String getSystemId() {
            return this.a.getSystemId();
        }

        @Override
        public String getPublicId() {
            return this.a.getPublicId();
        }

        @Override
        public int getLineNumber() {
            return this.a.getLineNumber();
        }

        @Override
        public int getColumnNumber() {
            return this.a.getColumnNumber();
        }

        @Override
        public Location saveLocation() {
            return new ExplicitLocation(this.getSystemId(), this.getLineNumber(), this.getColumnNumber());
        }
    }
}

