/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Version;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.EventSource;
import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.NamePoolConverter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.expr.number.AbstractNumberer;
import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.StandardErrorHandler;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.PullPushCopier;
import net.sf.saxon.pull.PullSource;
import net.sf.saxon.pull.StaxBridge;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public abstract class Sender {
    private Sender() {
    }

    /*
     * WARNING - void declaration
     */
    public static void send(Source object, Receiver object2, ParseOptions object3) {
        List<ExternalObjectModel> list;
        int n2;
        Configuration configuration;
        while (true) {
            SpaceStrippingRule spaceStrippingRule;
            Object object4;
            void object6;
            Object object5 = object2.getPipelineConfiguration();
            object3 = object3 == null ? new ParseOptions(((PipelineConfiguration)object5).getParseOptions()) : new ParseOptions((ParseOptions)object3);
            String string = object.getSystemId();
            if (object instanceof AugmentedSource) {
                ((ParseOptions)object3).merge(((AugmentedSource)object).getParseOptions());
                String string2 = object.getSystemId();
                object = ((AugmentedSource)object).getContainedSource();
            }
            configuration = ((PipelineConfiguration)object5).getConfiguration();
            ((ParseOptions)object3).applyDefaults(configuration);
            object2.setSystemId((String)object6);
            n2 = ((ParseOptions)object3).getSchemaValidationMode();
            list = ((ParseOptions)object3).getFilters();
            if (list != null) {
                for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                    object4 = list.get(i2).makeFilter((Receiver)object2);
                    object4.setSystemId(object.getSystemId());
                    object2 = object4;
                }
            }
            if ((spaceStrippingRule = ((ParseOptions)object3).getSpaceStrippingRule()) != null && !(spaceStrippingRule instanceof NoElementsSpaceStrippingRule)) {
                object2 = spaceStrippingRule.makeStripper((Receiver)object2);
            }
            if (object instanceof TreeInfo) {
                object = ((TreeInfo)object).getRootNode();
            }
            if (object instanceof NodeInfo) {
                int n3;
                object4 = (NodeInfo)object;
                list = object4.getBaseURI();
                if (n2 != 3) {
                    object2 = configuration.getDocumentValidator((Receiver)object2, (String)((Object)list), (ParseOptions)object3, null);
                }
                if ((n3 = object4.getNodeKind()) != 9 && n3 != 1) {
                    throw new IllegalArgumentException("Sender can only handle document or element nodes");
                }
                object2.setSystemId((String)((Object)list));
                ExplicitLocation explicitLocation = new ExplicitLocation((String)object6, -1, -1);
                object3 = explicitLocation;
                object = object4;
                PipelineConfiguration pipelineConfiguration = object2.getPipelineConfiguration();
                NamePool namePool = pipelineConfiguration.getConfiguration().getNamePool();
                if (object.getConfiguration().getNamePool() != namePool) {
                    object2 = new NamePoolConverter((Receiver)object2, object.getConfiguration().getNamePool(), namePool);
                }
                LocationCopier locationCopier = new LocationCopier(object.getNodeKind() == 9);
                pipelineConfiguration.setComponent(CopyInformee.class.getName(), locationCopier);
                object2.open();
                switch (object.getNodeKind()) {
                    case 9: {
                        object.copy((Receiver)object2, 6, (Location)object3);
                        break;
                    }
                    case 1: {
                        object2.startDocument(0);
                        object.copy((Receiver)object2, 6, (Location)object3);
                        object2.endDocument();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Expected document or element node");
                    }
                }
                object2.close();
                return;
            }
            if (object instanceof PullSource) {
                Sender.a((PullSource)object, (Receiver)object2, (ParseOptions)object3);
                return;
            }
            if (object instanceof EventSource) {
                ((EventSource)object).send((Receiver)object2);
                return;
            }
            if (object instanceof SAXSource) {
                Sender.a((SAXSource)object, (Receiver)object2, (ParseOptions)object3);
                return;
            }
            if (object instanceof StreamSource) {
                object4 = (StreamSource)object;
                boolean bl2 = ((ParseOptions)object3).getDTDValidationMode() == 1;
                if ((object5 = Version.platform.getParserSource((PipelineConfiguration)object5, (StreamSource)object4, n2, bl2, ((ParseOptions)object3).getStripSpace())) == object4) {
                    String string3 = object.getSystemId();
                    InputSource inputSource = new InputSource(string3);
                    inputSource.setCharacterStream(((StreamSource)object4).getReader());
                    inputSource.setByteStream(((StreamSource)object4).getInputStream());
                    n2 = 0;
                    object5 = ((ParseOptions)object3).obtainXMLReader();
                    if (object5 == null) {
                        object5 = configuration.getSourceParser();
                        if (((ParseOptions)object3).getEntityResolver() != null && object5.getEntityResolver() == null) {
                            object5.setEntityResolver(((ParseOptions)object3).getEntityResolver());
                        }
                        n2 = 1;
                    }
                    SAXSource sAXSource = new SAXSource((XMLReader)object5, inputSource);
                    sAXSource.setSystemId(object.getSystemId());
                    Sender.a(sAXSource, (Receiver)object2, (ParseOptions)object3);
                    if (n2 != 0) {
                        configuration.reuseSourceParser((XMLReader)object5);
                    }
                    return;
                }
                object = object5;
                continue;
            }
            if (object instanceof StAXSource) {
                object4 = ((StAXSource)object).getXMLStreamReader();
                if (object4 == null) {
                    throw new XPathException("Saxon can only handle a StAXSource that wraps an XMLStreamReader");
                }
                list = new StaxBridge();
                ((StaxBridge)((Object)list)).setXMLStreamReader((XMLStreamReader)object4);
                Sender.a(new PullSource((PullProvider)((Object)list)), (Receiver)object2, (ParseOptions)object3);
                return;
            }
            object.getSystemId();
            object2 = Sender.a((Receiver)object2, (ParseOptions)object3);
            object4 = configuration.getSourceResolver().resolveSource((Source)object, configuration);
            if (!(object4 instanceof StreamSource) && !(object4 instanceof SAXSource) && !(object4 instanceof NodeInfo) && !(object4 instanceof PullSource) && !(object4 instanceof AugmentedSource) && !(object4 instanceof EventSource)) break;
            object = object4;
        }
        list = configuration.getExternalObjectModels();
        for (Object e2 : list) {
            ExternalObjectModel externalObjectModel = (ExternalObjectModel)e2;
            boolean bl3 = externalObjectModel.sendSource((Source)object, (Receiver)object2);
            n2 = bl3 ? 1 : 0;
            if (!bl3) continue;
            return;
        }
        throw new XPathException("A source of type " + object.getClass().getName() + " is not supported in this environment");
    }

    /*
     * WARNING - void declaration
     */
    private static void a(SAXSource sAXSource, Receiver receiver, ParseOptions parseOptions) {
        void var12_21;
        boolean bl2;
        int n2;
        Object object;
        ErrorHandler errorHandler;
        PipelineConfiguration pipelineConfiguration = receiver.getPipelineConfiguration();
        XMLReader xMLReader = sAXSource.getXMLReader();
        boolean bl3 = false;
        Configuration configuration = pipelineConfiguration.getConfiguration();
        UnfailingErrorListener unfailingErrorListener = parseOptions.getErrorListener();
        if (unfailingErrorListener == null) {
            unfailingErrorListener = pipelineConfiguration.getErrorListener();
        }
        if ((errorHandler = parseOptions.getErrorHandler()) == null) {
            errorHandler = new StandardErrorHandler(unfailingErrorListener);
        }
        if (xMLReader == null) {
            xMLReader = parseOptions.obtainXMLReader();
        }
        if (xMLReader == null) {
            SAXSource sAXSource2 = new SAXSource();
            sAXSource2.setInputSource(sAXSource.getInputSource());
            sAXSource2.setSystemId(sAXSource.getSystemId());
            xMLReader = configuration.getSourceParser();
            xMLReader.setErrorHandler(errorHandler);
            if (parseOptions.getEntityResolver() != null && xMLReader.getEntityResolver() == null) {
                xMLReader.setEntityResolver(parseOptions.getEntityResolver());
            }
            sAXSource2.setXMLReader(xMLReader);
            sAXSource = sAXSource2;
            bl3 = true;
        } else {
            Sender.configureParser(xMLReader);
            if (xMLReader.getErrorHandler() == null) {
                xMLReader.setErrorHandler(errorHandler);
            }
        }
        if (!pipelineConfiguration.getParseOptions().isExpandAttributeDefaults()) {
            try {
                xMLReader.setFeature("http://xml.org/sax/features/use-attributes2", true);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {}
        }
        boolean bl4 = parseOptions.getDTDValidationMode() == 2;
        Iterator<Map.Entry<String, Object>> iterator = parseOptions.getParserFeatures();
        Map<String, Object> map = parseOptions.getParserProperties();
        if (iterator != null) {
            for (Map.Entry<String, Object> entry : iterator.entrySet()) {
                try {
                    object = entry.getKey();
                    n2 = ((Boolean)entry.getValue()).booleanValue();
                    if (((String)object).equals("http://apache.org/xml/features/xinclude")) {
                        boolean bl5 = false;
                        try {
                            xMLReader.setFeature((String)object, n2 != 0);
                        }
                        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                            bl5 = true;
                        }
                        if (!bl5) continue;
                        try {
                            xMLReader.setFeature((String)object + "-aware", n2 != 0);
                            continue;
                        }
                        catch (SAXNotRecognizedException sAXNotRecognizedException) {
                            throw new XPathException(Sender.a(xMLReader) + " does not recognize request for XInclude processing", sAXNotRecognizedException);
                        }
                        catch (SAXNotSupportedException sAXNotSupportedException) {
                            throw new XPathException(Sender.a(xMLReader) + " does not support XInclude processing", sAXNotSupportedException);
                        }
                    }
                    xMLReader.setFeature(entry.getKey(), (Boolean)entry.getValue());
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    if (!((Boolean)entry.getValue()).booleanValue()) continue;
                    configuration.getLogger().warning(Sender.a(xMLReader) + " does not recognize the feature " + entry.getKey());
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    if (!((Boolean)entry.getValue()).booleanValue()) continue;
                    configuration.getLogger().warning(Sender.a(xMLReader) + " does not support the feature " + entry.getKey());
                }
            }
        }
        if (map != null) {
            for (Map.Entry<String, Object> receivingContentHandler : map.entrySet()) {
                try {
                    xMLReader.setProperty(receivingContentHandler.getKey(), receivingContentHandler.getValue());
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    configuration.getLogger().warning(Sender.a(xMLReader) + " does not recognize the property " + receivingContentHandler.getKey());
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    configuration.getLogger().warning(Sender.a(xMLReader) + " does not support the property " + receivingContentHandler.getKey());
                }
            }
        }
        if (bl2 = parseOptions.isXIncludeAware()) {
            boolean bl6;
            boolean bl7 = false;
            try {
                xMLReader.setFeature("http://apache.org/xml/features/xinclude-aware", true);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                bl6 = true;
            }
            if (bl6) {
                try {
                    xMLReader.setFeature("http://apache.org/xml/features/xinclude", true);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    throw new XPathException(Sender.a(xMLReader) + " does not recognize request for XInclude processing", sAXNotRecognizedException);
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    throw new XPathException(Sender.a(xMLReader) + " does not support XInclude processing", sAXNotSupportedException);
                }
            }
        }
        sAXSource.getSystemId();
        receiver = Sender.a(receiver, parseOptions);
        object = xMLReader.getContentHandler();
        if (object instanceof ReceivingContentHandler && configuration.isCompatible(((ReceivingContentHandler)object).getConfiguration())) {
            ReceivingContentHandler receivingContentHandler = (ReceivingContentHandler)object;
            receivingContentHandler.reset();
        } else {
            ReceivingContentHandler receivingContentHandler = new ReceivingContentHandler();
            xMLReader.setContentHandler(receivingContentHandler);
            xMLReader.setDTDHandler(receivingContentHandler);
            try {
                xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", receivingContentHandler);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {}
        }
        var12_21.setReceiver(receiver);
        var12_21.setPipelineConfiguration(pipelineConfiguration);
        try {
            xMLReader.parse(sAXSource.getInputSource());
        }
        catch (SAXException sAXException) {
            SAXException sAXException2 = sAXException;
            Exception exception = sAXException.getException();
            if (exception instanceof XPathException) {
                throw (XPathException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (errorHandler instanceof StandardErrorHandler && ((StandardErrorHandler)errorHandler).getFatalErrorCount() == 0 || sAXException2 instanceof SAXParseException && ((SAXParseException)sAXException2).getSystemId() == null && sAXSource.getSystemId() != null) {
                object = new XPathException("Error reported by XML parser processing " + sAXSource.getSystemId() + ": " + sAXException2.getMessage(), sAXException2);
                unfailingErrorListener.fatalError((TransformerException)object);
                ((XPathException)object).setHasBeenReported(true);
                throw object;
            }
            object = new XPathException(sAXException2);
            ((XPathException)object).setErrorCode("SXXP0003");
            ((XPathException)object).setHasBeenReported(true);
            throw object;
        }
        catch (IOException iOException) {
            throw new XPathException("I/O error reported by XML parser processing " + sAXSource.getSystemId() + ": " + iOException.getMessage(), iOException);
        }
        if (errorHandler instanceof StandardErrorHandler) {
            n2 = ((StandardErrorHandler)errorHandler).getFatalErrorCount();
            if (n2 > 0) {
                throw new XPathException("The XML parser reported " + n2 + (n2 == 1 ? " error" : " errors"));
            }
            n2 = ((StandardErrorHandler)errorHandler).getErrorCount();
            if (n2 > 0) {
                String string = "The XML parser reported " + ((AbstractNumberer)new Numberer_en()).toWords(n2).toLowerCase() + " validation error" + (n2 == 1 ? "" : "s");
                if (bl4) {
                    string = string + ". Processing continues, because recovery from validation errors was requested";
                    unfailingErrorListener.warning(new XPathException(string));
                } else {
                    throw new XPathException(string);
                }
            }
        }
        if (bl3) {
            configuration.reuseSourceParser(xMLReader);
        }
    }

    private static String a(XMLReader xMLReader) {
        return "Selected XML parser " + xMLReader.getClass().getName();
    }

    private static Receiver a(Receiver receiver, ParseOptions parseOptions) {
        Object object = receiver.getPipelineConfiguration();
        ((PipelineConfiguration)object).getConfiguration();
        int n2 = parseOptions.getSchemaValidationMode();
        if (n2 != 3 && n2 != 0 && (object = ((PipelineConfiguration)object).getController()) != null && !((Controller)object).getExecutable().isSchemaAware() && n2 != 4) {
            throw new XPathException("Cannot use schema-validated input documents when the query/stylesheet is not schema-aware");
        }
        return receiver;
    }

    private static void a(PullSource object, Receiver object2, ParseOptions parseOptions) {
        PipelineConfiguration pipelineConfiguration = object2.getPipelineConfiguration();
        boolean bl2 = parseOptions.isXIncludeAware();
        if (bl2) {
            throw new XPathException("XInclude processing is not supported with a pull parser");
        }
        ((PullSource)object).getSystemId();
        object2 = Sender.a((Receiver)object2, parseOptions);
        object = ((PullSource)object).getPullProvider();
        object.setPipelineConfiguration(pipelineConfiguration);
        object2.setPipelineConfiguration(pipelineConfiguration);
        object2 = new PullPushCopier((PullProvider)object, (Receiver)object2);
        try {
            ((PullPushCopier)object2).copy();
            if (parseOptions.isPleaseCloseAfterUse()) {
                object.close();
                return;
            }
        }
        catch (Throwable throwable) {
            if (parseOptions.isPleaseCloseAfterUse()) {
                object.close();
            }
            throw throwable;
        }
    }

    public static void configureParser(XMLReader xMLReader) {
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new XPathException("The SAX2 parser " + xMLReader.getClass().getName() + " does not recognize the 'namespaces' feature", sAXNotSupportedException);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new XPathException("The SAX2 parser " + xMLReader.getClass().getName() + " does not support setting the 'namespaces' feature to true", sAXNotRecognizedException);
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            return;
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new XPathException("The SAX2 parser " + xMLReader.getClass().getName() + " does not recognize the 'namespace-prefixes' feature", sAXNotSupportedException);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new XPathException("The SAX2 parser " + xMLReader.getClass().getName() + " does not support setting the 'namespace-prefixes' feature to false", sAXNotRecognizedException);
        }
    }

    static {
        Class[] cfr_ignored_0 = new Class[0];
    }
}

