/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.SequenceWriter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

public final class SequenceOutputter
extends SequenceWriter {
    private List<Item<?>> a;

    public SequenceOutputter(PipelineConfiguration pipelineConfiguration) {
        this(pipelineConfiguration, 50);
    }

    public SequenceOutputter(PipelineConfiguration pipelineConfiguration, int n2) {
        super(pipelineConfiguration);
        this.a = new ArrayList(n2);
    }

    public static SequenceOutputter allocateSequenceOutputter(XPathContext object, int n2) {
        object = object.getController();
        object = ((Controller)object).allocateSequenceOutputter(20);
        ((SequenceReceiver)object).getPipelineConfiguration().setHostLanguage(n2);
        return object;
    }

    public final void reset() {
        this.a = new ArrayList(Math.min(this.a.size() + 10, 50));
    }

    @Override
    public final void write(Item item) {
        this.a.add(item);
    }

    public final Sequence<?> getSequence() {
        switch (this.a.size()) {
            case 0: {
                return EmptySequence.getInstance();
            }
            case 1: {
                return this.a.get(0);
            }
        }
        return new SequenceExtent(this.a);
    }

    public final SequenceIterator<Item<?>> iterate() {
        if (this.a.isEmpty()) {
            return EmptyIterator.emptyIterator();
        }
        return new ListIterator(this.a);
    }

    public final List<Item<?>> getList() {
        return this.a;
    }

    public final Item getFirstItem() {
        if (this.a.isEmpty()) {
            return null;
        }
        return this.a.get(0);
    }

    public final Item popLastItem() {
        if (this.a.isEmpty()) {
            return null;
        }
        return this.a.remove(this.a.size() - 1);
    }
}

