/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ExternalObject;

public abstract class SequenceReceiver
implements Receiver {
    protected boolean previousAtomic = false;
    protected PipelineConfiguration pipelineConfiguration;
    protected String systemId = null;

    public SequenceReceiver(PipelineConfiguration pipelineConfiguration) {
        this.pipelineConfiguration = pipelineConfiguration;
    }

    @Override
    public final PipelineConfiguration getPipelineConfiguration() {
        return this.pipelineConfiguration;
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        this.pipelineConfiguration = pipelineConfiguration;
    }

    public final Configuration getConfiguration() {
        return this.pipelineConfiguration.getConfiguration();
    }

    @Override
    public void setSystemId(String string) {
        this.systemId = string;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public void setUnparsedEntity(String string, String string2, String string3) {
    }

    @Override
    public void open() {
        this.previousAtomic = false;
    }

    @Override
    public abstract void append(Item var1, Location var2, int var3);

    @Override
    public void append(Item item) {
        this.append(item, ExplicitLocation.UNKNOWN_LOCATION, 524288);
    }

    public NamePool getNamePool() {
        return this.pipelineConfiguration.getConfiguration().getNamePool();
    }

    protected void flatten(ArrayItem object, Location location, int n2) {
        for (Sequence sequence : object.members()) {
            sequence.iterate().forEachOrFail(item -> this.append(item, location, n2));
        }
    }

    protected void decompose(Item item, Location location, int n2) {
        if (item != null) {
            if (item instanceof AtomicValue || item instanceof ExternalObject) {
                if (this.previousAtomic) {
                    this.characters(" ", location, 0);
                }
                this.characters(item.getStringValueCS(), location, 0);
                this.previousAtomic = true;
                return;
            }
            if (item instanceof ArrayItem) {
                this.flatten((ArrayItem)item, location, n2);
                return;
            }
            if (item instanceof Function) {
                String string = item instanceof MapItem ? "map" : "function item";
                String string2 = this.getErrorCodeForDecomposingFunctionItems();
                if (string2.startsWith("SENR")) {
                    throw new XPathException("Cannot serialize a " + string + " using this output method", string2, location);
                }
                throw new XPathException("Cannot add a " + string + " to an XDM node tree", string2, location);
            }
            NodeInfo nodeInfo2 = (NodeInfo)item;
            if (nodeInfo2 instanceof Orphan && ((Orphan)nodeInfo2).isDisableOutputEscaping()) {
                this.characters(item.getStringValueCS(), location, 1);
                this.previousAtomic = false;
                return;
            }
            if (nodeInfo2.getNodeKind() == 9) {
                this.startDocument(0);
                nodeInfo2.iterateAxis((byte)3).forEachOrFail(nodeInfo -> this.append(nodeInfo, location, n2));
                this.previousAtomic = false;
                this.endDocument();
                return;
            }
            if (nodeInfo2.getNodeKind() == 2 && ((SimpleType)nodeInfo2.getSchemaType()).isNamespaceSensitive()) {
                XPathException xPathException = new XPathException("Cannot copy attributes whose type is namespace-sensitive (QName or NOTATION): " + Err.wrap(nodeInfo2.getDisplayName(), 2));
                xPathException.setErrorCode(this.getPipelineConfiguration().getHostLanguage() == 50 ? "XTTE0950" : "XQTY0086");
                throw xPathException;
            }
            int n3 = 4;
            if (n2 == 262144) {
                n3 = 5;
            } else if (n2 == 524288) {
                n3 = 6;
            }
            ((NodeInfo)item).copy(this, n3, location);
            this.previousAtomic = false;
        }
    }

    protected String getErrorCodeForDecomposingFunctionItems() {
        boolean bl2 = this.getPipelineConfiguration().getHostLanguage() == 50;
        if (bl2) {
            return "XTDE0450";
        }
        return "XQTY0105";
    }

    @Override
    public boolean handlesAppend() {
        return true;
    }
}

