/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class StartTagBuffer
extends ProxyReceiver
implements NamespaceResolver {
    protected NodeName elementNameCode;
    protected SchemaType elementTypeCode;
    protected Location elementLocationId;
    protected int elementProperties;
    protected AttributeCollectionImpl bufferedAttributes;
    private boolean a;
    private boolean b;
    private boolean c;
    protected NamespaceBinding[] namespaces = new NamespaceBinding[50];
    protected int namespacesSize = 0;
    private int[] d = new int[50];
    private int e = 0;
    private int f = 0;
    private boolean g = false;

    public StartTagBuffer(Receiver receiver) {
        super(receiver);
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        super.setPipelineConfiguration(pipelineConfiguration);
        this.bufferedAttributes = new AttributeCollectionImpl(pipelineConfiguration.getConfiguration());
    }

    @Override
    public void startDocument(int n2) {
        if (this.e == 0) {
            ++this.e;
            super.startDocument(n2);
        }
        this.a = false;
        this.b = true;
        this.c = false;
    }

    @Override
    public void endDocument() {
        if (this.e == 1) {
            --this.e;
            super.endDocument();
        }
    }

    @Override
    public void startElement(NodeName nodeName, SchemaType schemaType, Location location, int n2) {
        this.a();
        this.elementNameCode = nodeName;
        this.elementTypeCode = schemaType;
        this.elementLocationId = location.saveLocation();
        this.elementProperties = n2;
        this.bufferedAttributes.clear();
        this.g = false;
        this.d[this.e] = 0;
        if (++this.e >= this.d.length) {
            this.d = Arrays.copyOf(this.d, this.e << 1);
        }
        this.a = true;
        this.b = false;
        if ((n2 & 0x40) == 0) {
            ((ProxyReceiver)this).namespace(nodeName.getNamespaceBinding(), 0);
        }
        this.f = 0;
        this.c = true;
    }

    @Override
    public void namespace(NamespaceBindingSet object, int n2) {
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (NamespaceBinding)object.next();
            if (!this.a) {
                throw NoOpenStartTagException.makeNoOpenStartTagException(13, ((NamespaceBinding)object2).getPrefix(), this.getPipelineConfiguration().getHostLanguage(), this.b, ExplicitLocation.UNKNOWN_LOCATION);
            }
            boolean bl2 = false;
            for (int i2 = 0; i2 < this.d[this.e - 1]; ++i2) {
                if (!this.namespaces[this.namespacesSize - 1 - i2].equals(object2)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            NamespaceBinding namespaceBinding = object2;
            object2 = this;
            if (((StartTagBuffer)object2).namespacesSize + 1 >= ((StartTagBuffer)object2).namespaces.length) {
                ((StartTagBuffer)object2).namespaces = Arrays.copyOf(((StartTagBuffer)object2).namespaces, ((StartTagBuffer)object2).namespacesSize << 1);
            }
            ((StartTagBuffer)object2).namespaces[((StartTagBuffer)object2).namespacesSize++] = namespaceBinding;
            int n3 = this.e - 1;
            this.d[n3] = this.d[n3] + 1;
        }
    }

    @Override
    public void attribute(NodeName object, SimpleType simpleType, CharSequence charSequence, Location location, int n2) {
        if (!this.a) {
            throw NoOpenStartTagException.makeNoOpenStartTagException(2, object.getDisplayName(), this.getPipelineConfiguration().getHostLanguage(), this.b, ExplicitLocation.UNKNOWN_LOCATION);
        }
        if ((n2 & 0x40) == 0 && !object.hasURI("")) {
            NodeName nodeName;
            int n3 = this.f++;
            NodeName nodeName2 = object;
            object = this;
            NamespaceBinding namespaceBinding = nodeName2.getNamespaceBinding();
            String string = namespaceBinding.getPrefix();
            if ((string = ((StartTagBuffer)object).getURIForPrefix(string, true)) == null) {
                ((ProxyReceiver)object).namespace(namespaceBinding, 0);
                nodeName = nodeName2;
            } else if (namespaceBinding.getURI().equals(string)) {
                nodeName = nodeName2;
            } else {
                int n4 = n3;
                Object object2 = namespaceBinding;
                object2 = ((NamespaceBinding)object2).getPrefix();
                string = (String)object2 + '_' + n4;
                nodeName2 = new FingerprintedQName(string, nodeName2.getURI(), nodeName2.getLocalPart());
                ((ProxyReceiver)object).namespace(nodeName2.getNamespaceBinding(), 0);
                nodeName = nodeName2;
            }
            object = nodeName;
        }
        this.bufferedAttributes.addAttribute((NodeName)object, simpleType, charSequence.toString(), location, n2);
    }

    public void setHasChildren(boolean bl2) {
        this.g = bl2;
    }

    @Override
    public void startContent() {
        this.c = false;
        int n2 = this.elementProperties | 0x40;
        if (this.g) {
            n2 |= 0x20000;
        }
        this.nextReceiver.startElement(this.elementNameCode, this.elementTypeCode, this.elementLocationId, n2);
        this.declareNamespacesForStartElement();
        n2 = this.bufferedAttributes.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.nextReceiver.attribute(this.bufferedAttributes.getNodeName(i2), this.bufferedAttributes.getTypeAnnotation(i2), this.bufferedAttributes.getValue(i2), this.bufferedAttributes.getLocation(i2), this.bufferedAttributes.getProperties(i2) | 0x40);
        }
        this.a = false;
        this.nextReceiver.startContent();
    }

    private void a() {
        if (this.c) {
            ((ProxyReceiver)this).startContent();
        }
    }

    protected void declareNamespacesForStartElement() {
        for (int i2 = this.namespacesSize - this.d[this.e - 1]; i2 < this.namespacesSize; ++i2) {
            this.nextReceiver.namespace(this.namespaces[i2], 0);
        }
    }

    public NamespaceBinding[] getLocalNamespaces() {
        int n2 = this.d[this.e - 1];
        if (n2 == 0) {
            return NamespaceBinding.EMPTY_ARRAY;
        }
        NamespaceBinding[] namespaceBindingArray = new NamespaceBinding[this.d[this.e - 1]];
        System.arraycopy(this.namespaces, this.namespacesSize - n2, namespaceBindingArray, 0, n2);
        return namespaceBindingArray;
    }

    protected void declareAllNamespaces() {
        for (int i2 = 0; i2 < this.namespacesSize; ++i2) {
            this.nextReceiver.namespace(this.namespaces[i2], 0);
        }
    }

    @Override
    public void endElement() {
        this.a();
        this.nextReceiver.endElement();
        this.undeclareNamespacesForElement();
    }

    protected void undeclareNamespacesForElement() {
        this.namespacesSize -= this.d[--this.e];
    }

    public boolean hasAttributes() {
        return this.bufferedAttributes.getLength() > 0;
    }

    public String getAttribute(int n2) {
        return this.bufferedAttributes.getValueByFingerprint(n2 & 0xFFFFF);
    }

    public String getAttribute(String string, String string2) {
        return this.bufferedAttributes.getValue(string, string2);
    }

    public AttributeCollection getAllAttributes() {
        return this.bufferedAttributes;
    }

    public boolean hasAttributeInNamespace(String string) {
        return this.bufferedAttributes.hasAttributeInNamespace(string);
    }

    @Override
    public String getURIForPrefix(String string, boolean n2) {
        if (string.isEmpty() && n2 == 0) {
            return "";
        }
        if ("xml".equals(string)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        for (n2 = this.namespacesSize - 1; n2 >= 0; --n2) {
            String string2;
            if (!this.namespaces[n2].getPrefix().equals(string) || (string2 = this.namespaces[n2].getURI()).isEmpty()) continue;
            return string2;
        }
        if (string.isEmpty()) {
            return "";
        }
        return null;
    }

    @Override
    public Iterator<String> iteratePrefixes() {
        ArrayList<String> arrayList = new ArrayList<String>(this.namespacesSize);
        for (int i2 = this.namespacesSize - 1; i2 >= 0; --i2) {
            String string = this.namespaces[i2].getPrefix();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        arrayList.add("xml");
        return arrayList.iterator();
    }

    @Override
    public void characters(CharSequence charSequence, Location location, int n2) {
        this.a();
        this.nextReceiver.characters(charSequence, location, n2);
    }

    @Override
    public void processingInstruction(String string, CharSequence charSequence, Location location, int n2) {
        this.a();
        this.nextReceiver.processingInstruction(string, charSequence, location, n2);
    }

    @Override
    public void comment(CharSequence charSequence, Location location, int n2) {
        this.a();
        this.nextReceiver.comment(charSequence, location, n2);
    }
}

