/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashSet;
import java.util.function.Supplier;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;

public class TypeCheckingFilter
extends ProxyReceiver {
    private ItemType a;
    private int b;
    private RoleDiagnostic c;
    private Location d;
    private int e = 0;
    private int f = 0;
    private HashSet<Long> g = new HashSet(10);

    public TypeCheckingFilter(Receiver receiver) {
        super(receiver);
    }

    public void setRequiredType(ItemType itemType, int n2, RoleDiagnostic roleDiagnostic, Location location) {
        this.a = itemType;
        this.b = n2;
        this.c = roleDiagnostic;
        this.d = location;
    }

    @Override
    public void attribute(NodeName nodeName, SimpleType simpleType, CharSequence charSequence, Location location, int n2) {
        if (this.f == 0) {
            if (++this.e == 2) {
                this.a(location);
            }
            CombinedNodeTest combinedNodeTest = new CombinedNodeTest(new NameTest(2, nodeName, ((SequenceReceiver)this).getNamePool()), 23, new ContentTypeTest(2, simpleType, this.getConfiguration(), false));
            this.a(combinedNodeTest, this.a((short)2, nodeName, charSequence), location);
        }
        this.nextReceiver.attribute(nodeName, simpleType, charSequence, location, n2);
    }

    @Override
    public void characters(CharSequence charSequence, Location location, int n2) {
        if (this.f == 0) {
            if (++this.e == 2) {
                this.a(location);
            }
            this.a(NodeKindTest.TEXT, this.a((short)3, null, charSequence), location);
        }
        this.nextReceiver.characters(charSequence, location, n2);
    }

    @Override
    public void comment(CharSequence charSequence, Location location, int n2) {
        if (this.f == 0) {
            if (++this.e == 2) {
                this.a(location);
            }
            this.a(NodeKindTest.COMMENT, this.a((short)8, null, charSequence), location);
        }
        this.nextReceiver.comment(charSequence, location, n2);
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindingSet, int n2) {
        if (this.f == 0) {
            if (++this.e == 2) {
                this.a(ExplicitLocation.UNKNOWN_LOCATION);
            }
            this.a(NodeKindTest.NAMESPACE, null, (Location)ExplicitLocation.UNKNOWN_LOCATION);
        }
        this.nextReceiver.namespace(namespaceBindingSet, n2);
    }

    @Override
    public void processingInstruction(String string, CharSequence charSequence, Location location, int n2) {
        if (this.f == 0) {
            if (++this.e == 2) {
                this.a(location);
            }
            this.a(NodeKindTest.PROCESSING_INSTRUCTION, this.a((short)7, new NoNamespaceName(string), charSequence), location);
        }
        this.nextReceiver.processingInstruction(string, charSequence, location, n2);
    }

    @Override
    public void startDocument(int n2) {
        if (this.f == 0) {
            if (++this.e == 2) {
                this.a(ExplicitLocation.UNKNOWN_LOCATION);
            }
            this.a(NodeKindTest.DOCUMENT, this.a((short)9, null, ""), (Location)ExplicitLocation.UNKNOWN_LOCATION);
        }
        ++this.f;
        this.nextReceiver.startDocument(n2);
    }

    @Override
    public void startElement(NodeName nodeName, SchemaType schemaType, Location location, int n2) {
        if (this.f == 0) {
            if (++this.e == 1) {
                CombinedNodeTest combinedNodeTest = new CombinedNodeTest(new NameTest(1, nodeName, ((SequenceReceiver)this).getNamePool()), 23, new ContentTypeTest(1, schemaType, this.getConfiguration(), false));
                this.a(combinedNodeTest, this.a((short)1, nodeName, ""), location);
            } else {
                long l2;
                if (this.e == 2) {
                    this.a(location);
                }
                if (!this.g.contains(l2 = (long)nodeName.obtainFingerprint(((SequenceReceiver)this).getNamePool()) << 32 | (long)schemaType.getFingerprint())) {
                    CombinedNodeTest combinedNodeTest = new CombinedNodeTest(new NameTest(1, nodeName, ((SequenceReceiver)this).getNamePool()), 23, new ContentTypeTest(1, schemaType, this.getConfiguration(), false));
                    this.a(combinedNodeTest, this.a((short)1, nodeName, ""), location);
                    this.g.add(l2);
                }
            }
        }
        ++this.f;
        this.nextReceiver.startElement(nodeName, schemaType, location, n2);
    }

    @Override
    public void endDocument() {
        --this.f;
        this.nextReceiver.endDocument();
    }

    @Override
    public void endElement() {
        --this.f;
        this.nextReceiver.endElement();
    }

    @Override
    public void close() {
        if (this.e == 0 && !Cardinality.allowsZero(this.b)) {
            XPathException xPathException = new XPathException("An empty sequence is not allowed as the " + this.c.getMessage());
            String string = this.c.getErrorCode();
            xPathException.setErrorCode(string);
            if (!"XPDY0050".equals(string)) {
                xPathException.setIsTypeError(true);
            }
            throw xPathException;
        }
    }

    private Supplier<NodeInfo> a(short s2, NodeName nodeName, CharSequence charSequence) {
        return () -> {
            Orphan orphan = new Orphan(this.getConfiguration());
            orphan.setNodeKind(s2);
            if (nodeName != null) {
                orphan.setNodeName(nodeName);
            }
            orphan.setStringValue(charSequence);
            return orphan;
        };
    }

    @Override
    public void append(Item item, Location location, int n2) {
        if (this.f == 0) {
            if (++this.e == 2) {
                this.a(location);
            }
            Location location2 = location;
            Item item2 = item;
            TypeCheckingFilter typeCheckingFilter = this;
            TypeHierarchy typeHierarchy = typeCheckingFilter.getConfiguration().getTypeHierarchy();
            if (!typeCheckingFilter.a.matches(item2, typeHierarchy)) {
                typeCheckingFilter.a(null, item2, location2);
            }
        }
        if (this.nextReceiver instanceof SequenceReceiver) {
            this.nextReceiver.append(item, location, n2);
            return;
        }
        super.append(item, location, n2);
    }

    @Override
    public boolean usesTypeAnnotations() {
        return true;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private void a(NodeTest nodeTest, Supplier supplier, Location location) {
        if (!this.getConfiguration().getTypeHierarchy().isSubType(nodeTest, this.a)) {
            this.a((ItemType)nodeTest, supplier == null ? null : (Item)supplier.get(), location);
        }
    }

    private void a(ItemType object, Item object2, Location location) {
        TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
        object = object2 == null ? this.c.composeErrorMessage(this.a, (ItemType)object) : this.c.composeErrorMessage(this.a, (Item)object2, typeHierarchy);
        object2 = this.c.getErrorCode();
        object = new XPathException((String)object);
        ((XPathException)object).setErrorCode((String)object2);
        if (!"XPDY0050".equals(object2)) {
            ((XPathException)object).setIsTypeError(true);
        }
        if (location == null) {
            ((XPathException)object).setLocation(this.d);
        } else {
            ((XPathException)object).setLocation(location.saveLocation());
        }
        throw object;
    }

    private void a(Location location) {
        if (!Cardinality.allowsMany(this.b)) {
            XPathException xPathException = new XPathException("A sequence of more than one item is not allowed as the " + this.c.getMessage());
            String string = this.c.getErrorCode();
            xPathException.setErrorCode(string);
            if (!"XPDY0050".equals(string)) {
                xPathException.setIsTypeError(true);
            }
            if (location == null || location == ExplicitLocation.UNKNOWN_LOCATION) {
                xPathException.setLocator(this.d);
            } else {
                xPathException.setLocator(location);
            }
            throw xPathException;
        }
    }
}

