/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.EmptyTextNodeRemover;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.tree.iter.AdjacentTextNodeMergingIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public class AdjacentTextNodeMerger
extends UnaryExpression {
    public AdjacentTextNodeMerger(Expression expression) {
        super(expression);
    }

    public static Expression makeAdjacentTextNodeMerger(Expression expression) {
        if (expression instanceof Literal && ((Literal)expression).getValue() instanceof AtomicSequence) {
            return expression;
        }
        return new AdjacentTextNodeMerger(expression);
    }

    @Override
    protected OperandRole getOperandRole() {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    @Override
    public Expression simplify() {
        Expression expression = this.getBaseExpression();
        if (expression instanceof Literal && ((Literal)expression).getValue() instanceof AtomicValue) {
            return expression;
        }
        return super.simplify();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.getOperand().typeCheck(expressionVisitor, contextItemStaticInfo);
        TypeHierarchy typeHierarchy = expressionVisitor.getConfiguration().getTypeHierarchy();
        if (typeHierarchy.relationship(this.getBaseExpression().getItemType(), NodeKindTest.TEXT) == 4) {
            Expression expression = this.getBaseExpression();
            expression.setParentExpression(this.getParentExpression());
            return expression;
        }
        if (!Cardinality.allowsMany(this.getBaseExpression().getCardinality())) {
            Expression expression = this.getBaseExpression();
            expression.setParentExpression(this.getParentExpression());
            return expression;
        }
        if (this.getBaseExpression() instanceof Choose) {
            Choose choose = (Choose)this.getBaseExpression();
            for (int i2 = 0; i2 < choose.size(); ++i2) {
                AdjacentTextNodeMerger adjacentTextNodeMerger = new AdjacentTextNodeMerger(choose.getAction(i2));
                choose.setAction(i2, ((Expression)adjacentTextNodeMerger).typeCheck(expressionVisitor, contextItemStaticInfo));
            }
            return choose;
        }
        if (this.getBaseExpression() instanceof Block) {
            Block block = (Block)this.getBaseExpression();
            Operand[] operandArray = block.getOperanda();
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            for (Operand operand : operandArray) {
                boolean bl5;
                Expression object = operand.getChildExpression();
                if (object instanceof ValueOf) {
                    bl5 = true;
                    Expression expression = ((ValueOf)object).getSelect();
                    bl4 = expression instanceof StringLiteral ? (bl4 |= ((StringLiteral)expression).getStringValue().isEmpty()) : true;
                } else {
                    bl5 = typeHierarchy.relationship(object.getItemType(), NodeKindTest.TEXT) != 4;
                    bl4 |= bl5;
                }
                if (bl2 && bl5) {
                    bl3 = true;
                    break;
                }
                if (bl5 && Cardinality.allowsMany(object.getCardinality())) {
                    bl3 = true;
                    break;
                }
                bl2 = bl5;
            }
            if (!bl3) {
                if (bl4) {
                    return new EmptyTextNodeRemover(block);
                }
                return block;
            }
        }
        return this;
    }

    @Override
    public ItemType getItemType() {
        return this.getBaseExpression().getItemType();
    }

    @Override
    public UType getStaticUType(UType uType) {
        return this.getBaseExpression().getStaticUType(uType);
    }

    @Override
    public int computeCardinality() {
        return this.getBaseExpression().getCardinality() | 0x2000;
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new AdjacentTextNodeMerger(this.getBaseExpression().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public int getImplementationMethod() {
        return 30;
    }

    @Override
    public String getStreamerName() {
        return "AdjacentTextNodeMerger";
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        return new AdjacentTextNodeMergingIterator(this.getBaseExpression().iterate(xPathContext));
    }

    public void process(XPathContext object, Location location, int n2) {
        Object object2;
        Receiver receiver = object.getReceiver();
        FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
        object = this.getBaseExpression().iterate((XPathContext)object);
        boolean bl2 = false;
        while ((object2 = object.next()) != null) {
            if (AdjacentTextNodeMerger.isTextNode(object2)) {
                if ((object2 = object2.getStringValueCS()).length() <= 0) continue;
                fastStringBuffer.append((CharSequence)object2);
                bl2 = true;
                continue;
            }
            if (bl2) {
                receiver.characters(fastStringBuffer, location, n2);
            }
            bl2 = false;
            fastStringBuffer.setLength(0);
            receiver.append((Item)object2, location, n2);
        }
        if (bl2) {
            receiver.characters(fastStringBuffer, location, n2);
        }
    }

    @Override
    public String getExpressionName() {
        return "mergeAdj";
    }

    public static boolean isTextNode(Item item) {
        return item instanceof NodeInfo && ((NodeInfo)item).getNodeKind() == 3;
    }
}

